#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys, os
from PyQt5 import Qsci
from PyQt5.QtGui import QFont, QFontMetrics, QColor
from PyQt5.QtWidgets import QApplication, QMessageBox

def run(bk):
    
    #=====================
    # save changes
    #=====================
    def SaveChanges():
        new_html = editor.text()
        if new_html != html:
            answer = QMessageBox.question(editor, "Save changes?", "Do you want to save the changes.")
            if answer == QMessageBox.Yes:
                bk.writefile(html_id, new_html)
                print('{} was updated.'.format(file_name))
        else:
            print('{} was NOT updated.'.format(file_name))

    #===================================
    # select a file
    #===================================
    
    # get all selected files
    file_names = list(bk.selected_iter())
    if file_names != []:
        # only use the first file
        html_id = file_names[0][1]
        file_name = os.path.basename(bk.id_to_href(html_id))
        # only load HTML files
        if bk.id_to_mime(html_id) == 'application/xhtml+xml':
            html = bk.readfile(html_id)
        else:
            print('No HTML file selected.')
            return
    else:
        print('You must select an HTML file.')
        return
    
    
    #=====================================
    # define QScintilla window
    #=====================================
    app = QApplication(sys.argv)
    editor = Qsci.QsciScintilla()
    lexer = Qsci.QsciLexerHTML(editor)
    editor.setLexer(lexer)

    # define autocompletion parameters
    editor.setAutoCompletionThreshold(1)
    editor.setAutoCompletionSource(Qsci.QsciScintilla.AcsAll)

    # define font
    font = QFont()
    font.setFamily('Courier')
    font.setFixedPitch(True)
    font.setPointSize(10)
    
    # editor code page
    editor.setUtf8(True)
    
    # editor font
    editor.setFont(font)
    editor.setMarginsFont(font)
    fontmetrics = QFontMetrics(font)
    editor.setMarginsFont(font)
    
    # margins & line numbers
    editor.setMarginWidth(0, fontmetrics.width("00000") + 6)
    editor.setMarginLineNumbers(0, True)
    editor.setMarginsBackgroundColor(QColor("#cccccc"))
    editor.setMarginWidth(2, 15)
    
    # line wrapping
    editor.setWrapMode(editor.WrapWord)
    
    # enable folding
    editor.setFolding(True)

    # window size
    editor.setMinimumSize(600, 450)
    editor.show()
    editor.setText(html)
    
    # save changes
    app.aboutToQuit.connect(SaveChanges)
    
    # display editor
    app.exec_()
    
    print('Done')
    
    return 0

def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())
