# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__docformat__ = 'restructuredtext en'

import os

from functools import partial

try:
    from PyQt5.Qt import QMenu, QToolButton
except ImportError:
    from PyQt4.Qt import QMenu, QToolButton

from calibre.gui2 import choose_dir, info_dialog, open_local_file
from calibre.gui2.actions import InterfaceAction

from calibre.ptempfile import PersistentTemporaryDirectory
from calibre_plugins.ACE.__init__ import (PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_DESCRIPTION)
import calibre_plugins.ACE.config as cfg


class InterfacePlugin(InterfaceAction):
    name = 'ACE'
    action_spec = ('ACE', None,
            _(PLUGIN_DESCRIPTION), None)
    popup_type = QToolButton.InstantPopup
    dont_add_to = frozenset(['menubar-device', 'toolbar-device', 'context-menu-device'])
    action_type = 'current'

    def show_configuration(self):
        '''
        Show plugin's configuration widget.
        '''
        self.interface_action_base_plugin.do_user_config(self.gui)