#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys, os, re

# see https://www.typografie.info/3/topic/36709-%E2%80%9Egesperrte%E2%80%9C-w%C3%B6rter-mit-grep-finden/?do=findComment&comment=238416
spaced = re.compile('(?<=[ ])([\w][ ]+){1,}[\w](?=[ .,:;!?])')

# main routine    
def run(bk):
    for html_id, href in bk.text_iter():
        html = bk.readfile(html_id)
        orig_html = html
        matches = re.finditer(spaced, html)
        for match in matches:
            spaced_word = match.group(0)
            unspaced_word = spaced_word.replace(' ', '')
            # remove the comment to wrap the word in span tags
            #unspaced_word = '<span class="italics">{}</span>'.format(unspaced_word)
            print('\n{} => {}\n'.format(spaced_word, unspaced_word))
            html = html.replace(spaced_word, unspaced_word)
        
        if html != orig_html:
            bk.writefile(html_id, html)
            print(os.path.basename(href), 'updated')

    return 0

def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())