#!/usr/bin/python2
# -- coding: utf-8 --

# Matching between two .ts files to update changes.
# A new file will be created with all strings from 'nickel_ts_file' and translations from 'translated_ts_file'
# Translations not found are marked as "unfinished".
# More info: http://www.mobileread.com/forums/showthread.php?t=261771

# By pipcat & surquizu. Thanks to: tshering, axaRu, davidfor, mobileread.com

import os
import sys

from xml.etree import ElementTree as ET

reserved = [
    "Kobo Aura", "Kobo Aura H2O", "Kobo Aura H2O Edition 2", "Kobo Aura HD", "Kobo Aura ONE",
    "Kobo Glo", "Kobo Glo HD", "Kobo Mini", "Kobo Touch", "Kobo Touch 2.0", "Kobo eReader Touch Edition",
    "Kobo", "Kobo Plus", "Kobo Clara HD", "Kobo Forma",
    "Papillon",
    "Adobe", "Facebook", "Pocket", "Twitter", "OverDrive", "Google", "Wikipedia",
    "Kobo Plus FAQ", "OverDrive FAQ",
    "kobo.com/help", "kobo.faq.rakuten.ne.jp", "<html><head></head><body></body></html>",
    "Blackjack", "Demon", "Double Klondike", "Freecell", "Klondike", "Solitaire", "Spider", "Spiderette", "Sudoku", "Video Poker",
    "Avenir Next", "Avenir Next Medium", "KBJ-TsukuMin Pr6N RB", "KBJ-UDKakugo Pr6N M", "Open Dyslexic",
    "WordItemWidget", 
    "SSID:", "ISBN: %1",
    "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A-Z", ".", "--", "aeiou",
    "%1 B", "%1 EB", "%1 GB", "%1 KB", "%1 MB", "%1 PB", "%1 TB",
    "%1%", " (%1)", u"%1 · %2", "%1 - %2", "%0 %1.", "%1: %2",
    "OK", "Export"]

def find_translation(root_trans, name, source, plurals):
    numerus = ['', '', '']
    for co2 in root_trans.iter('context'):
        name2 = co2.find('name').text
        if name2 == name:
            for me2 in co2.iter('message'):
                source2 = me2.find('source').text
                if source2 == source:
                    if plurals == 'yes':
                        i2 = 0
                        for nm2 in me2.iter('numerusform'):
                            numerus[i2] = nm2.text
                            i2 += 1
                        return numerus
                    else:
                        return me2.find('translation').text

    return '' if plurals == 'no' else numerus

def move_translation(last_ts_nickel, last_ts_translation, translated_ts):
    tree = ET.parse(last_ts_nickel)
    root = tree.getroot()

    tree_trans = ET.parse(last_ts_translation)
    root_trans = tree_trans.getroot()

    found = 0
    no_found = 0
    for co in root.iter('context'):
        name = co.find('name').text
        for me in co.iter('message'):
            source = me.find('source').text

            if me.get('numerus', 'no') == 'yes':
                new_t1 = find_translation(root_trans, name, source, 'yes')
                i = 0
                for nm in me.iter('numerusform'):
                    if i == 0:
                        if new_t1[i] == '' or new_t1 == source:
                            me.find('translation').set('type', 'unfinished')
                            no_found += 1
                        else:
                            found += 1
                    if new_t1[i] != '' and nm.text != new_t1[i]:
                        nm.text = new_t1[i]
                    i += 1

            else:
                t1 = me.find('translation').text
                new_t1 = find_translation(root_trans, name, source, 'no')

                if new_t1 == '' or (new_t1 == source and not use_reserved) or (new_t1 == source and use_reserved and not new_t1.lower() in reserved):
                    me.find('translation').set('type', 'unfinished')
                    no_found += 1
                if (new_t1 != source and new_t1 != '') or (new_t1 == source and use_reserved and new_t1.lower() in reserved):
                    found += 1
                    if new_t1 != t1:
                        me.find('translation').text = new_t1

    tree.write(translated_ts, encoding='utf-8', xml_declaration=True)
    print str(found) + ' strings found, ' + str(no_found) + ' not found. Created file: ' + translated_ts

if len(sys.argv) > 1 and sys.argv[1] == "-u":
    use_reserved = True
    sys.argv = [sys.argv[0]] + sys.argv[2:]
else:
    use_reserved = False

if len(sys.argv) != 3:
    print "usage: %s [-u] nickel_ts_file translated_ts_file\nOptions:\n-u\t: use untranslatable sentences" % os.path.basename(sys.argv[0])
    sys.exit(1)

reserved = [s.lower() for s in reserved]
move_translation(sys.argv[1], sys.argv[2], 'moved_translation-' + sys.argv[1])
