#!/bin/sh

#################################################################
# Create/Update records in database for installed dictionaries
#################################################################
file="/mnt/onboard/.kobo/KoboReader.sqlite"

echo "INSERT OR REPLACE INTO "Dictionary" VALUES('-sk-en','Extra:_sk - English','true','1270789',NULL,'true'); INSERT OR REPLACE INTO "Dictionary" VALUES('-en-sk','English - Extra:_sk','true','1490143',NULL,'true');" | sqlite3 $file

#################################################################
# Patch libnickel to allow searches on Extra dictionaries
#################################################################
inpfile="/usr/local/Kobo/libnickel.so.1.0.0"
tmpfile="/tmp/libnickel.so"
patchfile="/root/dictionary.patch"

cp $inpfile $tmpfile
/sbin/patch32lsb -p $patchfile -i $tmpfile -o $tmpfile

cp $tmpfile $inpfile
rm $tmpfile

#################################################################
# Update Kobo eReader config to allow UI in Extra locale language
#################################################################
file="/mnt/onboard/.kobo/Kobo/Kobo eReader.conf"

locale="sk"
searchstr="ExtraLocales="
section="ApplicationPreferences"

ret=`grep $searchstr "$file" | sed 's/^.*=//'`
if [ -z "$ret" ]; then
    sed -i "/\[$section\]/a $searchstr$locale" "$file"
else
    if [ "${ret#*$locale}" = "$ret" ]; then
        sed -i "s/\($searchstr.*\)/\1, $locale/" "$file"
    fi
fi

curlocale="sk_SK"
searchstr="CurrentLocale="
section="ApplicationPreferences"

ret=`grep $section "$file"`
if [ -z "$ret" ]; then
    echo "" >> "$file"
    echo "[$section]" >> "$file"
fi

ret=`grep $searchstr "$file" | sed 's/^.*=//'`

if [ -z "$ret" ]; then
    sed -i "/\[$section\]/a $searchstr$curlocale" "$file"
else
    if [ "${ret%$curlocale}" = "$ret" ]; then
        sed -i "s/\($searchstr\)\(.*\)/\1$curlocale/" "$file"
    fi
fi

#################################################################
# Clean & reboot - remove uneeded files
#################################################################

rm /sbin/sqlite3
rm /sbin/patch32lsb
rm /etc/udev/rules.d/do_it_all.rules
rm $patchfile
rm $0

sync
/sbin/reboot
