#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

#********************************************************************************#
#                                                                                #
# MIT Licence(OSI)                                                               #
# Copyright (c) 2017 Bill Thompson                                               #
#                                                                                #
# Permission is hereby granted, free of charge, to any person obtaining a copy   # 
# of this software and associated documentation files (the "Software"), to deal  # 
# in the Software without restriction, including without limitation the rights   #
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell      #
# copies of the Software, and to permit persons to whom the Software is          #
# furnished to do so, subject to the following conditions:                       # 
#                                                                                #
# The above copyright notice and this permission notice shall be included in all #
# copies or substantial portions of the Software.                                #
#                                                                                # 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR     # 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,       #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE    #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER         # 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  # 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE  # 
# SOFTWARE.                                                                      #
#                                                                                #  
#********************************************************************************#


import options
from convert import convert2Epub
from cutils import validateHTMLFile, show_msgbox
from updater import updateCheck
from dialog import MetadataDialog

import os, os.path, sys, codecs, inspect

from  datetime import timedelta, datetime as dt
from time import sleep
import tkinter as tk
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox


SITE_URL = "https://www.mobileread.com/forums/showpost.php?p=3467707&postcount=1"
PLUGIN_PATH = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
options.PLUGIN_PATH = PLUGIN_PATH
           
# main routine
def run(bk):
    print('Python version: ', sys.version, '\n')
    print('Running GoogleZipImport...\n')
    
    # initialize variables
    html_file_path = None
    prefs = bk.getPrefs()
   
    # check for new plugin versions   
    latest_version, installed_version = updateCheck(SITE_URL, PLUGIN_PATH)
    if latest_version and latest_version != installed_version:
        options.NEW_PLUGIN_VERSION = True
        options.MSG_NEW_VERSION_AVAILABLE = ("A new version of this plugin is available from MR - v" + latest_version)      
        
    # initialize file open default dirs    
    if 'initialdir' in prefs:
        options.HTML_OPTIONS['initialdir'] = prefs['initialdir']
        options.COVER_OPTIONS['initialdir'] = prefs['initialdir']    
    else:
        prefs['initialdir'] = os.path.expanduser('~')
        bk.savePrefs(prefs)        
             
    # set default output to epub 2
    output_format = 'epub 2.0'
    prefs['output_format'] = output_format
    
    # metadata dialog
    root = tk.Tk()
    root.title('GoogleZipImport')
    root.resizable(width=True, height=True)
    if not sys.platform.startswith('darwin'):
        img = tk.Image('photo', file=os.path.join(bk._w.plugin_dir, bk._w.plugin_name, 'images/penwrench.png'))
        root.tk.call('wm','iconphoto', root._w, img)
    MetadataDialog(root).pack(fill=tk.BOTH, expand=True)
    root.mainloop()
    
    # if dialog 'Cancel' or exit 
    # is pressed then exit run()
    if options.SYS_EXIT == True:
       return(0)
    
    # get the input html file path
    html_file_path = options.META_OPTIONS['filename'] 
    
    # save the dir path for next time
    prefs['initialdir'] = os.path.split(html_file_path)[0]
    bk.savePrefs(prefs)
    
    # process the html file
    if html_file_path:
        
        # run html to epub conversion
        print('\n -- Start conversion to epub...')
        epub_path = convert2Epub(html_file_path)

        # if conversion fails, exit run()
        if options.SYS_EXIT == True:
            return(0)                
        
        # import the epub into Sigil
        if os.path.isfile(epub_path):
            with codecs.open(epub_path,'rb') as fp:
                data = fp.read()
            bk.addotherfile('dummy.epub', data)
            os.remove(epub_path)
            return(0)
        
    else:
        print(' >>> Error: Unable to process html file due to critical conversion errors.')
        return(1)
        

def main():
    print('I reached main when I should not have\n')
    return(-1)

if __name__ == "__main__":
    sys.exit(main())
