#!/Python35/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

from uid_generators import generateSmallUID
from cutils import *
from hformat import *

import os, os.path, shutil
from string import capwords
from locale import getdefaultlocale

try:
    from sigil_bs4 import BeautifulSoup
except:
    from bs4 import BeautifulSoup

__all__=["prettifyXHTMLFile", "educateHTMLStyles","reformatHTMLStyles", "createCSSFile", "formatCSSFile", "createTOCFile", "createCoverImageFile", "createOPFFile", "createMIMETYPEFile", "createContainerXMLFile", "createNCXFile", "createOPFHTMLHeader", "addOPFMetadata", "addManifestData", "addSpineData", "addGuideData", "buildOPFFile"]  


def prettifyXHTMLFile(wdir, file):
    # reformat andd prettify the XHTML file
    outfile= wdir + os.sep + 'final_one.css'
    infp = open(file, 'rt', encoding='utf-8')
    outfp = open(outfile, 'wt', encoding='utf-8') 
    for line in infp:
        if line.strip().startswith('<?xml') or \
            line.strip().startswith('<!DOCTYPE') or \
            line.strip().startswith('<html') or \
            line.strip().startswith('<head>') or \
            line.strip().startswith('<meta')or \
            line.strip().startswith('<title>') or \
            line.strip().startswith('<link') or \
            line.strip().startswith('</head>') or \
            line.strip().startswith('<body'):
            if line.startswith('<meta') or \
                line.startswith('<title>') or \
                line.startswith('<link'):
                line = '  ' + line 
            if line.startswith('<body'):
                line = '\n' + line            
            outfp.write(line.rstrip())    
        else:
            outfp.write(line)    
            
    infp.close()
    outfp.close()
    os.remove(file)
    os.rename(outfile, file)    
    return(0)       

def educateHTMLStyles(wdir, file):
    temp1 = wdir + os.sep + 'convert_align.html'
    outfp = open(temp1, 'wt', encoding='utf-8')
    html = open(file, 'rt', encoding='utf-8').read()
    soup = BeautifulSoup('html', 'html.parser')
    
    for tag in soup.findAll('p'):
        if tag['align'] == 'center':
            if tag.has_attr('style'):
                tag['style'] == 'text-align: center;' + tag['style']
                del tag['align']
             
    outfp.writelines(str(soup))
    outfp.close()
    os.remove(file)
    shutil.copy(temp1, file)
    os.remove(temp1) 
    return(0)
    
#===================================================================#
#   
#   re-integrate older "align" item value pairs(HTML 3.2) 
#   into inline HTML styles(for HTML 4.01)
#
#         
def reformatHTMLStyles(file, wdir):
    print(' -- Reformat and remove garbage from html styles...')
    temp1 = wdir + os.sep + 'html3.tmp'
    outfp = open(temp1, 'wt', encoding='utf-8')
    infp = open(file, 'rt', encoding='utf-8')
    
    for line in infp:
        
        # remove the outdated 'align' property(html 3.2) and replace 
        # it with 'text-align' and 'vertical-align'(html 4.01+). 
        line = line.replace('<p align="center">', '<p style="text-align: center;">')
        line = line.replace('<p align="left">', '<p style="text-align: left;">')
        line = line.replace('<p align="right">', '<p style="text-align: right;">')
        line = line.replace('<p align="top">', '<p style="vertical-align: top;">')
        line = line.replace('<p align="bottom">', '<p style="vertical-align: bottom;">')
         
        line = line.replace('align="center" style="', 'style="text-align: center;')
        line = line.replace('align="left" style="', 'style="text-align: left;')
        line = line.replace('align="right" style="', 'style="text-align: right;')
        line = line.replace('align="top" style="', 'style="vertical-align: top;')
        line = line.replace('align="bottom" style="', 'style="vertical-align: bottom;')
        #line = line.replace(' align="center"', '')
        line = line.replace(' align="left"', '')
        line = line.replace(' align="right"', '')
        line = line.replace(' align="justify"', '')
        line = line.replace(' align="top"', '')
        line = line.replace(' align="bottom"', '')
        
        if 'HTML PUBLIC' in line:
            continue
            
        if 'p.western {' in line.lower():
            continue        
        
        if '@page' in line:
            continue
         
        if '<meta ' in line and r'content="text/html' in line: 
            outfp.write(line)
            continue
            
        # remove meta data    
        if '<meta' in line and ('LibreOffice' in line or 'OpenOffice' in line):
            outfp.write(line)
            continue
        elif '<meta' in line:
            continue        
    
        if '-->' in line or '<!--' in line:
           continue             
        
        # remove control default fallbacks
        if '.ctl' in line or '-ctl' in line:
            continue    
            
        # remove regional default fallbacks
        if '.cjk' in line or '-cjk' in line:
            continue    
            
        # remove link formatting    
        if 'a:link' in line.lower():
            continue            
        
        if '{ ' in line :
            line = line.strip().lower()
            line = line.replace('\s', '')
            line = line.replace('{', ' {\n')
            line = line.replace(';', ';\n')
            line = line.replace(' }', '\n}\n')
            outfp.write(line)
        else:
            line.strip().replace('line', line + '\n')
            outfp.write(line)

    infp.close()
    outfp.close()
   
    os.remove(file)
    shutil.copy(temp1, file)
    os.remove(temp1)
   
    return(0)
            
#-----------------------------------------------------#
#
#   extracts the raw stylesdheet from the top of html file
#
def createCSSFile(wdir, file):
    print('\n -- Create the stylesheet...')
    print(' -- Creating the CSS file')
    
    new_file = wdir + os.sep + 'new_file.htm'
    outf2 = open(new_file, 'wt', encoding=('utf-8'))
     
    temp2 = wdir + os.sep + 'temp.css'
    outfp= open(temp2, 'wt', encoding='utf8')
    
    with open(file, 'rt', encoding='utf-8') as infp:
        for line in infp:
            if '<style>' in line or \
                '<style type="text/css">'in line:
                for line in infp:
                    if '</style>' in line:
                        break
                    else:                    
                        outfp.write(line)
            else:
                if '</body></html>' in line:
                    line = line.replace('</body></html>', '\n')     
                outf2.write(line)      
 
    outfp.close() 
    outf2.close()
    os.remove(file)
    os.rename(new_file, file)
    
    return(0)

def formatCSSFile(wdir):
    print(' -- Format the CSS file\n')
    """ Properly formats the styleshheet and also
        removes propriatary or unnecessary styles
        or attributes. Also adds some useful globals 
        and presets.
    """    
    
    styles = wdir + os.sep + 'tmp2.tmp'
    temp1 = wdir+ os.sep + 'temp.css'
    outfp = open(styles, 'wt', encoding=('utf-8'))
    with open(temp1, 'rt', encoding=('utf-8')) as infp:
        
        for line in infp:
            
            if line.strip() == '':
                continue  
        
            if re.match(r'^\s*$', line):
                continue    
                
            if 'padding:' in line:
                continue            
                
            if 'vertical-align:baseline' in line:
                if 'vertical-align:baseline;' in line:
                    line = line.replace('vertical-align:baseline;', '')
                else:                     
                    line = line.replace('vertical-align:baseline', '')
            
            if 'text-decoration:none' in line:
                if 'text-decoration:none;' in line:
                    line = line.replace('text-decoration:none;', '')
                else:                     
                    line = line.replace('text-decoration:none', '')
                    
                    
            if 'padding-top' in line:
                line = line.replace('padding-top', 'margin-top')
                
            if 'padding-bottom' in line:
                line = line.replace('padding-bottom', 'margin-bottom')

            #if 'padding:' in line:
            #    line = line.replace('padding:', 'margin:')            
                            

            if 'ol{' in line or \
               'ul{' in line or \
               'li{' in line:
                continue    

            #if 'font-size:24pt' in line:
            #    continue            
                
            line = line.replace('400', 'normal')
            line = line.replace('700', 'bold')            
                
            if '<![CDATA[' in line \
            or ']]>' in line or \
            '<!&#8212;' in line or\
            '<!&#8211;' in line or \
            '<' in line:
                continue            
              
            if 'table ' in line or 'td ' in line or 'td.' in line or 'tr.' in line:
                continue                
             
            # reformat from inline to stacked attributes         
            line = line.replace('{', '  {\n')   
            line = line.replace(';', ';\n')
            line=line.replace('}\n', '\n}\n')                                 
            outfp.write(line.strip(' '))
            
        outfp.close()
        infp.close
           
    # create the final stylesheet    
    tmp2 = wdir + os.sep + 'stylesheet.css'
    outfp = open(tmp2, 'wt', encoding=('utf-8'))
    with open(styles, 'rt', encoding=('utf-8')) as infp:       
        for line in infp: 
            if '@import url' in line:
                continue                 
            """    
            # adjust superscript attributess to avoid text line-height disruptions            
            if line == 'vertical-align: top\n' or line == 'vertical-align:top\n':             
                line = 'vertical-align:top;\nfont-size:0.75em;\nline-height: 90%;\n'    
             
            # adjust superscript attributess to avoid text line-height disruptions            
            if line == 'vertical-align: super\n' or line == 'vertical-align:super\n':             
                line = 'vertical-align:top;\nfont-size:0.75em;\nline-height: 90%;\n'
                
            # adjust subscript attributess to avoid text line-height disruptions            
            if line == 'vertical-align: bottom\n' or line == 'vertical-align:bottom\n':             
                line = 'vertical-align: bottom;\nfont-size:0.75em;\nline-height: 90%;\n'    
            
            # adjust subscript attributess to avoid text line-height disruptions            
            if line == 'vertical-align: sub\n' or line == 'vertical-align:sub\n':             
                line = 'vertical-align: bottom;\nfont-size:0.75em;\nline-height: 90%;\n'        
                
            """
                
            outfp.write(line)        
        
        # Add some useful globals and presets
        outfp.write('/* Some useful globals and presets */\n')
        outfp.write('p.TOCItem   {\n')
        outfp.write('margin-top: 0.3em;\n')
        outfp.write('margin-right: 0em;\n')
        outfp.write('margin-bottom: 0.3em;\n')
        outfp.write('margin-left: 0em;\n') 
        outfp.write('font-size: 0.9166em;\n')
        outfp.write('font-weight: bold;\n')
        outfp.write('font-style: normal;\n')
        outfp.write('text-indent: 1em;\n')
        outfp.write('text-transform: uppercase;\n')
        outfp.write('color:#00000a;\n')
        outfp.write('}\n')     
        
        outfp.write('body.globals  {\n')
        outfp.write('font-family: "Times New Roman", serif;\n')
        outfp.write('font-size: 100%;\n')
        outfp.write('color:#00000a;\n')
        outfp.write('line-height: 1.2em;\n')
        outfp.write('font-style: normal;\n')
        outfp.write('font-weight: normal;\n')
        outfp.write('text-align: justify;\n')
        outfp.write('text-indent: 0em;\n')
        outfp.write('margin: 3% 3% 3% 3%;\n')
        outfp.write('padding: 0;\n')
        outfp.write('}\n')
        
        outfp.write('div  {\n')   
        outfp.write('margin: 0;\n')
        outfp.write('padding:0;\n')
        outfp.write('}\n')
        
        outfp.write('p.ebk-imagestyle  {\n')      
        outfp.write('text-align: center;\n')
        outfp.write('text-indent: 0em;\n')
        outfp.write('}\n')
        
        outfp.write('a:link    { color: blue; text-decoration: none; }\n')
        outfp.write('a:visited { color: blue; text-decoration: none; }\n')
        outfp.write('a:hover   { color: #ff8c00; text-decoration: underline; }\n')
        outfp.write('a:active  { color: blue; text-decoration: none; }\n')
        
    outfp.close()
    os.remove(styles)
    #os.remove(temp)
    os.remove(temp1)
    return(0)    

#-----------------------------------------------------#
#
# format and change the stylesheet style defsult;
#

def formatCSSFile2(wdir):
    print(' -- Reformat the CSS File')
    styles = wdir + os.sep + 'tmp2.tmp'
    outfp = open(styles, 'wt', encoding=('utf-8'))
    temp1 = wdir + os.sep + 'temp.css'
    with open(temp1, 'rt', encoding=('utf-8')) as infp1:
        
        for line in infp1:
            
            if line.strip() == '':
                continue  
                
            if 'widows' in line or 'orphans' in line:
                continue            
        
            if re.match(r'^\s*$', line):
                continue        
                
            if '<![CDATA[' in line \
            or ']]>' in line or \
            '<!&#8212;' in line or\
            '<!&#8211;' in line or \
            '<' in line:
                continue               
                
            if 'font-family:' in line:
                continue 
                
            if 'so-language' in line:
                continue            

            if 'direction' in line:
                continue                  
                
            if 'background: transparent;' in line:
                continue                

            if 'page-break' in line:
                continue            
                
            if 'vertical-align' in line:
                continue  

            if 'padding:' in line.strip():
                continue     

            if '<table ' in line or 'td ' in line or 'td.' in line or 'tr.' in line:
                continue 

            if 'margin:' in line:
                continue            
                
            if ';\n}\n' not in line:
                line = line.replace('\n}\n', ';\n}\n')
            
            if '{' not in line and \
                '}' not in line and \
                '/*' not in line:
                if not line.endswith(';\n'):
                    line = line.replace('\n', ';\n')
            
            line = line.strip()
            outfp.write(line + '\n')
            
        outfp.close()
        infp1.close()
        
    # creates the new and final stylesheet    
    tmp2 = wdir + os.sep + 'stylesheet.css'
    outfp = open(tmp2, 'wt', encoding=('utf-8'))
    with open(styles, 'rt', encoding=('utf-8')) as infp:       
        for line in infp:        
            outfp.write(line)    
        
        # Add useful globals and presets
        outfp.write('\n/* Added some useful globals, presets and classes */\n')
        outfp.write('p.TOCItem   {\n')
        outfp.write('margin-top: 0.5em;\n')
        outfp.write('margin-right: 0em;\n')
        outfp.write('margin-bottom: 0.5em;\n')
        outfp.write('margin-left: 0em;\n') 
        outfp.write('font-size: 0.9167em;\n')
        outfp.write('font-weight: bold;\n')
        outfp.write('font-style: normal;\n')
        outfp.write('text-indent: 1em;\n')
        outfp.write('text-transform: uppercase;\n')
        outfp.write('color:#00000a;\n')
        outfp.write('}\n')     
        
        outfp.write('body.globals  {\n')
        outfp.write('font-family: "Times New Roman", serif;\n')
        outfp.write('font-size: 1em;\n')
        outfp.write('color:#00000a;\n')
        outfp.write('line-height: 1.2;\n')
        outfp.write('font-style: normal;\n')
        outfp.write('font-weight: normal;\n')
        outfp.write('text-align: justify;\n')
        outfp.write('text-indent: 0em;\n')
        outfp.write('margin: 3% 3% 3% 3%;\n')
        outfp.write('padding: 0;\n')
        outfp.write('}\n')
        
        outfp.write('div  {\n')      
        outfp.write('margin: 0;\n')
        outfp.write('padding:0;\n')
        outfp.write('}\n')
        
        outfp.write('\n/* Classes substituted for html inline styles */\n')
        outfp.write('p.ebk-imagestyle  {\n')      
        outfp.write('text-align: center;\n')
        outfp.write('text-indent: 0em;\n')
        outfp.write('}\n')
        
        outfp.write('p.ebk-centered-text  {\n')      
        outfp.write('margin-top: 0em;\n')
        outfp.write('margin-bottom: 0em;\n')
        outfp.write('text-align: center;\n')
        outfp.write('text-indent: 0em;\n')
        outfp.write('}\n')
        
        outfp.write('p.ebk-blocktext  {\n')
        outfp.write('margin-top: 0em;\n')  
        outfp.write('margin-bottom: 0em;\n')          
        outfp.write('text-align: justify;\n')
        outfp.write('text-indent: 0em;\n')
        outfp.write('}\n')
        
        outfp.write('p.ebk-text-no-indent  {\n')
        outfp.write('margin-top: 0em;\n')
        outfp.write('margin-bottom: 0em;\n')          
        outfp.write('text-align: justify;\n')
        outfp.write('text-indent: 0em;\n')
        outfp.write('}\n')
        
        outfp.write('p.ebk-text-with-indent  {\n')
        outfp.write('margin-top: 0em;\n')
        outfp.write('margin-bottom: 0em;\n')          
        outfp.write('text-align: justify;\n')
        outfp.write('text-indent: 1.5em;\n')
        outfp.write('}\n')
        
        outfp.write('sup  {\n')    
        outfp.write('font-size: 0.833em;\n')
        outfp.write('vertical-align: top;\n')
        outfp.write('margin-left: 0.10em;\n')
        outfp.write('}\n')
        
        outfp.write('sub  {\n')    
        outfp.write('font-size: 0.6em;\n')
        outfp.write('vertical-align: bottom;\n')
        outfp.write('margin-left: 0.30em;\n')
        outfp.write('margin-right: 0.10em;\n')
        outfp.write('}\n')
        
        outfp.write('a:link    {color: blue;text-decoration: none;}\n')
        outfp.write('a:visited {color: blue;text-decoration: none;}\n')
        outfp.write('a:hover   {color: #ff8c00;text-decoration: underline;}\n')
        outfp.write('a:active  {color: blue;text-decoration: none;}\n')
        outfp.write('\n')
        outfp.write('/* Moved remaining indexed inline styles here */\n')  
        
    outfp.close()
    os.remove(styles)
    #os.remove(temp)
    os.remove(temp1)
    
    return(0)

#    
# create a toc file
#
def createTOCFile(pathdir, filenames, files):
    print(' -- Create the TOC file')
    lang = getdefaultlocale()[0]
    if lang == None:
        lang = 'en-US'
    lang = lang.replace("_", "-")
    
    outfile = pathdir + os.sep + 'contents.xhtml'
    outfp = open(outfile, 'wt', encoding=('utf-8'))
    outfp.write('<?xml version="1.0" encoding="utf-8"?>\n')
    outfp.write('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">\n\n')
    outfp.write('<html xml:lang="' + lang + '" xmlns="http://www.w3.org/1999/xhtml">')
    outfp.write('<head>\n')
    outfp.write(' <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>\n')
    outfp.write(' <link href="../Styles/stylesheet.css" type="text/css" rel="stylesheet"/>\n')
    outfp.write(' <title></title>\n')
    outfp.write('</head>\n')
    outfp.write('<body class="globals">\n')
    outfp.write('<h5 style="text-align:center;text-indent:0em;' + \
                'font-size:1.25em;font-weight:bold;margin-top:1em;' + \
                'margin-bottom:1.5em;"><a id="toc">' + \
                '</a>Table of Contents</h5>\n')
    
    i = 1
    max_len = len(files)
    while i < max_len:
               
        # if chapters are only numbers, add 'Chapter'
        filenames[i] = filenames[i].replace('_', ' ')        
        if filenames[i].isdigit() and len(filenames[i]) <= 2:  
            filenames[i] = 'Chapter' + ' ' + filenames[i]
            
        line = '\n<p class="TOCItem">' + '<a href="../Text/' + files[i] + '">' + filenames[i].upper() + '</a></p>'
        outfp.write(line)
        outfp.write('\n')
        i = i + 1
    
    outfp.write('  </body>\n</html>')    
    outfp.close()
    
    return(0)
    
    
def createCoverImageFile(wdir, cover):
    print('\n -- Build the zip archive...')
    print(' -- Creating the cover image file')

    # format the cover image
    img_out = wdir + os.sep + 'cover.xhtml'
    img_fname = os.path.basename(cover)
    
    with open(img_out, 'wt', encoding=('utf-8')) as outfp:
        outfp = addMainHeaders(outfp, 'Cover')
        outfp.write('<div style="padding: 0;margin: 0;">\n')
        outfp.write('    <p style="text-align: center;"><span><img alt="Cover" id="cover" src="../Images/' + img_fname + \
        '" style="height:100%;width:auto;"/></span></p>\n')
        outfp.write('</div>\n')
        outfp.write('\n</body>\n</html>')
      
    return(0)
    

def createOPFFile(work_dir, file_paths):
    outfile = work_dir + os.sep + 'content.opf'  
    with open(outfile, 'wt', encoding=('utf-8')) as outfp:
        print(' -- Add content.opf headers ')
        outfp = addOPFHeaders(outfp)
        print(' -- Add metadata ')
        outfp = addMetadata(outfp)
        print(' -- Add manifest data')
        outfp = addManifestData(outfp) 
        print(' -- Add spine data')
        outfp = addSpineData(outfp)
        print(' -- Add guide data\n')
        outfp = addGuideData(outfp)
    return(0)        

    
def createMIMETYPEFile(work_dir):
    print(' -- Create mimetype file')
    
    mime = work_dir + os.sep + 'MIMETYPE'
    with open(mime, 'wt', encoding=('utf-8')) as outfp:
        outfp.write('application/epub+zip')
        outfp.close()
        os.chmod(mime, 0o777)
    return(1)
    
    
def createContainerXMLFile(work_dir):
    print(' -- Create the container XML file')
    
    outfile = work_dir + os.sep + 'container.xml'  
    with open(outfile, 'wt', encoding=('utf-8')) as outfp:
        outfp.write('<?xml version="1.0" encoding="UTF-8"?>\n')
        outfp.write('<container version="1.0" xmlns="urn:oasis:names:tc:opendocument:xmlns:container">\n')
        outfp.write('    <rootfiles>\n')    
        outfp.write('        <rootfile full-path="OEBPS/content.opf" media-type="application/oebps-package+xml" />\n')
        outfp.write('    </rootfiles>\n')
        outfp.write('</container>')
    return(1)
       
        
def createNCXFile(work_dir, names, file_paths, meta):
    print(' -- Create the toc.ncx XML file')
    
    outf = work_dir + os.sep + 'toc.ncx'
    with open(outf, 'wt', encoding=('utf-8')) as outfp:  
        outfp.write('<?xml version="1.0" encoding="utf-8" ?>\n')
        outfp.write('<!DOCTYPE ncx PUBLIC "-//NISO//DTD ncx 2005-1//EN"\
         "http://www.daisy.org/z3986/2005/ncx-2005-1.dtd"><ncx version="2005-1" xml:lang="en"\
        xmlns="http://www.daisy.org/z3986/2005/ncx/">\n')
        
        outfp.write('  <head>\n')
        outfp.write('    <meta content="urn:uuid:' + meta['book id'] + '" name="dtb:uid"/>\n')
        outfp.write('    <meta content="1" name="dtb:depth"/>\n')
        outfp.write('    <meta content="0" name="dtb:totalPageCount"/>\n')
        outfp.write('    <meta content="0" name="dtb:maxPageNumber"/>\n')
        outfp.write('  </head>\n')
        outfp.write('  <docTitle>\n')
        outfp.write('    <text>' + meta['title'] + '</text>\n')
        outfp.write('  </docTitle>\n')
        outfp.write('  <navMap>\n')
        outfp.write('    <navPoint id="navPoint-1" playOrder="1">\n')
        outfp.write('      <navLabel>\n')
        outfp.write('        <text>Cover</text>\n')
        outfp.write('      </navLabel>\n')
        outfp.write('      <content src="Text/cover.xhtml"/>\n')
        outfp.write('    </navPoint>\n')    
        
        i = 2
        x = 0
        max_count = len(file_paths)
        while x < max_count:
            fp = os.path.basename(file_paths[x])
            #fp = fp.replace('_', ' ')
            #fp = capwords(fp)
            #fp = fp.replace(' ', '_')
            
            fp2 = fp.split('.')[0]
            fp2 = fp2.replace('_',' ')
            
            outfp.write('    <navPoint id="navPoint-' + str(i) + '" playOrder="' + str(i) + '">\n')
            outfp.write('      <navLabel>\n')
            outfp.write('        <text>' + fp2 + '</text>\n')
            outfp.write('      </navLabel>\n')
            outfp.write('      <content src="Text/' + fp + '"/>\n')
            outfp.write('    </navPoint>\n')
            x = x + 1
            i = i + 1
            
        outfp.write('  </navMap>\n')
        outfp.write('</ncx>')         
        
    return(0) 
                    
    
def createOPFHTMLHeader(dir, meta):
    
    opf = dir + os.sep + 'content.opf'
    outfp = open(opf, 'wt', encoding=('utf-8'))
    
    # write the top headers to the opf file
    outfp.write('<?xml version="1.0" encoding="utf-8"?>\n')
    outfp.write('<package version="2.0" unique-identifier="PrimaryID" xmlns="http://www.idpf.org/2007/opf">\n')
    outfp.write('  <metadata xmlns:opf="http://www.idpf.org/2007/opf" xmlns:dc="http://purl.org/dc/elements/1.1/">\n')    
    return(0)
    
    
def addOPFMetadata(dir, meta):
    lang = getdefaultlocale()[0]
    if lang == None:
        lang = 'en'
    if '_' in lang:    
        lang = lang.split("_")[0]
    
    opf_file = dir + os.sep + 'content.opf'
    outfp = open(opf_file, 'a+t', encoding=('utf-8')) 

    # add the metadata template with markers
    #outfp.write('    <dc:date>' + meta['timestamp'] + '</dc:date>\n')
    outfp.write('    <dc:date opf:event="creation">' + meta['date'] + '</dc:date>')
    outfp.write('    <dc:title>' + meta['title'].strip() + '</dc:title>\n')
    outfp.write('    <dc:identifier id="PrimaryID">urn:uuid:' + meta['book id'] + '</dc:identifier>\n')
    outfp.write('    <dc:language>' + lang + '</dc:language>\n')
    outfp.write('    <dc:creator opf:role="aut">' + meta['author'].strip() + '</dc:creator>\n')
    outfp.write('    <dc:publisher>' + meta['publisher'].strip() + '</dc:publisher>\n')
    outfp.write('    <dc:contributor opf:role="bkp">GoogleZipImport</dc:contributor>\n')
    outfp.write('    <dc:rights>Worldwide Copyright ' + meta['year'] + ' ' +  meta['author'].strip() + \
                     '. All Rights Reserved.</dc:rights>\n')
    outfp.write('    <meta name="cover" content="cover-img" />\n')
    outfp.write('  </metadata>\n')
    outfp.close  
    return(0)
    
    
def addManifestData(dir, file_paths, meta, images):
    
    opf_file = dir + os.sep + 'content.opf'
    cover_fname = os.path.basename(meta['cover'])
    outfp = open(opf_file, 'at', encoding='utf-8')
    
    outfp.write('  <manifest>\n')
    outfp.write('    <item id="ncx" href="toc.ncx" media-type="application/x-dtbncx+xml"/>\n')
    outfp.write('    <item id="styles_css" href="Styles/stylesheet.css" media-type="text/css"/>\n')
    outfp.write('    <item id="cover" href="Text/cover.xhtml" media-type="application/xhtml+xml"/>\n')
    outfp.write('    <item id="contents" href="Text/contents.xhtml" media-type="application/xhtml+xml"/>\n')
    outfp.write('    <item id="title" href="Text/title.xhtml" media-type="application/xhtml+xml"/>\n') 
  
    max_len = len(file_paths)
    i = 1
    while i < max_len:
        file_paths[i] = file_paths[i].replace("-", '')
        file_paths[i] = file_paths[i].replace(" ", '_').strip()
        
        fp = file_paths[i]
        outfp.write('    <item id="body' + str(i) + '" href="Text/' + file_paths[i] + '" media-type="application/xhtml+xml"/>\n')
        i = i + 1  
  
    i=0
    while i < len(images):
        # exclude the cover image
        if cover_fname in images[i]:  
            i = i + 1
            continue
        #uid = generateSmallUID()
        uid = '-00' + str(i)
        itype = images[i].split('.')[1]
        if itype == 'jpg':
            itype = 'jpeg'
        
        # add the images, if they exist
        outfp.write('    <item id="img' + uid + '" href="Images/' + images[i] +'" media-type="image/' + itype + '"/>\n') 
        i = i + 1
    
    
    # write the cover image data last    
    img_type = cover_fname.split('.')[1]
    if img_type == 'jpg':
        img_type = 'jpeg'
    outfp.write('    <item id="cover-img" href="Images/' + cover_fname + '" media-type="image/' + img_type + '"/>\n')     
    
    outfp.write('  </manifest>\n')        
    outfp.close()
    
    return(0)    

    
def addSpineData(dir, file_paths):
    
    opf_file = dir + os.sep + 'content.opf'
    outfp = open(opf_file, 'a+t', encoding=('utf-8')) 
    
    outfp.write('  <spine toc="ncx">\n')
    outfp.write('    <itemref idref="cover"/>\n')
    outfp.write('    <itemref idref="contents"/>\n') 
    outfp.write('    <itemref idref="title"/>')
    
    #file_paths.remove('Title.xhtml') 
    #del file_paths[0]
    max_len = len(file_paths)
    i = 1
    while i < max_len:
        outfp.write('    <itemref idref="body' + str(i) + '"/>\n')
        i = i + 1                                  
    outfp.write('  </spine>\n')
    
    outfp.close()
    
    #shutil.copy2(temp1, opf_file)
    #os.remove(temp)
    #os.remove(temp1)
    
    return(0)
    
    
def addGuideData(dir, file_paths):
    print('\n -- Add the Go To guides for toc, cover and begin read.')
    opf_file = dir + os.sep + 'content.opf'
    outfp = open(opf_file, 'at', encoding='utf-8') 
   
    max_len = len(file_paths)
    chapter_1 = ''
    i = 0
    found = False
    while i < max_len:
        # accomodate just numeric only chapters
        if '_1.xhtml' in file_paths[i]:            
            chapter_1 = file_paths[i]
            found = True
            break
        elif 'Chapter_One.xhtml' in file_paths[i]:
            chapter_1 = file_paths[i]
            found = True
            break    
        i = i + 1                
    
    if found == False:
        chapter_1 = 'Title.xhtml'   # set default to "title.xhtml"
    
    i = 0     
    while i < max_len:
        if 'Title' in file_paths[i]:            
            title = file_paths[i]
            break
        else:
            i = i + 1         
    
    outfp.write('  <guide>\n')    
    outfp.write('    <reference  type="cover" title="Cover" href="Text/cover.xhtml"/>\n')
    outfp.write('    <reference  type="toc" title="Contents" href="Text/contents.xhtml"/>\n')
    outfp.write('    <reference  type="text" title="Chapter_1" href="Text/' + chapter_1 + '"/>\n')
    outfp.write('  </guide>\n')
    outfp.write('</package>')
    outfp.close()
    
    return(0)
    
    
def buildOPFFile(WORK_DIR_PATH, file_name_paths, meta, image_names):
    print(' -- Build the content.opf file')
    
    createOPFHTMLHeader(WORK_DIR_PATH, meta)
    addOPFMetadata(WORK_DIR_PATH, meta)
    addManifestData(WORK_DIR_PATH, file_name_paths, meta, image_names)
    addSpineData(WORK_DIR_PATH, file_name_paths)
    addGuideData(WORK_DIR_PATH, file_name_paths)
    return(0)
    
