#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path
from time import sleep
from updater import updateCheck

import options
from cutils import (duplicateFile,
                    checkCoverImageFile,
                    checkMainFile)                         
import tkinter as tk
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 


__all__=["centeredWindow", "MetadataDialog", "populateMetaDialog", "onFileSelect", "onCoverSelect", "onOK", "onCancel"]


def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 75)
    
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))
    
    
class MetadataDialog(tk.Frame):
    def __init__(self, parent):
        tk.Frame.__init__(self, parent, background='#E0E0E0')
        self.parent = parent
        centeredWindow(self.parent, 500, 320)
        parent.minsize(450, 300)
        parent.maxsize(550, 420)
        self.parent.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
        
    def setup_UI(self):
    
        self.labelf1 = LabelFrame(self, text='Edit eBook Details',
                        labelanchor = N,         
                        bg     = '#E0E0E0', 
                        font   = ('arial', 10, 'normal'),                             
                        width  = 300, height=195, 
                        relief = RIDGE
                        )
        self.labelf1.pack(fill=BOTH, expand=1, ipady=27, pady=3, padx=3)
        
        InfoLabel = Label(self.labelf1, 
                        text   = "",
                        fg     = '#E0E0E0',                         
                        bg     = '#E0E0E0', 
                        anchor = S
                        )
        InfoLabel.grid(columnspan=2, sticky=E, row=0)
        
        bookLabel = Label(self.labelf1, 
                        text  = "Book title", 
                        bg    = '#E0E0E0',
                        #font  = ('arial', 9, 'normal') 
                        )
        bookLabel.grid(row=1, sticky=E, padx=20, pady=7)
        
        authorLabel = Label(self.labelf1, 
                        text = "Author", 
                        bg   = '#E0E0E0',
                        #font = ('arial', 9, 'normal')
                        )
        authorLabel.grid(row=2, sticky=E, padx=20, pady=8)
        
        publisherLabel = Label(self.labelf1, 
                        text = "Publisher", 
                        bg   = '#E0E0E0',
                        #font = ('arial', 9, 'normal')
                        )
        publisherLabel.grid(row=3, sticky=E, padx=20, pady=8)
        
        fileLabel = Label(self.labelf1, 
                        text = "HTML file path", 
                        bg   = '#E0E0E0',
                        #font = ('arial', 9, 'normal')
                        )
        fileLabel.grid(row=4, sticky=E, padx=20, pady=8)
        
        coverLabel = Label(self.labelf1, 
                        text = "Book cover file path",                        
                        bg   = '#E0E0E0',
                        #font = ('arial', 9, 'normal')   
                        )
        coverLabel.grid(row=5, sticky=E, padx=20, pady=8)
                         
        self.book = StringVar()
        self.author = StringVar()
        self.publisher = StringVar()
        self.file = StringVar()
        self.cover = StringVar()
        
        bookEntry = Entry(self.labelf1, 
                        width        = 33, 
                        textvariable = self.book, 
                        relief       = FLAT
                        )
        authorEntry = Entry(self.labelf1,  
                        width        = 33, 
                        textvariable = self.author,
                        relief       = FLAT
                        )
        publisherEntry = Entry(self.labelf1,  
                        width        = 33, 
                        textvariable = self.publisher,
                        relief       = FLAT
                        )
        fileEntry = Entry(self.labelf1,  
                        width        = 27, 
                        textvariable = self.file,
                        relief       = FLAT                        
                        )
        coverEntry = Entry(self.labelf1,  
                        width        = 27, 
                        textvariable = self.cover,
                        relief       = FLAT                        
                        )
        bookEntry.grid(sticky=W, row=1, column=1, pady=5)
        authorEntry.grid(sticky=W, row=2, column=1, pady=6)           
        publisherEntry.grid(sticky=W, row=3, column=1, pady=6)   
        fileEntry.grid(sticky=W, row=4, column=1, pady=6)
        coverEntry.grid(sticky=W, row=5, column=1, pady=6)
        
        styler = ttk.Style()
        styler.configure('TButton', background='#E7E7E7', width=5, relief=GROOVE)
        fileButton = ttk.Button(self.labelf1, 
                        text    = "Select", 
                        style   = 'TButton', 
                        command = self.onFileSelect
                        ).grid(row=4, column=1, sticky=E, pady=1)
        
        coverButton = ttk.Button(self.labelf1, 
                        text    = "Select", 
                        style   = 'TButton', 
                        command = self.onCoverSelect
                        ).grid(row=5, column=1, sticky=E, pady=1)
                        
        InfoLabel2 = Label(self.labelf1, 
                        text   = "",
                        fg     = '#E0E0E0',                         
                        bg     = '#E0E0E0', 
                        anchor = S
                        )
        InfoLabel2.grid(row=6, columnspan=2, sticky=E)                
   
        styler = ttk.Style()
        styler.configure('New.TButton', background='#E0E0E0', font=('Helvetica', 10), width=12, relief=FLAT)
        cancelButton = ttk.Button(self.labelf1, 
                        text    = "Cancel", 
                        style   = 'New.TButton', 
                        command = self.onCancel
                        ).grid(row=9, column=1, sticky=E, pady=20)
        
        okButton = ttk.Button(self.labelf1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        ).grid(row=9, column=1, sticky=W, pady=20)       
                        
        #**** Create the statusbar *****#
        self.status = Label(self.labelf1, text=" ",
                        relief = FLAT,
                        bg     = '#E0E0E0',
                        fg     = '#0000FF',
                        font   = ('arial',9,'normal'),
                        anchor = W
                        )
        self.status.grid(row = 10, columnspan=2, sticky=W, padx=3)
        
        # show new plugin version msg if available
        if options.NEW_PLUGIN_VERSION:
            centeredWindow(self.parent, 500, 340)   
            self.status.config(text=options.MSG_NEW_VERSION_AVAILABLE)
        
        bookEntry.focus_set()
        self.populateMetaDialog()
        self.grab_set()      
        
    def populateMetaDialog(self):
        if options.LAST_META == True:
            self.book.set(options.META_OPTIONS['title'])
            self.author.set(options.META_OPTIONS['author'])
            self.publisher.set(options.META_OPTIONS['publisher'])
            self.file.set(options.META_OPTIONS['filename']) 
            self.cover.set(options.META_OPTIONS['cover'])
     
    def onFiction(self):
        if self.fiction.get() == True:        
            options.SET_FICTION_STYLE = True   # set fiction style
            self.chapblock.set(False)     
            options.SET_CHAPTERS_BLOCKTEXT = False  
            self.block.set(False)
            options.SET_ALL_BLOCKTEXT = False    # toggle block text style
            
        else:
            options.SET_FICTION_STYLE = False     
            
    def onChapBlock(self):
        if self.chapblock.get() == True:            
            options.SET_CHAPTERS_BLOCKTEXT = True   # set fiction style
            self.block.set(False)     
            options.SET_ALL_BLOCKTEXT = False    # toggle block text style
            self.fiction.set(False)
            options.SET_FICTION_STYLE = False
        else:
            options.SET_CHAPTERS_BLOCKTEXT = False     
        
    def onBlock(self):
        if self.block.get() == True:            
            options.SET_ALL_BLOCKTEXT = True      # set blck text style
            self.fiction.set(False)
            options.SET_FICTION_STYLE = False   # toggle fiction style
            self.chapblock.set(False)
            options.SET_CHAPTERS_BLOCKTEXT = False
        else:
            options.SET_ALL_BLOCKTEXT = False  
     
    def onFileSelect(self):
        self.file_opt = options.HTML_OPTIONS  
        self.file_opt['parent'] = self  

        sleep(0.25)
        filename = fdbox.askopenfilename(**self.file_opt)
        if filename == '':  # on Cancel --> return
            return(0)
                
        self.file.set(filename)
        return(0)       
        
    def onCoverSelect(self):
        self.file_opt = options.COVER_OPTIONS  
        self.file_opt['parent'] = self  

        sleep(0.25)
        filename = fdbox.askopenfilename(**self.file_opt)
        if filename == '':  # on Cancel --> return
            return(0)
            
        self.cover.set(filename)
        return(0)
           
    def onOK(self):
        if self.book.get() == '' or \
            self.author.get() == '' or \
            self.publisher.get() == '' or \
            self.file.get() == '' or \
            self.cover.get() == '':
            mbox.showwarning('Warning', 'Completing the ebook metadata is mandatory. The conversion to ' + \
                              'epub cannot continue without this data. \n\nPlease fill in all the required data.')
            sleep(0.25)
            return(0)
              
        # Set options for later use      
        options.META_OPTIONS['title'] = self.book.get().strip()
        options.META_OPTIONS['author'] = self.author.get().strip()
        options.META_OPTIONS['publisher'] = self.publisher.get().strip()
        options.META_OPTIONS['filename'] = self.file.get()
        options.META_OPTIONS['cover'] = self.cover.get()
        options.LAST_META = True
        
        # set the user working directory location
        ldir = options.META_OPTIONS['filename']
        ldir = os.path.split(ldir)[0]        
        options.LOCAL_DIR = ldir
       
       ##=========== Input Data Validation ==============##
              
        # check html file path exists
        if checkMainFile(self.file.get()) == 1:             
            return(0)       
       
        # check cover image file path exists    
        if checkCoverImageFile(self.cover.get()) == 1:   
            return(0)     
          
        self.parent.destroy()
       
    def onCancel(self):
        options.SYS_EXIT = True
        print('\n -- Plugin abort...!!')
        self.parent.destroy()
        
