#!/usr/bin/env python
# -*- coding: utf-8 -*-



from __future__ import unicode_literals, division, absolute_import, print_function

from cutils import *
from hformat import *
from epubref import *
from log import *
import options
from zutils import createZipArc
from doc_tidy import docTidyNoWrap, docTidy, docTidyXML

import os.path, shutil, sys
from tempfile import mkdtemp

    
def convert2Epub(file):
    
    ##--------------------- Initialize vars ---------------------## 
    
    # set options and presets
    meta = options.META_OPTIONS      
    WDIR = options.TMP_WORK_DIR = mkdtemp()
    LDIR = options.LOCAL_DIR = os.path.split(file)[0]
    cover_path = meta['cover']
    title = meta['title']
    logmsg9(meta['filename'], 
            meta['author'], 
            meta['title'], 
            meta['cover'])
            
    # get image folder data
    img_folder, img_folder_exists = getImageFolderName(LDIR)
    
    # check that there are images in the folder
    if img_folder_exists == True and len(os.listdir(img_folder)) < 1:
        print('\n >>> Error: No image files were found in the images folder!!')
        shutil.rmtree(WDIR, ignore_errors=True)
        options.SYS_EXIT = True
        shutil.rmtree(WDIR, ignore_errors=True)
        return(1)
    
    # get the ebook images
    images = []
    if img_folder_exists:    
        images = getBookImages(LDIR, meta['cover'])
    else:
        print('\n >>> Warning: The "images" folder was not found.\n')    
    
    temp_file = os.path.join(WDIR, os.path.basename(file)) 
    shutil.copy(file, temp_file)
    file = temp_file
    
    # check and report file encoding
    encoder = checkFileEncoding(WDIR, file)
    file = convertFile2UTF8(WDIR, file, encoder)
    
    ##-------- Sanitize, fix, transform and reformat the html file ----------## 
    
    # reformat the html file and make it readable
    docTidyNoWrap(WDIR, file)
    reformatGoogleHTML(WDIR, file)
    
    # validate html file
    validateHTMLFile(file)
    if options.SYS_EXIT == True:
        shutil.rmtree(WDIR, ignore_errors=True)
        return(1)  
    
    # remove unnecessary proprietary html data
    #fixHTML(WDIR, file)
    
    # remove, cleanup and fix html code
    newfile = sanitizeHTML(file, WDIR, LDIR)
   
    ##------------------ Build epub files ------------------------##
    
    # create CSS file
    createCSSFile(WDIR, newfile)
    formatCSSFile(WDIR)
    
    # reformat inline styles and create named styles
    docTidy(WDIR, newfile)
    docTidyNoWrap(WDIR, newfile)
    
    # move all inline styles to CSS 
    moveInlineStyles2CSS(WDIR, newfile)
    
    # format and add the ebook images
    formatBookImages(LDIR, WDIR, newfile)
    #fixHTML(WDIR, file)
    
    # remove doc TOC
    removeDocTOC(WDIR, file)
    
    # split chapter and main header sections into separate xhtml files
    file_name_paths, pure_file_names = splitHeaders2Files(WDIR, file, newfile, title)
    
    ##--------------- Modify and adjust the CSS ----------------## 
    
    # normalize the css file
    removeBadAttributesfromCSS(WDIR)
    repairCSSErrors(WDIR)
    setGlobalCSSValues(WDIR)
    adjustCSSBody(WDIR)
    cssFinalFormat(WDIR)
    processSuperscript(WDIR)
    convertAbs2RelCSSValues(WDIR)
     
    ##------------------- Build the zip file -------------------## 
    
    # create the epub XML structure
    createCoverImageFile(WDIR, cover_path)
    createTOCFile(WDIR, pure_file_names, file_name_paths)
    createContainerXMLFile(WDIR)

    createNCXFile(WDIR, pure_file_names, file_name_paths, meta)
    buildOPFFile(WDIR, file_name_paths, meta, images)
    
    print(' -- Tidy up all XML layouts')
    docTidyXML(WDIR, os.path.join(WDIR, 'toc.ncx'))
    docTidyXML(WDIR, os.path.join(WDIR, 'content.opf')) 
    
    # create new zip archive
    new_zip = createZipArc(file, LDIR, WDIR, file_name_paths, img_folder_exists, img_folder, images, cover_path)
    
    ##-------------------- Create the epub ------------------------## 
    
    # create the epub file name
    new_epub = new_zip.replace('.zip', '.epub')
    new_epub = os.path.basename(new_epub)
    
    # delete old epub file, if it exists
    new_epub = os.path.join(LDIR, new_epub)
    if os.path.isfile(new_epub):
        os.remove(new_epub)    
          
    print(' -- Converting the zip archive to epub format...\n')    
    shutil.copy2(new_zip, new_epub)
    os.remove(new_zip)
    logmsg53()
      
    # delete temp working dir      
    shutil.rmtree(WDIR, ignore_errors=True)
    return(new_epub)
            
    

