#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os.path
import zipfile

__All__="createZipArc"

def createZipArc(file, LDIR, WDIR, file_name_paths, images, cover_path):
   
    # create the original file name + .zip
    new_zip = file.split('.')[0]
    new_zip = new_zip + '.zip'
    
    # create the new zip archive and populate the ziptree
    new_arc = new_zip
    print(' ')
    print(' -- Create the zip file archive...')
    print(' -- Adding files to the new zip file...')
    myZipFile = zipfile.ZipFile(new_arc, "w", zipfile.ZIP_DEFLATED )
    print(' -- Add mimetype file')
    myZipFile.writestr("mimetype", "application/epub+zip", zipfile.ZIP_STORED)
    print(' -- Add container.xml file')
    myZipFile.write(os.path.join(WDIR, 'container.xml'), os.path.join('META-INF', 'container.xml'), zipfile.ZIP_DEFLATED)
    print(' -- Add toc.ncx file')
    myZipFile.write(os.path.join(WDIR, 'toc.ncx'),  os.path.join('OEBPS', 'toc.ncx'), zipfile.ZIP_DEFLATED)
    print(' -- Add content.opf file')
    myZipFile.write(os.path.join(WDIR, 'content.opf'), os.path.join('OEBPS', 'content.opf'), zipfile.ZIP_DEFLATED)
    print(' -- Add ebook cover file')
    myZipFile.write(os.path.join(WDIR, 'cover.xhtml'), os.path.join('OEBPS', 'Text', 'cover.xhtml'), zipfile.ZIP_DEFLATED)
    print(' -- Add content.xhtml file')
    myZipFile.write(os.path.join(WDIR, 'contents.xhtml'), os.path.join('OEBPS','Text', 'contents.xhtml'), zipfile.ZIP_DEFLATED)
    print(' -- Add stylesheet file')   
    myZipFile.write(os.path.join(WDIR, 'stylesheet.css'), os.path.join('OEBPS', 'Styles', 'stylesheet.css'), zipfile.ZIP_DEFLATED)
    print(' -- Add cover image file')   
    myZipFile.write(cover_path, os.path.join('OEBPS', 'Images', os.path.basename(cover_path)), zipfile.ZIP_DEFLATED)   
    
    print('\n -- Add all ebook image files to the zip Images directory')
    for fname in images:
        fname = os.path.basename(fname)
        if fname == os.path.basename(cover_path):
            continue
        # no spaces allowed in image filename
        fname = fname.replace(' ', '_')     
        myZipFile.write(os.path.join(LDIR, fname), os.path.join('OEBPS', 'Images', fname), zipfile.ZIP_DEFLATED)      
                
    print(' -- Add all XHTML text header files to the zip Text directory')
    files = file_name_paths
    for fname in files:
        fname = os.path.basename(fname)
        if '.xhtml' in fname:        
            myZipFile.write(os.path.join(WDIR, fname), os.path.join('OEBPS', 'Text', fname), zipfile.ZIP_DEFLATED)        
    myZipFile.close()
    
    return(new_zip)
    