# exported by rcS: PLATFORM PRODUCT INTERFACE WIFI_MODULE

PRODUCT=`/bin/kobo_config.sh`
[ $PRODUCT != trilogy ] && PREFIX=$PRODUCT-
PLATFORM=freescale

if [ `dd if=/dev/mmcblk0 bs=512 skip=1024 count=1 | grep -c "HW CONFIG"` == 1 ]; then
  CPU=`ntx_hwconfig -s -p /dev/mmcblk0 CPU`
  PLATFORM=$CPU-ntx
  WIFI=`ntx_hwconfig -s -p /dev/mmcblk0 Wifi`
fi

if [ $CPU ]; then
  PCB=`ntx_hwconfig -s -p /dev/mmcblk0 PCB`
  RAM=`ntx_hwconfig -s -p /dev/mmcblk0 RAMType`
  RAM_SIZE=`ntx_hwconfig -s -p /dev/mmcblk0 RamSize`
fi

versionfilename=/mnt/onboard/.kobo/version

if [ -e ${versionfilename} ]; then
  MODEL_NUMBER=$(awk -F"," '{print $6}' ${versionfilename})
  MODEL_NUMBER=$(echo ${MODEL_NUMBER} | awk '{print substr($0,34,3)}')
  FW=$(awk -F"," '{print $3}' ${versionfilename})
fi



UNAME=$(uname -a)

echo "PLATFORM=${PLATFORM} PRODUCT=${PRODUCT} INTERFACE=${INTERFACE} WIFI_MODULE=${WIFI_MODULE} WIFI=${WIFI}<br>CPU=${CPU} PCB=${PCB} RAM=${RAM} RAM_SIZE=${RAM_SIZE}<br>MODEL_NUMBER=${MODEL_NUMBER} FW=${FW} UNAME=${UNAME}"
