export ksmroot=/mnt/onboard/.adds/ksm_helper
export ksmFontDir=${ksmroot}/fonts
##ksmuser=${ksmuser:-"/mnt/onboard/.adds/kbmenu_user"}

if [ "$(pidof nickel | wc -w)" -ge "1" ]; then
  echo "warning: nickel is still running"
  exit
fi
if [ "$(pidof kobomenu | wc -w)" -ge "1" ]; then
  echo "warning: kobomenu is still running"
  exit
fi

NAME=`/bin/kobo_config.sh 2>/dev/null`
MODEL_NUMBER=$(cut -f 6 -d ',' /mnt/onboard/.kobo/version | sed -e 's/^[0-]*//')
case $NAME in
  alyssum)  DEVICE=GLOHD    ;;
  dahlia)   DEVICE=AURAH2O  ;;
  dragon)   DEVICE=AURAHD   ;;
  phoenix)  DEVICE=AURA     ;;
  kraken)   DEVICE=GLO      ;;
  trilogy)  DEVICE=TOUCH    ;;
  pixie)    DEVICE=MINI     ;;
  pika)     DEVICE=TOUCH2   ;;
  daylight) DEVICE=AURAONE  ;;
  star)     DEVICE=AURA2    ;;
  snow)
    case $MODEL_NUMBER in
      374) DEVICE=AURAH2O2_v1 ;;
      378) DEVICE=AURAH2O2_v2 ;;
      *)   DEVICE=TOUCH ;;
    esac
    ;;
  nova)     DEVICE=CLARAHD  ;;
  frost)    DEVICE=FORMA    ;;
  *)        DEVICE=TOUCH    ;;
esac
export DEVICE



if [ ! -e ${ksmroot}/Qt/plugins/mousedrivers/lib${QWS_MOUSE_PROTO}.so ]; then
  echo "cannot find ${ksmroot}/Qt/plugins/mousedrivers/lib${QWS_MOUSE_PROTO}.so"
  exit
fi


export MODEL_NUMBER=$(cut -f 6 -d ',' /mnt/onboard/.kobo/version | sed -e 's/^[0-]*//')
source ${ksmroot}/onstart/exp_geometryblock



infotext="MODEL_NUMBER=${MODEL_NUMBER}"

setoptions() {
  infotext="MODEL_NUMBER=${MODEL_NUMBER}<br/>selection=${selection}"
  moptions="a b c d e f g h i j k l m n o p q r s t u v w x y z EXIT"
  moptions="-infolines=2 -infotext=${infotext} ${moptions}"
}

selection="empty"

while [ "x$selection" != "xEXIT" ] && [ "x$selection" != "x" ]; do
  setoptions
  selection=$($ksmroot/kobomenu.sh $moptions)
done

infotext="...exited"
moptions="-autoselectafter=1 -ksmAutoselectoption=nothing_special -infolines=2 -infotext=${infotext}"
$ksmroot/kobomenu.sh $moptions
echo "MODEL_NUMBER=${MODEL_NUMBER}<br/>QWS_MOUSE_PROTO=${QWS_MOUSE_PROTO}<br/>mrotation=${mrotation}<br/>ksmrotate=${ksmrotate}<br/>kobomenuFontsize=${kobomenuFontsize}<br/>ksmroot=${ksmroot}"


