//
// Copyright (c) 2013 Mikko Mononen memon@inside.org
//
// This software is provided 'as-is', without any express or implied
// warranty.  In no event will the authors be held liable for any damages
// arising from the use of this software.
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
// 1. The origin of this software must not be misrepresented; you must not
//    claim that you wrote the original software. If you use this software
//    in a product, an acknowledgment in the product documentation would be
//    appreciated but is not required.
// 2. Altered source versions must be plainly marked as such, and must not be
//    misrepresented as being the original software.
// 3. This notice may not be removed or altered from any source distribution.
//

#include <stdio.h>
#include <string.h>
#include <float.h>
#define STB_IMAGE_WRITE_IMPLEMENTATION
#define STB_IMAGE_WRITE_STATIC
#include "stb_image_write.h"
#define NANOSVG_IMPLEMENTATION
#include "../src/nanosvg.h"
#define NANOSVGRAST_IMPLEMENTATION
#include "../src/nanosvgrast.h"

int main(int argc, char* argv[])
{
	NSVGimage *image = NULL;
	NSVGrasterizer *rast = NULL;
	unsigned char* img = NULL;
	int w, h;

	if (argc < 2) {
		fprintf(stderr, "Not enough arguments!\n");
		return -1;
	}

	const char* filename = argv[argc-1];

	printf("Parsing %s\n", filename);
	image = nsvgParseFromFile(filename, "px", 96.0f);
	if (image == NULL) {
		printf("Could not open SVG image.\n");
		goto error;
	}
	w = (int) image->width;
	h = (int) image->height;

	rast = nsvgCreateRasterizer();
	if (rast == NULL) {
		printf("Could not init rasterizer.\n");
		goto error;
	}

	img = malloc(w * h * 4);
	if (img == NULL) {
		printf("Could not alloc image buffer.\n");
		goto error;
	}

	printf("Rasterizing %dx%d image\n", w, h);
	// 0,0 is offset after scaling; while 1 is the scaling factor
	nsvgRasterize(rast, image, 0.0f, 0.0f, 1.0f, img, w, h, w * 4);

	char* output = NULL;
	size_t len = strlen(filename) + 1;
	output = malloc(len);
	snprintf(output, len, "%.*s.png", (int) (len - 5), filename);

	printf("Writing %s\n", output);
	stbi_write_png(output, w, h, 4, img, w*4);

error:
	nsvgDeleteRasterizer(rast);
	nsvgDelete(image);
	free(img);

	return 0;
}
