#!/bin/sh
scriptdir=`/usr/bin/dirname $0`
cd $scriptdir

# Log file
LOGDIR=../logfile
LOGFILE=$LOGDIR/install-log.txt
mkdir $LOGDIR
rm $LOGFILE

# Functions for updating the log file
log_success()
{
	cp manifest_ok.xml $LOGDIR/manifest.xml
	cp icon_ok.png $LOGDIR/icon.png
        echo "Install successful"
}

log_failed()
{
	echo $1
	cat manifest_failed.xml | sed -e "s/ERROR/$1/" > $LOGDIR/manifest.xml
	cp icon_failed.png $LOGDIR/icon.png
}

# Function that returns the first two numbers in the iLiad firmware
parse_firmware()
{
  Firmware_iLiad=$1.$2
}

# Dump everything from now on to the log file
exec 1>> $LOGFILE 2>> $LOGFILE

# Assume the worst case (installation failed) and echo a start message
log_failed "Starting installation"

# Get the firmware of the iLiad
parse_firmware `cat /etc/er_version_commercial | tr '.' ' '`

# Get the firmware for which this script is intended
Firmware_Script=`cat Firmware_Script`

if [ "$Firmware_iLiad" = "$Firmware_Script" ]; then
	# The Java DjVu viewer pre-depends on iliad-regutils:
	ipkg install iliad-regutils_0.1_arm.ipk
	ipkg install -force-overwrite -force-defaults javadjvu_0.4_arm.ipk
        code=$?
        if [ $code = 0 ]; then
        	# Installation successful
		log_success
        else
		# ipkg failed for some reason
		log_failed "ipkg failed with code $code"
        fi
else
	# Wrong firmware version
	log_failed "Firmware $Firmware_Script is needed, your iLiad has got $Firmware_iLiad."
fi
