# v0.7 - Initial plugin idea by ashkulz; modifications by nrapallo (Sept 2008)
#
# Uses Mobi2IMP (dos command) to convert .prc to .imp (EBW1150/REB1200) 'on the fly'...
# Must have Mobi2IMP 9.4 fully installed (to C: drive preferrably) or must edit below .bat.
# See thread http://www.mobileread.com/forums/showthread.php?t=22178 for how to install.

from ebookutils import impserve

class PrcConverter(impserve.ProxyResponse):
    def get_response(self, url, headers, data):
        #debug statements
        #print " URL: ", url
        #print " HEAD: ", headers
        #print " DATA: ", data
        
        # check if we got a Content-Type
        if not 'Content-Type' in headers:
            return headers, data

        ctype = headers['Content-Type']
        if 'text/html' in ctype or 'image/' in ctype or 'application/pdf' in ctype or 'djvu' in ctype or 'application/x-softbook' in ctype:
            return headers, data
        #print " TYPE: ", ctype
            
        import os, subprocess, shutil, re, urllib, tempfile
        from os.path import getsize

	#Extract suggested .prc filename and use it to save a copy to the local 'shelf'
        fname, name = os.path.split(url)
        
        if 'Content-Disposition' in headers:
            m = headers['Content-Disposition']
            name2 = re.compile('filename="?([^"]+)"?').search(m).group(1)
            if name2.lower().endswith('.prc') or name2.lower().endswith('.mobi') or name2.lower().endswith('.pdb'):         
                name = name2
        
        name = urllib.unquote(name)
        
        #filename should end with .prc or .mobi or .pdb (PalmDoc only i.e TEXTt/REAd), if not return.
        if not name.lower().endswith('.prc') and not name.lower().endswith('.mobi') and not name.lower().endswith('.pdb'):         
            return headers, data                 #IGNORING: no compatible .prc/.mobi/.pdb file found

        if impserve.config.ebook_type == 1:
           ext = '_1200.imp'                     #For REB1200
        else:
           ext = '.imp'                          #For EBW1150        

        #need temp dir here 
        tempdir = tempfile.mkdtemp(prefix='impserve-')
        #print '\nTemporary directory: ', tempdir
	cwd = os.getcwd()
        os.chdir(tempdir)

        fname, extorig = os.path.splitext(name)
        open(name, 'wb').write(data)

        #uses local .bat file copy to call Mobi2IMP from install directory and passes up to 9 parameters.
        #Double quotes are a problem so .bat must be fixed to make them work; otherwise no spaces allowed!
        #Currently using 3 parameters below (not including the command).
        f = open('mobi2imp-cmd.bat','w')
        print >>f, "@echo off\n\"C:/Program Files/Mobi2IMP/bin/mobi2imp.exe\" %~1 %2 %3 %4 %~5 %6 %~7 %~8 %~9"
        f.close()
        
        if impserve.config.ebook_type == 1:
            if subprocess.call(['mobi2imp-cmd.bat', '--1200 --1150 --cover --out', fname, name]) or not os.path.isfile(fname+ext):  #For REB1200
                print " IGNORING: mobi2imp unable to convert selected file"
                return headers, data
        else:
            if subprocess.call(['mobi2imp-cmd.bat', '--cover --out', fname, name]) or not os.path.isfile(fname+ext):                #For EBW1150
                print " IGNORING: mobi2imp unable to convert selected file"
                return headers, data

        #Send back converted .imp file instead with new filesize.
        headers['Content-Type'] = 'application/x-softbook'
        headers['Content-Length'] = str(getsize(fname+ext))
        data = open(fname+ext, 'rb').read()
        
        #Cleanup and leave no evidence of 'on-the-fly' conversion.
        os.remove(name)
        shutil.rmtree(fname, True)
	if impserve.config.ebook_type == 1:
            os.remove(fname+'_1200.opf')         #For REB1200
        else:
            os.remove(fname+'.opf')              #For EBW1150
        
        #move .imp ebook to local 'shelf' directory using suggested filename
        #TODO: need to do error-checking if file already exists and if so, append to '_1' or '_2' and so on...
        shelf = impserve.config.shelf_dirs[0]
        shutil.copy(fname+ext, shelf+'/impserve-'+fname+ext)
        os.remove(fname+ext)
        os.chdir(cwd)
        shutil.rmtree(tempdir, True)
        
        #Store just downloaded .imp in (first) local bookshelf and printout ebook Meta data
        info = impserve.get_ebook_info(shelf+'/impserve-'+fname+ext)  
        path, shelf2 = os.path.split(shelf)
        print '', fname+ext, '-downloaded to-', shelf2, 'directory'
        print '', info.title, '-by-', info.author, '-Category-', info.category

        return headers, data