# v0.4 - Initial plugin by nrapallo (Sept 2008)
#
# Uses PDFRead (dos command) to convert .pdf to .imp (EBW1150/REB1200) 'on the fly'...
# Must have PDFRead 1.8 fully installed (to C: drive preferrably) or must edit .bat used.
# See thread http://www.mobileread.com/forums/showthread.php?t=21906 for how to install.

from ebookutils import impserve

# All-in-one design; just set OPTION to your choice's name.
landscape = 1
portrait  = 2
OPTION = landscape

class PdfConverter(impserve.ProxyResponse):
    def get_response(self, url, headers, data):
        #debug statements
        #print " URL: ", url
        #print " HEAD: ", headers
        #print " DATA: ", data
        
        # check if we got a Content-Type
        if not 'Content-Type' in headers:
            return headers, data

        ctype = headers['Content-Type']
        if 'text/html' in ctype or 'image/' in ctype or 'application/octet-stream' in ctype or 'djvu' in ctype or 'application/x-softbook' in ctype:
            return headers, data
        #print " TYPE: ", ctype
            
        import os, subprocess, shutil, re, urllib, tempfile
        from os.path import getsize

        #Extract suggested .pdf filename and use it to save a copy to the local 'shelf'
        fname, name = os.path.split(url)
        
        if 'Content-Disposition' in headers:
            m = headers['Content-Disposition']
            name2 = re.compile('filename="?([^"]+)"?').search(m).group(1)
            if name2.lower().endswith('.pdf'):         
                name = name2
        
        name = urllib.unquote(name)
        
        #filename should end with .pdf, if not return.
        if not name.lower().endswith('.pdf'):
            return headers, data                 #IGNORING: no compatible .pdf file found

        if impserve.config.ebook_type == 1:
           ext = '_1200.imp'                     #For REB1200
        else:
           ext = '.imp'                          #For EBW1150        

        #need temp dir here 
        tempdir = tempfile.mkdtemp(prefix='impserve-')
        #print '\nTemporary directory: ', tempdir
	cwd = os.getcwd()
        os.chdir(tempdir)

        fname, extorig = os.path.splitext(name)
        open(name, 'wb').write(data)

        #uses local .bat file copy to call PDFRead from install directory and passes up to 9 parameters.
        #Double quotes are a problem so are reversed for parameters 2, 4, 6; otherwise no spaces allowed!
        #Currently using 9 parameters below (not including the command).  
        f = open('pdfread-cmd.bat','w')
        print >>f, "@echo off\n\"C:/Program Files/PDFRead/bin/pdfread.exe\" %~1 %2 %~3 %4 %~5 %6 %~7 %8 %9"
        f.close()
 
	if impserve.config.ebook_type == 1:
            if OPTION == landscape:
                if subprocess.call(['pdfread-cmd.bat', '-t', fname, '-a', 'Impserve PDFRead plugin', '-c', 'Converted PDF', '-p reb1200C -i pdf -f imp1 -m landscape-half -o', fname+'_1200', name]) or not os.path.isfile(fname+ext):   #For REB1200
                    print " IGNORING: pdfread unable to convert selected file"
                    return headers, data
            else:
                if subprocess.call(['pdfread-cmd.bat', '-t', fname, '-a', 'Impserve PDFRead plugin', '-c', 'Converted PDF', '-p reb1200Cp -i pdf -f imp1 -m portrait-full -o', fname+'_1200', name]) or not os.path.isfile(fname+ext):   #For REB1200
                    print " IGNORING: pdfread unable to convert selected file"
                    return headers, data
        else:
            if OPTION == landscape:
                if subprocess.call(['pdfread-cmd.bat', '-t', fname, '-a', 'Impserve PDFRead plugin', '-c', 'Converted PDF', '-p ebw1150 -i pdf -f imp2 -m landscape-half -o', fname, name]) or not os.path.isfile(fname+ext):            #For EBW1150
                    print " IGNORING: pdfread unable to convert selected file"
                    return headers, data
            else:
                if subprocess.call(['pdfread-cmd.bat', '-t', fname, '-a', 'Impserve PDFRead plugin', '-c', 'Converted PDF', '-p ebw1150-p -i pdf -f imp2 -m portrait-full -o', fname, name]) or not os.path.isfile(fname+ext):           #For EBW1150
                    print " IGNORING: pdfread unable to convert selected file"
                    return headers, data

        #Send back converted .imp file instead with new filesize.
        headers['Content-Type'] = 'application/x-softbook'
        headers['Content-Length'] = str(getsize(fname+ext))
        data = open(fname+ext, 'rb').read()
        
        #Cleanup and leave no evidence of 'on-the-fly' conversion.
        os.remove(name)
        #move .imp ebook to local 'shelf' directory using suggested filename
        #TODO: need to do error-checking if file already exists and if so, append to '_1' or '_2' and so on...
        shelf = impserve.config.shelf_dirs[0]
        shutil.copy(fname+ext, shelf+'/impserve-'+fname+ext)
        os.remove(fname+ext)
        os.chdir(cwd)
        shutil.rmtree(tempdir, True)
        
        #Store just downloaded .imp in (first) local bookshelf and printout ebook Meta data
        info = impserve.get_ebook_info(shelf+'/impserve-'+fname+ext)  
        path, shelf2 = os.path.split(shelf)
        print '', fname+ext, '-downloaded to-', shelf2, 'directory'
        print '', info.title, '-by-', info.author, '-Category-', info.category

        return headers, data