# v0.2 - Initial plugin idea by ashkulz; modifications by nrapallo (Sept 2008)
#
# Uses Lit2sb (dos command) to convert .lit to .imp (EBW1150/REB1200) 'on the fly'...
# Must have s32lit2sb fully installed (to C: drive preferrably) or must edit .bat used.
# See thread http://www.mobileread.com/forums/showthread.php?t=20592 for how to install.
#
# TODO: when saving a copy to the local 'shelf' need to do error-checking if file already exists and if so, append to '_1' or '_2' and so on...

from ebookutils import impserve

#need to edit path (in line below) to point to your Lit2sb "home" or install directory
LIT2SB_1150 = "C:/Program Files/Lit2sb/GEB1150"

class LitConverter(impserve.ProxyResponse):
    def get_response(self, url, headers, data):
        #debug statements
        #print " URL: ", url
        #print " HEAD: ", headers
        #print " DATA: ", data
        
        # check if we got a Content-Type
        if not 'Content-Type' in headers:
            return headers, data

        ctype = headers['Content-Type']
        if 'text/html' in ctype or 'image/' in ctype or 'application/pdf' in ctype or 'djvu' in ctype or 'application/x-softbook' in ctype:
            return headers, data
        print " TYPE: ", ctype
            
        import os, subprocess, shutil, re, urllib, tempfile
        from os.path import getsize

	#Extract suggested .lit filename and use it to save a copy to the local 'shelf'
        fname, name = os.path.split(url)
        
        if 'Content-Disposition' in headers:
            m = headers['Content-Disposition']
            name2 = re.compile('filename="?([^"]+)"?').search(m).group(1)
            if name2.lower().endswith('.lit'):         
                name = name2
        
        name = urllib.unquote(name)
        
        #Extract suggested .lit filename and use it to save a copy to the local 'shelf'
        if not name.lower().endswith('.lit'):         
            return headers, data                 #IGNORING: no compatible .lit file found

        if impserve.config.ebook_type == 1:
           ext = '_1200.imp'                     #For REB1200
        else:
           ext = '.imp'                          #For EBW1150        

        #need temp dir here 
        tempdir = tempfile.mkdtemp(prefix='impserve-')
        #print '\nTemporary directory: ', tempdir
	cwd = os.getcwd()
        os.chdir(tempdir)

        fname, extorig = os.path.splitext(name)
        open(name, 'wb').write(data)

        #uses local .bat file copy to call Lit2Sb from install directory and passes up to 9 parameters.
        #Double quotes are a problem so .bat must be fixed to make them work; otherwise no spaces allowed!
        #Currently using 1 parameters below (not including the command).
        f = open('dolit.bat','w')
        print >>f, "@echo off\nstart /wait %1"
        f.close()
        
 	if impserve.config.ebook_type == 1:
 	    if os.path.exists(LIT2SB_1150):
 	        os.remove(LIT2SB_1150)
            if subprocess.call(['dolit.bat', name]) or not os.path.isfile(fname+'.imp'):     #For REB1200
                print " IGNORING: lit2sb unable to convert selected file"
                return headers, data
            shutil.move(fname+'.imp', fname+ext)
        else:
 	    if not os.path.exists(LIT2SB_1150):
                f = open(LIT2SB_1150,'w')
                print >>f, " "
                f.close()
            if subprocess.call(['dolit.bat', name]) or not os.path.isfile(fname+ext):        #For EBW1150
                print " IGNORING: lit2sb unable to convert selected file"
                return headers, data
        
        #Send back converted .imp file instead with new filesize.
        headers['Content-Type'] = 'application/x-softbook'
        headers['Content-Length'] = str(getsize(fname+ext))
        data = open(fname+ext, 'rb').read()
        
        #Cleanup and leave no evidence of 'on-the-fly' conversion.
        os.remove(name)
        
        #move .imp ebook to local 'shelf' directory using suggested filename
        #TODO: need to do error-checking if file already exists and if so, append to '_1' or '_2' and so on...
        shelf = impserve.config.shelf_dirs[0]
        shutil.copy(fname+ext, shelf+'/impserve-'+fname+ext)
        os.remove(fname+ext)
        os.chdir(cwd)
        shutil.rmtree(tempdir, True)
        
        #Store just downloaded .imp in (first) local bookshelf and printout ebook Meta data
        info = impserve.get_ebook_info(shelf+'/impserve-'+fname+ext)  
        path, shelf2 = os.path.split(shelf)
        print '', fname+ext, '-downloaded to-', shelf2, 'directory'
        print '', info.title, '-by-', info.author, '-Category-', info.category

        return headers, data
