# v0.3 - Initial plugin by nrapallo (Sept 2008)
#
# Sets the smallest reader font to use, where possible.
# eBook Publisher default: '3' (small) for EBW1150 or '2' (x-small) for REB1200.
# Use "<font size='1'>" for xx-small font; '2' for x-small; '3' for small; '4' for medium; '5' for large; '6' for x-large.

from ebookutils import impserve

class AdjustSmallestFont(impserve.ProxyResponse):
    def get_response(self, url, headers, data):
        if not 'text/html' in headers['Content-Type']:
            return headers, data

	# force smallest font for entire webpage, if possible (crude, but works!)
	if impserve.config.ebook_type == 1:
            data = "<font size='1'>" + data + "</font>"              #For REB1200
        else:
            data = "<font size='2'>" + data + "</font>"              #For EBW1150
	
        return headers, data