# v0.4 - Initial plugin by nrapallo (Sept 2008)
#
# Converts any large image (bigger than 128x128) down to 128x128 and,
# if not already, based on OPTION set below:
#     Orig:   converts it to a 256 color!
#     B&W:    converts it to a B&W GIF!
#     Box:    converts any large image (bigger than 128x128) down to 64x64 (boxed) GIF
#             REQUIRED:  box.gif must to be in the plugins directory (Hint: use your own image!)
#     Dot:    converts any large image (bigger than 128x128) down to 1x1 (blank) GIF
#             REQUIRED:  dot.gif must to be in the plugins directory
#     GIF16:  converts it to a 16 color GIF!
#     GIF256: converts it to a 256 color GIF!
#     PNG16:  converts it to a 16 color PNG!
#     PNG256: converts it to a 256 color PNG!
#
# Requires PIL (Python Image Library) to be installed ( see http://www.pythonware.com/products/pil/ ).

from ebookutils import impserve

# All-in-one design; just set OPTION to your choice's name.
Orig   = 1
GIF256 = 2
GIF16  = 4
PNG256 = 3
PNG16  = 5
BW     = 6
Box    = 7
Dot    = 8
OPTION = Orig

size = 128, 128

class AdjustImageSize(impserve.ProxyResponse):
    def get_response(self, url, headers, data):
        #print headers       #debug statement

        if not 'image/' in headers['Content-Type']:
            return headers, data

        import os
        from os.path import getsize
        from PIL import Image

	# save a copy locally so that can 'open' image
        open('plugins/impserve.image', 'wb').write(data)
	
        im = Image.open('plugins/impserve.image')

        if im.size > size:
                print  " Old image --> ", im.format, im.size, im.mode
                oldsize = getsize('plugins/impserve.image')
                if OPTION == Orig:
		    oldformat = im.format
                    colors_selected = 256

                    #convert image to 8-bit color, paletted, if not "JPEG" 
                    if im.format != "JPEG":
                        if impserve.config.ebook_type == 1:
                            im = im.convert('P', palette=Image.ADAPTIVE, colors=colors_selected, dither=Image.FLOYDSTEINBERG)   #For REB1200
                        else:
                            im = im.convert('L', palette=Image.ADAPTIVE, colors=colors_selected, dither=Image.FLOYDSTEINBERG)   #For EBW1150

                    #convert image to 128x128 thumbnail
                    im.thumbnail(size, Image.ANTIALIAS)

                    im.format = oldformat                #Kludge: must tell im what format it was after convert
                                
        	    im.save('plugins/impserve.thumbnailorig.'+oldformat, im.format)
                    print " New image --> ", im.format, im.size, im.mode, "reduced to %3d%%" % (getsize('plugins/impserve.thumbnailorig.'+oldformat) * 100 / oldsize)
        
        	    # save a copy locally so that can return image
         	    data = open('plugins/impserve.thumbnailorig.'+oldformat, 'rb').read()                
                    headers['Content-Length'] = str(getsize('plugins/impserve.thumbnailorig.'+oldformat))
                
                    os.remove('plugins/impserve.thumbnailorig.'+oldformat)
                elif OPTION == GIF256 or OPTION == GIF16 or OPTION == BW:
                    if OPTION == GIF256:
                        colors_selected = 256
                    elif OPTION == GIF16:
                        colors_selected = 16
                    else:
                        colors_selected = 2
                    
                    if impserve.config.ebook_type == 1:
                        #convert image to 8-bit/4-bit/1-bit color, paletted for REB1200 
                        im = im.convert('P', palette=Image.ADAPTIVE, colors=colors_selected, dither=Image.FLOYDSTEINBERG)
                    else:
                        #convert image to 8-bit/4-bit/1-bit grayscale, paletted for EBW1150
                        im = im.convert('L', palette=Image.ADAPTIVE, colors=colors_selected, dither=Image.FLOYDSTEINBERG)
                
                    #convert image to 128x128 thumbnail
                    im.thumbnail(size, Image.ANTIALIAS)

                    im.format = "GIF"    #Kludge: must tell im what format it was after convert
                
                    im.save('plugins/impserve.thumbnail.gif', 'GIF')
        	
                    print " New image --> ", im.format, im.size, im.mode, "reduced to %3d%%" % (getsize('plugins/impserve.thumbnail.gif') * 100 / oldsize)
        
                    # save a copy locally so that can return image
                    data = open('plugins/impserve.thumbnail.gif', 'rb').read()                
                    headers['Content-Type'] = 'image/gif'
                    headers['Content-Length'] = str(getsize('plugins/impserve.thumbnail.gif'))
                
                    os.remove('plugins/impserve.thumbnail.gif')
                elif OPTION == PNG256 or OPTION == PNG16:
                    if OPTION == PNG256:
                        colors_selected = 256
                    else:
                        colors_selected = 16
                    
                    if impserve.config.ebook_type == 1:
                        #convert image to 8-bit/4-bit color, paletted for REB1200 
                        im = im.convert('P', palette=Image.ADAPTIVE, colors=colors_selected, dither=Image.FLOYDSTEINBERG)
                    else:
                        #convert image to 8-bit/4-bit grayscale, paletted for EBW1150
                        im = im.convert('L', palette=Image.ADAPTIVE, colors=colors_selected, dither=Image.FLOYDSTEINBERG)
                
                    #convert image to 128x128 thumbnail
                    im.thumbnail(size, Image.ANTIALIAS)

                    im.format = "PNG"    #Kludge: must tell im what format it was after convert
        	
                    im.save('plugins/impserve.thumbnail.png', 'PNG', optimize=1)

                    print " New image --> ", im.format, im.size, im.mode, "reduced to %3d%%" % (getsize('plugins/impserve.thumbnail.png') * 100 / oldsize)
        
                    # save a copy locally so that can return image
                    data = open('plugins/impserve.thumbnail.png', 'rb').read()                
                    headers['Content-Type'] = 'image/png'
                    headers['Content-Length'] = str(getsize('plugins/impserve.thumbnail.png'))
                
                    os.remove('plugins/impserve.thumbnail.png')
                elif OPTION == Box:
                    print " New image --> ", "GIF", "(64, 64)", "1", "reduced to %3d%%" % (getsize('plugins/box.gif') * 100 / oldsize)
        
                    # saved box.gif copy (locally) is returned as image
                    data = open('plugins/box.gif', 'rb').read()                
                    headers['Content-Type'] = 'image/gif'
                    headers['Content-Length'] = str(getsize('plugins/box.gif'))
                
                    os.remove('plugins/box.gif')
                elif OPTION == Dot:
                    print " New image --> ", "GIF", "(1, 1)", "1", "reduced to %3d%%" % (getsize('plugins/dot.gif') * 100 / oldsize)
        
                    # saved dot.gif copy (locally) is returned as image
                    data = open('plugins/dot.gif', 'rb').read()                
                    headers['Content-Type'] = 'image/gif'
                    headers['Content-Length'] = str(getsize('plugins/dot.gif'))
                
                    os.remove('plugins/dot.gif')
                else:
                    print " New image --> (no OPTION chosen, see AdjustImageSize plugin)"
         	
	del im
        os.remove('plugins/impserve.image')  
        
        return headers, data