#!/usr/bin/env python2
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__docformat__ = 'restructuredtext en'

# A class to extract the tables of contents from selected ePub files to a CSV file.
# This was developed to enable me to make a list of short stories in my collection
# of anthologies. It incorporates a copy of https://pypi.org/project/Unidecode/
# which is used to flatten all strings to ASCII, since Microsoft Excel seems to
# be allergic to UTF-8. The authors, titles and series are all converted to title
# case to make it easier to sort the output file.

from calibre.customize import InterfaceActionBase

class ExtractToCs(InterfaceActionBase):
    name                = 'Extract ToCs'
    description         = _('Extract tables of contents from selected ePub files to CSV')
    supported_platforms = ['windows', 'osx', 'linux']
    author              = 'Phssthpok'
    version             = (1, 0, 0)
    minimum_calibre_version = (1, 0, 0)
    actual_plugin       = 'calibre_plugins.extract_tocs.main:ExtractToCsAction'

    def is_customizable(self):
        return False
