#!/usr/bin/env python2
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__docformat__ = 'restructuredtext en'

from calibre_plugins.extract_tocs.progress  import ProgressDialog
from calibre.gui2                           import error_dialog, choose_save_file
from calibre.gui2.actions                   import InterfaceAction

class ExtractToCsAction(InterfaceAction):

    name = 'Extract ToCs'
    # Create our top-level menu/toolbar action (text, icon_path, tooltip, keyboard shortcut)
    action_spec = (name, None, _('Extract the tables of contents of selected ePub files'), ())

    def genesis(self):
        icon = get_icons('images/icon.png')
        self.qaction.setIcon(icon)
        self.qaction.triggered.connect(self.extract_tocs)

    def extract_tocs(self):
        rows = self.gui.library_view.selectionModel().selectedRows()
        if not rows or len(rows) == 0:
            return error_dialog(self.gui, _('Cannot process books'),
                                _('You must select one or more books to perform this action.'),
                                show=True)

        book_ids    = set(self.gui.library_view.get_selected_ids())
        db          = self.gui.current_db.new_api
        book_epubs  = []
        
        for book_id in book_ids:
            if db.has_format(book_id, 'EPUB'):
                book_epubs.append(book_id)

        if not book_epubs:
            return error_dialog(self.gui, _('Cannot process books'),
                                _('No ePub available. First convert the books to ePub.'),
                                show=True)

        dlg = ProgressDialog(self.gui, book_epubs)
        if dlg.wasCanceled():
            return error_dialog(self.gui, _('Cancelled'),
                                _('Extraction of ToCs cancelled.'),
                                show=True)
        else:
            csvname = choose_save_file(self.gui, 'extract-tocs-save-file', _('Choose file location'),
                                       filters=[(_('CSV files'), ['csv'])], all_files=False)
            if csvname:
                with open(csvname, mode='w') as csv:
                    csv.write(_('"Authors","Title","Series","Index","ToC Entry"\n'))
                    for item in dlg.toc_items:
                        csv.write('"%s"\n' % '","'.join(item))
            
