# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.132"  # Technical Changes

import os,sys,apsw,ast,copy,json,re,subprocess,time,uuid
from difflib import SequenceMatcher
from functools import partial
from time import sleep

from PyQt5.Qt import (Qt, QMenu, QDialog, QIcon, QAction, QSize, QWidget, QRegularExpression, QTimer,
                                       QFileDialog,QObject,QApplication, QPoint, QPalette, QComboBox, QInputDialog)

from calibre import isbytestring, sanitize_file_name_unicode
from calibre.constants import filesystem_encoding, DEBUG, iswindows
from calibre.db.backend import DB, _author_to_author_sort
from calibre.db.cache import Cache as dbcache
from calibre.ebooks.metadata.book.base import Metadata
from calibre.gui2 import __init__, gprefs, FileDialog, error_dialog, question_dialog, info_dialog, Dispatcher
from calibre.gui2.actions import InterfaceAction
from calibre.utils.config import config_dir, JSONConfig, from_json
from calibre.utils.html2text import html2text

from calibre.ebooks.metadata import title_sort, get_title_sort_pat, author_to_author_sort, string_to_authors, authors_to_string
_title_pats = {}
_ignore_starts = u'\'"'+u''.join(unichr(x) for x in
        range(0x2018, 0x201e)+[0x2032, 0x2033])

from calibre_plugins.job_spy.__init__ import JS_DESCRIPTION
from calibre_plugins.job_spy.config import prefs,PREFS_NAMESPACE,PREFS_KEY_SETTINGS
from calibre_plugins.job_spy.config import ConfigWidget
from calibre_plugins.job_spy.common_utils import set_plugin_icon_resources, get_icon, get_pixmap, get_local_images_dir, create_menu_action_unique
from calibre_plugins.job_spy.jobs import start_threaded_js_extract_original_title_translator, start_threaded_js_add_null_values



if 'GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_REGEX' in prefs:
    VL_REGEX = prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_REGEX']
else:
    VL_REGEX = "[-]+[0-9]+$"

PREFS_NAMESPACE = 'JobSpyPlugin'
PREFS_KEY_SETTINGS = 'settings'

PLUGIN_ICONS = ['images/job_spy.png','images/wrench-hammer.png','images/minus.png','images/plus.png', \
'images/execute.png','images/calendar_month.png','images/search.png','images/unlinked.png', \
'images/dropdown.png','images/protect.png','images/piechart.png','images/purge.png','images/reading_list.png',\
'images/translate.png', 'images/html2text.png', 'images/view_manager.png', 'images/ignore.png', 'images/rainbow.png',\
'images/vacuum.png','images/shortcuts.png','images/lookfeel.png','images/exec.png','images/config.png','images/column.png',\
'images/ftp.png','images/empty_value.png','images/change.png', 'images/spreadsheet.png','images/null.png',\
'images/user_category.png','images/polish.png','images/authorsort.png','images/quill.png','images/import.png','images/export.png',
'images/nothing_found.png','images/filenotfound.png']

#-------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------
RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS = False   # development and testing only
if DEBUG:
    if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
        print("RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS", RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS)
#-------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------
class ActionJobSpy(InterfaceAction):

    name = 'Job Spy'
    action_spec = ('JS+','images/job_spy.png', JS_DESCRIPTION, None)
    action_type = 'global'
    accepts_drops = False
    auto_repeat = False
    priority = 1
    popup_type = 1

    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def genesis(self):
        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources )
        self.menu = QMenu(self.gui)
        self.menu.aboutToShow.connect(self._about_to_show_menu)
        self.built_already = False
        #~ self.build_menus(self.gui)  # must defer until self.guidb exists due to apsw lookup for menu names...dynamic menus...
        self.qaction.setMenu(self.menu)
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.qaction.triggered.connect(self.spy_on_jobs)

        self.tweak_thread_is_running = False
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def _about_to_show_menu(self):
        # Need to rebuild the menus each time shown, because the associated
        # QAction objects likely have changed due to different Group names...
        if not self.built_already:
            return

        self.get_reserved_prefs()   #need column labels for matrix for group names...

        #dynamic names based on the library...the "about to show" is critical for this; otherwise, silent crash in Qt...soon.

        #~ only rebuild self.j3, since that is the only submenu with dynamic menu names...

        self.js3.clear()    # if the user changes a group name, the old menu item with that old name would otherwise still be displayed on the menu...

        unique_name = "JS+:GUI Tool:   Protect/Unprotect Custom Columns from Edit Metadata Dialogs"
        menu_desc = unique_name.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_normal),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js3.addSeparator()

        create_menu_action_unique(self, self.js3, ' ', ' ',
                              triggered=None)
        self.js3.addSeparator()

        unique_name1 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name1 = unique_name1.replace("Group [G]",self.group1_name)
        menu_desc1 = unique_name1.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc1, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group1),unique_name=unique_name1, favourites_menu_unique_name=unique_name1)
        self.js3.addSeparator()

        unique_name2 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name2 = unique_name2.replace("Group [G]",self.group2_name)
        menu_desc2 = unique_name2.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc2, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group2),unique_name=unique_name2, favourites_menu_unique_name=unique_name2)
        self.js3.addSeparator()

        unique_name3 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name3 = unique_name3.replace("Group [G]",self.group3_name)
        menu_desc3 = unique_name3.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc3, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group3),unique_name=unique_name3, favourites_menu_unique_name=unique_name3)
        self.js3.addSeparator()

        unique_name4 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name4 = unique_name4.replace("Group [G]",self.group4_name)
        menu_desc4 = unique_name4.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc4, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group4),unique_name=unique_name4, favourites_menu_unique_name=unique_name4)
        self.js3.addSeparator()

        unique_name5 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name5 = unique_name5.replace("Group [G]",self.group5_name)
        menu_desc5 = unique_name5.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc5, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group5),unique_name=unique_name5, favourites_menu_unique_name=unique_name5)
        self.js3.addSeparator()

        unique_name6 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name6 = unique_name6.replace("Group [G]",self.group6_name)
        menu_desc6 = unique_name6.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc6, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group6),unique_name=unique_name6, favourites_menu_unique_name=unique_name6)
        self.js3.addSeparator()
        #END submenu js3 ----------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def library_changed(self,guidb):

        self.guidb = guidb

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTHOR_SORT_COPY_METHOD'] == unicode("True"):
            self.apply_author_sort_method_by_library()
            self.maingui.tags_view.recount()

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_ADD_BOOKS_READ_METADATA_FROM_FILE_CONTENTS_NOT_NAME'] == unicode("True"):
            self.apply_read_file_metadata_pref_by_library()

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'] == unicode("True"):
            self.apply_auto_add_directory_by_library(source="library_changed")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'] == unicode("True"):
            self.apply_save_to_directory_by_library(source="library_changed")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] == unicode("True"):
            self.apply_save_to_template_by_library(source="library_changed")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_COVER_SEPARATELY_BY_LIBRARY'] == unicode("True"):
            self.apply_save_cover_separately_option_by_library(source="library_changed")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY'] == unicode("True"):
            self.apply_default_output_format_option_by_library(source="library_changed")

        self.qf_ids_previous = []

        try:
            self.purge_prefs_dialog.close()
        except:
            pass
        try:
            self.cc_editable_dialog.close()
        except:
            pass
        try:
            self.my_copy_saved_searches_dialog.close()
        except:
            pass
        try:
            self.my_visualize_metadata_dialog.close()
        except:
            pass
        try:
            self.cctechnicallistingdialog.close()
        except:
            pass
        #~ try:
            #~ self.rowspy_dialog.close()      # do not do this due to event-connects requiring disconnects...
        #~ except:
            #~ pass
        try:
            self.copy_user_categories_dialog.close()
        except:
            pass
        #~ try:
            #~ self.formatspy_dialog.close()      # do not do this due to event-connects requiring disconnects...
        #~ except:
            #~ pass
        try:
            self.tagbrowsericonsdialog.close()
        except:
            pass
        try:
            self.remove_id_types_dialog.close()
        except:
            pass
        try:
            self.copy_virtual_libraries_dialog.close()
        except:
            pass

        try:
            if  self.tweak_thread_is_running:
                self.tweak_thread_is_running = False
                try:
                    self.tweak_thread.stop()
                except Exception as e:
                    if DEBUG: print("JS+ self.tweak_thread.stop(): ", str(e))
                if DEBUG: print("JS+ Tweak Widget Properties Daemon has been STOPPED due to a Library change. ")
                try:
                    del self.tweak_thread
                except:
                    pass
                self.gui.status_bar.show_message(_('Edit Metadata Dropdown Daemon has been STOPPED due to a Library change'), 10000)
            else:
                pass
        except Exception as e:
            if DEBUG: print("JS+ Library Change:  Unexpected Error: ", str(e))
            self.tweak_thread_is_running = False

        try:
            del self.current_custom_columns_list
        except:
            pass
        self.current_custom_columns_list = []
        tmp_list = self.guidb.custom_field_keys()
        for row in tmp_list:
            self.current_custom_columns_list.append(row)
        #END FOR
        del tmp_list
        self.current_custom_columns_list.sort()

        self.custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_AUTORUN'] == unicode("True"):
            if prefs['GUI_TOOLS_ADD_NULL_VALUES_ACTIVE'] == unicode("True"):
                self.autorun_add_null_values()

        try:
            self.quality_fix_original_titles_dict.clear()
        except:
            pass

        if prefs['GUI_TOOLS_TAGBROWSER_ICONS_AUTO_SET_AT_STARTUP']  == unicode("True"):
            if DEBUG: print("JS Tag Browser Icons Tool is running at Library Changed")
            self.tagbrowser_icon_tool_is_running = True
            self.ensure_icon_directory_exists()
            self.apply_tagbrowser_custom_icons()   #after every tag_browser.recount() and after the library changes
        else:
            self.tagbrowser_icon_tool_is_running = False

        #----------------------------------------
        self.migrate_table_preferences_for_jobspy()   #current library only...purge table preferences for JS (and do not create anything)
        #----------------------------------------
        #----------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def initialization_complete(self):

        if DEBUG: print("Job Spy has begun initialization...")

        self.guidb = self.gui.library_view.model().db

        self.search_bar_object_set = None

        self.tweak_thread_is_running = False

        self.job_is_running = False

        self.gprefs = gprefs
        #----------------------------------------
        #----------------------------------------
        for k,v in prefs.defaults.iteritems():
            if k in prefs:
                continue
            else:
                prefs[k] = v
                prefs
        #END FOR
        #----------------------------------------
        #----------------------------------------
        try:
            from calibre.gui2.ui import get_gui
            self.maingui = get_gui()
        except Exception as e:
            if DEBUG: print(str(e))
            self.maingui = None
        #----------------------------------------
        #----------------------------------------
        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_ADD_BOOKS_READ_METADATA_FROM_FILE_CONTENTS_NOT_NAME'] == unicode("True"):
            self.apply_read_file_metadata_pref_by_library()  #execute as early as feasible due to Pools...

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTHOR_SORT_COPY_METHOD'] == unicode("True"):
            self.apply_author_sort_method_by_library()
            self.maingui.tags_view.recount()

        self.original_global_auto_add_path = None
        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'] == unicode("True"):
            self.apply_auto_add_directory_by_library(source="initialization_complete")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'] == unicode("True"):
            self.apply_save_to_directory_by_library(source="initialization_complete")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] == unicode("True"):
            self.apply_save_to_template_by_library(source="initialization_complete")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_COVER_SEPARATELY_BY_LIBRARY'] == unicode("True"):
            self.apply_save_cover_separately_option_by_library(source="initialization_complete")

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY'] == unicode("True"):
            self.apply_default_output_format_option_by_library(source="initialization_complete")
        #----------------------------------------
        #----------------------------------------
        self.migrate_table_preferences_for_jobspy()  #current library only
        #----------------------------------------
        #----------------------------------------
        if "ALL_LIBRARIES_INITIALIZED_FOR_JS_SETTINGS_INITIALIZATION" in prefs:   # deprecated
            del prefs['ALL_LIBRARIES_INITIALIZED_FOR_JS_SETTINGS_INITIALIZATION']
            prefs

        if 'ALL_LIBRARIES_CONVERTED_FOR_JS_SETTINGS_EXECUTION_COUNT' in prefs:   # deprecated
            del prefs['ALL_LIBRARIES_CONVERTED_FOR_JS_SETTINGS_EXECUTION_COUNT']
            prefs

        if 'ALL_LIBRARIES_INITIALIZED_FOR_JS_SETTINGS_LIBRARY_CHANGED' in prefs:  # deprecated
            del prefs['ALL_LIBRARIES_INITIALIZED_FOR_JS_SETTINGS_LIBRARY_CHANGED']
            prefs
        #----------------------------------------
        #----------------------------------------
        if 'GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_SORTS_COMPLEX_SURNAMES' in prefs:  # deprecated
            del prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_SORTS_COMPLEX_SURNAMES']
            prefs
        #----------------------------------------
        #----------------------------------------
        self.jobs_to_show_consecutively = int(prefs['JOBS_TO_SHOW_CONSECUTIVELY'])

        self.my_jobs_dialog_object = None
        self.my_virtual_library_pushbutton_object = None
        self.my_copytolibraryaction_object = None

        try:
            found_jobsdialog = False
            found_jobsmanager = False
            found_vlbutton = False
            sre = QRegularExpression(".+")
            answer  = self.gui.findChildren(QWidget,sre)
            if answer:
                if isinstance(answer,list):
                    for item in answer:
                        if item:
                            s = str(item)
                            #~ if DEBUG: print(item.staticMetaObject.className(),item.objectName(),s)
                            if "JobsDialog" in s:
                                self.my_jobs_dialog_object = item
                                found_jobsdialog = True
                                #~ if DEBUG: print(item.staticMetaObject.className(),item.objectName(),s)
                            if prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_CLICK_RELEASE_ACTIVE'] == unicode("True"):
                                if item.staticMetaObject.className() == "QToolButton":
                                    if item.objectName() == "virtual_library":
                                        self.my_virtual_library_pushbutton_object = item
                                        self.my_virtual_library_pushbutton_object.released.connect(self.vl_pushbutton_released_event)
                                        found_vlbutton = True
                                        #~ if DEBUG: print(item.staticMetaObject.className(),item.objectName(),s)
                            if found_jobsdialog and found_vlbutton:
                                break
                    #END FOR
                    del answer
        except Exception as e:
            if DEBUG: print("Exception in initialization_complete(): ", str(e))
            self.my_jobs_dialog_object = None
            self.my_virtual_library_pushbutton_object = None

        #----------------------------------------
        if prefs['GUI_TOOLS_VISIBLE_ITEMS_SEARCHBAR_AUTORUN'] == unicode("True"):
            self.searchbar_increase_visible_items()
        #----------------------------------------

        if prefs['JOB_SPY_GRACEFUL_SHUTDOWN_LAST_TIME'] == unicode("True"):
            if prefs['GUI_TOOLS_VISIBLE_ITEMS_EDIT_METADATA_AUTORUN'] == unicode("True"):
                self.start_stop_tweak_widget_properties_daemon()
        else:
            prefs['GUI_TOOLS_VISIBLE_ITEMS_EDIT_METADATA_AUTORUN'] = unicode("False")
            prefs
            if prefs['GUI_TOOLS_TAGBROWSER_ICONS_AUTO_SET_AT_STARTUP']  == unicode("True"):
                prefs['GUI_TOOLS_TAGBROWSER_ICONS_AUTO_SET_AT_STARTUP']  = unicode("False")
                prefs
                msg = "Job Spy has automatically gone into 'Safe Mode' because Calibre was 'Aborted' last time, rather than Shutting Down gracefully.\
                           <br><br>The JS Customization for the 'Tag Browser Custom Icons' GUI Tool has been 'Deactivated'.\
                           <br><br>If you intentionally 'Aborted' or 'abnormally ended' Calibre last session, and this GUI Tool was not the reason you did so, then you may 'Activate' it in the Tag Browser Custom Icon Assignment customization if you wish, and then Restart Calibre.\
                           <br><br>If that GUI Tool <b>was</b> the reason for the 'abnormal end' of Calibre last session, please 'Activate' it but immediately Restart Calibre in <b>Debug Mode</b> to capture any error details generated by your activity.  Save the Debug Log as a text file, and then provide it to the JS developer for action.  Thank you."
                info_dialog(self.gui, 'Calibre Previous Shutdown Improper',msg).show()
                if DEBUG: print(msg)

        if DEBUG: print("Calibre, and hence Job Spy, was gracefully shut down last time? ", prefs['JOB_SPY_GRACEFUL_SHUTDOWN_LAST_TIME'])
        if DEBUG: print("Last time daemon started: ", prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_LAST_STARTED'])
        if DEBUG: print("Last time daemon failed: ", prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_LAST_FAILED'])
        if DEBUG: print("Total daemon starts inception_to_date: ", str(prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_TOTAL_STARTS']))
        if DEBUG: print("Total daemon failures inception-to-date: ", str(prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_TOTAL_FAILURES']))

        prefs['JOB_SPY_GRACEFUL_SHUTDOWN_LAST_TIME'] = unicode("False")
        prefs

           #----------------------------------------
        self.build_menus(self.gui)
        self.gui.keyboard.finalize()

        if prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_ACTIVE'] == unicode("True"):
            self.ignore_copy_to_library_cc_messages()

        if prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_AUTORUN'] == unicode("True"):
            self.autorun_library_view_colors = True
        else:
            self.autorun_library_view_colors = False

        if not 'GUI_TOOLS_LIBRARY_VIEW_COLOR_JSON_CONVERTED' in prefs:
            if self.autorun_library_view_colors:
                prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_CONFIGURED'] = unicode("True")
                prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_ACTIVE'] = unicode("True")
                prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_JSON_CONVERTED'] = __my_version__
                prefs

        if prefs['GUI_TOOLS_MAIN_GUI_COLOR_AUTORUN'] == unicode("True"):
            self.autorun_main_gui_colors = True
        else:
            self.autorun_main_gui_colors = False

        if self.autorun_library_view_colors or self.autorun_main_gui_colors:
            self.color_runtype = "autorun"
            self.change_gui_alternating_row_colors()

        self.color_runtype = "manual"

        self.current_custom_columns_list = []
        tmp_list = self.guidb.custom_field_keys()
        for row in tmp_list:
            self.current_custom_columns_list.append(row)
        #END FOR
        del tmp_list
        self.current_custom_columns_list.sort()

        self.custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()

        self.pseudonym_matching_in_progress = False

        self.mycopytolibraryobject = None

        self.myftp = None

        self.clip = QApplication.clipboard()

        if prefs['GUI_TOOLS_ADD_NULL_VALUES_AUTORUN'] == unicode("True"):
            if prefs['GUI_TOOLS_ADD_NULL_VALUES_ACTIVE'] == unicode("True"):
                self.autorun_add_null_values()

        self.qf_ids_previous = []
        if prefs['GUI_TOOLS_QUALITY_FIXES_ACTIVATE'] == unicode("True"):
            self.initialize_quality_fixes()

        if prefs['GUI_TOOLS_TAGBROWSER_ICONS_AUTO_SET_AT_STARTUP']  == unicode("True"):
            if DEBUG: print("JS Tag Browser Icons Tool is running at Startup")
            self.tagbrowser_icon_tool_is_running = True
            self.ensure_icon_directory_exists() #once per Calibre session.
            self.apply_decoration_to_tagbrowser()  #once per Calibre session.
            self.maingui.tags_view._model.modelReset.connect(self.apply_tagbrowser_recount_delayed) #once per Calibre session.   this catches odds and sods that do not later invoke a recount()
            self.apply_tagbrowser_custom_icons()   #after every tag_browser.recount()
        else:
            self.tagbrowser_icon_tool_is_running = False

        if DEBUG: print("Job Spy has finished initialization...")

    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def shutting_down(self):

        try:
            self.tweak_thread.stop()
        except:
            pass

        self.delete_temporary_reading_lists()

        prefs['JOB_SPY_GRACEFUL_SHUTDOWN_LAST_TIME'] = unicode("True")
        prefs

        return True
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def build_menus(self,gui):

        self.gui = gui

        self.job_spy_menu = self.menu
        self.job_spy_menu.clear()

        self.job_spy_menu.setTearOffEnabled(True)
        self.job_spy_menu.setWindowTitle('JS+ Tool Box Menu')

        self.job_spy_menu.addSeparator()
        create_menu_action_unique(self, self.job_spy_menu, ' ', ' ',
                              triggered=None)
        self.job_spy_menu.addSeparator()

        create_menu_action_unique(self, self.job_spy_menu, 'Show Last: Default', 'images/job_spy.png',
                              triggered=partial(self.show_last_per_customization))
        self.job_spy_menu.addSeparator()
        #BEGIN submenu js1 --------------------------------------------------------------------------
        self.js1 = QMenu(_('[Menu] Job Dialog Tools'))
        self.js1_action = self.job_spy_menu.addMenu(self.js1)
        self.js1.setIcon(get_icon('images/job_spy.png'))

        self.js1.setTearOffEnabled(True)
        self.js1.setWindowTitle('JS+ Tool Box Menu - Job Details')

        self.js1.addSeparator()
        unique_name = "JS+:Show Last: Default"
        create_menu_action_unique(self, self.js1, 'Show Last: Default', 'images/job_spy.png',
                              triggered=partial(self.show_last_per_customization),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  1"
        create_menu_action_unique(self, self.js1, 'Show Last:  1', 'images/job_spy.png',
                              triggered=partial(self.show_last_1),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  2"
        create_menu_action_unique(self, self.js1, 'Show Last:  2', 'images/job_spy.png',
                              triggered=partial(self.show_last_2),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  3"
        create_menu_action_unique(self, self.js1, 'Show Last:  3', 'images/job_spy.png',
                              triggered=partial(self.show_last_3),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  4"
        create_menu_action_unique(self, self.js1, 'Show Last:  4', 'images/job_spy.png',
                              triggered=partial(self.show_last_4),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  5"
        create_menu_action_unique(self, self.js1, 'Show Last:  5', 'images/job_spy.png',
                              triggered=partial(self.show_last_5),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  6"
        create_menu_action_unique(self, self.js1, 'Show Last:  6', 'images/job_spy.png',
                              triggered=partial(self.show_last_6),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  7"
        create_menu_action_unique(self, self.js1, 'Show Last:  7', 'images/job_spy.png',
                              triggered=partial(self.show_last_7),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  8"
        create_menu_action_unique(self, self.js1, 'Show Last:  8', 'images/job_spy.png',
                              triggered=partial(self.show_last_8),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  9"
        create_menu_action_unique(self, self.js1, 'Show Last:  9', 'images/job_spy.png',
                              triggered=partial(self.show_last_9),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Show Last:  10"
        create_menu_action_unique(self, self.js1, 'Show Last: 10', 'images/job_spy.png',
                              triggered=partial(self.show_last_10),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Increase Current Session Value by 200%"
        create_menu_action_unique(self, self.js1, 'Increase Current Session Value by 200%', 'images/job_spy.png',
                              triggered=partial(self.increase_n_by_200_percent),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        unique_name = "JS+:Set Default to Current Session Value"
        create_menu_action_unique(self, self.js1, 'Set Default to Current Session Value', 'images/wrench-hammer.png',
                              triggered=partial(self.reset_default),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        create_menu_action_unique(self, self.js1, ' ', ' ',
                              triggered=None)
        self.js1.addSeparator()
        unique_name = "JS+:Customize Job Spy"
        create_menu_action_unique(self, self.js1, 'Customize Job Spy', 'images/config.png',
                              triggered=partial(self.show_configuration),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js1.addSeparator()
        create_menu_action_unique(self, self.js1, ' ', ' ',
                              triggered=None)
        #END submenu js1 --------------------------------------------------------------------------
        self.job_spy_menu.addSeparator()
        create_menu_action_unique(self, self.job_spy_menu, ' ', ' ',
                              triggered=None)
        self.job_spy_menu.addSeparator()

        #~ BEGIN: GUI Tools: -----------------------------------------------------------------

        #~ BEGIN submenu js_look_and_feel --------------------------------------------------------------------------
        self.js_look_and_feel = QMenu(_('[Menu] GUI Tools that are Look and Feel Related'))
        self.js_look_and_feel_action = self.job_spy_menu.addMenu(self.js_look_and_feel)
        self.js_look_and_feel.setIcon(get_icon('images/lookfeel.png'))

        self.js_look_and_feel.setTearOffEnabled(True)
        self.js_look_and_feel.setWindowTitle('JS+ Look and Feel GUI Tools Menu')

        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   Change GUI Text and Alternating Row Colors [As Customized]"
        create_menu_action_unique(self, self.js_look_and_feel, "GUI Tool:   Change GUI Text and Alternating Row Colors [As Customized]", 'images/rainbow.png',
                              triggered=partial(self.change_gui_alternating_row_colors),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   Customize User Category Tag Browser Icons"
        create_menu_action_unique(self, self.js_look_and_feel, 'GUI Tool:   Customize User Category Tag Browser Icons', 'images/rainbow.png',
                              shortcut = True,
                              triggered=partial(self.customize_tag_browser_icons),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   Resize Column Widths to Fit [Calibre Will Auto-Save]"
        create_menu_action_unique(self, self.js_look_and_feel, 'GUI Tool:   Resize Column Widths to Fit [Calibre Will Auto-Save]', 'images/plus.png',
                              triggered=partial(self.expand_column_widths),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   Compress Column Widths Uniformly [Calibre Will Auto-Save]"
        create_menu_action_unique(self, self.js_look_and_feel, 'GUI Tool:   Compress Column Widths Uniformly [Calibre Will Auto-Save]', 'images/minus.png',
                              triggered=partial(self.compress_column_widths),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   Search Bar Dropdowns - Increase Visible Items"
        create_menu_action_unique(self, self.js_look_and_feel, 'GUI Tool:   Search Bar Dropdowns - Increase Visible Items and Search History', 'images/dropdown.png',
                              triggered=partial(self.searchbar_increase_visible_items),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   'Edit Metadata' Dropdowns - Start/Stop 'Visible Items Increaser' Daemon"
        create_menu_action_unique(self, self.js_look_and_feel, "GUI Tool:   Edit Metadata Dropdowns - Start/Stop 'Visible Items Increaser' Daemon", 'images/dropdown.png',
                              triggered=partial(self.start_stop_tweak_widget_properties_daemon),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        #BEGIN submenu js3 --------------------------------------------------------------
        self.js3 = QMenu(_('GUI Tool:   Protect/Unprotect Custom Columns from Edit Metadata Dialogs [Menu]'))
        self.js3_action = self.js_look_and_feel.addMenu(self.js3)
        self.js3.setIcon(get_icon('images/protect.png'))

        self.js3.setTearOffEnabled(True)
        self.js3.setWindowTitle('JS+:GUI Tool:   [Menu] Protect/Unprotect Custom Columns from Edit Metadata Dialogs')

        self.js3.addSeparator()
        create_menu_action_unique(self, self.js3, ' ', ' ',
                              triggered=None)
        self.js3.addSeparator()

        unique_name = "JS+:GUI Tool:   Protect/Unprotect Custom Columns from Edit Metadata Dialogs"
        menu_desc = unique_name.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_normal),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js3.addSeparator()

        create_menu_action_unique(self, self.js3, ' ', ' ',
                              triggered=None)
        self.js3.addSeparator()

        self.get_reserved_prefs()   #need column labels for matrix for group names...

        #dynamic names based on the library...the "about to show" is critical for this; otherwise, silent crash in Qt...soon.

        unique_name1 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name1 = unique_name1.replace("Group [G]",self.group1_name)
        menu_desc1 = unique_name1.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc1, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group1),unique_name=unique_name1, favourites_menu_unique_name=unique_name1)
        self.js3.addSeparator()

        unique_name2 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name2 = unique_name2.replace("Group [G]",self.group2_name)
        menu_desc2 = unique_name2.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc2, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group2),unique_name=unique_name2, favourites_menu_unique_name=unique_name2)
        self.js3.addSeparator()

        unique_name3 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name3 = unique_name3.replace("Group [G]",self.group3_name)
        menu_desc3 = unique_name3.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc3, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group3),unique_name=unique_name3, favourites_menu_unique_name=unique_name3)
        self.js3.addSeparator()

        unique_name4 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name4 = unique_name4.replace("Group [G]",self.group4_name)
        menu_desc4 = unique_name4.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc4, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group4),unique_name=unique_name4, favourites_menu_unique_name=unique_name4)
        self.js3.addSeparator()

        unique_name5 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name5 = unique_name5.replace("Group [G]",self.group5_name)
        menu_desc5 = unique_name5.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc5, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group5),unique_name=unique_name5, favourites_menu_unique_name=unique_name5)
        self.js3.addSeparator()

        unique_name6 = "JS+:GUI Tool:   Protect/Unprotect Custom Columns  - Group [G]"
        unique_name6 = unique_name6.replace("Group [G]",self.group6_name)
        menu_desc6 = unique_name6.replace("JS+:","")
        create_menu_action_unique(self, self.js3, menu_desc6, 'images/protect.png',
                              triggered=partial(self.protect_unprotect_custom_column_easy_group6),unique_name=unique_name6, favourites_menu_unique_name=unique_name6)
        self.js3.addSeparator()
        #END submenu js3 ----------------------------------------------------------------
        self.js_look_and_feel.addSeparator()
        unique_name = "JS+:GUI Tool:   'RowSpy"
        create_menu_action_unique(self, self.js_look_and_feel, "GUI Tool:   RowSpy", 'images/job_spy.png',
                              shortcut = True,
                              triggered=partial(self.show_rowspy_dialog),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_look_and_feel.addSeparator()
        #~ END submenu js_look_and_feel --------------------------------------------------------------------------
        self.job_spy_menu.addSeparator()
        #~ BEGIN submenu js_behavior --------------------------------------------------------------------------
        self.js_behavior = QMenu(_('[Menu] GUI Tools that are Behavior Related'))
        self.js_behavior_action = self.job_spy_menu.addMenu(self.js_behavior)
        self.js_behavior.setIcon(get_icon('images/exec.png'))

        self.js_behavior.setTearOffEnabled(True)
        self.js_behavior.setWindowTitle('JS+ Behavior GUI Tools Menu')

        self.js_behavior.addSeparator()
        unique_name = "JS+:GUI Tool:   Invert Selection"
        create_menu_action_unique(self, self.js_behavior, 'GUI Tool:   Invert Selection [Selected Books]', 'images/shortcuts.png',
                              shortcut = True,
                              triggered=partial(self.invert_selection),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_behavior.addSeparator()
        unique_name = "JS+:GUI Tool:   Apply View Manager Views based on Virtual Library"
        create_menu_action_unique(self, self.js_behavior, "GUI Tool:   Apply View Manager Views based on Virtual Library", 'images/view_manager.png',
                              triggered=partial(self.select_view_manager_view_for_vl),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_behavior.addSeparator()
        unique_name = "JS+:GUI Tool:   Ignore Copy-to-Library Custom Column Messages [Selected Library Combinations]"
        create_menu_action_unique(self, self.js_behavior, "GUI Tool:   Ignore Copy-to-Library Custom Column Messages [Selected Library Combinations]", 'images/ignore.png',
                              triggered=partial(self.show_configuration),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_behavior.addSeparator()
        unique_name = "JS+:GUI Tool:   Copy-to-Library Shortcut"
        create_menu_action_unique(self, self.js_behavior, 'GUI Tool:   Copy-to-Library Shortcut [Selected Books]', 'images/shortcuts.png',
                              shortcut = True,
                              triggered=partial(self.copy_to_library_shortcut),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_behavior.addSeparator()
        unique_name = "JS+:GUI Tool:   Tickle Auto-Adder to Wake Up"
        create_menu_action_unique(self, self.js_behavior, 'GUI Tool:   Tickle Auto-Adder to Wake Up [Experimental]', 'images/shortcuts.png',
                              shortcut = True,
                              triggered=partial(self.tickle_auto_adder_watcher_worker),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_behavior.addSeparator()
        #~ END submenu js_behavior --------------------------------------------------------------------------
        self.job_spy_menu.addSeparator()
        #~ BEGIN submenu js_metadata --------------------------------------------------------------------------
        self.js_metadata = QMenu(_('[Menu] GUI Tools that are Metadata Related'))
        self.js_metadata_action = self.job_spy_menu.addMenu(self.js_metadata)
        self.js_metadata.setIcon(get_icon('images/column.png'))

        self.js_metadata.setTearOffEnabled(True)
        self.js_metadata.setWindowTitle('JS+ Metadata GUI Tools Menu')

        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Apply JS Quality Fixes [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, "GUI Tool:   Apply JS Quality Fixes [Selected Books]", 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.manually_invoke_quality_fixes),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Update Custom Column Based on Another Custom Column [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Update Custom Column Based on Another Custom Column [Selected Books]', 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.update_cc_based_on_another_cc),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        #BEGIN submenu js4 --------------------------------------------------------------------------
        self.js4 = QMenu(_('GUI Tool:   Autofill Custom Columns via Keyboard Shortcuts [Menu]'))
        self.js4_action = self.js_metadata.addMenu(self.js4)
        self.js4.setIcon(get_icon('images/change.png'))

        self.js4.setTearOffEnabled(True)
        self.js4.setWindowTitle('JS+:GUI Tool:   [Menu] Autofill Custom Columns via Keyboard Shortcuts')

        self.js4.addSeparator()
        unique_name = "JS+:GUI Tool:   Keyboard Shortcut to Autofill Custom Column #1 [Selected Books]"
        create_menu_action_unique(self, self.js4, 'GUI Tool:   Keyboard Shortcut to Autofill Custom Column #1 [Selected Books]', 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.kb_shortcut_cc1),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js4.addSeparator()
        unique_name = "JS+:GUI Tool:   Keyboard Shortcut to Autofill Custom Column #2 [Selected Books]"
        create_menu_action_unique(self, self.js4, 'GUI Tool:   Keyboard Shortcut to Autofill Custom Column #2 [Selected Books]', 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.kb_shortcut_cc2),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js4.addSeparator()
        unique_name = "JS+:GUI Tool:   Keyboard Shortcut to Autofill Custom Column #3 [Selected Books]"
        create_menu_action_unique(self, self.js4, 'GUI Tool:   Keyboard Shortcut to Autofill Custom Column #3 [Selected Books]', 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.kb_shortcut_cc3),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js4.addSeparator()
        unique_name = "JS+:GUI Tool:   Keyboard Shortcut to Autofill Custom Column #4 [Selected Books]"
        create_menu_action_unique(self, self.js4, 'GUI Tool:   Keyboard Shortcut to Autofill Custom Column #4 [Selected Books]', 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.kb_shortcut_cc4),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js4.addSeparator()
        #END submenu js4 --------------------------------------------------------------------------
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Bulk Empty Chosen 'Comments/Long Text' Custom Column of all Values [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, "GUI Tool:   Bulk Empty Chosen 'Comments/Long Text' Custom Column of all Values [Selected Books]", 'images/empty_value.png',
                              shortcut = True,
                              triggered=partial(self.bulk_empty_comments_custom_columns),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Bulk Update Chosen 'Comments/Long Text' Custom Column from Clipboard Text [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, "GUI Tool:   Bulk Update Chosen 'Comments/Long Text' Custom Column from Clipboard Text [Selected Books]", 'images/change.png',
                              shortcut = True,
                              triggered=partial(self.bulk_update_comments_custom_columns),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Update Author Sort for Complex Surnames [Selected Books - Matching Authors]"
        create_menu_action_unique(self, self.js_metadata, "GUI Tool:   Update Author Sort for Complex Surnames [Selected Books - Matching Authors]", 'images/authorsort.png',
                              shortcut = True,
                              triggered=partial(self.update_author_sort_for_complex_surnames_menu),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Extract Original Title/Translator to Update Custom Columns [Selected EPUBs]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Extract Original Title/Translator to Update Custom Columns [Selected EPUBs]', 'images/translate.png',
                              triggered=partial(self.extract_translation_data),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Mega-Metadata Reference Book Dropdown Helper [Selected Book]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Mega-Metadata Reference Book Dropdown Helper [Selected Book]', 'images/dropdown.png',
                              shortcut = True,
                              triggered=partial(self.mega_metadata_book_creator_tool),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Reset Last-Modified Date [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Reset Last-Modified Date [Selected Books]', 'images/calendar_month.png',
                              triggered=partial(self.reset_last_modified_date),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Set Last-Modified Date to Date-Added (Timestamp) [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Set Last-Modified Date to Date-Added (Timestamp) [Selected Books]', 'images/calendar_month.png',
                              triggered=partial(self.set_last_modified_date_to_timestamp),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        #BEGIN submenu js2 --------------------------------------------------------------------------
        self.js2 = QMenu(_('GUI Tool:   Back up/Restore Last-Modified Dates [Menu]'))
        self.js2_action = self.js_metadata.addMenu(self.js2)
        self.js2.setIcon(get_icon('images/calendar_month.png'))

        self.js2.setTearOffEnabled(True)
        self.js2.setWindowTitle('JS+:GUI Tool:   [Menu] Back up/Restore Last-Modified Dates')

        self.js2.addSeparator()
        create_menu_action_unique(self, self.js2, ' ', ' ',
                              triggered=None)
        self.js2.addSeparator()
        unique_name = "JS+:GUI Tool:   Back Up Last_Modified Dates [All Books]"
        create_menu_action_unique(self, self.js2, 'GUI Tool:   Back Up Last-Modified Dates [All Books]', 'images/calendar_month.png',
                              triggered=partial(self.back_up_last_modified_dates),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js2.addSeparator()
        create_menu_action_unique(self, self.js2, ' ', ' ',
                              triggered=None)
        self.js2.addSeparator()
        unique_name = "JS+:GUI Tool:   Restore Last_Modified Dates [All Books]"
        create_menu_action_unique(self, self.js2, 'GUI Tool:   Restore Last-Modified Dates [All Books]', 'images/calendar_month.png',
                              triggered=partial(self.restore_last_modified_dates),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js2.addSeparator()
        create_menu_action_unique(self, self.js2, ' ', ' ',
                              triggered=None)
        self.js2.addSeparator()
        #END submenu js2 --------------------------------------------------------------------------
        self.js_metadata.addSeparator()
        #BEGIN submenu js5 --------------------------------------------------------------------------
        self.js5 = QMenu(_('GUI Tool:   Pseudonymous Authors [Menu]'))
        self.js5_action = self.js_metadata.addMenu(self.js5)
        self.js5.setIcon(get_icon('images/quill.png'))

        self.js5.setTearOffEnabled(True)
        self.js5.setWindowTitle('JS+:GUI Tool:   [Menu] Author Pseudonyms')

        unique_name = "JS+:GUI Tool:   Update Real Authors CC for Pseudonymous Authors [Selected Books]"
        create_menu_action_unique(self, self.js5, 'GUI Tool:   Update Real Authors CC for Pseudonymous Authors [Selected Books]', 'images/quill.png',
                              shortcut = True,
                              triggered=partial(self.update_author_pseudonyms),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js5.addSeparator()
        create_menu_action_unique(self, self.js5, ' ', ' ',
                              triggered=None)
        self.js5.addSeparator()
        unique_name = "JS+:GUI Tool:   Export Current Pseudonym Table to CSV Text File"
        create_menu_action_unique(self, self.js5, 'GUI Tool:   Export Current Pseudonym Table to CSV Text File', 'images/export.png',
                              shortcut = True,
                              triggered=partial(self.export_pseudonym_csv_file),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js5.addSeparator()
        unique_name = "JS+:GUI Tool:   Import New Pseudonym Table from CSV Text File"
        create_menu_action_unique(self, self.js5, 'GUI Tool:   Import New Pseudonym Table from CSV Text File', 'images/import.png',
                              shortcut = True,
                              triggered=partial(self.import_pseudonym_csv_file),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js5.addSeparator()
        create_menu_action_unique(self, self.js5, ' ', ' ',
                              triggered=None)
        self.js5.addSeparator()
        unique_name = "JS+:GUI Tool:   Uninstall Pseudonym Table [Current Library]"
        create_menu_action_unique(self, self.js5, 'GUI Tool:   Uninstall Pseudonym Table [Current Library]', 'images/wrench-hammer.png',
                              shortcut = True,
                              triggered=partial(self.uninstall_pseudonym_table),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js5.addSeparator()
        #END submenu js5 --------------------------------------------------------------------------

        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Add 'Null' to all Custom Columns for books with no existing 'real' values in them [All Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Add Null to all Custom Columns for books with no existing real values in them [All Books]', 'images/null.png',
                              triggered=partial(self.add_null_values),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Convert HTML 'Comments' to Plain Text [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, "GUI Tool:   Convert HTML 'Comments' to Plain Text [Selected Books]", 'images/html2text.png',
                              triggered=partial(self.convert_datatype_coments_to_plaintext),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Show Book-Identifier Matrix [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Show Book-Identifier Matrix [Selected Books]', 'images/spreadsheet.png',
                              shortcut = True,
                              triggered=partial(self.show_book_identifier_matrix),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Remove Identifier Types [Selected Books]"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Remove Identifier Types [Selected Books]', 'images/empty_value.png',
                              shortcut = True,
                              triggered=partial(self.remove_identifier_types_tool),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        unique_name = "JS+:GUI Tool:   Visualize Metadata"
        create_menu_action_unique(self, self.js_metadata, 'GUI Tool:   Visualize Metadata', 'images/piechart.png',
                              shortcut = True,
                              triggered=partial(self.visualize_metadata),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_metadata.addSeparator()
        #~ END submenu js_metadata --------------------------------------------------------------------------
        self.job_spy_menu.addSeparator()
        #~ BEGIN submenu js_search --------------------------------------------------------------------------
        self.js_search = QMenu(_('[Menu] GUI Tools that are Search Related'))
        self.js_search_action = self.job_spy_menu.addMenu(self.js_search)
        self.js_search.setIcon(get_icon('images/search.png'))

        self.js_search.setTearOffEnabled(True)
        self.js_search.setWindowTitle('JS+ Search GUI Tools Menu')

        self.js_search.addSeparator()
        unique_name = "JS+:GUI Tool:   Search for Book Title List Currently in System Clipboard"
        create_menu_action_unique(self, self.js_search, 'GUI Tool:   Search for Book Title List Currently in System Clipboard', 'images/search.png',
                              triggered=partial(self.search_for_clipboard_book_list_titles),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_search.addSeparator()
        unique_name = "JS+:GUI Tool:   Search Current Custom Column Using Text Currently in System Clipboard"
        create_menu_action_unique(self, self.js_search, 'GUI Tool:   Search Current Custom Column Using Text Currently in System Clipboard', 'images/search.png',
                              shortcut = True,
                              triggered=partial(self.search_for_clipboard_book_list_custom_columns),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_search.addSeparator()
        unique_name = "JS+:GUI Tool:   Virtual Library Helper - Create Search Criteria Using Selected Book IDs"
        create_menu_action_unique(self, self.js_search, 'GUI Tool:   Virtual Library Helper - Create Search Criteria Using Selected Book IDs', 'images/search.png',
                              triggered=partial(self.vl_helper_set_search_string_using_book_ids),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_search.addSeparator()
        unique_name = "JS+:GUI Tool:   Virtual Library Helper - View VLs Sorted by VL Criteria instead of VL Name"
        create_menu_action_unique(self, self.js_search, 'GUI Tool:   Virtual Library Helper - View VLs Sorted by VL Criteria instead of VL Name', 'images/search.png',
                              triggered=partial(self.create_vl_helper_dialog),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_search.addSeparator()
        unique_name = "JS+:GUI Tool:   Copy Saved Searches of Current Library to Target Library"
        create_menu_action_unique(self, self.js_search, 'GUI Tool:   Copy Saved Searches of Current Library to Target Library', 'images/search.png',
                              triggered=partial(self.copy_saved_searches),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_search.addSeparator()
        unique_name = "JS+:GUI Tool:   Copy Selected Virtual Library from Current Library to Target Library"
        create_menu_action_unique(self, self.js_search, 'GUI Tool:   Copy Selected Virtual Library from Current Library to Target Library', 'images/search.png',
                              triggered=partial(self.copy_virtual_libraries_to_target),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_search.addSeparator()
        #~ END submenu js_search --------------------------------------------------------------------------
        self.job_spy_menu.addSeparator()
        #~ BEGIN submenu js_utilities --------------------------------------------------------------------------
        self.js_utilities = QMenu(_('[Menu] GUI Tools that are Utilities'))
        self.js_utilities_action = self.job_spy_menu.addMenu(self.js_utilities)
        self.js_utilities.setIcon(get_icon('images/wrench-hammer.png'))

        self.js_utilities.setTearOffEnabled(True)
        self.js_utilities.setWindowTitle('JS+ Utility GUI Tools Menu')

        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   List Active Keyboard Shortcuts"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   List Active Keyboard Shortcut Assignments', 'images/shortcuts.png',
                              shortcut = True,
                              triggered=partial(self.list_all_keyboard_shortcuts),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()

        unique_name = "JS+:GUI Tool:   Select & Open Arbitrary Programs and Files"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   Select && Open Arbitrary Programs and Files', 'images/execute.png',
                              triggered=partial(self.create_arbitrary_file_dialog),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Select & Open Arbitrary Programs and Files (Basic)"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   Select && Open Arbitrary Programs and Files (Basic)', 'images/execute.png',
                              triggered=partial(self.select_and_open_files),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Vacuum/Compress metadata.db En Masse [All Other Calibre Libraries]"
        create_menu_action_unique(self, self.js_utilities, "GUI Tool:   Vacuum/Compress metadata.db En Masse [All Other Calibre Libraries]", 'images/vacuum.png',
                              triggered=partial(self.sqlite_vacuum_en_masse),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Purge Library-specific Preferences [Selected Plug-ins]"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   Purge Library-specific Preferences [Selected Plug-ins]', 'images/unlinked.png',
                              triggered=partial(self.purge_plugin_settings),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Purge metadata.opf Backup Queue [User Discretion Advised]"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   Purge metadata.opf Backup Queue [User Discretion Advised]', 'images/purge.png',
                              triggered=partial(self.purge_metadata_opf_backup_queue),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Automatically Delete Temporary Reading Lists at Calibre Shutdown"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   Automatically Delete Temporary Reading Lists at Calibre Shutdown', 'images/reading_list.png',
                              triggered=partial(self.show_configuration),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Copy Selected 'User Category' to a Target Library"
        create_menu_action_unique(self, self.js_utilities, "GUI Tool:   Copy Selected 'User Category' to a Target Library", 'images/user_category.png',
                              shortcut = True,
                              triggered=partial(self.copy_user_categories),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   List Technical Custom Column Details from Table Custom Columns"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   List Technical Custom Column Details from Table Custom Columns', 'images/column.png',
                              triggered=partial(self.list_custom_columns_technical_details),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   'FormatSpy"
        create_menu_action_unique(self, self.js_utilities, "GUI Tool:   FormatSpy", 'images/job_spy.png',
                              shortcut = True,
                              triggered=partial(self.show_formatspy_dialog),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Display 'Polish Books' Job Font-Embedding Failures and Failed Books"
        create_menu_action_unique(self, self.js_utilities, "GUI Tool:   Display 'Polish Books' Job Font-Embedding Failures and Failed Books", 'images/polish.png',
                              shortcut = True,
                              triggered=partial(self.display_polish_books_job_log_fails),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   FTP Books to Host [Selected Books] [Specified Formats]"
        create_menu_action_unique(self, self.js_utilities, 'GUI Tool:   FTP Books to Host [Selected Books] [Specified Formats]', 'images/ftp.png',
                              shortcut = True,
                              triggered=partial(self.ftp_selected_books),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        unique_name = "JS+:GUI Tool:   Back Up Job Spy Configuration File 'Job Spy.json'"
        create_menu_action_unique(self, self.js_utilities, "GUI Tool:   Back Up Job Spy Configuration File 'Job Spy.json'", 'images/wrench-hammer.png',
                              shortcut = True,
                              triggered=partial(self.create_job_spy_json_backup_file),
                              shortcut_name=unique_name,
                              unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.js_utilities.addSeparator()
        #~ END submenu js_utilities --------------------------------------------------------------------------

        self.job_spy_menu.addSeparator()

        create_menu_action_unique(self, self.job_spy_menu, ' ', ' ',
                              triggered=None)
        self.job_spy_menu.addSeparator()
        unique_name = "JS+:GUI Tool:   Customize GUI Tools"
        create_menu_action_unique(self, self.job_spy_menu, 'Customize GUI Tools', 'images/config.png',
                              triggered=partial(self.show_configuration),unique_name=unique_name, favourites_menu_unique_name=unique_name)
        self.job_spy_menu.addSeparator()
        create_menu_action_unique(self, self.job_spy_menu, ' ', ' ',
                              triggered=None)

        #~ END: GUI Tools: -----------------------------------------------------------------


        self.tooltipjs1 = ("<p style='white-space:wrap'>Your default N 'last jobs to execute' to show consecutively is set via Calibre > Preferences > Plug-ins > Customize.\
                                                <br><br>This menu can be used to quickly and easily change the value of N for this Calibre session only.\
                                                <br><br>The default value set in Customization will not be changed unless you explicitly select the bottom menu option to do so.\
                                                <br><br>\
                                                <br><br>")

        self.tooltipmain = ("<p style='white-space:wrap'>\
                                                <br><br>[-]  The GUI Tool 'Search Bar Dropdowns - Increase Visible Items' sets the number of visible items and maximum items to 100 for the current Calibre session only. This is only a temporary tweak.<br><br>The JS Customization has an option to specify that this tweak is to be automatically executed after Calibre starts.\
                                                <br><br>[-]  The GUI Tool  'Edit Metadata' Dropdowns - Start/Stop 'Visible Items Increaser' Daemon sets the number of visible items and maximum items to 100 for the current Calibre session only.<br><br>Unlike the Search Bar, the Bulk Edit dialog is created and closed by the user, so a daemon that 'runs' only every eight (8) seconds (to minimize resources) is needed to 'fix' it whenever it suddenly appears. There will be a 'lag' from the time you open an Edit Metadata dialog to the time that the daemon will have discovered and tweaked it.<br><br>The JS Customization has an option to specify that this tweak is to be automatically executed after Calibre starts.\
                                                <br><br>[-]  The GUI Tool 'Resize Column Widths to Fit' can easily be reversed by clicking the 'View Manager' plug-in 'View' you wish to activate.\
                                                <br><br>[-]  The GUI Tool 'Compress Column Widths Uniformly' can easily be reversed by clicking the 'View Manager' plug-in 'View' you wish to activate.\
                                                <br><br>[-]  The GUI Tool 'Select & Open Arbitrary Programs and Files' is generic.\
                                                <br><br>[-]  The GUI Tool 'Reset Last-Modified Date' will ignore any selected future date.\
                                                <br><br>[-]  The GUI Tool 'Virtual Library Helper - Create Search Criteria Using Selected Book IDs' allows totally random and arbitrary book selections to be easily made into a Virtual Library.  Maximum: 200 books.\
                                                <br><br>[-]  The GUI Tool 'Virtual Library Helper - View VLs Sorted by VL Criteria instead of VL Name' does what it says.  This can be very handy.\
                                                <br><br>[-]  The GUI Tool 'Purge Library-specific Preferences' is useful for removing 'orphaned' or 'unlinked' settings for (currently) non-existent Plug-ins.  If the current Calibre Library has no Library-specific Preferences for any Plug-ins, then clicking the menu item will do nothing.\
                                                <br><br>[-]  The GUI Tool 'Protect/Unprotect Custom Columns from Edit Metadata Dialogs' removes the selected Custom Columns from both Edit Metadata dialogs.  Caution: The 'Bulk Edit Search and Replace' tab ignores this setting.  Also, 'Composite' (virtual) Custom Columns are excluded by this GUI Tool.  \
                                                <br><br>[-]   And too many more to fit in this ToolTip.  View many more specific ToolTips in 'Customization'. ")

        if prefs['GUI_TOOLS_SHOW_TOOLTIPS'] == unicode("True"):
            self.job_spy_menu.setToolTip(self.tooltipmain)

        self.js1.setToolTip(self.tooltipjs1)

        self.built_already = True
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_configuration(self):
        self.interface_action_base_plugin.do_user_config(self.gui)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def spy_on_jobs(self):

        if not self.my_jobs_dialog_object:
            return

        for n in range(0,self.jobs_to_show_consecutively):
            index = self.my_jobs_dialog_object.jobs_view.model().index(n, 0)
            if index.isValid():
                self.my_jobs_dialog_object.show_job_details(index)
        #END FOR
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------------
    def show_last_per_customization(self):
        n = int(prefs['JOBS_TO_SHOW_CONSECUTIVELY'])
        self.show_last_n(n)
    def show_last_1(self):
        self.show_last_n(1)
    def show_last_2(self):
        self.show_last_n(2)
    def show_last_3(self):
        self.show_last_n(3)
    def show_last_4(self):
        self.show_last_n(4)
    def show_last_5(self):
        self.show_last_n(5)
    def show_last_6(self):
        self.show_last_n(6)
    def show_last_7(self):
        self.show_last_n(7)
    def show_last_8(self):
        self.show_last_n(8)
    def show_last_9(self):
        self.show_last_n(9)
    def show_last_10(self):
        self.show_last_n(10)
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------------
    def increase_n_by_200_percent(self):
        self.jobs_to_show_consecutively = self.jobs_to_show_consecutively * 2
        self.spy_on_jobs()
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------------
    def show_last_n(self,n):
        self.jobs_to_show_consecutively = n
        self.spy_on_jobs()
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------------
    def reset_default(self):
        prefs['JOBS_TO_SHOW_CONSECUTIVELY'] = self.jobs_to_show_consecutively
        prefs
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_settings(self):
        prefs
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------------
    # GUI Tools:
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-------------------------------------------------------------------------------------------------------------------------------------
    #-----------------------------------------------------
    #-----------------------------------------------------
    def expand_column_widths(self):
        try:
            if not self.maingui:
                return
            self.maingui.library_view.resizeColumnsToContents()
        except Exception as e:
            if DEBUG: print(str(e))
            pass
    #-----------------------------------------------------
    #-----------------------------------------------------
    def compress_column_widths(self):
        try:
            if not self.maingui:
                return
            db = self.gui.current_db.new_api
            work_book_ids_frozenset = db.all_book_ids()
            n_total_rows = len(work_book_ids_frozenset)
            for r in range(0,n_total_rows):
                self.maingui.library_view.setColumnWidth(r, 100)
        except Exception as e:
            if DEBUG: print(str(e))
            pass
    #-----------------------------------------------------
    #-----------------------------------------------------
    def select_and_open_files(self):
        try:
            gotten_files = self.choose_file_to_open()
            if not gotten_files:
                info_dialog(self.gui, 'Canceled','Nothing Selected; Canceled.').show()
                return
            else:
                chosen_path = gotten_files[0]
                p_pid = subprocess.Popen(chosen_path, shell=True)
        except Exception as e:
            if DEBUG: print(str(e))
            pass
    #-----------------------------------------------------
    def choose_file_to_open(self):

        name = "choose_file_to_open"
        title = "JS GUI Tool: Choose Arbitrary File to Open"
        all_files=True
        select_only_single_file=True
        filters=[]
        window = None   # parent = None

        mode = QFileDialog.ExistingFile if select_only_single_file else QFileDialog.ExistingFiles
        fd = FileDialog(title=title, name=name, filters=filters, parent=window, add_all_files_filter=all_files, mode=mode)
        fd.setParent(None)
        if fd.accepted:
            return fd.get_files()
        return None
    #-----------------------------------------------------
    #-----------------------------------------------------
    def reset_last_modified_date(self):
        from calibre_plugins.job_spy.ui import PopUpCalendar
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.my_popupdialog = PopUpCalendar(self.gui,self.qaction.icon(),self.guidb,self.execute_reset_date_for_selected_books)
    #-----------------------------------------------------
    def execute_reset_date_for_selected_books(self,new_last_modified_date):
        self.my_popupdialog.close()
        new_last_modified_date = str(new_last_modified_date) + str(" 12:00:00.000000+00:00")             # UTC at Noon...       # example last_modified:      2015-11-05 15:07:15.635000+00:00
        #~ if DEBUG: print(new_last_modified_date)
        self.guidb = self.gui.library_view.model().db
        #-------------------------------------
        # get selected books
        #-------------------------------------
        self.selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
        self.selected_books_list.sort()
        #-------------------------------------
        # process selected books
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        try:
            my_cursor.execute("begin")
            mysql = "UPDATE books SET last_modified = ? WHERE id = ?"
            for book in self.selected_books_list:
                my_cursor.execute(mysql,(new_last_modified_date,book))
            #END FOR
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print(str(e))
            try:
                my_cursor.execute("commit")
            except:
                pass
            del self.selected_books_list
            self.selected_books_list = []

        #-------------------------------------
        my_db.close()
        #-------------------------------------
        self.force_refresh_of_cache(self.selected_books_list)
        #-------------------------------------
        self.mark_selected_books()
        #-------------------------------------
        del self.selected_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def set_last_modified_date_to_timestamp(self):
        self.guidb = self.gui.library_view.model().db
        self.selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        try:
            my_cursor.execute("begin")
            mysql = "UPDATE books SET last_modified = timestamp WHERE books.id = ?"
            for book in self.selected_books_list:
                my_cursor.execute(mysql,([book]))            # books has a trigger to auto-change the author sort, so this takes longer than you would think...
            #END FOR
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print(str(e))
            try:
                my_cursor.execute("commit")
            except:
                pass
            del self.selected_books_list
            self.selected_books_list = []

        #-------------------------------------
        my_db.close()
        #-------------------------------------
        self.force_refresh_of_cache(self.selected_books_list)
        #-------------------------------------
        self.mark_selected_books()
        #-------------------------------------
        del self.selected_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def mark_selected_books(self):

        found_dict = {}
        s_true = 'true'
        for row in self.selected_books_list:
            key = int(row)
            found_dict[key] = s_true
        #END FOR

        marked_ids = dict.fromkeys(found_dict, s_true)
        self.gui.current_db.set_marked_ids(marked_ids)
        self.gui.search.clear()
        self.gui.search.set_search_string('marked:true')

        del found_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_selected_books(self):

        try:
            del self.selected_books_list
        except:
            pass
        self.selected_books_list = []

        book_ids_list = []

        book_ids_list = map( partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() )
        n = len(book_ids_list)
        if n == 0:
            del book_ids_list
            return self.selected_books_list
        for item in book_ids_list:
            s = str(item['calibre_id'])
            self.selected_books_list.append(s)
        #END FOR

        del book_ids_list

        return self.selected_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def convert_id_to_book(self, idval):
        book = {}
        book['calibre_id'] = idval
        return book
    #---------------------------------------------------------------------------------------------------------------------------------------
    def force_refresh_of_cache(self,selected_book_list):
        backend = self.gui.library_view.model().db.backend
        mydbcache = dbcache(self.gui.library_view.model().db.backend)
        mydbcache.init()
        self.gui.library_view.model().refresh_ids(selected_book_list)
        self.gui.tags_view.recount()
        del selected_book_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apsw_connect_to_library(self):

        self.guidb = self.gui.library_view.model().db

        my_db = self.gui.library_view.model().db

        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        if isbytestring(path):
            path = path.decode(filesystem_encoding)

        if path.endswith("/"):
            path = path[0:-1]

        try:
            my_db =apsw.Connection(path)
            is_valid = True
        except Exception as e:
            if DEBUG: print("path to metadata.db is: ", path)
            if DEBUG: print("error: ", str(e))
            is_valid = False
            return None,None,is_valid

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        # Standard Calibre uses these in backend.py as of Release 3.17
        my_db.createscalarfunction("title_sort", title_sort,1)   # for trigger...
        my_db.createscalarfunction('author_to_author_sort',_author_to_author_sort, 1)
        my_db.createscalarfunction('uuid4', lambda: str(uuid.uuid4()),0)

        return my_db,my_cursor,is_valid
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def vl_helper_set_search_string_using_book_ids(self):

        self.selected_books_list = self.get_selected_books()
        n = len(self.selected_books_list)
        if n == 0 or n > 200:
            return
        bids = ""  #book id search string
        for book in self.selected_books_list:
            book = str(book)
            bids = bids + "id:" + book + " OR "
        #END FOR
        if bids.endswith(" OR "):
            bids = bids[0:-4]
        self.gui.search.clear()
        self.gui.search.set_search_string(bids)
    #-------------------------------------------------------------------------------------------------------------------------------------
    def create_vl_helper_dialog(self):
        from calibre_plugins.job_spy.vl_helper_dialog import VLHelperDialog
        self.vl_helper_dialog = VLHelperDialog(self.gui,self.qaction.icon())
        self.vl_helper_dialog.show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def purge_plugin_settings(self):
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        mysql = "SELECT id,key FROM preferences WHERE key LIKE 'namespaced:%' ORDER BY key"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        if not tmp_rows:
            tmp_rows = []
        if len(tmp_rows) == 0:
            return
        preferences_list = []
        for row in tmp_rows:
            id,key = row
            #~ if DEBUG: print("full: ", key)
            key = key.replace("namespaced:","")
            if key.count(":") > 0:
                n = key.find(":")
                key = key[0:n]
                #~ if DEBUG: print("plugin: ", key)
                preferences_list.append(key)
        #END FOR
        if len(preferences_list) == 0:
            return

        from calibre_plugins.job_spy.purge_prefs_dialog import PurgePrefsDialog
        icon = get_icon('images/unlinked.png')
        self.purge_prefs_dialog = PurgePrefsDialog(self.gui,icon,preferences_list)
        self.purge_prefs_dialog.show()
        del PurgePrefsDialog
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def protect_unprotect_custom_column_normal(self):
        mode = "normal"
        group = 0
        self.protect_unprotect_custom_column(mode,group)
    def protect_unprotect_custom_column_easy_group1(self):
        self.protect_unprotect_custom_column_easy_generic(1)
    def protect_unprotect_custom_column_easy_group2(self):
        self.protect_unprotect_custom_column_easy_generic(2)
    def protect_unprotect_custom_column_easy_group3(self):
        self.protect_unprotect_custom_column_easy_generic(3)
    def protect_unprotect_custom_column_easy_group4(self):
        self.protect_unprotect_custom_column_easy_generic(4)
    def protect_unprotect_custom_column_easy_group5(self):
        self.protect_unprotect_custom_column_easy_generic(5)
    def protect_unprotect_custom_column_easy_group6(self):
        self.protect_unprotect_custom_column_easy_generic(6)
    def protect_unprotect_custom_column_easy_generic(self,group):
        mode = "easy"
        self.protect_unprotect_custom_column(mode,group)
    def protect_unprotect_custom_column(self,mode,group):
        from calibre_plugins.job_spy.custom_column_editable_dialog import CustomColumnEditableDialog
        icon = get_icon('images/protect.png')
        self.guidb = self.gui.library_view.model().db
        self.cc_editable_dialog = CustomColumnEditableDialog(self.gui,self.guidb,icon,mode,group)
        if mode == "normal":
            self.cc_editable_dialog.show()
        else:
            pass
            #~ if DEBUG: self.cc_editable_dialog.show()
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def searchbar_increase_visible_items(self):
        try:
            if not self.search_bar_object_set:
                from calibre.gui2.ui import get_gui
                self.maingui = get_gui()
                from calibre_plugins.job_spy.gui_objects import JSGetGUIObjects
                #---------------------------------------------------------------------------------------------
                #~ criteria_type:  1 = name; 2 = hasattr; 3 = object_class; NNN = multiple ANDs
                #---------------------------------------------------------------------------------------------
                criteria_type = 12
                name_criteria_set = set([])
                hasattr_criteria_set =  set([])
                hasattr_criteria_set.add("setMaxVisibleItems")
                object_class_set =  set([])
                name_criteria_set.add("calibre.gui2.search_box")
                my_jsgetguiobjects = JSGetGUIObjects(self.gui,self.maingui,QApplication)
                iterations = 1
                children_level = 0  # sufficient for the Search Bar
                self.search_bar_object_set = my_jsgetguiobjects.get_objects(criteria_type,name_criteria_set,hasattr_criteria_set,object_class_set,iterations,children_level)
                #~ <calibre.gui2.search_box.SearchBox2 object at 0x000000000A209CA8>
                #~ <calibre.gui2.search_box.SavedSearchBox object at 0x000000000D1A3048>
                del JSGetGUIObjects
                del my_jsgetguiobjects
            try:
                if not self.search_bar_object_set:
                    return
            except Exception as e:
                self.search_bar_object_set = None
                if DEBUG: print("[0] Exception in searchbar_increase_visible_items: ", str(e))
                return
            for item in self.search_bar_object_set:
                if hasattr(item, 'setMaxVisibleItems'):
                    if item.maxCount() < 100:
                        item.setMaxCount(100)
                    if item.maxVisibleItems() < 100:
                        item.setMaxVisibleItems(100)
                    s = str(item)
                    if 'calibre.gui2.search_box.SearchBox2' in s:
                        final_list = self.append_additional_search_history()
                        numitems = item.count()
                        for i in range(0,numitems):
                            if not item.itemText(i) in final_list:
                                item.removeItem(i)
                        for row in final_list:
                            n = item.findText(row,Qt.MatchExactly)
                            if n == -1:
                                if row > " ":
                                    item.addItem(row)
                        #END
                    item.update()
                self.gui.status_bar.show_message(_('Search Bar Visible Items Increased to 100'), 10000)
        except Exception as e:
            if DEBUG: print("[1] Exception in searchbar_increase_visible_items: ", str(e))
            pass


    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def start_stop_tweak_widget_properties_daemon(self):

        if not self.tweak_thread_is_running:
            from calibre.gui2.ui import get_gui
            self.maingui = get_gui()
            from calibre_plugins.job_spy.tweak_widget_properties_daemon import TweakWidgetPropertiesDaemon
            self.tweak_thread = TweakWidgetPropertiesDaemon(self.gui,self.maingui,QApplication)
            self.tweak_thread.start()
            self.tweak_thread_is_running = True
            self.gui.status_bar.show_message(_('JS+ Edit Metadata Dropdown Daemon has been STARTED'), 10000)
            del TweakWidgetPropertiesDaemon
        else:
            try:
                self.tweak_thread.stop()
                if DEBUG: print("JS+ Tweak Widget Properties Daemon has been STOPPED")
                self.tweak_thread_is_running = False
                del self.tweak_thread
                self.gui.status_bar.show_message(_('JS+ Edit Metadata Dropdown Daemon has been STOPPED'), 10000)
            except:
                pass
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def append_additional_search_history(self):

        if prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY_PURGE'] == unicode("True"):
            prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY'] = prefs.defaults['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY']
            prefs

        import ast
        additional_history = str(prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY'])
        additional_history_list = ast.literal_eval(additional_history)

        from calibre.gui2 import config
        opt_name = "main_search_history"
        full_list = []
        for line in config[opt_name]:
            full_list.append(line)
        prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY']  = unicode(str(full_list))
        prefs

        if prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY_PURGE'] == unicode("True"):
            prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY_PURGE'] = unicode("False")
            full_list = full_list[0:25]
            prefs['GUI_TOOLS_SEARCHBAR_ADDITIONAL_HISTORY']  = unicode(str(full_list))
            prefs
        else:
            additional_history_list.sort()
            for row in additional_history_list:
                if row in full_list:
                    pass
                else:
                    full_list.append(row)
            #END FOR

        try:
            del ast
            del additional_history
            del additional_history_list
        except:
            pass

        #~ if DEBUG: print("Number of search history items available: ", str(len(full_list)))

        return full_list

    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def copy_saved_searches(self):
        from calibre_plugins.job_spy.synchronize_saved_searches_dialog import SynchronizeSavedSearchesDialog
        icon = get_icon('images/search.png')
        self.my_copy_saved_searches_dialog = SynchronizeSavedSearchesDialog(self.gui,self.guidb,icon)
        self.my_copy_saved_searches_dialog.show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def visualize_metadata(self):
        from calibre_plugins.job_spy.visualize_metadata_dialog import VisualizeMetadataDialog
        icon = get_icon('images/piechart.png')
        self.my_visualize_metadata_dialog = VisualizeMetadataDialog(self.gui,self.guidb,icon)
        self.my_visualize_metadata_dialog.show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def purge_metadata_opf_backup_queue(self):

        if question_dialog(self.gui, "JS+ GUI Tool - Purge metadata.opf Backup Queue", "Purge the Queue of the Current Library?  Are you sure?"):
            pass
        else:
            return

        mydbcache = self.gui.current_db.new_api
        mybackend = self.gui.library_view.model().db.backend

        try:
            #~ if DEBUG: print("[0] len of tmp_dict: ", str(len(mydbcache.dirtied_cache)))
            mydbcache.dirtied_cache.clear()
            mybackend.execute('DELETE FROM metadata_dirtied')      # autocommits...
            #~ if DEBUG: print("[1] len of tmp_dict: ", str(len(mydbcache.dirtied_cache)))
            #~ if DEBUG: print("Queue Cleared: All Books")
            del mydbcache
            del mybackend
            return info_dialog(self.gui, 'JS+ GUI Tool - Purge metadata.opf Backup Queue','The Queue has been purged.').show()
        except Exception as e:
            del mydbcache
            del mybackend
            return error_dialog(self.gui, _('JS+ GUI Tool - Purge Error - Try Again - Exception: '),_(str(e)), show=True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def back_up_last_modified_dates(self):

        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        mysql = "SELECT id AS book,uuid AS book_uuid,last_modified,(select uuid from library_id) AS library_uuid,datetime() as date_saved FROM books"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        if not tmp_rows:
            tmp_rows = []
        if len(tmp_rows) == 0:
            return
        data_list = []
        for row in tmp_rows:
            #~ if DEBUG: print(str(row))
            book,book_uuid,last_modified,library_uuid,date_saved = row
            new_line = str(book) + "|" + str(book_uuid) + "|" + str(last_modified) + "|" + str(date_saved)
            data_list.append(str(new_line))
            #~ if DEBUG: print(str(new_line))
        #END FOR
        del tmp_rows

        if library_uuid == "07111111-0000-4000-b000-f00000000001":
            return error_dialog(self.gui, _('JS+ GUI Tool - Back Up Last-Modified Dates: '),_('Sorry, but QuarantineAndScrub Libraries cannot use this function.'), show=True)
        if library_uuid == "5d170c8f-1b20-4243-8d68-31a255e34fdd":
            return error_dialog(self.gui, _('JS+ GUI Tool - Back Up Last-Modified Dates: '),_('Sorry, but CALM Target Libraries cannot use this function.'), show=True)

        saved_data_dict = {}
        saved_data_dict[library_uuid] = str(data_list)

        self.build_protected_subdirectory_path()

        unique_library_name = library_uuid + str(".txt")

        out_file =  os.path.join(self.protected_data_directory, unique_library_name)
        out_file.encode("ascii", "strict")
        out_file = str(out_file)
        out_file = out_file.decode(filesystem_encoding)
        out_file = out_file.replace(os.sep, '/')         #   /calibre/plugins/job_spy/[library_uuid]

        my_outfile = open(out_file, 'w')
        my_outfile.write(str(saved_data_dict))
        my_outfile.close

        #~ if DEBUG: print("data was saved to: ", str(out_file))

        msg = "Backup was successful for " + str(len(data_list)) + " books.  <br><br> The backup file path for this library is: " + out_file
        info_dialog(self.gui, 'JS+ GUI Tool - Back Up Last-Modified Dates',msg).show()

        del data_list
        del saved_data_dict
        del out_file
        del my_outfile
    #---------------------------------------------------------------------------------------------------------------------------------------
    def restore_last_modified_dates(self):

        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        mysql = "SELECT id,uuid FROM library_id"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        if not tmp_rows:
            tmp_rows = []
        if len(tmp_rows) == 0:
            return
        for row in tmp_rows:
            id,library_uuid = row
        #END FOR
        del tmp_rows

        if library_uuid == "07111111-0000-4000-b000-f00000000001":
            return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but QuarantineAndScrub Libraries cannot use this function.'), show=True)
        if library_uuid == "5d170c8f-1b20-4243-8d68-31a255e34fdd":
            return error_dialog(self.gui, _('JS+ GUI Tool - Back Up Last-Modified Dates: '),_('Sorry, but CALM Target Libraries cannot use this function.'), show=True)

        self.build_protected_subdirectory_path()

        unique_library_name = library_uuid + str(".txt")

        in_file =  os.path.join(self.protected_data_directory, unique_library_name)
        in_file.encode("ascii", "strict")
        in_file = str(in_file)
        in_file = in_file.decode(filesystem_encoding)
        in_file = in_file.replace(os.sep, '/')         #   /calibre/plugins/job_spy/[library_uuid]

        saved_data_list = []
        if os.path.exists(in_file):
            try:
                with open(in_file, 'r') as f:
                    lines = f.readlines()
                    for line in lines:
                        line = str(line)
                        line = line.encode("ascii", "strict")
                        saved_data_list.append(str(line))
                    f.close()
            except Exception as e:
                return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but the backed up data could not be restored.  Error [0]. Please try again. '), show=True)
        else:
            return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but there is no backed up data to restore.  Error [1].  Nothing done.'), show=True)

        import ast

        for row in saved_data_list:
            saved_data_dict = ast.literal_eval(row)                #~ saved_data_dict = {}
            break
        #END FOR
        if not isinstance(saved_data_dict,dict):
            return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but the backed up data could not be restored.  Error [2].'), show=True)

        if not library_uuid in saved_data_dict:                   #~ saved_data_dict[library_uuid] = str(data_list)
            return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but the backed up data could not be restored.  Error [3].'), show=True)
        else:
            data_list = saved_data_dict[library_uuid]
            data_list = ast.literal_eval(data_list)
            if not isinstance(data_list,list):
                return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but the backed up data could not be restored.  Error [4].'), show=True)

        if len(data_list) == 0:
            return error_dialog(self.gui, _('JS+ GUI Tool - Restore Last-Modified Dates: '),_('Sorry, but the backed up data could not be restored.  Error [5].'), show=True)

        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        book_list = []
        my_cursor.execute("begin")
        for row in data_list:
            s_split = row.split("|")                                         #~ str(book) + "|" + str(book_uuid) + "|" + str(last_modified) + "|" + str(date_saved)
            if s_split:
                if len(s_split) == 4:
                    book = s_split[0]
                    if book.isdigit():
                        book = int(book)
                        book_list.append(book)
                        book_uuid = s_split[1]
                        saved_last_modified = s_split[2]
                        date_saved = s_split[3]
                        mysql = "UPDATE books SET last_modified = ? WHERE id = ? and uuid = ?"
                        my_cursor.execute(mysql,(saved_last_modified,book,book_uuid))
        #END FOR
        my_cursor.execute("commit")
        my_db.close()

        self.force_refresh_of_cache(book_list)

        msg = "Restore was successful for " + str(len(book_list)) + " books that were previously backed up at:  " + date_saved + " (UTC) to backup file: " + in_file

        del in_file
        del data_list
        del book_list
        del saved_data_dict
        del ast

        return info_dialog(self.gui, 'JS+ GUI Tool - Restore Last-Modified Dates',msg).show()
    #--------------------------------------------------------------------------------------------------
    def build_protected_subdirectory_path(self):

        self.protected_data_path = self.plugin_path
        self.protected_data_path = self.protected_data_path.replace("\Job Spy.zip", "")
        self.protected_data_path = self.protected_data_path.replace("/Job Spy.zip", "")

        self.protected_data_directory = self.protected_data_path

        sub_directory = str("job_spy")
        sub_directory = sub_directory.decode(filesystem_encoding)

        self.protected_data_directory =  os.path.join(self.protected_data_directory, sub_directory)

        self.protected_data_directory.encode("ascii", "strict")

        self.protected_data_directory = str(self.protected_data_directory)

        self.protected_data_directory = self.protected_data_directory.decode(filesystem_encoding)

        self.protected_data_directory = self.protected_data_directory.replace(os.sep, '/')         #   /calibre/plugins/job_spy

        if not os.path.exists(self.protected_data_directory):
            os.makedirs(self.protected_data_directory)
        #~ if DEBUG: print("protected_data_directory: ",self.protected_data_directory)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def extract_translation_data(self):

        if self.job_is_running:
            return

        self.selected_book_list = self.get_selected_books()

        n_books = len(self.selected_book_list)
        if  n_books == 0:
            return

        self.guidb = self.gui.library_view.model().db

        param_dict = self.build_job_param_dict()

        start_threaded_js_extract_original_title_translator(self, self.guidb, self.plugin_path, self.selected_books_list, param_dict, Dispatcher(self.js_finish_with_refresh))

        self.job_is_running = True

        msg = ('JS+ Job was submitted and is processing %d book(s)' %(n_books))
        self.gui.status_bar.showMessage(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def js_finish_with_refresh(self, job):

        self.job_is_running = False

        if job.failed:
            self.force_refresh_of_cache(self.selected_books_list)
            self.gui.job_exception(job, dialog_title=_('JS+ Job Failed...'))

        self.gui.status_bar.show_message(_('JS+ Job Has Finished'), 5000)

        self.force_refresh_of_cache(self.selected_books_list)

        self.mark_selected_books()

        del self.selected_books_list

        try:
            del job
        except:
            pass
    #---------------------------------------------------------------------------------------------------------------------------------------
    def build_job_param_dict(self):
        param_dict = {}
        return param_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def delete_temporary_reading_lists(self):

        if not prefs['GUI_TOOLS_AUTO_DELETE_TEMPORARY_READING_LISTS'] == unicode("True"):
            return

        try:
            from calibre_plugins.reading_list.config import (PREFS_NAMESPACE, PREFS_KEY_SETTINGS, KEY_LISTS,
                                                                                          KEY_DEFAULT_LIST, KEY_SCHEMA_VERSION,
                                                                                          DEFAULT_SCHEMA_VERSION, DEFAULT_LIBRARY_VALUES)
        except Exception as e:
            prefs['GUI_TOOLS_AUTO_DELETE_TEMPORARY_READING_LISTS'] = unicode("False")
            prefs
            if DEBUG: print("Reading List Plug-in is NOT installed, but the user has activated it in JS+...", str(e))
            return

        try:
            import copy
            db = self.gui.library_view.model().db
            library_config = db.prefs.get_namespaced(PREFS_NAMESPACE, PREFS_KEY_SETTINGS,
                                                                                copy.deepcopy(DEFAULT_LIBRARY_VALUES))
            lists = library_config[KEY_LISTS]
            tmp_dict = lists.copy()
            found_tmp_list = False
            for k,v in tmp_dict.iteritems():
              if k.startswith('!'):
                del lists[k]
                found_tmp_list = True
            #END FOR
            if found_tmp_list:
                library_config[KEY_LISTS]  = lists
                db.prefs.set_namespaced(PREFS_NAMESPACE, PREFS_KEY_SETTINGS, library_config)
        except Exception as e:
            if DEBUG: print(str(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def convert_datatype_coments_to_plaintext(self):

        self.selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
        self.selected_books_list.sort()
        #-------------------------------------
        # process selected books
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        tmp_dict = {}
        mysql = "SELECT book,text FROM comments WHERE book = ?"
        for book in self.selected_books_list:
            my_cursor.execute(mysql,[book])
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                continue
            if len(tmp_rows) == 0:
                continue
            for row in tmp_rows:
                book,text = row
                tmp_dict[book] = text
            del tmp_rows
        #END FOR
        #-------------------------------------
        comments_dict = {}
        for book,text in tmp_dict.iteritems():
            text = html2text(text)
            text = text.strip()
            comments_dict[book] = text
        #END FOR
        del tmp_dict
        #-------------------------------------
        mysql = "UPDATE comments SET text = ? WHERE book = ? "
        my_cursor.execute("begin")
        for book,text in comments_dict.iteritems():
            my_cursor.execute(mysql,(text,book))
        #END FOR
        my_cursor.execute("commit")
        #-------------------------------------
        my_db.close()
        #-------------------------------------
        self.force_refresh_of_cache(self.selected_books_list)
        #-------------------------------------
        self.mark_selected_books()
        #-------------------------------------

        n_books = len(self.selected_books_list)

        msg = ('Comments were converted from HTML to Plain Text for %d book(s)' %(n_books))
        self.gui.status_bar.showMessage(msg)

        del comments_dict
        del self.selected_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def select_view_manager_view_for_vl(self):

        if prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_ACTIVE'] == unicode("False"):
            msg = "VL Views are inactive per Customization.  Nothing can be done until VL Views are activated and Calibre is restarted."
            error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)
            return

        vlname = self.guidb.data.get_base_restriction_name()     #full name of the virtual library
        #~ if DEBUG: print(vlname)

        try:
            p = re.compile(VL_REGEX, re.IGNORECASE)
            match_vl_tag = p.search(vlname)
            if not match_vl_tag:
                #~ if DEBUG: print("RE no match_vl_tag")
                return
        except Exception as e:
            #~ if DEBUG: print("RE COMPILE ERROR IN VL_REGEX", str(e))
            return

        vl_tag = match_vl_tag.group()
        #~ if DEBUG: print("vl_tag: ", vl_tag)

        try:
            from calibre_plugins.view_manager.config import (PREFS_NAMESPACE as vl_namespace,
                                                                                               PREFS_KEY_SETTINGS as vl_key_settings,
                                                                                               KEY_VIEWS as vl_key_views,
                                                                                               KEY_LAST_VIEW as vl_key_last_view)
        except Exception as e:
            if DEBUG: print("View Manager Plug-in is NOT installed, but the user has tried to use it via JS+...", str(e))
            prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_ACTIVE'] = unicode("False")
            prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_CLICK_RELEASE_ACTIVE'] = unicode("False")
            prefs
            return

        db = self.gui.library_view.model().db
        library_config = db.prefs.get_namespaced(vl_namespace,vl_key_settings)
        views = library_config[vl_key_views]

        matching_view = None
        for view in views:
            if vl_tag in view:
                matching_view = view
                #~ if DEBUG: print("matching_view: ", matching_view)
                break

        if not matching_view:
            #~ if DEBUG: print("no matching view found for: ", vl_tag)
            return

        view_info = views[matching_view]

        #~ if DEBUG: print("view_info: ", str(view_info))

        view_manager_object = None

        from calibre.customize.ui import _initialized_plugins as tmp_list2

        for item in tmp_list2:
            s = str(item)
            if "calibre_plugins.view_manager.ActionViewManager" in s:
                #~ if DEBUG: print(s)  #~ <calibre_plugins.view_manager.ActionViewManager object at 0x000000000354A4A8>
                view_manager_object = item
                break
        del tmp_list2

        if not view_manager_object:
            return

        key = matching_view

        #change only if not already using the correct vl view...
        if key == library_config[vl_key_last_view]:
            #~ if DEBUG: print("already using the correct vl view...")
            return

        view_manager_object.actual_plugin_.switch_view(key)

        msg = "JS+ VL View Changed to: " + key
        self.gui.status_bar.showMessage(msg)

        #~ if DEBUG:
            #~ s = ', '.join(i for i in dir(view_manager_object) if not i.startswith('__'))
            #~ print(s)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def vl_pushbutton_released_event(self):
        if prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_MATCHING_ACTIVE'] == unicode("True"):
            if prefs['GUI_TOOLS_VIRTUAL_LIBRARY_VIEWS_CLICK_RELEASE_ACTIVE'] == unicode("True"):
                #~ self.my_virtual_library_pushbutton_object is the pushbutton labeled 'Virtual Library' on the searchbar (unfortunately, the QLabel next to it is not 'clickable' in Qt...)
                #~ if DEBUG: print("vl_pushbutton_released_event(self):")
                self.select_view_manager_view_for_vl()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def migrate_table_preferences_for_jobspy(self):
        #current library only...
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
            return

        #the use of table preferences by JS is long-deprecated.  delete JS from it if it exists.
        my_cursor.execute("begin")
        mysql = "DELETE FROM preferences WHERE key LIKE '%:JobSpyPlugin:settings'  "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        try:
            #the use of table __js_settings is normal and required when it was needed and created by custom_column_editable_dialog.py; otherwise, delete it if it contains only an empty dict  '{}'  .
            #~ typical value:  {u'CUSTOM_COLUMN_EDITABLE_MATRIX': {2: "[2, 'True', 'False', 'False', 'True', 'False', 'True']", 3: "[3,.....................
            mysql = "SELECT id,val FROM __js_settings WHERE key = 'reserved:JobSpyPlugin:settings' AND val <> '{}' "
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                tmp_rows = []
            if len(tmp_rows) > 0:       # val <> '{}'
                can_delete = False
                #~ if DEBUG: print("**cannot** delete; found: __js_settings WHERE key = 'reserved:JobSpyPlugin:settings' AND val <> '{}'")
            else:
                can_delete = True
                #~ if DEBUG: print("**can delete**; did not find __js_settings WHERE key = 'reserved:JobSpyPlugin:settings' AND val <> '{}'")

            if can_delete:
                my_cursor.execute("begin")
                mysql = "DROP TABLE IF EXISTS __js_settings "
                my_cursor.execute(mysql)
                my_cursor.execute("commit")

            del tmp_rows
            del can_delete
        except:
            #~ if DEBUG: print(" Job Spy table __js_settings does not exist at this time (which is normal).")
            pass

        my_db.close()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_all_libraries_list(self,include_current=False):
        # has the complete list of all currently known Calibre libraries

        self.current_library_path = self.gui.library_view.model().db.library_path
        if isbytestring(self.current_library_path):
            self.current_library_path = self.current_library_path.decode(filesystem_encoding)
        self.current_library_path = self.current_library_path.replace(os.sep, '/').strip()

        self.target_library_list = []

        stats = self.gprefs.get('library_usage_stats', {})

        for k,v in stats.iteritems():
            k = k.strip()
            if k <> self.current_library_path:
                self.target_library_list.append(k)
                #~ if DEBUG: print("gprefs: k", k)
            else:
                if include_current:
                    self.target_library_list.append(k)

        #END FOR

        del stats

        self.target_library_list.sort()
    #----------------------------------------------------
    def apsw_connect_to_target_library(self,selected_target_library):

        path = selected_target_library
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        if isbytestring(path):
            path = path.decode(filesystem_encoding)

        if path.endswith("/"):
            path = path[0:-1]

        try:
            my_db =apsw.Connection(path)
            is_valid = True
        except Exception as e:
            #~ if DEBUG: print("path to metadata.db is: ", path)
            #~ if DEBUG: print("error: ", str(e))
            is_valid = False
            return None,None,is_valid

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        return my_db,my_cursor,is_valid
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_reserved_prefs(self):

        try:
            try:
                my_db,my_cursor,is_valid = self.apsw_connect_to_library()
                if not is_valid:
                    error_dialog(self.gui, _('Job Spy'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
                    return
                mysql = "SELECT id,val FROM __js_settings WHERE key = 'reserved:JobSpyPlugin:settings' "
                my_cursor.execute(mysql)
                tmp_rows = my_cursor.fetchall()
                my_db.close()
                if not tmp_rows:
                    tmp_rows = []
                    self.library_config = None
                if len(tmp_rows) == 0:
                    self.library_config = None
                for row in tmp_rows:
                    id,val = row
                    if not val:
                        self.library_config = None
                    else:
                        self.library_config = val
                    break
                del tmp_rows
                if not self.library_config:
                    self.library_config = {}
            except Exception as e:
                #~ if DEBUG: print("[0] Exception in get_reserved_prefs: ", str(e))
                self.library_config = {}

            self.matrix_dict = self.library_config
            self.matrix_dict = str(self.matrix_dict)
            if not isinstance(self.matrix_dict,dict):
                self.matrix_dict = str(self.matrix_dict)
                self.matrix_dict = ast.literal_eval(self.matrix_dict)
            if not isinstance(self.matrix_dict,dict):
                self.matrix_dict = {}
            #~ if DEBUG:
                #~ for k,v in self.matrix_dict.iteritems():
                    #~ print("initial self.matrix_dict: ", str(k),str(v))
        except Exception as e:
            if DEBUG: print("[1] Exception in get_reserved_prefs: ", str(e))
            self.library_config = {}
            self.matrix_dict = {}

        self.unpack_matrix_column_labels()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def unpack_matrix_column_labels(self):
        #default to the generic, cross-library prefs values, but these will be overridden by self.matrix_dict if one exists...
        self.group1_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP1']
        self.group2_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP2']
        self.group3_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP3']
        self.group4_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP4']
        self.group5_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP5']
        self.group6_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP6']

        if len(self.matrix_dict) == 0:
            return

        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP1' in self.matrix_dict:
            self.group1_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP1']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP2' in self.matrix_dict:
            self.group2_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP2']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP3' in self.matrix_dict:
            self.group3_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP3']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP4' in self.matrix_dict:
            self.group4_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP4']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP5' in self.matrix_dict:
            self.group5_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP5']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP6' in self.matrix_dict:
            self.group6_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP6']

        #~ if DEBUG: print("1: ", self.group1_name)
        #~ if DEBUG: print("2: ", self.group2_name)
        #~ if DEBUG: print("3: ", self.group3_name)
        #~ if DEBUG: print("4: ", self.group4_name)
        #~ if DEBUG: print("5: ", self.group5_name)
        #~ if DEBUG: print("6: ", self.group6_name)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ignore_copy_to_library_cc_messages(self):

        include_current = True
        self.get_all_libraries_list(include_current)

        if len(self.target_library_list) == 0:
            return

        self.library_name_uuid_dict = {}

        for library in self.target_library_list:
            self.get_all_target_library_uuids(library)
        #END FOR

        self.add_items_to_libraries_with_checked_columns_defaultdict()

    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_all_target_library_uuids(self,library):
        my_db,my_cursor,is_valid = self.apsw_connect_to_target_library(library)
        if not is_valid:
            #~ if DEBUG: print("ERROR: apsw connection error - not is_valid for: ", library)
            return

        try:
            mysql = "SELECT id,uuid FROM library_id WHERE uuid NOT NULL and uuid > ' ' "
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
        except Exception as e:
            if DEBUG: print("Library is invalid for UUID lookup: ", library, "    ", str(e))
            my_db.close()
            return

        my_db.close()
        if not tmp_rows:
            tmp_rows = []
        if len(tmp_rows) <> 1:
            return
        for row in tmp_rows:
            id,library_id = row
            libraryname = self.decompose_library_path(library)
            if libraryname > " ":
                if library_id > " ":
                    self.library_name_uuid_dict[libraryname] = library_id
                    #~ if DEBUG: print("added to uuid_dict: ", libraryname,library_id)
        #END FOR
        del tmp_rows
        return

    #---------------------------------------------------------------------------------------------------------------------------------------
    def decompose_library_path(self,library):

        #~ if DEBUG: print("path: ", library)
        if library.endswith("/"):
            library = library[ :-1]
        s_split = library.split("/")
        n = len(s_split)
        libraryname = s_split[n-1]
        libraryname = libraryname.strip()
        #~ if DEBUG: print("decomposed: ", libraryname)

        return libraryname
    #---------------------------------------------------------------------------------------------------------------------------------------
    def add_items_to_libraries_with_checked_columns_defaultdict(self):

        sources1 = prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_SOURCES_1'] + "|"
        sources2 = prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_SOURCES_2'] + "|"
        targets1 = prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_TARGETS_1'] + "|"
        targets2 = prefs['GUI_TOOLS_IGNORE_CC_MESSAGES_TARGETS_2'] +"|"

        #~ if DEBUG: print("Sources1: ", sources1)
        #~ if DEBUG: print("Targets1: ", targets1)
        #~ if DEBUG: print("Sources2: ", sources2)
        #~ if DEBUG: print("Targets2: ", targets2)

        #~ ---------------------------------
        source1_list = []
        s_split = sources1.split("|")
        if "*" in s_split:
            for k,v in self.library_name_uuid_dict.iteritems():
                source1_list.append(k)
            #END FOR
        else:
            for row in s_split:
                source = row.strip()
                if source > " ":
                    if source in self.library_name_uuid_dict:
                        source1_list.append(source)
                    else:
                        if DEBUG: print("source1 missing from uuid dict: ", source)
            #END FOR
        #~ ---------------------------------
        target1_list = []
        s_split = targets1.split("|")
        if "*" in s_split:
            for k,v in self.library_name_uuid_dict.iteritems():
                target1_list.append(k)
            #END FOR
        else:
            for row in s_split:
                target = row.strip()
                if target > " ":
                    if target in self.library_name_uuid_dict:
                        target1_list.append(target)
                    else:
                        if DEBUG: print("target1 missing from uuid dict: ", target)
            #END FOR
        #~ ---------------------------------
        #~ ---------------------------------
        source2_list = []
        s_split = sources2.split("|")
        if "*" in s_split:
            for k,v in self.library_name_uuid_dict.iteritems():
                source2_list.append(k)
            #END FOR
        else:
            for row in s_split:
                source = row.strip()
                if source > " ":
                    if source in self.library_name_uuid_dict:
                        source2_list.append(source)
                    else:
                        if DEBUG: print("source2 missing from uuid dict: ", source)
            #END FOR
        #~ ---------------------------------
        target2_list = []
        s_split = targets2.split("|")
        if "*" in s_split:
            for k,v in self.library_name_uuid_dict.iteritems():
                target2_list.append(k)
            #END FOR
        else:
            for row in s_split:
                target = row.strip()
                if target > " ":
                    if target in self.library_name_uuid_dict:
                        target2_list.append(target)
                    else:
                        if DEBUG: print("target2 missing from uuid dict: ", target)
            #END FOR
        #~ ---------------------------------
        try:
            from calibre.gui2.actions.copy_to_library import libraries_with_checked_columns
        except Exception as e:
            if DEBUG: print("ignore_copy_to_library_cc_messages: import error: ", str(e))
            return
        #~ ---------------------------------

        for source in source1_list:
            for target in target1_list:
                source_uuid = self.library_name_uuid_dict[source]
                target_uuid = self.library_name_uuid_dict[target]
                libraries_with_checked_columns[source_uuid].add(target_uuid)
                #~ if DEBUG: print("[1]: ", source_uuid,"--->>", target_uuid)
            #END FOR
        #END FOR

        for source in source2_list:
            for target in target2_list:
                source_uuid = self.library_name_uuid_dict[source]
                target_uuid = self.library_name_uuid_dict[target]
                libraries_with_checked_columns[source_uuid].add(target_uuid)
                #~ if DEBUG: print("[2]: ", source_uuid,"--->>", target_uuid)
            #END FOR
        #END FOR

        #~ if DEBUG:
            #~ for k,v in libraries_with_checked_columns.iteritems():
                #~ print(k,v)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def change_gui_alternating_row_colors(self):

        if not self.maingui:
            if DEBUG: print("no self.maingui; returning...")
            return

        try:
            if self.color_runtype == "manual" or self.autorun_main_gui_colors:
                if prefs['GUI_TOOLS_MAIN_GUI_COLOR_ACTIVE'] == unicode("True"):
                    tc = prefs['GUI_TOOLS_MAIN_GUI_TEXT_COLOR']
                    vl = prefs['GUI_TOOLS_MAIN_GUI_VIRTUAL_LIBRARY_COLOR']
                    srch = prefs['GUI_TOOLS_MAIN_GUI_SEARCHBAR_COLOR']

                    vl_style_string = "QToolButton {background-color: [VL];color : [TC]; }"
                    vl_style_string = vl_style_string.replace("[TC]",tc)
                    vl_style_string = vl_style_string.replace("[VL]",vl)
                    self.maingui.virtual_library.setStyleSheet(vl_style_string)     # QToolButton virtual_library
                    self.maingui.clear_vl.setStyleSheet(vl_style_string)               # QToolButton clear_vl

                    ss_string = "[QT] {background-color: [SRCH];color : [TC]; }"
                    search_style_string = ss_string.replace("[TC]",tc)
                    search_style_string = search_style_string.replace("[SRCH]",srch)
                    search_style_string = search_style_string.replace("[QT] ","QToolButton, RightClickButton,SavedSearchBox,SearchBar,SearchBox2,StatusBar, VersionLabel ")
                    self.maingui.copy_search_button.setStyleSheet(search_style_string)    # QToolButton copy_search_button
                    self.maingui.save_search_button.setStyleSheet(search_style_string)     # RightClickButton save_search_button
                    self.maingui.saved_search.setStyleSheet(search_style_string)   #SavedSearchBox saved_search
                    self.maingui.search_bar.setStyleSheet(search_style_string)     # SearchBar search_bar
                    self.maingui.search.setStyleSheet(search_style_string)            # SearchBox2 search
                    if prefs['GUI_TOOLS_STATUS_BAR_COLOR_CHANGE'] == unicode("False"):
                        self.maingui.status_bar.setStyleSheet(search_style_string)     # StatusBar status_bar
                        self.maingui.status_bar.defmsg.setStyleSheet(search_style_string)  # Version Label on left of status bar


            if self.color_runtype == "manual" or self.autorun_library_view_colors:
                if prefs['GUI_TOOLS_LIBRARY_VIEW_COLOR_ACTIVE'] == unicode("True"):
                    tc = prefs['GUI_TOOLS_LIBRARY_VIEW_TEXT_COLOR']
                    bc = prefs['GUI_TOOLS_LIBRARY_VIEW_BACKGROUND_COLOR']
                    ac = prefs['GUI_TOOLS_LIBRARY_VIEW_ALTERNATING_COLOR']


                    if prefs['GUI_TOOLS_LIBRARY_VIEW_COLUMN_HEADING_COLOR_CHANGE'] == unicode("True"):
                        style_string = "QTableView, QTreeView, QHeaderView, StatusBar, QToolButton {alternate-background-color: [AC];background-color: [BC];color : [TC]; }"
                    else:
                        style_string = "QTableView, QTreeView, StatusBar, QToolButton {alternate-background-color: [AC];background-color: [BC];color : [TC]; }"
                    style_string = style_string.replace("[TC]",tc)
                    style_string = style_string.replace("[BC]",bc)
                    style_string = style_string.replace("[AC]",ac)
                    self.maingui.library_view.setAlternatingRowColors(True)    # QTableView BooksView library_view       QHeaderView will change the column/row heading colors
                    self.maingui.library_view.setStyleSheet(style_string)
                    #-----As of Calibre 3.17 20180209------Begin
                    try:
                        self.maingui.library_view.pin_view.setAlternatingRowColors(True)
                        self.maingui.library_view.pin_view.setStyleSheet(style_string)
                    except Exception as e:
                        if DEBUG: print("Calibre version is too low for pin_view...", str(e))
                    #-----As of Calibre 3.17 20180209------End
                    self.maingui.tags_view.setAlternatingRowColors(True)       # QTreeView TagsView tags_view
                    self.maingui.tags_view.setStyleSheet(style_string)
                    self.maingui.alter_tb.setStyleSheet(style_string)   # QToolButton alter_tb       This is the 'configure' button in the very left bottom of the tag browser...just above the status bar...
                    #~ Note: the "find" button to the right of alter_tb is really a child of the stack and is a combobox with completer that is first shown with the button merged with the line edit; it is not worth messing with...

                    if prefs['GUI_TOOLS_STATUS_BAR_COLOR_CHANGE'] == unicode("True"):
                        self.maingui.status_bar.setStyleSheet(style_string)   # StatusBar status_bar
                        style_string2 = "VersionLabel, " + style_string
                        self.maingui.status_bar.defmsg.setStyleSheet(style_string2)  # Version Label on left of status bar

                    book_details_style_string = "QWidget {background-color: [BC];color : [TC];}"
                    book_details_style_string = book_details_style_string.replace("[TC]",tc)
                    book_details_style_string = book_details_style_string.replace("[BC]",bc)
                    self.maingui.book_details.setStyleSheet(book_details_style_string)     # QWidget  BookDetails book_details

            if self.color_runtype == "manual" or self.autorun_main_gui_colors:
                if prefs['GUI_TOOLS_MAIN_GUI_COLOR_ACTIVE'] == unicode("True"):
                    tc = prefs['GUI_TOOLS_MAIN_GUI_TEXT_COLOR']
                    srch = prefs['GUI_TOOLS_MAIN_GUI_SEARCHBAR_COLOR']
                    search_style_string = "background-color: [SRCH];color : [TC];"
                    search_style_string = search_style_string.replace("[TC]",tc)
                    search_style_string = search_style_string.replace("[SRCH]",srch)
                    toolbar_style_string = 'QToolBar { border: 0px;' + search_style_string + ' }'
                    for bar in self.maingui.bars_manager.main_bars:
                        bar.setStyleSheet(toolbar_style_string)
                        #~ if DEBUG: print("main bar", str(bar))  # <calibre.gui2.bars.ToolBar              2 of these...
                    for bar in self.maingui.bars_manager.child_bars:
                        bar.setStyleSheet(toolbar_style_string)
                        #~ if DEBUG: print("child bar", str(bar))  #<calibre.gui2.bars.ToolBar               1 of these...

        except Exception as e:
            if DEBUG: print(str(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def sqlite_vacuum_en_masse(self):
        self.get_all_libraries_list()
        n = len(self.target_library_list)
        msg = "Vacuum all of the <b>" + str(n) + "</b> Calibre Libraries currently remembered if they still exist and can be connected?"
        #~ for library in self.target_library_list:
            #~ msg = msg + "<br>" + library
        #~ #END FOR
        msg = msg + "<br><br><b><i>Offline/Unconnected Network/Cloud Libraries will necessarily be skipped.<i></b>"
        if question_dialog(self.gui, "JS+ GUI Tool - Vacuum/Compress metadata.db En Masse", msg):
            pass
        else:
            return

        for library in self.target_library_list:
            msg = "Vacuuming: " + library
            self.gui.status_bar.show_message(_(msg), 2000)
            my_db,my_cursor,is_valid = self.apsw_connect_to_target_library(library)
            if not is_valid:
                if DEBUG: print("not is_valid for: ", library)
                continue
            my_cursor.execute("VACUUM")
            my_db.close()
        #END FOR
        n = len(self.target_library_list)
        msg = "Total Other Libraries Vacuumed: " + str(n) + "  --  Current  Library Ignored..."
        self.gui.status_bar.show_message(_(msg), 10000)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def kb_shortcut_cc1(self):
        if not prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_AUTOFILL_ACTIVE'] == unicode("True"):
            return
        selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool for KB Shortcut #1'),_('No Books Were Selected.'), show=True)
        selected_books_list.sort()
        predefined_cc1 = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE1_CUSTOM_COLUMN']
        predefined_cc1_value = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE1_VALUE']
        was_success = self.update_custom_metadata_using_standard_calibre(selected_books_list,predefined_cc1,predefined_cc1_value)
        if not was_success:
            if DEBUG: print("JS+:  CC1  ERROR: update_custom_column using keyboard shortcut")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def kb_shortcut_cc2(self):
        if not prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_AUTOFILL_ACTIVE'] == unicode("True"):
            return
        selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool for KB Shortcut #2'),_('No Books Were Selected.'), show=True)
        selected_books_list.sort()
        predefined_cc2 = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE2_CUSTOM_COLUMN']
        predefined_cc2_value = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE2_VALUE']
        was_success = self.update_custom_metadata_using_standard_calibre(selected_books_list,predefined_cc2,predefined_cc2_value)
        if not was_success:
            if DEBUG: print("JS+:  CC2  ERROR: update_custom_column using keyboard shortcut")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def kb_shortcut_cc3(self):
        if not prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_AUTOFILL_ACTIVE'] == unicode("True"):
            return
        selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool for KB Shortcut #3'),_('No Books Were Selected.'), show=True)
        selected_books_list.sort()
        predefined_cc3 = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE3_CUSTOM_COLUMN']
        predefined_cc3_value = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE3_VALUE']
        was_success = self.update_custom_metadata_using_standard_calibre(selected_books_list,predefined_cc3,predefined_cc3_value)
        if not was_success:
            if DEBUG: print("JS+:  CC3  ERROR: update_custom_column using keyboard shortcut")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def kb_shortcut_cc4(self):
        if not prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_AUTOFILL_ACTIVE'] == unicode("True"):
            return
        selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool for KB Shortcut #4'),_('No Books Were Selected.'), show=True)
        selected_books_list.sort()
        predefined_cc4 = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE4_CUSTOM_COLUMN']
        predefined_cc4_value = prefs['GUI_TOOLS_KEYBOARD_SHORTCUTS_FOR_CC_RULE4_VALUE']
        was_success = self.update_custom_metadata_using_standard_calibre(selected_books_list,predefined_cc4,predefined_cc4_value)
        if not was_success:
            if DEBUG: print("JS+:  CC4  ERROR: update_custom_column using keyboard shortcut")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_custom_metadata_using_standard_calibre(self,selected_books_list,predefined_cc,predefined_value):

        predefined_cc = predefined_cc.strip()
        predefined_cc = str(predefined_cc)

        if not predefined_cc in self.current_custom_columns_list:
            return False

        mi_field = predefined_cc  # should be a '#label'

        #~ Validate datatype
        custcol = self.custom_columns_metadata_dict[mi_field]   # should be a '#label'
        cc_datatype = custcol['datatype']
        if cc_datatype <> "text" and cc_datatype <> "comments" and cc_datatype <> "enumeration":
            #~ if DEBUG: print("cc_datatype is not text and is not comments and is not an enumeration: ", predefined_cc, "   ", cc_datatype)
            msg = "Customized KB Shortcut Custom Column datatype is not text and is not comments and is not an enumeration (fixed set of values): " + predefined_cc + " with a value type of:  " + cc_datatype
            error_dialog(self.gui, _('JS+ GUI Tool for KB Shortcuts'),_(msg), show=True)
            return False

        payload = selected_books_list

        id_map = {}

        for book in selected_books_list:
            book = int(book)
            mi = Metadata(_('Unknown'))
            custcol = self.custom_columns_metadata_dict[mi_field]   # should be a '#label'
            custcol['#value#'] = predefined_value
            mi.set_user_metadata(mi_field, custcol)
            id_map[book] = mi
        #END FOR
        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=None)

        del id_map
        del mi

        return True
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def list_all_keyboard_shortcuts(self):
        #~ -------------------------------------------------
        #~ First, get all standard Calibre shortcuts:
        #~ -------------------------------------------------
        from calibre.utils.icu import sort_key
        self.keyboard = self.maingui.keyboard
        groups = sorted(self.keyboard.groups, key=sort_key)
        shortcut_map = {k:v.copy() for k, v in self.keyboard.shortcuts.iteritems()}

        shortcut_assignments_dict = {}

        for un, s in shortcut_map.iteritems():
            s['keys'] = tuple(self.keyboard.keys_map.get(un, ()))
            k = str(s['keys'])
            if k.count("()") == 1:
                continue
            s['unique_name'] = un
            s['group'] = [g for g, names in self.keyboard.groups.iteritems() if un in
                    names][0]
            row = 'Default', s['group'], s['name'], s['default_keys']
            ss = str(s['default_keys'])
            if ss.count("()") == 1:  # e.g.    tag browser alter ()
                continue
            shortcut_assignments_dict[ss] = row
            if DEBUG: print("Standard: ", str(row))
        #END FOR

        #~ -------------------------------------------------
        #~ Next, get all User Custom shortcuts:
        #~ -------------------------------------------------
        from calibre.utils.config import JSONConfig
        config_name='shortcuts/main'
        self.config = JSONConfig(config_name)
        custom_keys_map = {un:tuple(keys) for un, keys in self.config.get('map', {}).iteritems()}
        for un,shortcut in custom_keys_map.iteritems():
            if DEBUG: print("CUSTOM:  un,shortcut: ", str(un), str(shortcut))
            ss = str(shortcut)
            if ss.count("()") == 1:  # e.g.    tag browser alter ()
                continue

            group,tmpname = self.parse_group_name(un)

            if un in self.keyboard.shortcuts:
                name = self.keyboard.shortcuts[un]['name']
                if DEBUG: print("un name1: ", name)
            else:
                name = tmpname  # un was not found in self.keyboard.shortcuts
                if name.count("-") >= 4 and name.count(" ") == 0 and len(name) >= 36:     #  e.g. 62d04d2b-be8b-417f-89bd-b90bd7f0a8d2
                    if name in self.keyboard.shortcuts:
                        v_dict = self.keyboard.shortcuts[name]
                        if "name" in v_dict:
                            name = v_dict["name"]
                            if DEBUG: print("un name3: ", name)
                    else:
                        if DEBUG: print("....un real name not found...",name)
                else:
                    if DEBUG: print("un name2: ", name)        # e.g.  Size: 450(w) x 600(h) - proportional

            row = 'Custom', group, name, shortcut
            shortcut_assignments_dict[ss] = row   # since a dict, custom shortcuts will replace any preexisting standard shortcuts, just as Calibre does.
            if DEBUG: print("Custom: ", str(row))
        #END FOR

        shortcut_assignments_list = []
        for k,v in shortcut_assignments_dict.iteritems():
            shortcut_assignments_list.append(v)
        #END FOR

        #~ -------------------------------------------------
        #~ Finally, display the sortable listing of all shortcuts
        #~ -------------------------------------------------
        try:
            self.shortcutslistingdialog.close()
        except:
            pass

        from calibre_plugins.job_spy.shortcuts_listing_dialog import ShortcutsListingDialog
        self.shortcutslistingdialog = ShortcutsListingDialog(None,shortcut_assignments_list)
        self.shortcutslistingdialog.show()

        del shortcut_assignments_list
        del shortcut_assignments_dict
        del ShortcutsListingDialog
        del custom_keys_map
        del shortcut_map
        del JSONConfig
        del sort_key
    #---------------------------------------------------------------------------------------------------------------------------------------
    def parse_group_name(self,un):

    #~ Interface Action: Job Spy (Job Spy) : menu action : JS+:GUI Tool:   Keyboard Shortcut to Autofill Custom Column #3 [Selected Books] >>> (u'Ctrl+Num+3',)
    #~ Interface Action: Job Spy (Job Spy) : menu action : JS+:GUI Tool:   Keyboard Shortcut to Autofill Custom Column #1 [Selected Books] >>> (u'Ctrl+Num+1',)
    #~ Interface Action: Job Spy (Job Spy) : menu action : JS+:GUI Tool:   Keyboard Shortcut to Autofill Custom Column #2 [Selected Books] >>> (u'Ctrl+Num+2',)
    #~ Interface Action: Job Spy (Job Spy) : menu action : JS+:GUI Tool:   Keyboard Shortcut to Autofill Custom Column #4 [Selected Books] >>> (u'Ctrl+Num+4',)
    #~ Interface Action: Library Codes (Library Codes) : menu action : Attempt to Substitute Non-Responsive ISBN Using Author/Title [Selected Single Book] >>> (u'Ctrl+Alt+Z',)
    #~ Interface Action: Drop Search Results (Drop Search Results) : menu action : Drop Search Results >>> (u'F12',)
    #~ 62d04d2b-be8b-417f-89bd-b90bd7f0a8d2  >>> (u'Shift+Z',)
    #~ splitter cover_browser_splitter Cover browser  >>> (u'Ctrl+Alt+C',)
    #~ Focus To Quickview  >>> (u'Ctrl+Shift+Q',)
    #~ fbd2cffb-8165-469b-bcbf-3386fe82f854 (u'Ctrl+Shift+O',)
    #~ 627f358b-c496-48b5-bc58-eab0d5ff7b93 (u'Shift+B',)


        group = "Miscellaneous"
        name = un

        try:
            s_split1 = un.split("Interface Action:")
            if s_split1:
                if isinstance(s_split1,list):
                    if len(s_split1) > 1:
                        for row in s_split1:
                            row = row.strip()
                            s_split2 = row.split(": menu action :")
                            if s_split2:
                                if isinstance(s_split2,list):
                                    if len(s_split2) > 1:
                                        group = s_split2[0].strip()
                                        name = s_split2[1].strip()
                        #END FOR
        except Exception as e:
            if DEBUG: print("JS+ Shortcuts Listing custom shortcut parse error for: ", un, "     ", str(e))

        if group.endswith(")") and "(" in group:  # example:  Job Spy (Job Spy)
            s_split = group.split("(")
            group = s_split[0].strip()   # example:  Job Spy

        name = name.strip()

        return group,name
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def mega_metadata_book_creator_tool(self):

        selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool Mega-Metadata Book Creation Helper'),_('No Book Was Selected.'), show=True)
        if n_books > 1:
             return error_dialog(self.gui, _('JS+ GUI Tool Mega-Metadata Book Creation Helper'),_('Only a single book may be Selected.'), show=True)

        selected_books_list.sort()

        choices = str(prefs['GUI_TOOLS_MEGA_METADATA_BOOK_HELPER_CHOICES_DICT'])
        choices_dict = ast.literal_eval(choices)
        if not isinstance(choices_dict,dict):
            if DEBUG: print("choices_dict is invalid dict")
            return

        tags = choices_dict["tags"]
        if tags == "True":
            tags = True
        else:
            tags = False
        cc = choices_dict["cc"]
        if cc == "True":
            cc = True
        else:
            cc = False
        custom_columns = str(choices_dict["custom_columns"])
        custom_columns_list = ast.literal_eval(custom_columns)
        custom_columns_list.sort()


        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        cc_list_dict = {}

        if tags:
            tag_list = self.get_all_tags(my_db,my_cursor)
            if len(tag_list) > 0:
                self.mega_metadata_update_tags(my_db,my_cursor,selected_books_list,tag_list)

        if cc:
            for row in custom_columns_list:
                row = str(row).strip()
                value_list = self.get_all_of_cc(my_db,my_cursor,row)
                cc_list_dict[row] = value_list
            #END FOR
            for custcolumn,value_list in cc_list_dict.iteritems():
                if len(value_list) > 0:
                    for book in selected_books_list:
                        is_valid = self.mega_metadata_update_custom_column(book,custcolumn,value_list)
                        if not is_valid:
                            if DEBUG: print("self.mega_metadata_update_custom_column(book,custcol,value_list) failed for: ", str(custcolumn))
                            break
                    #END FOR
            #END FOR

        my_db.close()
        #-------------------------------------
        self.force_refresh_of_cache(selected_books_list)
        #-------------------------------------
        self.selected_books_list = selected_books_list
        self.mark_selected_books()
        del selected_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_all_tags(self,my_db,my_cursor):
        tag_list = []
        mysql = "SELECT id,name FROM tags ORDER BY name"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id,name = row
            tag_list.append(id)
        #END FOR
        del tmp_rows

        return tag_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def mega_metadata_update_tags(self,my_db,my_cursor,selected_books_list,tag_list):

        my_cursor.execute("begin")

        for book in selected_books_list:
            for tag in tag_list:
                mysql = "INSERT OR IGNORE INTO books_tags_link (id,book,tag) VALUES (null,?,?)"
                my_cursor.execute(mysql,(book,tag))
            #END FOR
        #END FOR

        my_cursor.execute("commit")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_all_of_cc(self,my_db,my_cursor,cc):

        custcol = self.custom_columns_metadata_dict[cc]   # should be a '#label'
        cc_table = str(custcol['table'])

        cc_list = []

        mysql = "SELECT id,value FROM [TABLE] ORDER BY value"
        mysql = mysql.replace("[TABLE]",cc_table)
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id,value = row
            cc_list.append(value)
        #END FOR
        del tmp_rows

        return cc_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def mega_metadata_update_custom_column(self,book,custcolumn,value_list):

        custcolumn = custcolumn.strip()
        custcolumn = str(custcolumn)

        if not custcolumn in self.current_custom_columns_list:
            if DEBUG: print("not custcolumn in self.current_custom_columns_list; return False...")
            return False

        mi_field = custcolumn  # should be a '#label'

        #~ Validate datatype
        custcol = self.custom_columns_metadata_dict[mi_field]   # should be a '#label'
        cc_datatype = custcol['datatype']
        if cc_datatype <> "text":
            msg = "Customized Custom Column is NOT a Tag-like Text type: " + custcolumn + " and has a value type of:  " + cc_datatype
            error_dialog(self.gui, _('JS+ GUI Tool for Mega-Metadata Book Creation Helper'),_(msg), show=True)
            return False

        book_list = []
        book = int(book)
        book_list.append(book)

        payload = book_list

        id_map = {}

        mi = Metadata(_('Unknown'))
        custcol = self.custom_columns_metadata_dict[mi_field]   # should be a '#label'
        custcol['#value#'] = value_list
        mi.set_user_metadata(mi_field, custcol)
        id_map[book] = mi

        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=None)

        del custcol
        del id_map
        del mi
        del value_list

        return True
    #---------------------------------------------------------------------------------------------------------------------------------------
    def invert_selection(self):
        #great as a shortcut...
        self.get_selected_books()
        self.mark_selected_books()
        self.gui.search.clear()
        self.gui.search.set_search_string('marked:false')
        self.maingui.library_view.selectAll()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def copy_to_library_shortcut(self):
        if not self.mycopytolibraryobject:
            for k,v in self.maingui.iactions.iteritems():
                if "Copy To Library" in k:
                    self.mycopytolibraryobject = v
                    self.monkey_patch_chooselibrary()
                    break
            #END FOR

        if self.mycopytolibraryobject:
            try:
                self.mycopytolibraryobject.choose_library()
            except Exception as e:
                if DEBUG: print("Error in copy_to_library_shortcut: ", str(e))
        #----------------------------------------
        #----------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def monkey_patch_chooselibrary(self):
        #~ -------------------------------------
        def js_browse(self):
            title = "Choose the Target Calibre Library"
            default_user_library_directory = prefs['GUI_TOOLS_COPY_TO_LIBRARY_SHORTCUT_DEFAULT_DIRECTORY']
            chosen_directory_name = QFileDialog.getExistingDirectory(None,title,default_user_library_directory,QFileDialog.ShowDirsOnly | QFileDialog.DontResolveSymlinks )
            self.le.setText(chosen_directory_name)
        #~ -------------------------------------
        from calibre.gui2.actions.copy_to_library import ChooseLibrary
        ChooseLibrary.browse = js_browse
        #~ -------------------------------------1
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ftp_selected_books(self):

        self.selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
        self.selected_books_list.sort()

        self.guidb = self.gui.library_view.model().db
        my_db = self.gui.library_view.model().db
        libpath = my_db.library_path
        if isbytestring(libpath):
            libpath = libpath.decode(filesystem_encoding)
        libpath = libpath.replace(os.sep, '/')
        libpath = libpath + "/"
        if DEBUG: print("libpath: ", libpath)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        try:
            my_book_path_dict = {}
            mysql = "SELECT id,path FROM books WHERE id = ?"
            for book in self.selected_books_list:
                my_cursor.execute(mysql,([book]))
                tmp_rows = my_cursor.fetchall()
                if not tmp_rows:
                    tmp_rows = []
                if len(tmp_rows) == 0:
                   continue
                for row in tmp_rows:
                    id,path = row
                    my_book_path_dict[id] = libpath + path
                #END FOR
                del tmp_rows
            #END FOR

            formats = prefs['GUI_TOOLS_FTP_FORMAT']
            formats = formats.upper().strip()
            formats = formats + ","
            formats = formats.replace(" ","")
            formats_list = formats.split(",")

            my_book_name_dict = {}

            mysql = "SELECT book,format,name FROM data WHERE book = ? AND format = ?"

            for book in self.selected_books_list:
                found_format = False
                format_to_use = ""
                name_to_use = ""
                for format in formats_list:  # in priority sequence
                    if format > " ":
                        my_cursor.execute(mysql,(book,format))
                        tmp_rows = my_cursor.fetchall()
                        if not tmp_rows:
                            #~ if DEBUG: print("format  not found for book: ", format)
                            continue
                        if len(tmp_rows) == 0:
                            #~ if DEBUG: print("format  not found for book: ", format)
                            continue
                        for row in tmp_rows:
                            book,form,name = row
                            found_format = True
                            format_to_use = form
                            name_to_use = name
                            #~ if DEBUG: print("format was found for book: ", format, name)
                        #END FOR
                        if found_format:
                            break
                #END FOR
                if not found_format:
                    if book in my_book_path_dict:
                        del my_book_path_dict[book]
                    continue
                else:
                    path = my_book_path_dict[book]
                    name = name + "." + format_to_use.lower()
                    my_book_name_dict[book] = name
                    path = os.path.join(path, name)
                    path = path.replace(os.sep, '/')
                    my_book_path_dict[book] = path
                    #~ if DEBUG: print("full book format path: ", path)
            #END FOR
        except Exception as e:
            if DEBUG: print(str(e))
        #-------------------------------------
        my_db.close()
        #-------------------------------------

        host = prefs['GUI_TOOLS_FTP_HOST']
        port = prefs['GUI_TOOLS_FTP_HOST_PORT']
        host_directory = prefs['GUI_TOOLS_FTP_HOST_DIRECTORY']
        userid = prefs['GUI_TOOLS_FTP_USERID']
        password = prefs['GUI_TOOLS_FTP_PASSWORD']

        host = host.replace(os.sep,"/")
        host_directory = host_directory.replace(os.sep,"/")

        port = str(port.strip())

        if not self.myftp:
            from ftplib import FTP
            self.myftp = FTP
            del FTP

        ftp = self.myftp()

        try:
            ftp.connect(host,port)
        except Exception as e:
            msg = "Fatal error connecting to FTP host: " + host + " port: " + port + "  >>>  " + str(e)
            return error_dialog(self.gui, _('FTP'),_(msg), show=True)

        try:
            ftp.login(userid,password)
        except Exception as e:
            ftp.quit()
            msg = "Fatal error logging in to FTP host using specified credentials: " + str(e)
            return error_dialog(self.gui, _('FTP'),_(msg), show=True)

        try:
            ftp.cwd(host_directory)
        except Exception as e:
            ftp.quit()
            msg = "Fatal error changing directory to: " + host_directory + "  >>>  " + str(e)
            return error_dialog(self.gui, _('FTP'),_(msg), show=True)

        msg_list = []
        n_success = 0
        n_warning = 0
        n_no_formats_found = 0
        for k,v in my_book_path_dict.iteritems():
            if not k in my_book_name_dict:
                n_no_formats_found = n_no_formats_found + 1
                continue
            name = my_book_name_dict[k]
            v = v.replace( '/',os.sep)
            ok,msg = self.ftp_upload(ftp, v, name)
            if not ok:
                n_warning = n_warning + 1
                line = name,msg
                msg_list.append(line)
            else:
                n_success = n_success + 1
        #END FOR

        try:
            ftp.quit()
        except:
            try:
                ftp.close()
            except:
                pass

        n_total = len(my_book_path_dict)

        msg = "Books Selected: " + str(n_total) + "\nBooks with a specified format: " + str(n_success) + "\nBooks with no specified format: " + str(n_no_formats_found)
        msg = msg + "\nBooks having an FTP error message: " + str(n_warning) + "\n\n"
        for line in msg_list:
            name,m = line
            msg = msg + m + "\n"
        #END FOR

        if DEBUG: print(msg)

        info_dialog(self.gui, 'FTP Results: ',msg).show()

        del my_book_path_dict
        del ftp
    #----------------------------------------------------
    def ftp_upload(self,ftp, file, name):
        try:
            msg = "Uploading: " + name
            self.gui.status_bar.show_message(_(msg), 1000)
            #~ if DEBUG: print("ftp_upload: ", file)
            ftp.storbinary("STOR " + name, open(file, "rb"), 1024)   # 8192 or 1024
            return True,None
        except Exception as e:
            if DEBUG: print("ftp_upload error: ", str(e))
            msg = str(name) + "  :  " + str(e)
            return False,msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    def list_custom_columns_technical_details(self):

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        cc_list = []

        mysql = "SELECT id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized FROM custom_columns ORDER BY label,name"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            cc_list.append(row)
        #END FOR
        del tmp_rows

        my_db.close()

        try:
            self.cctechnicallistingdialog.close()
        except:
            pass
        from calibre_plugins.job_spy.custom_columns_technical_listing_dialog import CustomColumnsTechnicalListingDialog
        self.cctechnicallistingdialog = CustomColumnsTechnicalListingDialog(None,cc_list)
        self.cctechnicallistingdialog.show()
        del CustomColumnsTechnicalListingDialog
        del cc_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def search_for_clipboard_book_list_titles(self):
        search_text = self.clip.text()
        if not isinstance(search_text,unicode):
            return
        #~ if DEBUG: print("self.clip.text():", search_text)
        if search_text:
            orig_text = search_text
            btitles = ""  #book title search string
            search_list = search_text.split("\n")
            if isinstance(search_list,list):
                for line in search_list:
                    line = line.strip()
                    #~ if DEBUG: print(line)
                    if line > " ":
                        btitles = btitles + 'title:"' + line + '" OR '
                #END FOR
            else:
                if orig_text > " ":
                    btitles = btitles + 'title:"' + orig_text + '" OR '

            if btitles.endswith(" OR "):
                btitles = btitles[0:-4]
            self.gui.search.clear()
            self.gui.search.set_search_string(btitles)

            del btitles
            del search_text
            del orig_text
            del search_list
        else:
            self.gui.search.clear()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def search_for_clipboard_book_list_custom_columns(self):
        search_text = self.clip.text()
        if not isinstance(search_text,unicode):
            self.gui.search.clear()
            return
        #~ if DEBUG: print("self.clip.text():", search_text)
        if search_text:
            orig_text = search_text
            bcol = self.get_bcol()      #selected library_view column to search
            if not bcol:
                self.gui.search.clear()
                return
            bcolval = ""  #book column search string
            search_list = search_text.split("\n")
            if isinstance(search_list,list):
                for line in search_list:
                    line = line.strip()
                    #~ if DEBUG: print(line)
                    if line > " ":
                        line = line.replace('"',"'")
                        bcolval = bcolval + bcol + ':"' + line + '" OR '
                #END FOR
            else:
                if orig_text > " ":
                    orig_text = orig_text.replace('"',"'")
                    bcolval = bcolval + bcol + ':"' + orig_text + '" OR '

            if bcolval.endswith(" OR "):
                bcolval = bcolval[0:-4]

            self.gui.search.clear()
            self.gui.search.set_search_string(bcolval)

            del bcolval
            del search_text
            del orig_text
            del search_list
        else:
            self.gui.search.clear()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_bcol(self):
        bcol = None
        current_col = self.maingui.library_view.currentIndex().column()
        bcol = self.maingui.library_view.column_map[current_col]
        if DEBUG: print("current_col: ", str(current_col), "lookup/search name: ", str(bcol))
        return bcol
    #---------------------------------------------------------------------------------------------------------------------------------------
    def bulk_update_comments_custom_columns(self):
        clipboard_text = self.clip.text()
        if not isinstance(clipboard_text,unicode):
            return
        if clipboard_text:
            self.bulk_actions_comments_custom_columns(action="update",update_text=clipboard_text)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def bulk_empty_comments_custom_columns(self):
        self.bulk_actions_comments_custom_columns(action="empty")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def bulk_actions_comments_custom_columns(self,action=None,update_text=None):

        if not action:
            return

        bcol = self.get_bcol()      #selected library_view column to empty
        if not bcol:
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Column Was Selected. Your cursor must be within a cell underneath the desired Column.'), show=True)
        if not bcol.startswith("#"):
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Custom Column Was Selected. Your cursor must be within a cell underneath the desired Column.'), show=True)

        if DEBUG: print("Update CC: ", bcol)

        custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()
        if not bcol in custom_columns_metadata_dict:
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('Custom Column Was Not Found.  Unexpected Error.'), show=True)
        custcol = custom_columns_metadata_dict[bcol]

        if not custcol['datatype'] == "comments":
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Comments/Long-Text Custom Column Was Selected. Your cursor must be within a cell underneath the desired Column.'), show=True)

        self.selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
        self.selected_books_list.sort()

        payload = self.selected_books_list

        id_map = {}

        for book in self.selected_books_list:
            book = int(book)
            mi = Metadata(_('Unknown'))
            mi_field = bcol
            custcol = custom_columns_metadata_dict[mi_field]   # should be a '#label'
            if action == "empty":
                custcol['#value#'] = ''   # clear it
            elif action == "update":
                custcol['#value#'] = update_text
            else:
                return
            mi.set_user_metadata(mi_field, custcol)
            id_map[book] = mi
        #END FOR
        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=None)

        del id_map
        del mi
        del custom_columns_metadata_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_rowspy_dialog(self):
        try:
            self.rowspy_dialog.close()
        except:
            pass

        from calibre_plugins.job_spy.rowspy_dialog import RowSpyDialog
        self.rowspy_dialog = RowSpyDialog(self.maingui,self.maingui)
        self.rowspy_dialog.show()
        del RowSpyDialog
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_book_identifier_matrix(self):
        self.guidb = self.gui.library_view.model().db
        #-------------------------------------
        # get selected books
        #-------------------------------------
        self.selected_books_list = self.get_selected_books()
        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
        elif n_books  > 10000:
            msg = "You have selected " + str(n_books) + " books.  This may take quite some time.  Do you want to continue with the current selection of books?"
            if question_dialog(self.gui, "JS+ GUI Tool - Book Identifiers Matrix", msg):
                pass
            else:
                del self.selected_books_list
                return

        if DEBUG: print("show_book_identifier_matrix:  Number of book selected: ", str(n_books))

        selected_books_set = set(self.selected_books_list)
        #-------------------------------------
        # process selected books
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        mysql = "SELECT type FROM identifiers GROUP BY type ORDER BY type"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            my_db.close()
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Identifiers Exist in Library'), show=True)
        if len(tmp_rows) == 0:
            my_db.close()
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Identifiers Exist in Library'), show=True)

        column_assignment_dict = {}  # [type] = column number  #starting with col 3
        column_number = 3
        for row in tmp_rows:
            for col in row:
                type = col
                column_assignment_dict[type] = column_number
                column_number = column_number + 1
                break
            #END FOR
        #END FOR
        del tmp_rows

        final_column_number = column_number - 1

        book_data_dict = {}  # [bookid] = title,author_sort
        book_type_dict = {}   # [type] = val
        book_identifiers_dict = {}  # [bookid] = book_type_dict


        mysql = "SELECT books.id,books.title,books.author_sort,identifiers.type,identifiers.val \
                        FROM books,identifiers \
                        WHERE books.id = identifiers.book \
                        ORDER BY books.id,identifiers.type "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        oldid = 0
        for row in tmp_rows:
            #~ if DEBUG: print("tmp_rows: ", str(row))
            id,title,author_sort,type,val = row
            if not str(id) in selected_books_set:
                continue
            newid = id
            if newid <> oldid:
                del book_type_dict
                book_type_dict = {}
            book_data_dict[id] = title,author_sort
            book_type_dict[type] = val
            book_identifiers_dict[id] = book_type_dict
            oldid = id
        #END FOR
        del tmp_rows

        #~ some books have no identifiers at all, but if selected, should still appear in the matrix listing...
        mysql = "SELECT id,title,author_sort  \
                        FROM books"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()

        my_db.close()

        del book_type_dict
        book_type_dict = {}   # [type] = "NONE"     # just for books with no identifiers whatsoever

        for type,col in column_assignment_dict.iteritems():
            book_type_dict[type] = ""   # just for books with no identifiers whatsoever
        #END FOR

        for row in tmp_rows:
            id,title,author_sort = row
            if not str(id) in selected_books_set:
                continue
            if id in book_identifiers_dict:
                continue
            book_data_dict[id] = title,author_sort            # just for books with no identifiers whatsoever
            book_identifiers_dict[id] = book_type_dict     # just for books with no identifiers whatsoever
        #END FOR
        del tmp_rows

        if DEBUG: print("BookIdentifierMatrixDialog is now being created.")

        from calibre_plugins.job_spy.book_identifier_matrix_listing_dialog import BookIdentifierMatrixDialog
        self.bookidentifiermatrix_dialog =  BookIdentifierMatrixDialog(self.maingui,column_assignment_dict,final_column_number,book_data_dict,book_identifiers_dict)
        self.bookidentifiermatrix_dialog.show()

        del BookIdentifierMatrixDialog
        del book_identifiers_dict
        del column_assignment_dict
        del book_type_dict
        del selected_books_set
        del self.selected_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def autorun_add_null_values(self):
        wait_seconds = 5
        self.add_null_values(wait_seconds)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def add_null_values(self,wait_seconds=1):
        if prefs['GUI_TOOLS_ADD_NULL_VALUES_ACTIVE'] == unicode("False"):
            return

        if self.job_is_running:
            return

        self.guidb = self.gui.library_view.model().db
        path = self.guidb.library_path
        library_name = os.path.basename(path)
        #~ if DEBUG: print("current library name: ", library_name)

        active_libraries = prefs['GUI_TOOLS_ADD_NULL_VALUES_LIBRARIES']

        #~ if DEBUG: print("Add Null Values - active_libraries: ", active_libraries)

        active_libraries = active_libraries + "|"

        actionable_libraries = []

        tmp_list = active_libraries.split("|")
        for row in tmp_list:
            if not "QuarantineAndScrub" in row:   # this GUI Tool is invalid for use with Q&S Libraries...
                lib = row.strip()
                if lib > " ":
                    actionable_libraries.append(lib)
        #END FOR
        del tmp_list

        can_continue = False
        for lib in actionable_libraries:
            #~ if DEBUG: print("actionable_libraries: ", lib)
            if lib == "*":
                can_continue = True
                break
            elif lib == library_name:
                can_continue = True
                break
            else:
                pass
        #END FOR
        if can_continue:
            pass
        else:
            del actionable_libraries
            del path
            del library_name
            return

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        mysql = "SELECT id,id FROM books"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()

        my_db.close()

        if not tmp_rows:
           return error_dialog(self.gui, _('JS+ GUI Tool'),_('No books exist in the current Calibre Library.'), show=True)
        if len(tmp_rows) == 0:
           return error_dialog(self.gui, _('JS+ GUI Tool'),_('No books exist in the current Calibre Library.'), show=True)

        try:
            del self.selected_books_list
        except:
            pass

        self.selected_books_list = []

        for row in tmp_rows:
            id,dummy = row
            self.selected_books_list.append(id)
        #END FOR
        del tmp_rows

        #~ if DEBUG: print("number of books in library: ", str(len(self.selected_books_list)) )

        start_threaded_js_add_null_values(self, self.guidb, self.selected_books_list, wait_seconds, Dispatcher(self.js_finish_with_refresh_no_marking))

        self.job_is_running = True

        msg = 'JS+ Job was submitted and is processing all books in this library...'
        self.gui.status_bar.showMessage(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def js_finish_with_refresh_no_marking(self, job):

        self.job_is_running = False

        if job.failed:
            self.force_refresh_of_cache(self.selected_books_list)
            self.gui.job_exception(job, dialog_title=_('JS+ Job Failed...'))

        self.gui.status_bar.show_message(_('JS+ Add Nulls Job Has Finished'), 5000)

        self.force_refresh_of_cache(self.selected_books_list)

        del self.selected_books_list

        self.maingui.library_view.update()

        try:
            del job
        except:
            pass
    #---------------------------------------------------------------------------------------------------------------------------------------
    def copy_user_categories(self):
        try:
            self.copy_user_categories_dialog.close()
        except:
            pass
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        mysql = "SELECT key,val FROM preferences WHERE key = 'user_categories' "
        my_cursor.execute(mysql)
        user_cat_rows = my_cursor.fetchall()
        if not user_cat_rows:
            user_cat_rows = []
        if len(user_cat_rows) == 0:
            my_db.close()
            del user_cat_rows
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('You have no User Categories to Copy.'), show=True)
        #-------------------------------------
        mysql = "SELECT key,val FROM preferences WHERE key = 'field_metadata' "
        my_cursor.execute(mysql)
        field_metadata_rows = my_cursor.fetchall()
        my_db.close()
        if not field_metadata_rows:
            field_metadata_rows = []
        if len(field_metadata_rows) == 0:  # impossible for the Source Library (although unfortunately entirely possible for a just-created Target Library due to timing of Restarts of Calibre...)
            del user_cat_rows
            del field_metadata_rows
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('You have no Copyable User Categories until after Calibre is Restarted.'), show=True)
        #-------------------------------------
        source_field_metadata_dict = {}
        for row in field_metadata_rows:
            key,val = row    # key = 'field_metadata'
            if val:
                val = self.raw_to_object(val)    # JSON
                val = str(val)
                source_field_metadata_dict = ast.literal_eval(val)
                if isinstance(source_field_metadata_dict,dict):
                    break
                else:
                    source_field_metadata_dict = {}
                    if DEBUG: print("field metadata in table preferences are corrupt: ", val)
                    return error_dialog(self.gui, _('JS+ GUI Tool'),_('[1] Field Metadata for User Categories cannot be used.  Aborted.'), show=True)
        #END FOR
        del field_metadata_rows
        if len(source_field_metadata_dict) == 0:
            del source_field_metadata_dict
            del user_cat_rows
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('[2] Field Metadata for User Categories cannot be used.  Aborted.'), show=True)
        #-------------------------------------
        source_user_cat_dict = {}
        for row in user_cat_rows:
            key,val = row    # key = 'user_categories'
            if val:
                val = self.raw_to_object(val)    # JSON
                val = str(val)
                source_user_cat_dict = ast.literal_eval(val)
                if isinstance(source_user_cat_dict,dict):
                    break
                else:
                    source_user_cat_dict = {}
                    if DEBUG: print("user categories in table preferences are corrupt: ", val)
                    return error_dialog(self.gui, _('JS+ GUI Tool'),_('[3] Source User Categories cannot be used.  Aborted.'), show=True)
        #END FOR
        del user_cat_rows
        if len(source_user_cat_dict) == 0:
            del source_user_cat_dict
            del source_field_metadata_dict
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('You have no User Categories in this Library to Copy.'), show=True)
        #-------------------------------------
        #-------------------------------------
        self.get_all_libraries_list(include_current=False)
        #-------------------------------------
        from calibre_plugins.job_spy.copy_user_categories_dialog import CopyUserCategoriesDialog
        icon = get_icon('images/user_category.png')
        self.copy_user_categories_dialog = CopyUserCategoriesDialog(self.gui,icon,source_user_cat_dict,source_field_metadata_dict,self.target_library_list)
        self.copy_user_categories_dialog.show()
        #-------------------------------------
        #-------------------------------------
        del CopyUserCategoriesDialog
        del source_user_cat_dict
        del source_field_metadata_dict
        del self.target_library_list
        del my_db
        del my_cursor
        del is_valid
    #---------------------------------------------------------------------------------------------------------------------------------------
    def raw_to_object(self,raw):
        if not isinstance(raw, unicode):
            raw = raw.decode(preferred_encoding)
        try:
            val = json.loads(raw, object_hook=from_json)
        except Exception as e:
            if DEBUG: print("json.loads error: ", str(e))
            val = "ERROR"
        return val
    #---------------------------------------------------------------------------------------------------------------------------------------
    def copy_virtual_libraries_to_target(self):

        try:
            self.copy_virtual_libraries_dialog.close()
        except:
            pass
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        mysql = "SELECT key,val FROM preferences WHERE key = 'virtual_libraries' "
        my_cursor.execute(mysql)
        virtual_library_rows = my_cursor.fetchall()
        my_db.close()
        if not virtual_library_rows:
            virtual_library_rows = []
        if len(virtual_library_rows) == 0:
            del virtual_library_rows
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('You have no Virtual Libraries to Copy.'), show=True)
        #-------------------------------------
        #-------------------------------------
        source_virtual_library_dict = {}
        for row in virtual_library_rows:
            key,val = row    # key = name of VL, and val = search terms defining the VL '
            if DEBUG: print("virtual_library_rows: ", str(key),">>>", str(val))
            if val:
                val = self.raw_to_object(val)    # JSON
                val = str(val)
                source_virtual_library_dict = ast.literal_eval(val)
                if isinstance(source_virtual_library_dict,dict):
                    break
                else:
                    source_virtual_library_dict = {}
                    if DEBUG: print("virtual libraries in table preferences are corrupt: ", val)
                    return error_dialog(self.gui, _('JS+ GUI Tool'),_('[3] Source Virtual Libraries cannot be used.  Aborted.'), show=True)
        #END FOR
        del virtual_library_rows
        if len(source_virtual_library_dict) == 0:
            del source_virtual_library_dict
            return error_dialog(self.gui, _('JS+ GUI Tool'),_('You have no Virtual Libraries in this Library to Copy.'), show=True)
        #-------------------------------------
        #-------------------------------------
        self.get_all_libraries_list(include_current=False)
        #-------------------------------------
        from calibre_plugins.job_spy.copy_virtual_libraries_dialog import CopyVirtualLibrariesDialog
        icon = get_icon('images/search.png')
        self.copy_virtual_libraries_dialog = CopyVirtualLibrariesDialog(self.gui,icon,source_virtual_library_dict,self.target_library_list)
        self.copy_virtual_libraries_dialog.show()
        #-------------------------------------
        #-------------------------------------
        del CopyVirtualLibrariesDialog
        del source_virtual_library_dict
        del self.target_library_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_author_sort_method_by_library(self):
        #-------------------------------------
        #~ job_spy_author_sort_copy_method = {'CalibreJobSpyTest3': 'invert', 'CalibreJobSpyTest2': 'copy', 'CalibreJobSpyTest1': 'nocomma', 'CalibreJobSpyTest4': 'comma'}
        #-------------------------------------
        from calibre.utils.config_base import tweaks
        if not 'job_spy_author_sort_copy_method' in tweaks:
            del tweaks
            msg = "Error in the Tweak 'job_spy_author_sort_copy_method' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_author_sort_copy_method',msg).show()
        if not 'author_sort_copy_method' in tweaks:
            return
        #-------------------------------------
        orig_method = tweaks['author_sort_copy_method']
        if DEBUG: print("author_sort_copy_method >>> default tweaks.py method is: ", orig_method)
        #-------------------------------------
        jsdict = tweaks['job_spy_author_sort_copy_method']
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak 'job_spy_author_sort_copy_method' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_author_sort_copy_method',msg).show()
                return
        #-------------------------------------
        valid_methods_list = ['comma','copy','invert','nocomma']
        #-------------------------------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                method = jsdict[libname]
                if method in valid_methods_list:
                    if method <> orig_method:
                        tweaks['author_sort_copy_method'] = method  # in-memory only; this will not be written to tweaks.py.  The user must use Preferences > Tweaks properly to make permanent changes.
                        if DEBUG: print("author_sort_copy_method changed FROM: ",orig_method, " TO: ", method)
                    else:
                        pass
                else:
                    if DEBUG: print("apply_author_sort_method_by_library:   new method is NOT valid:   ", str(method))
            else:
                if DEBUG: print("apply_author_sort_method_by_library:   libname is NOT tweaked; nothing changed:   ", libname)
        else:
            if DEBUG: print("ERROR in os.path.split(path): ", path, " head: ", str(head), " libname: ", str(libname))
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_read_file_metadata_pref_by_library(self):
        #-------------------------------------
        #~ job_spy_add_books_read_metadata_from_file_contents_not_name = {'CalibreJobSpyTest3': 'True', 'CalibreJobSpyTest2': 'False', 'CalibreJobSpyTest1': 'True', 'CalibreJobSpyTest4': 'False'}
        #-------------------------------------
        from calibre.utils.config_base import tweaks
        if not 'job_spy_add_books_read_metadata_from_file_contents_not_name' in tweaks:
            del tweaks
            msg = "Error in the Tweak 'job_spy_add_books_read_metadata_from_file_contents_not_name' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_add_books_read_metadata_from_file_contents_not_name',msg).show()
        #-------------------------------------
        #-------------------------------------
        jsdict = tweaks['job_spy_add_books_read_metadata_from_file_contents_not_name']
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak 'job_spy_add_books_read_metadata_from_file_contents_not_name' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_add_books_read_metadata_from_file_contents_not_name',msg).show()
                return
        #-------------------------------------
        #-------------------------------------
        option_key = str("read_file_metadata")   # global.py does NOT default to unicode; only specific values are specified as unicode via a manual u' prefix.
        from calibre.utils.config import prefs
        orig_option = prefs.get(option_key)   # orig_option is stored in global.py as a Boolean
        orig_option = str(orig_option)
        if DEBUG: print("orig_option = prefs.get[option_key]: ", orig_option)
        #-------------------------------------
        #-------------------------------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if DEBUG: print("Tweak Library Name: ", libname)
            if libname in jsdict:
                option = jsdict[libname]
            else:
                option = str("True")  # Defaults to True if a Library was not specified in the Tweak...
            option = str(option)
            if option == str("True") or option == str("False"):
                if option == str("True"):
                    option = True
                else:
                    option = False
                try:
                    prefs.set(option_key, option)  # this writes to global.py
                    if DEBUG: print("'read_file_metadata' global.py file prefs.set  FROM: ", orig_option, " TO: ", option)
                except Exception as e:
                    if DEBUG: print("[1] setting option caused Exception: ", str(e))
                    return
                try:
                    prefs[option_key] = option  # in-memory only
                    current_option = prefs[option_key]
                    if DEBUG: print("'read_file_metadata' global prefs[option_key] value changed FROM: ", str(orig_option), " TO: ", str(current_option))
                except Exception as e:
                    if DEBUG: print("[2] setting option caused Exception: ", str(e))
                    return
                try:
                    if self.maingui._spare_pool is not None:
                        if DEBUG: print("executing:  self.maingui._spare_pool.shutdown(wait_time=60.0)")
                        self.maingui._spare_pool.shutdown(wait_time=60.0)  #necessary since otherwise the first books added will use the last Library's Tweak due to the way 'common_data' in Pool.set_common_data() is handled.
                        self.maingui._spare_pool = None        # forces a new pool to get created...
                        if DEBUG: print("Successful; forced the upcoming new pool to reload global preference 'read_file_metadata' just tweaked here per-Library...")
                    return
                except Exception as e:
                    self.maingui._spare_pool = None        # forces a new pool to get created...
                    if DEBUG: print("[3] setting option caused Exception: ", str(e))
                    return
            else:
                if DEBUG: print("apply_read_file_metadata_pref_by_library:   new option is NOT valid (True or False):   ", str(option))
                return
        else:
            if DEBUG: print("ERROR in os.path.split(path): ", path, " head: ", str(head), " libname: ", str(libname))
            return
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_auto_add_directory_by_library(self,source="initialization_complete"):
        # IMPORTANT: the auto_adder is created in gui2.ui AFTER all GUI plugins have been loaded, so at Calibre Startup there will be NO self.maingui.auto_adder available here (yet), so some things may only be done LATER than at initialization_complete...
        if source == "initialization_complete":
            is_startup = True
        else:
            is_startup = False

        from calibre.utils.config_base import tweaks
        if not 'job_spy_auto_add_directory' in tweaks:
            del tweaks
            msg = "Error in the Tweak 'job_spy_auto_add_directory' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_auto_add_directory',msg).show()

        global_path = gprefs['auto_add_path']
        if not global_path:
            return
        global_path = self.standardize_path_format(global_path)
        if not os.path.isdir(global_path):
            return

        if is_startup:
            self.original_global_auto_add_path = global_path   # just validated as a good directory and can be trusted...
            if DEBUG: print("self.original_global_auto_add_path: ",  self.original_global_auto_add_path)
        #-------------------------------------
        # JS can be customized without restarting, so the user might have just changed the default directory to another value and then immediately switched libraries.
        self.default_tweak_auto_add_directory_path = prefs['GUI_TOOLS_DEFAULT_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY']
        self.default_tweak_auto_add_directory_path = self.standardize_path_format(self.default_tweak_auto_add_directory_path)
        #~ self.default_tweak_auto_add_directory_path = "xxxx"  #testing;force an error
        if not os.path.isdir(self.default_tweak_auto_add_directory_path):   #not frequent, since config.py validates before saving prefs, but it could have just been renamed or deleted.
            if DEBUG: print("ERROR: Invalid Directory: self.default_tweak_auto_add_directory_path: ",  self.default_tweak_auto_add_directory_path)
            self.default_tweak_auto_add_directory_path = self.original_global_auto_add_path
            prefs['GUI_TOOLS_DEFAULT_TWEAK_AUTO_ADD_DIRECTORY_BY_LIBRARY'] = self.original_global_auto_add_path
            prefs
            msg = "Error in the Tweak to Auto-Adding: your Default Directory by Library was invalid.<br><br>You should Customize Job Spy preferences for this GUI Tool before proceeding."
            info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_auto_add_directory by Library',msg).show()      #non-modal so does not stop Calibre startup or library switching
            if DEBUG: print(msg)
            return
        #-------------------------------------
        #-------------------------------------
        jsdict = tweaks['job_spy_auto_add_directory']
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak to Auto-Adding: Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_auto_add_directory by Library',msg).show()     #non-modal so does not stop Calibre startup or library switching
                return
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                path = jsdict[libname]
                path = self.standardize_path_format(path)
                if os.path.isdir(path):
                    pass
                else:
                    msg = "Error in the Tweak to Auto-Adding: Your Preferences > Tweaks > Plugin Tweaks value for this specific Library is invalid.  <b>The specified directory does not exist.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                    info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_auto_add_directory by Library',msg).show()     #non-modal so does not stop Calibre startup or library switching
                    return
            else:
                path = self.default_tweak_auto_add_directory_path
        else:
            path = self.default_tweak_auto_add_directory_path

        ospath = path.replace("/",os.sep)   # gui.json stores the global default for windows like:    "auto_add_path": "S:\\Calibre\\ToBeImported",

        if DEBUG: print("new os path to be watched by auto_adder: ",ospath)

        #~ note:        per src/calibre/gui2/ui.py     self.auto_adder = AutoAdder(gprefs['auto_add_path'], self)    where in gui.json:   "auto_add_path": "S:\\Calibre\\ToBeImported",

        if not is_startup:
            dirlist = self.maingui.auto_adder.watcher.directories()
            if DEBUG:
                for dir in dirlist:
                    if DEBUG: print("=========[A] QFileSystemWatcher:  dir in dirlist: ", dir)
                #END FOR

        gprefs['auto_add_path'] = ospath   # which means that the gui.json value will be updated at shutdown with this preference...unless another library is changed-to before then...

        if not is_startup:
            if not ospath in dirlist:
                self.maingui.auto_adder.watcher.addPath(ospath)
            self.remove_old_auto_add_watcher_directories(ospath)
            if DEBUG: print("old auto_adder.worker: ", str(self.maingui.auto_adder.worker))
            self.maingui.auto_adder.worker.keep_running = False
            self.maingui.auto_adder.worker._Thread__stop()
            self.maingui.auto_adder.worker._Thread__delete()
            from calibre.gui2.auto_add import Worker
            self.maingui.auto_adder.worker = Worker(ospath, self.maingui.auto_adder.metadata_read.emit)
            if DEBUG: print("new auto_adder.worker: ", str(self.maingui.auto_adder.worker))
            self.maingui.auto_adder.worker.keep_running = True
            self.maingui.auto_adder.dir_changed()
            self.maingui.auto_adder.worker.auto_add()

        if DEBUG:
            if not is_startup:
                dirlist = self.maingui.auto_adder.watcher.directories()
                for dir in dirlist:
                    if DEBUG: print("========[B] QFileSystemWatcher:  dir in dirlist: ", dir)

        if DEBUG:
            if is_startup:
                print("[Calibre Startup] The per-Library tweak for the Current Library for auto_add_path has been changed to:  ", ospath)
            else:
                print("[Calibre Library Switched] The per-Library tweak for the Current Library for auto_add_path has been changed to:  ", ospath)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def remove_old_auto_add_watcher_directories(self,ospath):
        try:
            dirlist = self.maingui.auto_adder.watcher.directories()
            for dir in dirlist:
                if dir <> ospath:  #keep the current tweak auto-add dir
                    self.maingui.auto_adder.watcher.removePath(dir)   #although it was lots of fun, having more than a single path being watched at a single moment is not desirable.
                    if DEBUG: print("dir was removed: ", dir)
                else:
                    if DEBUG: print("dir NOT removed: ", dir)
            #END FOR
        except Exception as e:
            if DEBUG: print("Exception for QFileSystemWatcher in remove_auto_add_watcher_directories: ", str(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def standardize_path_format(self,path):
        path = path.replace('"','')  #no double quotes as used in windows
        path = path.strip()
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        if path.endswith("/"):
            path = path[0:-1]
            path = path.strip()
        return path
    #---------------------------------------------------------------------------------------------------------------------------------------
    def convert_string_to_dict(self,sdict):
        sdict = str(sdict)
        try:
            d = ast.literal_eval(sdict)
            del sdict
            if not isinstance(d,dict):
                if DEBUG: print("[1] tweaks['job_spy_XXX'] is not formatted properly as a valid dictionary.")
                return d,False
            else:
               return d,True
        except:
            if DEBUG: print("[2] tweaks['job_spy_XXX'] is not formatted properly as a valid dictionary.")
            return d,False
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def display_polish_books_job_log_fails(self):

        jmgr = self.maingui.job_manager

        done_jobs_list = [j for j in jmgr.jobs if (j.is_finished and not j.failed)]

        n_done_jobs = len(done_jobs_list)

        if n_done_jobs == 0:
            del done_jobs_list
            del jmgr
            del n_done_jobs
            return

        failed_fonts_set = set([])
        failed_titles_set = set([])
        found_failure = False

        for j in done_jobs_list:
            desc = j.description
            if "Polish" in desc:
                if j.log_path:
                    f = open(j.log_path, 'rb')
                    found_failure = False
                    for line in f:
                        line = str(line)
                        line =  line.decode('utf-8', 'replace')
                        if "Failed to find fonts for family" in line:
                            found_failure = True
                            line = line.replace("Failed to find fonts for family:","")
                            line = line.replace(", not embedding","")
                            failed_fonts_set.add(line.strip())
                    #END FOR
                    f.close()
                    del f
                    if found_failure:
                        n = desc.find("(")
                        if n < 1:
                            continue
                        desc = desc[n+1:-1]
                        failed_titles_set.add(desc)
        #END FOR

        titles_were_limited = False  #the search function will blow out due to python recursion errors if the search string is too long...
        NLIMIT = 199
        n = len(failed_titles_set)
        if n > 0:
            ssearch = ""
            n_limit = 0
            for title in failed_titles_set:
                ssearch = ssearch + 'title:"XXX" OR '
                ssearch = ssearch.replace("XXX",title)
                n_limit = n_limit + 1
                if n_limit > NLIMIT:
                    titles_were_limited = True
                    break
            #END FOR
            ssearch = ssearch[0:-3]
            ssearch = ssearch.strip()
            self.gui.search.clear()
            self.gui.search.set_search_string(ssearch)
            del ssearch
            del n_limit

        #~ if DEBUG: titles_were_limited = True

        msg = "Total Failed Titles: " + str(n) + "<br><br>"
        if titles_were_limited:
            msg = msg + "Search criteria limited to first 200 titles to avoid potential Calibre search errors.<br><br>"

        failed_fonts_list = list(failed_fonts_set)
        failed_fonts_list.sort()

        n = len(failed_fonts_list)
        if n > 1:
            msg = msg + "Failed to find fonts for families: <br><br>"
        else:
            msg = msg + "Failed to find fonts for family: <br><br>"

        for failure in failed_fonts_list:
            msg = msg + failure + "<br>"
        #END FOR

        if len(failed_fonts_set) > 0:
            info_dialog(self.gui, 'JS+ GUI Tool: Polishing-Missing Fonts',msg).show()

        try:
            del done_jobs_list
            del jmgr
            del n_done_jobs
            del desc
            del failed_fonts_list
            del failed_fonts_set
            del failed_titles_set
            del msg
            del found_failure
            del NLIMIT
        except:
            pass
    #---------------------------------------------------------------------------------------------------------------------------------------
    def show_formatspy_dialog(self):
        try:
            self.formatspy_dialog.close()
        except:
            pass

        from calibre_plugins.job_spy.formatspy_dialog import FormatSpyDialog
        self.formatspy_dialog = FormatSpyDialog(self.maingui,self.maingui)
        self.formatspy_dialog.show()
        del FormatSpyDialog
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_author_sort_for_complex_surnames_menu(self):
        self.update_author_sort_for_complex_surnames(True,False)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_author_sort_for_complex_surnames(self,confirm,ids):

        if not isinstance(ids,list):
            if confirm:
                self.selected_books_list = self.get_selected_books()  # ids are a string here...
                tids = self.selected_books_list
                if len(tids) == 0:
                    msg = "No Books Were Selected."
                    return error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)
                else:
                    del ids
                    ids = []
                    for id in tids:
                        id = int(id)
                        ids.append(id)
                    if DEBUG: print("number of manually selected books for complex surnames: ", str(len(tids)))

        self.gui.library_view.model().refresh_ids(ids)
        self.gui.tags_view.recount()

        from calibre.utils.config_base import tweaks
        #-------------------------------------
        self.author_sort_copy_method = tweaks['author_sort_copy_method']
        if self.author_sort_copy_method == "copy":          #~ copy  : copy author to author_sort without modification
            msg = "Error: The current 'author_sort_copy_method' standard Calibre tweak is 'copy'.  Nothing needs to be done by this function.  Terminated."
            if confirm:
                return error_dialog(self.gui, _('JS+ GUI Tool'),_(msg), show=True)
            else:
                if DEBUG: print(msg)
                return
        #-------------------------------------
        if confirm:
            msg = "This Tool only has value if you are using a 'author_sort_copy_method' of 'invert', 'comma' or 'nocomma'.  "
            msg = msg + "<br><br>Methods:<br>[*] invert: use 'fn ln' -> 'ln, fn' "
            msg = msg + "<br>[*] comma : use 'copy' if there is a ',' in the name, otherwise use 'invert'.  'copy' means copy the author to author_sort without modification "
            msg = msg + "<br>[*] nocomma : 'fn ln' -> 'ln fn'(without the comma) "
            msg = msg + "<br><br>The current Author Sort Copy Method in Tweaks is:   " + self.author_sort_copy_method
            msg = msg + "<br><br>Authors themselves have an Author Sort, but each individual book also has a 'combined' Author Sort for all of its Authors. Different Calibre tools may update different locations for 'Author Sort'."
            msg = msg + "<br><br>To reset each Author's individal Author Sort to 'Standard Calibre' values, simply use 'Manage Author' to 'Recalculate All Author Sort Values'.  Then, use 'Bulk Edit Metadata-Set Author Sort' to update each book's individual combined Author Sort to the newly recalculated standard values. "
            msg = msg + "<br><br>Do you wish to continue?"
            if question_dialog(self.gui, "JS+ GUI Tool: Update Author Sort for Complex Surnames", msg):
                pass
            else:
                return
        #-------------------------------------
        self.complex_surname_dict = {}
        self.original_surname_dict = {}
        self.original_to_complex_surname_dict = {}
        #-------------------------------------
        self.surname_ignore_set = set([])
        s = prefs['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_IGNORE']
        s_split = s.split("|")
        for row in s_split:
            row = row.strip()
            self.surname_ignore_set.add(row)
        #END FOR
        del s
        del row
        del s_split
        #-------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        #-------------------------------------
        my_db.createscalarfunction("MYAUTHORSORT",self.myauthorsortregexp)
        #-------------------------------------
        self.create_temp_book_ids_table(my_db,my_cursor,ids)
        #-------------------------------------
        try:
            my_cursor.execute("begin")
            mysql = "UPDATE authors SET sort = MYAUTHORSORT(name,sort) \
                          WHERE id IN (SELECT author FROM books_authors_link WHERE author = authors.id AND book IN (SELECT book FROM _js_book_ids_temp) )"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print(str(e))
            try:
                my_cursor.execute("commit")
            except:
                pass
        #-------------------------------------
        # All Single Authors (and the sole Author is in the Path)
        #-------------------------------------
        try:
            my_cursor.execute("begin")
            mysql = "UPDATE books SET author_sort = ? WHERE path LIKE ?  AND author_sort NOT LIKE '%&%' \
                           AND id IN (SELECT book FROM _js_book_ids_temp)"  # only single author scenarios
            for name,newsort in self.complex_surname_dict.iteritems():    # only has names that matched the REGEX in MYAUTHORSORT
                path = name + "/%"
                my_cursor.execute(mysql,(newsort,path))
                if DEBUG: print("[1] books: ", newsort, ">>>>", path)
            #END FOR
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print(str(e))
            try:
                my_cursor.execute("commit")
            except:
                pass
        #-------------------------------------
        for name,oldsort in self.original_surname_dict.iteritems():
            if name in self.complex_surname_dict:        # only has names that matched the REGEX in MYAUTHORSORT
                newsort = self.complex_surname_dict[name]
                self.original_to_complex_surname_dict[oldsort] = newsort
            else:
                if DEBUG: print("Error: name not in self.original_surname_dict: ", name, "    ", oldsort)
        #END FOR
        #-------------------------------------
        # All Multiple Authors
        #-------------------------------------
        try:
            mysql = "UPDATE books SET author_sort = REPLACE(author_sort,?,?) WHERE author_sort LIKE '%&%' \
                           AND id IN (SELECT book FROM _js_book_ids_temp)"  # only multiple author scenarios
            for oldsort,newsort in self.original_to_complex_surname_dict.iteritems():
                my_cursor.execute("begin")
                my_cursor.execute(mysql,(oldsort,newsort))
                my_cursor.execute("commit")
                if DEBUG: print("[2] books: ", oldsort, ">>>>", newsort)
            #END FOR
        except Exception as e:
            if DEBUG: print(str(e))
        #-------------------------------------
        tmp_dict = {}  #id = author_sort
        mysql = "SELECT id,author_sort FROM books WHERE id IN (SELECT book FROM _js_book_ids_temp)"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id,author_sort = row
            tmp_dict[id] = author_sort
        #END FOR
        #-------------------------------------
        my_db.close()
        #-------------------------------------
        self.gui.library_view.model().refresh_ids(ids)
        #-------------------------------------
        #~ This next is so that the metadata.db = cache = library_view without having to restart...
        payload = []
        id_map = {}
        for id in ids:
            id = int(id)
            payload.append(id)
            mi = Metadata(_('Unknown'))
            mi.author_sort = tmp_dict[id]
            id_map[id] = mi
        #END FOR

        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=self.apply_complex_surname_refresh_ids_callback)

        try:
            del self.complex_surname_dict
            del self.original_surname_dict
            del self.original_to_complex_surname_dict
            del self.surname_ignore_set
            del tmp_dict
            #~ del ids
        except:
            pass
    #---------------------------------------------------------------------------------------------------------------------------------------
    def myauthorsortregexp(self,name,sort):
        #~ self.author_sort_copy_method
        #~ invert: use "fn ln" -> "ln, fn"
        #~ comma : use 'copy' if there is a ',' in the name, otherwise use 'invert'
        #~ nocomma : "fn ln" -> "ln fn" (without the comma)

        expr = prefs['GUI_TOOLS_UPDATE_AUTHOR_SORT_FOR_COMPLEX_SURNAMES_REGEXP']
        try:
            p = re.compile(expr,  re.IGNORECASE|re.DOTALL|re.MULTILINE)
            match = p.search(name)
            if not match:
                return sort
            else:
                lastnames = match.group()
                lastnames = lastnames.strip()
                s_split = lastnames.split(" ")
                for n in s_split:
                    n = n.strip()
                    if n in self.surname_ignore_set:
                        if DEBUG: print("Middle Name Ignored: ", n, "  so nothing done.")
                        return sort
                #END FOR
                if DEBUG: print("Before: ", name,"       ", sort)
                self.original_surname_dict[name] = sort
                firstnames = name.replace(lastnames,"")
                firstnames = firstnames.strip()
                if self.author_sort_copy_method == "invert":
                    sort = lastnames + ", " + firstnames
                elif self.author_sort_copy_method == "comma":
                    if "," in name:
                        sort = name
                    else:
                        sort = lastnames + ", " + firstnames
                elif self.author_sort_copy_method == "nocomma":
                    sort = lastnames + " " + firstnames
                else:
                    return sort
                sort = sort.strip()
                if DEBUG: print("After: ", name,"       ", sort)
                self.complex_surname_dict[name] = sort
                return sort
        except Exception as e:
            if DEBUG: print(" myauthorsortregexp exception: ", str(e))
            return sort
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_complex_surname_refresh_ids_callback(self,payload):
        if DEBUG: print("Payload count for complex surnames callback: ", str(len(payload)))
        self.gui.library_view.model().refresh_ids(payload)
        self.gui.tags_view.recount()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_temp_book_ids_table(self,my_db,my_cursor,ids):

        mysql = "CREATE TEMP TABLE _js_book_ids_temp \
                                (id INTEGER PRIMARY KEY AUTOINCREMENT, \
                                book INTEGER NOT NULL, \
                                UNIQUE(book) );"

        my_cursor.execute(mysql)

        mysql = "INSERT OR IGNORE INTO _js_book_ids_temp (id,book) VALUES (null,?) "
        my_cursor.execute("begin")
        for id in ids:
            my_cursor.execute(mysql,([id]))
            #~ if DEBUG: print("book id added to _js_book_ids_temp: ", str(id))
        #END FOR
        my_cursor.execute("commit")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def manually_invoke_quality_fixes(self):
        self.apply_quality_fixes('manually')
    #---------------------------------------------------------------------------------------------------------------------------------------
    def initialize_quality_fixes(self):
        QTimer.singleShot(500, self.activate_quality_fixes)                 # milliseconds
    #---------------------------------------------------------------------------------------------------------------------------------------
    def activate_quality_fixes(self):
        try:
            from calibre_plugins.job_spy.decorated_functions import decorated_do_add
            self.maingui.auto_adder.do_add = decorated_do_add(self.maingui.auto_adder.do_add,self.apply_quality_fixes)
            fmt = "%Y-%m-%d %H:%M:%S     "
            self.quality_fixes_checkpoint_time = str(time.strftime(fmt,time.gmtime(time.time())))   #~ 2018-03-10 13:06:26
            self.quality_fixes_checkpoint_time = self.quality_fixes_checkpoint_time[0:19]
            if DEBUG: print("Job Spy: Quality Fixes have been activated as of: ",self.quality_fixes_checkpoint_time)
            self.quality_fix_original_titles_dict = {}  # id = original title
        except Exception as e:
            QTimer.singleShot(10, self.activate_quality_fixes)                 # milliseconds
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fixes(self,source='auto_adder'):

        if source == "auto_adder":
            self.apply_quality_fixes_source_is_auto_adder = True
        else:
            self.apply_quality_fixes_source_is_auto_adder = False

        if prefs['GUI_TOOLS_QUALITY_FIXES_ACTIVATE'] == unicode("False"):  # user must have just updated preferences to deactivate it just before an actual auto-add action...
            return

        self.guidb = self.gui.library_view.model().db
        path = self.guidb.library_path
        path = path.replace(os.sep, '/')
        current_libname = self.decompose_library_path(path)

        libs = prefs['GUI_TOOLS_QUALITY_FIXES_ACTIVATE_LIBRARIES']
        libs = libs + "|"
        libs_list = libs.split("|")

        if "*" in libs_list:
            if DEBUG: print("wildcard specified in job spy quality fix active library names, which includes: ", current_libname)
        else:
            if not current_libname in libs_list:
                if DEBUG: print("current library not specified in job spy quality fix active library names...", current_libname)
                return
            else:
                if DEBUG: print("job spy quality fix active library names includes: ", current_libname)

        self.quality_fixes_checkpoint_time_previous = self.quality_fixes_checkpoint_time
        fmt = "%Y-%m-%d %H:%M:%S     "
        self.quality_fixes_checkpoint_time = str(time.strftime(fmt,time.gmtime(time.time())))   #~ 2018-03-10 13:06:26
        self.quality_fixes_checkpoint_time = self.quality_fixes_checkpoint_time[0:19]

        if not self.apply_quality_fixes_source_is_auto_adder:
            tids = self.get_selected_books()
            if len(tids) == 0:
                 return error_dialog(self.gui, _('JS+ GUI Tool'),_('No Books Were Selected.'), show=True)
            ids = []
            for id in tids:
                id = int(id)
                ids.append(id)
            #END FOR
            ids.sort()
            del tids
            self.quality_fixes_checkpoint_time =  "0000-01-01 00:00:00"   #not used for manual fixes
            self.quality_fixes_checkpoint_time_previous = self.quality_fixes_checkpoint_time
        else:
            tids = self.retrieve_recently_added_books()
            if len(tids) == 0:
                return
            ids = []
            for id in tids:
                if not id in self.qf_ids_previous:
                    ids.append(id)
                    self.qf_ids_previous.append(id)
                else:
                    if DEBUG: print("already fixed book id: ", str(id), " from a previous auto-add event using the identical checkpoint time...")
            #END FOR
            del tids

        if len(ids) == 0:
            return

        self.quality_fix_current_ids = ids

        if not self.apply_quality_fixes_source_is_auto_adder:
            msg = "Job Spy is fixing " + str(len(ids)) + " manually selected books; wait..."
        else:
            msg = "Job Spy is fixing " + str(len(ids)) + " newly auto-added books; wait..."
        self.gui.status_bar.showMessage(msg)
        if DEBUG: print(msg)

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES'] == unicode("True"):
            self.update_original_title_custom_column(ids)

        if prefs['GUI_TOOLS_QUALITY_FIXES_CLEAR_PUBLISHERS'] == unicode("True"):
            self.apply_quality_fix_publishers(ids)

        if prefs['GUI_TOOLS_QUALITY_FIXES_CLEAR_TAGS'] == unicode("True"):
            self.apply_quality_fix_tags(ids)

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES'] == unicode("True"):
            self.apply_quality_fixes_scrub_titles(ids)

        if prefs['GUI_TOOLS_QUALITY_FIXES_TITLECASE_TITLES'] == unicode("True"):
            self.apply_quality_fix_titlecase_titles(ids)

        if prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_TITLE_SORTS'] == unicode("True"):
            my_db,my_cursor,is_valid = self.apsw_connect_to_library()
            if is_valid:
                self.apply_quality_fix_update_title_sorts(my_db,my_cursor,ids)
                my_db.close()
            else:
                if DEBUG: print("JS+ APSW connection error for updating title sorts...")

        also_do_author_sorts = False

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS'] == unicode("True"):
            self.update_original_authors_custom_column(ids)

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS'] == unicode("True"):  #part 1 of 2
            self.remove_title_from_authors(ids)
            also_do_author_sorts = True

        if prefs['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_FNLN'] == unicode("True"):
            self.apply_quality_fix_swap_author_names(ids,"FNLN")
            also_do_author_sorts = True
        elif prefs['GUI_TOOLS_QUALITY_FIXES_CHANGE_AUTHORS_LNFN'] == unicode("True"):
            self.apply_quality_fix_swap_author_names(ids,"LNFN")
            also_do_author_sorts = True

        if prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_INITIALS'] == unicode("True"):
            self.apply_quality_fix_update_author_initials(ids)
            also_do_author_sorts = True

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS'] == unicode("True"):  #part 2 of 2
            self.remove_title_from_authors(ids)
            self.remove_series_from_authors(ids)
            self.swap_author_and_title_if_needed(ids)
            also_do_author_sorts = True

        if also_do_author_sorts or prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_SORTS'] == unicode("True"):
            my_db,my_cursor,is_valid = self.apsw_connect_to_library()
            if is_valid:
                self.apply_quality_fix_update_author_sorts(my_db,my_cursor,ids)
                my_db.close()
            else:
                if DEBUG: print("JS+ APSW connection error for updating author sorts...")

        if prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_PSEUDONYMS'] == unicode("True"):
            self.update_author_pseudonyms(ids,source='auto')

        if prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_ISBN'] == unicode("True"):
            msg = "JS is scrubbing the ISBN of every book in the current Library that needs it; wait..."
            self.gui.status_bar.showMessage(msg)
            self.scrub_isbn()

        self.quality_fix_current_ids = ids

        self.apply_quality_fix_refresh_ids()
        self.gui.tags_view.recount()

        QApplication.instance().processEvents()

        if len(ids) < 10:
            msg = "Job Spy has fixed the quality of " + str(len(ids)) + " book(s), but refreshing the displayed metadata may take a second"
        elif len(ids) < 50:
            msg = "Job Spy has fixed the quality of " + str(len(ids)) + " books, but refreshing their displayed metadata may take a few seconds"
        elif len(ids) < 200:
            msg = "Job Spy has fixed the quality of " + str(len(ids)) + " books, but refreshing their displayed metadata may take half a minute"
        elif len(ids) < 500:
            msg = "Job Spy has fixed the quality of " + str(len(ids)) + " books, but refreshing their displayed metadata may take a minute or so"
        else:
            msg = "Job Spy has fixed the quality of " + str(len(ids)) + " books, but refreshing their displayed metadata may take a minute or longer"
        self.gui.status_bar.showMessage(msg)
        if DEBUG: print(msg)

        self.apply_quality_fix_refresh_ids()
        self.gui.tags_view.recount()

        for id in ids:
            if id in self.quality_fix_original_titles_dict:
                del self.quality_fix_original_titles_dict[id]
        #END FOR

        run_jobs = False

        if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_EXTRACT_ISBN_JOB'] == unicode("True"):
            run_jobs = True

        if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_POLISH_BOOKS_JOB'] == unicode("True"):
            run_jobs = True

        if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_RESIZE_COVER_PLUGIN'] == unicode("True"):
            run_jobs = True

        if run_jobs:
            self.gui.current_db.set_marked_ids(ids)
            self.gui.search.set_search_string('marked:true')
            self.gui.esc()
            self.gui.library_view.select_rows(ids)
            if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_EXTRACT_ISBN_JOB'] == unicode("True"):
                try:
                    extract_isbn_action = self.maingui.iactions['Extract ISBN']
                    QTimer.singleShot(0, extract_isbn_action.scan_for_isbns())
                except:
                    pass
            if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_POLISH_BOOKS_JOB'] == unicode("True"):
                try:
                    polish_books_action = self.maingui.iactions['Polish Books']
                    QTimer.singleShot(0, polish_books_action.polish_books())
                except:
                    pass
            if prefs['GUI_TOOLS_QUALITY_FIXES_AUTO_RUN_RESIZE_COVER_PLUGIN'] == unicode("True"):
                try:
                    resize_cover_action = self.maingui.iactions['Resize Cover']
                    resize_cover_action.resize_covers(None,None)
                    msg = "Resize Cover Plug-in Executed Using Customized ToolBar Defaults"
                    #~ self.gui.status_bar.showMessage(msg)
                    if DEBUG: print(msg)
                except Exception as e:
                    if DEBUG: print("Exception executing Resize Covers plug-in: ", str(e))
                    msg = "Error executing Resize Covers plug-in " + str(e)
                    self.gui.status_bar.showMessage(msg)


        QApplication.instance().processEvents()


        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_publishers(self,ids):
        for id in ids:
            self.guidb.set_publisher(id, None, notify=False)
            #~ if DEBUG: print("publisher cleared for book id: ", str(id))
        #END FOR
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_tags(self,ids):
        for id in ids:
            self.guidb.set_tags(id, None, notify=False)
            #~ if DEBUG: print("tags cleared for book id: ", str(id))
        #END FOR
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fixes_scrub_titles(self,ids):
        self.apply_quality_fix_scrub_titles_ignore_book(ids)
        self.apply_quality_fix_titles_regex_delete(ids)
        self.apply_quality_fix_titles_series_regex_control(ids)
        self.apply_quality_fix_titles_residual_artifacts_final(ids)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_scrub_titles_ignore_book(self,ids):
        apply_quality_fix_scrub_titles_ignore_books_list = []

        if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_IGNORE_BOOK'] =  prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_IGNORE_BOOK']
            prefs

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_IGNORE_BOOK']
        for id in ids:
            title = self.guidb.title(id, index_is_id=True)
            if not title:
                continue
            try:
                p = re.compile(r,re.IGNORECASE|re.MULTILINE|re.DOTALL)
            except Exception as e:
                if DEBUG: print("RE COMPILE ERROR IN apply_quality_fix_scrub_titles_ignore_book for book id:", str(id), "       ", str(e))
                continue
            try:
                match_r = p.search(title)
                if not match_r:
                    continue
                else:
                    apply_quality_fix_scrub_titles_ignore_books_list.append(id)
            except Exception as e:
                if DEBUG: print("RE p.search(title) Error in apply_quality_fix_scrub_titles_ignore_book for book id:", str(id), "       ", str(e), "  title: ", title)
        #END FOR
        self.apply_quality_fix_scrub_titles_ignore_books_set = set(apply_quality_fix_scrub_titles_ignore_books_list)  #*much* faster lookups
        del apply_quality_fix_scrub_titles_ignore_books_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_regex_delete(self,ids):

        if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE'] = prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE']
            prefs

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_REGEX_DELETE']

        for id in ids:
            if id in self.apply_quality_fix_scrub_titles_ignore_books_set:
                continue
            newtitle = self.apply_quality_fix_titles_words_delete_apply_regex(id,r)
            self.guidb.set_title(id, newtitle, notify=True)
        #END FOR
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_words_delete_apply_regex(self,id,r):

        title = self.guidb.title(id, index_is_id=True)

        authors = self.guidb.authors(id, index_is_id=True)
        if isinstance(authors,list):
            author.sort()
        else:
            authors_list = []
            authors_list.append(authors)

        for a in authors_list:
            title = title.replace(a,"").strip()
            if "," in a:
                s_split = a.split(",")
                s = s_split[0].strip()
                title = title.replace(a,"").strip()
                a = self.swap_name_to_fnln(a)  # John Smith
                title = title.replace(a,"").strip()
            else:
                a = self.swap_name_to_lnfn(a)  # Smith, John
                title = title.replace(a,"").strip()
                s_split = a.split(",")
                s = s_split[0].strip()
                title = title.replace(a,"").strip()
        #END FOR
        del authors_list

        match_r = None

        try:
            p = re.compile(r,re.IGNORECASE|re.MULTILINE|re.DOTALL)
            match_r = p.search(title)
            if not match_r:
                pass
        except Exception as e:
            if DEBUG: print("RE COMPILE ERROR IN apply_quality_fix_titles_words_delete_apply_regex for book id:", str(id), "       ", str(e))

        r = r + "|"
        r_list = r.split("|")

        new_title = title

        for r in r_list:
            r = r.strip()
            if not r > " ":
                continue
            try:
                p = re.compile(r,re.IGNORECASE|re.MULTILINE|re.DOTALL)
            except Exception as e:
                if DEBUG: print("re.compile error: ", r, "   ", str(e))
                continue
            match_r = p.search(new_title)
            if not match_r:
                continue
            else:
                bad_string = match_r.group()
                if DEBUG: print("words to delete from title:  ", bad_string)
                new_title = new_title.replace(bad_string,"").strip()
        #END FOR
        del r_list
        del match_r

        new_title = new_title.strip()

        if not new_title:
            new_title = "None"
        if not new_title > " ":
            new_title = "None"

        # standardize delimiters...use [ ] only to simplify regular expressions
        new_title = new_title.replace("(","[")
        new_title = new_title.replace(")","]")
        new_title = new_title.replace("{","[")
        new_title = new_title.replace("}","]")
        new_title = new_title.replace("<","[")
        new_title = new_title.replace(">","]")

        # odds and sods
        new_title = new_title.title()  # standardize
        new_title = new_title.replace(" No."," #")
        new_title = new_title.replace("_ The",": The")
        new_title = new_title.replace("Book One_","Book 1:")
        new_title = new_title.replace("Book Two_","Book 2:")
        new_title = new_title.replace("Book Three_","Book 3:")
        new_title = new_title.replace("Book One","Book 1:")
        new_title = new_title.replace("Book Two","Book 2:")
        new_title = new_title.replace("Book Three","Book 3:")
        new_title = new_title.replace("- Book 1]",": #1]")
        new_title = new_title.replace("- Book 2]",": #2]")
        new_title = new_title.replace("- Book 3]",": #3]")
        new_title = new_title.replace("- Book 4]",": #4]")
        new_title = new_title.replace("- Book 5]",": #5]")
        new_title = new_title.replace("Book I","Book 1")
        new_title = new_title.replace("Book Ii","Book 2")
        new_title = new_title.replace("Book II","Book 2")
        new_title = new_title.replace("Book Iii","Book 3")
        new_title = new_title.replace("Book III","Book 3")
        new_title = new_title.replace("Book Iv","Book 4")
        new_title = new_title.replace("Book IV","Book 4")
        new_title = new_title.replace("Book V","Book 5")
        new_title = new_title.replace(" Vol."," Volume")
        new_title = new_title.replace(" Vol "," Volume")
        new_title = new_title.replace("Volume One","Volume 1")
        new_title = new_title.replace("Volume Two","Volume 2")
        new_title = new_title.replace("Volume Three","Volume 3")
        new_title = new_title.replace("Volume Four","Volume 4")
        new_title = new_title.replace("Volume Five","Volume 5")
        new_title = new_title.replace(" Part One"," #1")
        new_title = new_title.replace(" Part Two"," #2")
        new_title = new_title.replace(" Part Three"," #3")
        new_title = new_title.replace(" Part Four"," #4")
        new_title = new_title.replace(" Part Five"," #5")
        new_title = new_title.replace(" Number One"," #1")
        new_title = new_title.replace(" Number Two"," #2")
        new_title = new_title.replace(" Number Three"," #3")
        new_title = new_title.replace(" Number Four"," #4")
        new_title = new_title.replace(" Number Five"," #5")
        new_title = new_title.replace(" - #",": #")
        new_title = new_title.replace(" 1-2"," @~~~1-2~~~@")   # mark so no regex will capture it, then remove mark at very end.
        new_title = new_title.replace(" 1-3"," @~~~1-3~~~@")
        new_title = new_title.replace(" 1-4"," @~~~1-4~~~@")  # The Way of the Tigress 1-4
        new_title = new_title.replace(" 1-5"," @~~~1-5~~~@")
        new_title = new_title.replace("] [Volume 1]"," #1]")     # originally:    (Some Series Here) (Volume 1)
        new_title = new_title.replace("] [Volume 2]"," #2]")
        new_title = new_title.replace("] [Volume 3]"," #3]")
        new_title = new_title.replace("] [Volume 4]"," #4]")
        new_title = new_title.replace("] [Volume 5]"," #5]")
        new_title = new_title.replace(" :",":")
        new_title = new_title.replace("[Short Story]","")
        new_title = new_title.replace("[Kindle Single]","")
        new_title = new_title.replace("[Vintage Espanol]","")
        new_title = new_title.replace("[Spanish Edition]","")
        new_title = new_title.replace("BBw Paranormal Werewolf Shifter Romance","")
        new_title = new_title.replace("Taboo Bareback Romance Novella","")
        new_title = new_title.replace("Lycan Lovers","")
        new_title = new_title.replace("Novella","Novel")   # standardize to simplify regexes
        new_title = new_title.replace("An Novel","")         # sic
        new_title = new_title.replace("A Novel","")

        if new_title.startswith(":"):
            new_title = new_title[1: ].strip()
        if new_title.endswith(":"):
            new_title = new_title[0:-1].strip()
        if new_title.startswith("-"):
            new_title = new_title[1: ].strip()
        if new_title.endswith("-"):
            new_title = new_title[0:-1].strip()

        new_title = new_title.replace("  "," ")
        new_title = new_title.replace("[ ]","")
        new_title = new_title.replace("[]","")

        if DEBUG: print("apply_quality_fix_titles_words_delete_apply_regex    id: ", str(id), "  old_title: ", title, "   new_title: ", new_title)

        return new_title
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_series_regex_control(self,ids):
        self.qfix_titles_update_series_dict = {}
        self.qfix_titles_update_series_index_dict = {}
        for id in ids:
            if id in self.apply_quality_fix_scrub_titles_ignore_books_set:
                continue
            title = self.guidb.title(id, index_is_id=True)
            scenario,series,index = self.apply_quality_fix_titles_series_analyze_scenario(id,title)
            if scenario == 0:
                new_title = self.apply_quality_fix_titles_series_scenario_0(id,title)
                new_title = self.apply_quality_fix_titles_residual_artifacts_delete(id,new_title)
            elif scenario == 1:
                new_title = self.apply_quality_fix_titles_series_scenario_0(id,title)
                new_title = self.apply_quality_fix_titles_series_scenario_1(id,new_title,series,index)
                new_title = self.apply_quality_fix_titles_residual_artifacts_delete(id,new_title)
            else:
                new_title = title

            if title <> new_title:
                self.guidb.set_title(id, new_title, notify=True)
        #END FOR

        if len(self.qfix_titles_update_series_dict) > 0 or len(self.qfix_titles_update_series_index_dict) > 0:
            self.apply_quality_fix_titles_update_series()

        del self.qfix_titles_update_series_dict
        del self.qfix_titles_update_series_index_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_series_analyze_scenario(self,id,title):

        series = None
        index = None

        series = self.guidb.series(id, index_is_id=True)
        index = self.guidb.series_index(id, index_is_id=True)

        if not series:
            scenario = 0
        elif not index:
            index = 0
            scenario = 1
        else:
            if index >= 0:
                scenario = 1

        if DEBUG: print("book id: ", str(id), " scenario: ", str(scenario), " series: ", series, " index: ", str(index))

        return scenario,series,index
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_series_scenario_0(self,id,title):

        new_title = title

        if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE'] = prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE']
            prefs

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RELATED_REGEX_RELOCATE']

        r_list = r.split("|")

        IS_REGEX_TESTING = False  # can see discrete search match values of each simple regex to confirm that whole regex is sorted properly from the most specific to the most generic. this is priceless.

        for r in r_list:
            try:
                p = re.compile(r,re.IGNORECASE|re.MULTILINE|re.DOTALL)
                match_r = p.search(title)
                if not match_r:
                    #~ if DEBUG: print("No series related words to relocate from title were found; nothing done.")
                    continue
                else:
                    series_related_string = match_r.group()
                    if DEBUG: print("Critical Value:  series_related_string = match_r.group() ",series_related_string, "      ", r)     # the very first one will be kept before the 'break', so it must be the correct answer...
                    if series_related_string > " ":
                        new_title = title.replace(series_related_string,"").strip()
                        self.qfix_titles_update_series_dict[id] = series_related_string  #for parse1
                        if not IS_REGEX_TESTING:
                            break  #we want to be non-greedy, so use only the *very first match* found in the original "|" separated regex...which *must* be manually sorted from most specific to most generic
            except Exception as e:
                if DEBUG: print("RE COMPILE ERROR IN apply_quality_fix_titles_series_scenario_0 for book id:", str(id), "       ", str(e))
                return title
        #END FOR

        if DEBUG: print("scenario 0:    id: ", str(id), "  old_title: ", title, "   new_title: ", new_title)

        return new_title
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_series_scenario_1(self,id,title,series,index):
        #~ example:   title:    Flat-Out Celeste (Flat-Out Love)             series:    Flat-Out Love [2]

        if not isinstance(series,unicode):
            if DEBUG: print("series is not unicode: ", str(series))
            return title

        new_title = title.replace(series,"")
        new_title = title.replace("[  ]","")
        new_title = title.replace("[ ]","")
        new_title = title.replace("[]","")
        new_title = new_title.strip()
        if DEBUG: print("scenario 1:    id: ", str(id), "  old_title: ", title, "   new_title: ", new_title, "   series:  ", series, "  index: ", str(index))
        #-------------------
        if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE'] = prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE']
            prefs

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_INDEX_RELATED_REGEX_RELOCATE']
        try:
            p = re.compile(r,re.IGNORECASE|re.UNICODE|re.DOTALL)
        except Exception as e:
            if DEBUG: print("RE COMPILE ERROR IN apply_quality_fix_titles_series_scenario_1 for book id:", str(id), "       ", str(e))
            return new_title
        try:
            match_r_1 = p.search(title)
            match_r_2 = p.search(new_title)
            if match_r_1:
                match_r = match_r_1
            elif match_r_2:
                match_r = match_r_2
            else:
                match_r = None
            if not match_r:
                if DEBUG: print("No series_index related words to delete from title were found; nothing done.")
            else:
                series_index_related_string = match_r.group()
                #~                           new_title = new_title.replace(series_related_string,"").strip()        # scenario_0 took care of this already...
                #~ if not id in self.qfix_titles_update_series_index_dict:  #may have been discovered and relocated in scenario_0, which is done just before scenario_1.
                self.qfix_titles_update_series_index_dict[id] = series_index_related_string  #for parse2
                if DEBUG: print("possible series-index related words to relocate from title in parse2:  ", series_index_related_string)
                del match_r
                del match_r_1
                del match_r_2
        except Exception as e:
            if DEBUG: print("Other Error In apply_quality_fix_titles_series_scenario_1 for book id:", str(id), "       ", str(e))

        return new_title
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_residual_artifacts_delete(self,id,new_title):

        if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE'] = prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE']
            prefs

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_SERIES_RESIDUAL_ARTIFACTS_REGEX_DELETE']

        try:
            p = re.compile(r,re.IGNORECASE)
            match_r = p.search(new_title)
            if not match_r:
                pass
                #~ if DEBUG: print("No artifacts to delete from title were found; nothing done.")
            else:
                artifacts_string = match_r.group()
                if DEBUG: print("artifacts to delete from title:  ", artifacts_string)
                new_title = new_title.replace(artifacts_string,"").strip()
                del match_r
        except Exception as e:
            if DEBUG: print("RE COMPILE ERROR IN apply_quality_fix_titles_residual_artifacts_delete for book id:", str(id), "       ", str(e))

        # odds and sods
        new_title = new_title.replace("_"," ").strip()
        new_title = new_title.replace(" :",":").strip()
        new_title = new_title.replace(": -2",": 1-2").strip()
        new_title = new_title.replace(": -3",": 1-3").strip()
        new_title = new_title.replace(": -4",": 1-4").strip()
        new_title = new_title.replace(": -5",": 1-5").strip()

        new_title = new_title.replace("The The","The").strip()
        new_title = new_title.replace("[The]","").strip()

        return new_title
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_update_series(self):

        new_series_dict = {}  #id = series
        new_series_index_dict = {}  #id = series_index

        for id,series_related_string in self.qfix_titles_update_series_dict.iteritems():
            if DEBUG: print(series_related_string)
            new_series,new_index = self.apply_quality_fix_titles_update_series_parse_1(id,series_related_string)
            if new_series:
                new_series_dict[id] = new_series
                if DEBUG: print("new_series_dict[id] = new_series: ", str(new_series))
            if new_index:
                new_series_index_dict[id] = new_index
                if DEBUG: print("new_series_index_dict[id] = new_index: ", str(new_index))
        #END FOR

        for id,series in new_series_dict.iteritems():
            series = series.title()
            series = series.strip()
            #~ --------------------------
            #~ special corrections
            #~ --------------------------
            if series.startswith("_"): series = series[1: ]
            if series.startswith("-"): series = series[1: ]
            series = series.replace("'S","'s")  #  The Horse'S is not fixed by title()
            series = series.replace(" Ii "," II ")
            series = series.replace(" Iii "," III ")
            series = series.replace(" Iv "," IV ")
            series = series.replace(" Vi "," VI ")
            series = series.replace("(","")
            series = series.replace(")","")

            if series.endswith("0.5") or series.endswith(" .5"):
                if id in new_series_index_dict:
                    index = new_series_index_dict[id]
                    index = float(index) + float(".5")
                    new_series_index_dict[id] = float(index)
                    series = series[0:-2].strip()
                else:
                    new_series_index_dict[id] = 0.50
                    series = series[0:-3].strip()

            old = series # for undo if series would otherwise become blank...

            series = series.replace("Series","")
            series = series.replace("Books","")
            series = series.replace("Novels","")
            series = series.replace("Volumes","")
            series = series.replace("Book","")
            series = series.replace("Novel","")
            series = series.replace("Volume","")
            #~ --------------------------
            #~ --------------------------
            series = series.strip()
            if not series > " " :
                series = old
            if series > " " :
                self.guidb.set_series(id, series, notify=True)
                if id in new_series_index_dict:
                    index = new_series_index_dict[id]
                    self.guidb.set_series_index(id, index, notify=True)
        #END FOR

        #----------------------
        #----------------------
        for id,series_index_related_string in self.qfix_titles_update_series_index_dict.iteritems():
            if DEBUG: print("for id,series_index_related_string in self.qfix_titles_update_series_index_dict.iteritems():  ", series_index_related_string)
            if id in new_series_index_dict:
                potential_new_index = new_series_index_dict[id]
            else:
                potential_new_index = None
            new_index = self.apply_quality_fix_titles_update_series_parse_2(id,series_index_related_string,potential_new_index)
            if not new_index:
                continue
            new_series_index_dict[id] = new_index
        #END FOR

        for id,index in new_series_index_dict.iteritems():
            self.guidb.set_series_index(id, index, notify=True)
        #END FOR

        #----------------------
        #----------------------
        del new_series_dict
        del new_series_index_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_update_series_parse_1(self,id,series_related_string):
        new_series = None
        new_index = None
        #----------------------
        if DEBUG: print("parse1  original   id,series_related_string: ", str(id), series_related_string)

        series_related_string = series_related_string.replace("[","")
        series_related_string = series_related_string.replace("]","")
        series_related_string = series_related_string.replace("(","")
        series_related_string = series_related_string.replace(")","")
        series_related_string = series_related_string.replace("{","")
        series_related_string = series_related_string.replace("}","")
        series_related_string = series_related_string.replace(",","")
        series_related_string = series_related_string.replace(";","")
        series_related_string = series_related_string.replace(":","")
        series_related_string = series_related_string.replace(" -","")  #but keep   Flat-Out
        series_related_string = series_related_string.replace("- ","")  #but keep   Flat-Out
        series_related_string = series_related_string.replace("#","")

        #~ ---------------
        r = "[0-9]+"  # extract series_index, if any
        index_found = False
        try:
            p = re.compile(r,re.IGNORECASE|re.UNICODE|re.DOTALL)
            match_r = p.search(series_related_string)              #  The Bear and the Dragon (A Jack Ryan Novel Book 8)
            if not match_r:
                pass
            else:
                new_index = match_r.group()
                if DEBUG: print("new index is: ", new_index)
                index_found = True         # A Jack Ryan Novel Book 8
                series_related_string = series_related_string.replace(new_index,"")  # A Jack Ryan Novel Book
                series_related_string = series_related_string.strip()
                new_series = series_related_string.title()
        except Exception as e:
            if DEBUG: print("RE COMPILE ERROR IN apply_quality_fix_titles_update_series_parse_1 for book id:", str(id), "       ", str(e))

        if new_series:
            if new_series.startswith("A "):    # A Jack Ryan Novel Book
                if "Novel" in new_series:
                    new_series = new_series[2: ]
                    new_series = new_series.replace("Novel","")
                    if "Book" in new_series:
                        new_series = new_series.replace("Book","")
                    new_series = new_series.replace("  "," ").strip()   # Jack Ryan

        if new_index:
            try:
                new_index = float(new_index)
            except:
                new_index = 0

        if DEBUG: print("parse1  final    new index found: ", index_found, "  new index: ", new_index, "  new series: ", new_series)

        #----------------------
        return new_series,new_index
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_update_series_parse_2(self,id,series_index_related_string,potential_new_index):

        if DEBUG: print("parse2[a]:  id,series_index_related_string,potential_new_index: ", str(id), "  ", series_index_related_string, "  ", str(potential_new_index))

        title = self.guidb.title(id, index_is_id=True)

        series_index_related_string = series_index_related_string.strip()
        new_title = title.replace(series_index_related_string,"")
        if potential_new_index:
            potential_new_index = str(potential_new_index).strip()
            new_title = title.replace(potential_new_index,"")
        if title <> new_title:
            self.guidb.set_title(id, new_title, notify=True)
            if DEBUG: print("parse2[b]:  new_title is: ", new_title)
        #----------------------
        # Try SIRS
        #----------------------
        sirs = str(series_index_related_string).strip()     # examples:   [ #3]     #3       3
        sirs = sirs.replace("[","")
        sirs = sirs.replace("#","")
        sirs = sirs.replace(" ","")
        sirs = sirs.replace("]","")

        if sirs.isnumeric():
            new_index = int(sirs)      # e.g. 3
            if DEBUG: print("parse2[c]: final new_index is: ", str(new_index))
        else:
            try:
                new_index = float(sirs)  # e.g. 3.5
            except Exception as e:
                if DEBUG: print("parse2[d]:  apply_quality_fix_titles_update_series_parse_2:  parsing potential series index of: ", str(sirs), "   ", str(e))
                new_index = None
        #----------------------
        # Try PNI
        #----------------------
        if not new_index:
            pni = str(potential_new_index).strip()     # example:   [ #3]
            pni = pni.replace("[","")
            pni = pni.replace("#","")
            pni = pni.replace(" ","")
            pni = pni.replace("]","")

            if pni.isnumeric():
                new_index = int(pni)      # e.g. 3
                if DEBUG: print("parse2[e]: final new_index is: ", str(new_index))
            else:
                try:
                    new_index = float(pni)  # e.g. 3.5
                except Exception as e:
                    if DEBUG: print("parse2[f]:  apply_quality_fix_titles_update_series_parse_2:  parsing potential series index of: ", str(pni), "   ", str(e))
                    new_index = None

        series = self.guidb.series(id, index_is_id=True)
        new_title = new_title.replace(series,"")
        if new_index:
            new_title = new_title.replace(str(new_index),"")
        self.guidb.set_title(id, new_title, notify=True)
        if DEBUG: print("parse2[g]:  final new_title is: ", new_title)

        return new_index
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titlecase_titles(self,ids):
        for id in ids:
            newtitle = self.guidb.title(id, index_is_id=True)
            newtitle = newtitle.title()

            #~ special corrections
            newtitle = newtitle.replace("'S","'s")  #  The Horse'S is not fixed by newtitle()
            newtitle = newtitle.replace("n'T","n't")

            newtitle = newtitle.replace("Iii ","III ")
            newtitle = newtitle.replace("Ii ","II ")
            newtitle = newtitle.replace("Iv ","IV ")
            newtitle = newtitle.replace("Vi ","VI ")
            newtitle = newtitle.replace(" Iii"," III")
            newtitle = newtitle.replace(" Ii"," II")
            newtitle = newtitle.replace(" Iv"," IV")
            newtitle = newtitle.replace(" Vi"," VI")
            newtitle = newtitle.replace("Iii: ","III ")
            newtitle = newtitle.replace("Ii: ","II ")
            newtitle = newtitle.replace("Iv: ","IV ")
            newtitle = newtitle.replace("Vi: ","VI ")

            newtitle = newtitle.replace("VIscount ","Viscount ")

            newtitle = newtitle.replace("Tv ","TV ")
            newtitle = newtitle.replace("Fbi ","FBI ")
            newtitle = newtitle.replace("Cia ","CIA ")
            newtitle = newtitle.replace("Nsa ","NSA ")
            newtitle = newtitle.replace("Epub","EPUB")
            newtitle = newtitle.replace("Atm","ATM")
            newtitle = newtitle.replace(" Uk"," UK")
            newtitle = newtitle.replace(" Usa"," Usa")
            newtitle = newtitle.replace(" Eu "," EU ")

            newtitle = newtitle.replace("1St","1st")
            newtitle = newtitle.replace("2Nd","2nd")
            newtitle = newtitle.replace("3Rd","3rd")
            newtitle = newtitle.replace("4Th","4th")
            newtitle = newtitle.replace("5Th","5th")
            newtitle = newtitle.replace("6Th","6th")
            newtitle = newtitle.replace("7Th","7th")
            newtitle = newtitle.replace("8Th","8th")
            newtitle = newtitle.replace("9Th","9th")
            newtitle = newtitle.replace("10Th","10th")

            self.guidb.set_title(id, newtitle, notify=True)
        #END FOR
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_update_title_sorts(self,my_db,my_cursor,ids):
        #Calibre has a table books trigger using a scalar function named 'title_sorts' that automatically updates it when the table is changed...but allow the user to force it here anyway...
        mysql = "UPDATE books SET sort = title_sort(title) WHERE id = ?"
        my_cursor.execute("begin")
        for id in ids:
            my_cursor.execute(mysql,([id]))
        #END FOR
        my_cursor.execute("commit")

        self.apply_quality_fix_refresh_ids()
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_titles_residual_artifacts_final(self,ids):

        for id in ids:
            if id in self.apply_quality_fix_scrub_titles_ignore_books_set:
                continue
            title = self.guidb.title(id, index_is_id=True)
            orig = title
            series = self.guidb.series(id, index_is_id=True)
            index = self.guidb.series_index(id, index_is_id=True)
            if series:
                title = title.replace(series,"").strip()
            if index:
                s_index = str(index)
                if s_index in title:
                    title = title.replace("#","").strip()
                    title = title.replace(s_index,"").strip()
            title = title.replace("  "," ").strip()
            title = title.replace("[    ]","")
            title = title.replace("[   ]","")
            title = title.replace("[  ]","")
            title = title.replace("[ ]","")
            title = title.replace("[]","")
            nleft = title.count("[")
            nright = title.count("]")
            if nleft <> nright:
                title = title.replace("[","")
                title = title.replace("]","")
            title = title.replace(", ]","]")
            title = title.replace("@~~~","")
            title = title.replace("~~~@","")
            title = title.strip()
            if title.startswith(":"):
                title = title[1: ].strip()
            if title.endswith(":"):
                title = title[0:-1].strip()
            title = title.replace("The  The","").strip()
            title = title.replace("::","").strip()
            title = title.replace("  "," ").strip()
            if title.count(".") > 4:
                title = title.replace("."," ").strip()
            if title.startswith("I -"):
                title = title[3: ].strip()
            if title.startswith("Ii -"):
                title = title[4: ].strip()
            if title.startswith("Iii -"):
                title = title[5: ].strip()
            if title.startswith("IV -"):
                title = title[4: ].strip()
            if title.startswith("V -"):
                title = title[3: ].strip()
            if title.startswith("Vi -"):
                title = title[4: ].strip()

            if title.startswith("'s"):
                title = title[2: ].strip()
            title = title.replace("'S","'s")  #  The Horse'S is not fixed by title()
            title = title.replace("n'T","n't")
            title = title.replace("Iii ","III ")
            title = title.replace("Ii ","II ")
            title = title.replace("Iv ","IV ")
            title = title.replace("Vi ","VI ")
            title = title.replace("Iii: ","III ")
            title = title.replace("Ii: ","II ")
            title = title.replace("Iv: ","IV ")
            title = title.replace("Vi: ","VI ")
            title = title.replace("Tv ","TV ")
            title = title.replace("Fbi ","FBI ")
            title = title.replace("Cia ","CIA ")
            title = title.replace("Nsa ","NSA ")
            title = title.replace("A Novel","")
            title = title.replace("An Novel","")  #sic

            if title.startswith("The ["):   # The [The Shades Of London]
                title = title.replace("The [","")
                title = title.replace("[","")
                title = title.replace("]","")

            title = title.replace("Fuck","F*ck")
            title = title.replace("Shit","Sh*t")

            title = title.strip()

            if title.startswith(":"):
                title = title[1: ].strip()
            if title.endswith(":"):
                title = title[0:-1].strip()

            if title.startswith("-"):
                title = title[1: ].strip()
            if title.endswith("-"):
                title = title[0:-1].strip()

            title = title.strip()

            if title == "The" or title == "A" or title == "An" or title <= " ":
                if series:
                    title = series
            if not title > " ":
                title = "None"

            if orig <> title:
                self.guidb.set_title(id, title, notify=True)
        #END FOR
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_update_author_initials(self,ids):

        self.apply_quality_fix_refresh_ids()

        initials_mode = prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_INITIALS_MODE']

        for id in ids:
            authors = self.guidb.authors(id, index_is_id=True)
            if authors:
                authors = [a.strip().replace('|', ',') for a in authors.split(',')]
                new_authors = [self.get_formatted_author_initials(initials_mode, a) for a in authors]
                if authors <> new_authors:
                    self.guidb.set_authors(id, new_authors, notify=True)
                    if DEBUG: print("author initials were standardized for book id: ", str(id), " with chosen style: ", initials_mode)
        #END FOR

        del initials_mode
        try:
            del authors
            del new_authors
        except:
            pass

        self.apply_quality_fix_refresh_ids()
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_update_author_sorts(self,my_db,my_cursor,ids):

        mysql = "UPDATE authors SET sort = author_to_author_sort(name) WHERE authors.id IN (SELECT author FROM books_authors_link WHERE book=?)"
        my_cursor.execute("begin")
        for id in ids:
            my_cursor.execute(mysql,([id]))
        #END FOR
        my_cursor.execute("commit")

        self.apply_quality_fix_refresh_ids()

        tmp_dict = {}

        for id in ids:
            authors_string = self.guidb.authors(id, index_is_id=True)
            authors_list = string_to_authors(authors_string)
            new_author_sort = self.guidb.new_api.author_sort_from_authors(authors_list, key_func=lambda x: x)
            tmp_dict[id] = new_author_sort
        #END FOR

        self.quality_fix_current_ids = copy.deepcopy(ids)

        #~ This ensures that the metadata.db = cache = library_view
        for id in ids:
            mi = Metadata(_('Unknown'))
            #~ ------------------------
            mi.author_sort = tmp_dict[id]
            #~ ------------------------
            id_map = {}
            id_map[id] = mi
            payload = []
            payload.append(id)
            edit_metadata_action = self.maingui.iactions['Edit Metadata']
            edit_metadata_action.apply_metadata_changes(id_map, callback=None)
        #END FOR

        self.apply_quality_fix_refresh_ids()

        del authors_string
        del authors_list
        del new_author_sort
        del tmp_dict
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_refresh_ids_callback(self,payload):
        self.gui.library_view.model().refresh_ids(payload)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_refresh_ids(self):
        ids = self.quality_fix_current_ids
        self.gui.library_view.model().refresh_ids(ids)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_formatted_author_initials(self,initials_mode, author):
        #~ Honors go to kiwidude for his excellent 'Quality Check' plug-in from which this is borrowed:
        '''
        Given an author name, break it down looking for potential initials
        and if any found reformat them to the desired preference indicated
        by initials mode.
        '''
        ignore_words = ['von', 'van', 'jr', 'jr.', 'sr', 'sr.', 'st', 'st.',
                        'ed', 'ed.', 'dr', 'dr.', 'phd', 'ph.d', 'ph.d.']
        ignore_upper_words = ['ii', 'iii']
        ignore_words_map = dict((k,True) for k in ignore_words)

        parts = author.split()
        new_parts = []
        append_to_previous = False
        for tok in parts:
            if len(tok) == 0:
                continue
            handled = False
            # We will only ignore these words if exact match and the
            # author does not have these in uppercase. i.e. JR should
            # be treated as author initials, but Jr or jr will be ignored
            if tok.lower() in ignore_words_map and tok.upper() != tok:
                pass
            # Some ignore words are likely to be all uppercase. If there
            # was a genuine author with these initials then bad luck!
            # i.e. II or III will get treated as not initials.
            elif tok.lower() in ignore_upper_words:
                pass
            elif tok.isnumeric():
                pass
            # Any word which has a period or is in uppercase with two or less
            # characters will be considered an initial
            elif '.' in tok or (tok.upper() == tok and len(tok) <= 2):
                # Ok, we have something in the expression we will treat as an initial
                # Now figure out how to format it
                if initials_mode == 'A.B.':
                    #print('Author',author,'Tok',tok)
                    new_tok = ''
                    for c in tok.replace('.',''):
                        new_tok += c + '.'
                    if append_to_previous:
                        new_parts[-1] = new_parts[-1] + new_tok
                    else:
                        new_parts.append(new_tok)
                        append_to_previous = True
                elif initials_mode == 'A. B.':
                    new_tok = ''
                    for c in tok.replace('.',''):
                        new_tok += c + '. '
                    new_parts.append(new_tok.strip())
                elif initials_mode == 'A B':
                    new_tok = ''
                    for c in tok.replace('.',''):
                        new_tok += c + ' '
                    new_parts.append(new_tok.strip())
                elif initials_mode == 'AB':
                    new_tok = tok.replace('.','')
                    if append_to_previous:
                        new_parts[-1] = new_parts[-1] + new_tok
                    else:
                        new_parts.append(new_tok)
                        append_to_previous = True

                handled = True

            if not handled:
                new_parts.append(tok)
                append_to_previous = False

        return ' '.join(new_parts)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_quality_fix_swap_author_names(self,ids,pattern="FNLN"):

        for id in ids:
            new_authors_list = []
            authors_list = []
            if id in self.quality_fix_scrub_authors_new_authors_dict:
                authors_list = self.quality_fix_scrub_authors_new_authors_dict[id]
                #~ authors = authors_to_string(authors_list)
            else:
                authors = self.guidb.authors(id, index_is_id=True)
                if not authors:
                    authors = "Unknown"
                if authors.count(",") > 0:
                    if len(authors) > 30:
                        authors = authors.replace(',', '&')  # original metadata likely uses a comma to separate multiple authors instead of an ampersand..."Daphne du Maurier,Antonio de la Madrid"
                authors = authors.replace('|', ',')
                authors = authors + " &"
                authors_list = authors.split("&")
            for author in authors_list:
                author = author.strip()
                if not author > " ":
                    continue
                #~ if DEBUG: print("original single author: ", author)
                if pattern == "FNLN":
                    if ',' in author:
                        new_author = self.swap_name_to_fnln(author)
                        new_authors_list.append(new_author)
                        if DEBUG: print("new FNLN author: ", new_author)
                    else:
                        new_authors_list.append(author)
                        #~ if DEBUG: print("author already FNLN: ", author)
                else:
                    if not ',' in author:
                        new_author = self.swap_name_to_lnfn(author)
                        new_authors_list.append(new_author)
                        if DEBUG: print("new LNFN author: ", new_author)
                    else:
                        new_authors_list.append(author)
                        #~ if DEBUG: print("author already LNFN: ", author)
            #END FOR
            mi = Metadata(_('Unknown'))
            #~ ------------------------
            mi.authors = new_authors_list
            #~ ------------------------
            id_map = {}
            id_map[id] = mi
            payload = []
            payload.append(id)
            edit_metadata_action = self.maingui.iactions['Edit Metadata']
            edit_metadata_action.apply_metadata_changes(id_map, callback=None)
            del authors_list
            del author
            del new_authors_list
        #END FOR
        self.apply_quality_fix_refresh_ids()
        del ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def swap_name_to_fnln(self,a):
        parts = a.split(',')
        if len(parts) <= 1:
            return a
        surname = parts[0]
        return '%s %s' % (' '.join(parts[1: ]), surname)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def swap_name_to_lnfn(self,a):
        parts = a.split(" ")
        if len(parts) <= 1:
            return a
        surname = parts[-1]
        return '%s, %s' % (surname, ' '.join(parts[0:-1]))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def remove_title_from_authors(self,ids):

        if RESET_QUALITY_FIX_SCRUB_TITLES_REGEXES_TO_DEFAULTS:
            prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_RESIDUAL_ARTIFACTS_REGEX_DELETE'] =  prefs.defaults['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_RESIDUAL_ARTIFACTS_REGEX_DELETE']

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_RESIDUAL_ARTIFACTS_REGEX_DELETE']

        r = r + "|"
        r = r.strip()
        r_list = r.split("|")

        self.quality_fix_scrub_authors_new_authors_dict = {}  # id = new authors     used by  FNLN   LN, FN function...

        for id in ids:
            if id in self.apply_quality_fix_scrub_titles_ignore_books_set:
                continue
            authors = self.guidb.authors(id, index_is_id=True)
            title = self.guidb.title(id, index_is_id=True)
            if authors:
                if isinstance(authors,list):
                    pass
                else:
                    t = []
                    t.append(authors)
                    authors = t
                    del t
                if not title:
                    title = "Unknown"
                title = title.replace(" @~~~1-2~~~@"," 1-2")   # marked earlier so no regex would capture it...
                title = title.replace(" @~~~1-3~~~@"," 1-3")
                title = title.replace(" @~~~1-4~~~@"," 1-4")  # The Way of the Tigress 1-4
                title = title.replace(" @~~~1-5~~~@"," 1-5")
                title = title.strip()
                new_authors = []
                for a in authors:
                    a = a.replace("|",",")
                    a = a.replace(";"," ")
                    if DEBUG: print(" author prior to scrubbing: ", str(a))
                    orig = a
                    a = a.strip()
                    a = self.remove_artifacts_from_authors(a,r_list)
                    s = str(orig).strip()
                    t = str(title).strip()
                    a = a.replace(title,"").strip()
                    a = a.replace(t,"").strip()
                    a = self.remove_artifacts_from_authors(a,r_list)
                    if a == "_." or a == "*.":
                        a = ""
                    if a > " ":
                        if a <> orig:
                            if "&" in a:  # ',' converted to a '&'
                                a_split = a.split("&")
                                for x in a_split:
                                    x = x.strip()
                                    x = x.title()
                                    new_authors.append(x)
                            else:
                                new_authors.append(a)
                            if DEBUG: print("author after scrubbing: ", str(a))
                    else:
                        new_authors.append("Unknown")
                    del s
                    del t
                #END FOR
                if len(new_authors) > 0:
                    #~ This ensures that the metadata.db = cache = library_view
                    mi = Metadata(_('Unknown'))
                    #~ ------------------------
                    mi.authors = new_authors
                    #~ ------------------------
                    id_map = {}
                    id_map[id] = mi
                    payload = []
                    payload.append(id)
                    edit_metadata_action = self.maingui.iactions['Edit Metadata']
                    edit_metadata_action.apply_metadata_changes(id_map, callback=None)
                    self.quality_fix_scrub_authors_new_authors_dict[id] = new_authors
                del new_authors
        #END FOR

        self.apply_quality_fix_refresh_ids()
#---------------------------------------------------------------------------------------------------------------------------------------
    def remove_series_from_authors(self,ids):
        for id in ids:
            if id in self.apply_quality_fix_scrub_titles_ignore_books_set:
                continue
            series = self.guidb.series(id, index_is_id=True)
            if series:
                index = self.guidb.series_index(id, index_is_id=True)
                authors_string = self.guidb.authors(id, index_is_id=True)
                if authors_string:
                    authors_list = string_to_authors(authors_string)
                    new_authors = []
                    for a in authors_list:
                        if DEBUG: print("remove_series_from_authors:   original author: ", a)
                        orig = a
                        series = series.strip()
                        a = a.replace("|",",")
                        a = a.replace("#","")
                        a = a.replace(";","")
                        a = a.strip()
                        s = str(orig)
                        t = str(series)
                        left = a.count("(")
                        right = a.count(")")
                        if left <> right:
                            a = a.replace("(","")
                            a = a.replace(")","").strip()
                        b = a[0:1]
                        if b.isnumeric():
                            a = a[1: ]
                        if a.startswith("(") or a.startswith(")") or a.endswith(")") or a.endswith("("):
                            a = a.replace("(","")
                            a = a.replace(")","")
                        a = a.strip()
                        if (s.count(t) > 0) or (t in s) or (series in a) or (a <> orig):
                            if DEBUG: print("series: ", t, "  index: ", str(index), "  author: ", s)
                            a = a.replace(series,"").strip()
                            a = a.replace(t,"").strip()
                            a = a.replace("-"," ")
                            if index:
                                index = str(index)
                                a = a.replace(index,"").strip()
                            a = a.replace("  "," ").strip()
                            if a > " ":
                                new_authors.append(a)
                                if DEBUG: print("[1] remove_series_from_authors:   new author: ", a)
                            else:
                                pass
                        else:
                            pass
                        del s
                        del t
                    #END FOR
                    if len(new_authors) > 0:
                        #~ This ensures that the metadata.db = cache = library_view
                        mi = Metadata(_('Unknown'))
                        #~ ------------------------
                        mi.authors = new_authors
                        #~ ------------------------
                        id_map = {}
                        id_map[id] = mi
                        payload = []
                        payload.append(id)
                        edit_metadata_action = self.maingui.iactions['Edit Metadata']
                        edit_metadata_action.apply_metadata_changes(id_map, callback=None)
                        self.quality_fix_scrub_authors_new_authors_dict[id] = new_authors
                    del new_authors
        #END FOR

        self.apply_quality_fix_refresh_ids()
#---------------------------------------------------------------------------------------------------------------------------------------
    def remove_artifacts_from_authors(self,a,r_list):

        match_r = None

        for r in r_list:
            r = r.strip()
            if not r > " ":
                continue
            try:
                p = re.compile(r,re.IGNORECASE|re.MULTILINE|re.DOTALL)
                match_r = p.search(a)
                if not match_r:
                    continue
                else:
                    bad_string = match_r.group()
                    if DEBUG: print("words to delete from author:  ", bad_string)
                    a = a.replace(bad_string,"").strip()
            except Exception as e:
                if DEBUG: print("RE COMPILE ERROR IN remove_artifacts_from_authors for author:", str(a), "       ", str(e), "  r = ", str(r))
        #END FOR
        del r_list
        del match_r

        a = a.replace("|",",")
        a = a.replace(";"," ")

        a = a.replace("-."," ")
        a = a.replace("_.","").strip()
        a = a.replace("*.","").strip()
        a = a.replace("_"," ").strip()
        a = a.replace("  "," ").strip()

        if "," in a:
            if a.count(" ") > 1:        #Examples:      Guillermo Del Toro,Daniel Kraus              Clive Cussler,Graham Brown
                if len(a) > 20:
                    a = a.replace(","," , ")
                    a = a.replace("  "," ").strip()
                    a = a.replace(",","&")

        if " trans " in a:
            a = a.replace(" trans ", "&")
        if "translator" in a:
            a = a.replace("translator", "&")
            a = a.replace(":","")
        if "translated by" in a:
            a = a.replace("translated by", "&")
            a = a.replace(":","")

        if DEBUG: print("author after artifacts, if any, removed: ", a)

        return a
    #---------------------------------------------------------------------------------------------------------------------------------------
    def swap_author_and_title_if_needed(self,ids):

        r = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_RESIDUAL_ARTIFACTS_REGEX_DELETE']
        r = r + "|"
        r = r.strip()
        r_list = r.split("|")

        for id in ids:
            if id in self.apply_quality_fix_scrub_titles_ignore_books_set:
                continue
            authors = self.guidb.authors(id, index_is_id=True)
            if not authors:
                continue
            if isinstance(authors,list):
                authors_list = authors
            else:
                authors_list = []
                authors_list.append(authors)
            authors = authors_to_string(authors_list)
            title = self.guidb.title(id, index_is_id=True)
            if ' ' in authors:
                if not ' ' in title:  #1-word title...unlikely it is an author's name...
                    continue
            tmpa = authors.replace(" ","").strip()  #remove characters normally found in a typical author from the current author
            tmpa = authors.replace(".","").strip()
            tmpa = authors.replace(",","").strip()
            tmpa = authors.replace("'","").strip()   # O'Shea
            tmpa = authors.replace("&","").strip()
            tmpt = title.replace(" ","").strip()  #remove characters normally found in a typical author from the current title
            tmpt = title.replace(".","").strip()
            tmpt = title.replace(",","").strip()
            tmpt = title.replace("'","").strip()
            tmpt = title.replace("&","").strip()
            if not tmpa.isalpha():
                if DEBUG: print("tmp author: ", tmpa)
                if tmpt.isalpha():
                    if DEBUG: print("tmp title: ", tmpt)
                    #check original title as a last check on correctness to do this swap...as title may have been scrubbed clean...
                    if id in self.quality_fix_original_titles_dict:
                        original_title = self.quality_fix_original_titles_dict[id]
                    else:
                        continue
                    original_title = original_title.replace(" ","").strip()
                    original_title = original_title.replace(".","").strip()
                    original_title = original_title.replace(",","").strip()
                    original_title = original_title.replace("'","").strip()
                    original_title = original_title.replace("&","").strip()
                    if not original_title.isalpha():
                        continue
                    t = authors  #swap
                    a = title
                    authors_list = []
                    a = a + "&"
                    a_split = a.split("&")
                    for a in a_split:
                        a = a.replace("*.","")
                        a = a.replace("_.","")
                        a = a.replace(";","")
                        a = a.strip()
                        if a > " ":
                            a = self.remove_artifacts_from_authors(a,r_list)  # remember that these new authors never went through the 'scrub author artifacts' function, since they were a title originally...
                            authors_list.append(a)
                    #END FOR
                    if len(authors_list) == 0:
                        authors_list.append("Unknown")
                    mi = Metadata(_('Unknown'))
                    #~ ------------------------
                    mi.authors = authors_list
                    mi.title = t
                    #~ ------------------------
                    id_map = {}
                    id_map[id] = mi
                    payload = []
                    payload.append(id)
                    edit_metadata_action = self.maingui.iactions['Edit Metadata']
                    edit_metadata_action.apply_metadata_changes(id_map, callback=None)
                    if DEBUG: print("Author and Title were swapped: ", str(id), " new Authors: ", str(t), " new Title: ", str(authors_list))
                    self.quality_fix_scrub_authors_new_authors_dict[id] = authors_list
        #END FOR

        self.apply_quality_fix_refresh_ids()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def retrieve_recently_added_books(self):
        tids = []
        for id in self.guidb.data.marked_ids:
            tids.append(id)
            #~ if DEBUG: print("Marked: ", str(id))
        #END FOR

        ids = []
        for id in tids:
            try:
                timestamp = self.guidb.timestamp(id, index_is_id=True)
                timestamp = str(timestamp)
                timestamp = timestamp[0:19]
                #~ if DEBUG: print(timestamp, " must be later than: ", self.quality_fixes_checkpoint_time_previous)
                if timestamp >= self.quality_fixes_checkpoint_time_previous:
                    ids.append(id)
            except Exception as e:
                pass
                #~ if DEBUG: print("Error in retrieve_recently_added_books for ", str(id), "  ",str(e))
        #END FOR
        del tids

        return ids
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_original_title_custom_column(self,ids):

        for id in ids:
            title = self.guidb.title(id, index_is_id=True)
            self.quality_fix_original_titles_dict[id] = title
        #END FOR

        orig_title_cc = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_TITLES_ORIGINAL_TITLE_CUSTOM_COLUMN']
        custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()
        if not orig_title_cc in custom_columns_metadata_dict:
            if DEBUG: print("Original Title Custom Column was not found in Calibre: ", orig_title_cc)
            del custom_columns_metadata_dict
            return
        custcol = custom_columns_metadata_dict[orig_title_cc]
        table = custcol["table"]
        table = str(table)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        mysql = "INSERT OR REPLACE INTO " + table + " (id,book,value) VALUES(null,?,?)"
        my_cursor.execute("begin")
        for id in ids:
            title = self.quality_fix_original_titles_dict[id]
            my_cursor.execute(mysql,(id,title))
        #END FOR
        my_cursor.execute("commit")
        my_db.close()

        self.apply_quality_fix_refresh_ids()

        #This ensures that the metadata.db = cache = library_view
        id_map = {}
        mi_field = orig_title_cc
        for id,orig_title in self.quality_fix_original_titles_dict.iteritems():
            mi = Metadata(_('Unknown'))
            custcol['#value#']  = orig_title
            mi.set_user_metadata(mi_field, custcol)
            id_map = {}
            id_map[id] = mi
            payload = []
            payload.append(id)
            edit_metadata_action = self.maingui.iactions['Edit Metadata']
            edit_metadata_action.apply_metadata_changes(id_map, callback=None)     # critical: can avoid the progress dialog ***if only do 1 at a time***; progress dialog hangs sometimes, and is modal, so cannot manually close it...
        #END FOR
        self.quality_fix_current_ids = copy.deepcopy(ids)
        del ids
        del custom_columns_metadata_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_original_authors_custom_column(self,ids):

        self.quality_fix_original_authors_dict = {}   # id = authors_string

        orig_authors_cc = prefs['GUI_TOOLS_QUALITY_FIXES_SCRUB_AUTHORS_ORIGINAL_AUTHORS_CUSTOM_COLUMN']
        custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()
        if not orig_authors_cc in custom_columns_metadata_dict:
            if DEBUG: print("Original authors Custom Column was not found in Calibre: ", orig_authors_cc)
            del custom_columns_metadata_dict
            return
        custcol = custom_columns_metadata_dict[orig_authors_cc]
        table = custcol["table"]
        table = str(table)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        mysql = "INSERT OR REPLACE INTO " + table + " (id,book,value) VALUES(null,?,?)"
        my_cursor.execute("begin")
        for id in ids:
            authors = self.guidb.authors(id, index_is_id=True)
            if not authors:
                continue
            if isinstance(authors,list):
                authors_list = authors
            else:
                authors_list = []
                authors_list.append(authors)
            authors_string = authors_to_string(authors_list)
            self.quality_fix_original_authors_dict[id] = authors_string
            my_cursor.execute(mysql,(id,authors_string))
        #END FOR
        my_cursor.execute("commit")
        my_db.close()

        self.apply_quality_fix_refresh_ids()

        #This ensures that the metadata.db = cache = library_view
        id_map = {}
        mi_field = orig_authors_cc
        for id,orig_authors in self.quality_fix_original_authors_dict.iteritems():
            mi = Metadata(_('Unknown'))
            custcol['#value#']  = orig_authors
            mi.set_user_metadata(mi_field, custcol)
            id_map = {}
            id_map[id] = mi
            payload = []
            payload.append(id)
            edit_metadata_action = self.maingui.iactions['Edit Metadata']
            edit_metadata_action.apply_metadata_changes(id_map, callback=None)     # critical: can avoid the progress dialog ***if only do 1 at a time***; progress dialog hangs sometimes, and is modal, so cannot manually close it...
        #END FOR
        self.quality_fix_current_ids = copy.deepcopy(ids)
        del ids
        del custom_columns_metadata_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def scrub_isbn(self):

        self.quality_fix_isbns_scrubbed_books_list = []

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('Convert ISBNs'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        self.scrub_isbn_values(my_db,my_cursor)

        self.convert_identifiers_isbn_from_10_to_13(my_db, my_cursor)

        self.detect_isbn_changes_to_refresh(my_db, my_cursor)

        my_db.close()
    #-----------------------------------------------------------------------------------------
    def convert_identifiers_isbn_from_10_to_13(self,my_db, my_cursor):
        #~ Important: this is alway done for all books, even if they were NOT selected otherwise.

        mysql = "SELECT book, val FROM identifiers WHERE type = 'isbn'  AND val NOT LIKE '978%'  \
                        AND val NOT LIKE '979%'  AND val NOT NULL;"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            if DEBUG: print("No ISBN 10's Were Found to Convert")
            return
        else:
            n = len(tmp_rows)
            if DEBUG: print("Total Number of ISBN 10s Found: " + str(n))
            if n == 0 :
                return
            my_counter = 0
            my_total = 0
            my_cursor.execute("begin")  #apsw
            for row in tmp_rows:
                book, old_isbn = row
                book = int(book)
                old_isbn = str(old_isbn).strip()
                if len(old_isbn) == 10:
                    self.quality_fix_isbns_scrubbed_books_list.append(book)
                    new_isbn = str(self._convert_isbn_convert_10_to_13(old_isbn))
                    if len(new_isbn) == 13:
                        if isinstance(new_isbn, str):
                            new_isbn = unicode(new_isbn)
                        mysql = "UPDATE identifiers SET val = ? WHERE book = ? AND type = 'isbn' "
                        my_cursor.execute(mysql,(new_isbn, book))
                        if DEBUG: print("ISBN10 Converted to ISBN13: " + str(old_isbn) + " >>> " + str(new_isbn))
                    else:
                        if isinstance(old_isbn, str):
                            old_isbn = unicode(old_isbn)
                        if DEBUG: print("This ISBN10 appears to not really be an ISBN10, and was deleted:  " + str(old_isbn) )
                        mysql = "DELETE FROM identifiers WHERE val = ? AND book = ? AND type = 'isbn' "
                        my_cursor.execute(mysql,(old_isbn, book))
                    self.quality_fix_isbns_scrubbed_books_list.append(book)
                else:
                    if isinstance(old_isbn, str):
                        old_isbn = unicode(old_isbn)
                    if DEBUG: print("This ISBN appears to not really be any kind of ISBN, and was deleted:  " + str(old_isbn) )
                    mysql = "DELETE FROM identifiers WHERE val = ? AND book = ? AND type = 'isbn' "
                    my_cursor.execute(mysql,(old_isbn, book))
                    self.quality_fix_isbns_scrubbed_books_list.append(book)
            #END FOR
            my_cursor.execute("commit")
    #-----------------------------------------------------------------------------------------
    def _convert_isbn_check_digit_13(self,isbn):
        try:
            assert len(isbn) == 12
            sum = 0
            for i in range(len(isbn)):
                c = int(isbn[i])
                if i % 2: w = 3
                else: w = 1
                sum += w * c
            r = 10 - (sum % 10)
            if r == 10: return '0'
            else: return str(r)
        except:
            return isbn
    #-----------------------------------------------------------------------------------------
    def _convert_isbn_convert_10_to_13(self,isbn):
        try:
            assert len(isbn) == 10
            prefix = '978' + isbn[:-1]
            check = self._convert_isbn_check_digit_13(prefix)
            return prefix + check
        except:
            return isbn
    #-----------------------------------------------------------------------------------------
    def scrub_isbn_values(self,my_db,my_cursor):
        try:
            #~ ----------
            my_cursor.execute("begin")
            mysql = "UPDATE OR IGNORE identifiers SET type = 'isbn',val=type WHERE type LIKE '%978%' AND val NOT LIKE '%978%'   "    # type 978000123456 value xxxxx  should be:  isbn:978000123456
            my_cursor.execute (mysql)
            mysql = "UPDATE OR IGNORE identifiers SET type = 'isbn',val=type WHERE type LIKE '979%' AND val NOT LIKE '979%'   "          # 979 is reservef for use by the same int'l agency that assigns 978
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            #~ ----------
            my_cursor.execute("begin")
            mysql = "UPDATE OR IGNORE identifiers SET type = 'isbn' WHERE type LIKE '%isbn%' AND type <> 'isbn'   "                               # type urnisbn            value 978000123456   should be:  isbn:978000123456
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            #~ ----------
            my_cursor.execute("begin")
            mysql = "UPDATE OR IGNORE identifiers SET type = (trim(type)) WHERE type LIKE '%isbn%'  "
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            #~ ----------
            my_cursor.execute("begin")
            mysql = "UPDATE identifiers SET val = (replace(val,'-','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%-%')"
            my_cursor.execute (mysql)
            mysql = "UPDATE identifiers SET val = (replace(val,' ','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '% %') "
            my_cursor.execute (mysql)
            mysql = "UPDATE identifiers SET val = (replace(val,':','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%:%') "
            my_cursor.execute (mysql)
            mysql = "UPDATE identifiers SET val = (replace(val,'/','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%/%') "
            my_cursor.execute (mysql)
            mysql = "UPDATE identifiers SET val = (trim(val)) WHERE type = 'isbn'  "
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            #~ ----------
            my_cursor.execute("begin")
            mysql = "UPDATE identifiers SET val = (replace(val,'urn','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%urn%') "
            my_cursor.execute (mysql)
            mysql = "UPDATE identifiers SET val = (replace(val,'ebook','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%ebook%') "
            my_cursor.execute (mysql)
            mysql = "UPDATE identifiers SET val = (replace(val,'eBook','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%eBook%') "
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            #~ ----------
            my_cursor.execute("begin")
            mysql = "UPDATE identifiers SET val = (replace(val,'isbn','')) WHERE val IN(SELECT val FROM identifiers WHERE type = 'isbn' AND val LIKE '%isbn%') "
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            #~ ----------
            if DEBUG: print("All ISBN13s have been standardized by removing any dashes, spaces and prefixes.")
        except Exception as e:
            if DEBUG: print(str(e))
            try:
                my_cursor.execute("commit")
            except:
                pass
    #---------------------------------------------------------------------------------------------------------------------------------------
    def detect_isbn_changes_to_refresh(self,my_db, my_cursor):
        #~ self.quality_fix_isbns_scrubbed_books_list

        mysql = "SELECT book, val FROM identifiers WHERE type = 'isbn' "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            return
        if len(tmp_rows) == 0:
            return

        tmp_rows.sort()

        for row in tmp_rows:
            book,val = row
            mi = self.guidb.new_api.get_metadata(book)
            identifiers_dict = mi.get_identifiers()
            if 'isbn' in identifiers_dict:
                cache_val = identifiers_dict['isbn']
            else:
                cache_val = "NONE"
            if val <> cache_val:
                self.quality_fix_isbns_scrubbed_books_list.append(book)
                if DEBUG: print("book: ", str(book), "  db val: ", str(val), "  cache val: ", str(cache_val))
        #END FOR

        self.quality_fix_isbns_scrubbed_books_list = list(set(self.quality_fix_isbns_scrubbed_books_list))

        if len(self.quality_fix_isbns_scrubbed_books_list) > 0:
            if DEBUG: print("Cache being refreshed from metadata.db due to ISBN key/value changes")
            self.force_refresh_of_cache(self.quality_fix_isbns_scrubbed_books_list)

        self.quality_fix_isbns_scrubbed_books_list[:] = []
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def tickle_auto_adder_watcher_worker(self):
        try:
            global_path = gprefs['auto_add_path']  # os path to be watched by auto_adder
            if not global_path:
                return
            self.tickle_global_path = self.standardize_path_format(global_path)
            if not os.path.isdir(self.tickle_global_path):
                return

            QTimer.singleShot(2, self.do_tickle)

        except Exception as e:
            if DEBUG: print("tickle_auto_adder_watcher_worker",str(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def do_tickle(self):
        try:
            msg = "The Auto-Adder will be tickled for 2 seconds...Wait..."
            self.gui.status_bar.showMessage(msg)
            if DEBUG: print(msg)
            filename_list = []
            for i in xrange(2):
                dummy_filename = "jsdummyfile_" + str(i) + ".tickle"
                self.tickle_global_path = self.tickle_global_path.replace(os.sep, '/')
                dummy_filename = os.path.join(self.tickle_global_path,dummy_filename)
                dummy_filename = dummy_filename.replace(os.sep, '/')
                if isbytestring(dummy_filename):
                    dummy_filename = dummy_filename.decode(filesystem_encoding)
                if DEBUG: print(dummy_filename)
                filename_list.append(dummy_filename)
                f = open(dummy_filename, 'wb')
                f.write("This is a dummy file to tickle the Calibre auto-adder watcher to wake up and start auto-adding...")
                f.close()
                sleep(1.00)
            #END FOR
            QApplication.instance().processEvents()
            msg = "The Auto-Adder has been tickled"
            self.gui.status_bar.showMessage(msg)
            if DEBUG: print(msg)
            for f in filename_list:
                try:
                    os.remove(f)
                except Exception as e:
                    if DEBUG: print("os.remove failed for: ", f, "  ", str(e))
            #END FOR
            del filename_list
        except Exception as e:
            if DEBUG: print("Exception in do_tickle(): ", str(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_cc_based_on_another_cc(self):
        if prefs['GUI_TOOLS_UCCBOACC_ACTIVE'] == unicode("False"):
            return

        cc_list = self.guidb.custom_field_keys()

        if not prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_1'] in cc_list:
            return
        if not prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_1'] in cc_list:
            return

        self.rule_1_is_valid = True

        self.rule_2_is_valid = True
        if not prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_2'] in cc_list:
            self.rule_2_is_valid = False
        if not prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_2'] in cc_list:
            self.rule_2_is_valid = False

        del cc_list

        self.uccboacc_1_source_cc = prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_1']
        self.uccboacc_1_source_cc_value = prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_VALUE_1']
        self.uccboacc_1_target_cc = prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_1']
        self.uccboacc_1_target_cc_value = prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_VALUE_1']

        self.uccboacc_2_source_cc = prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_2']
        self.uccboacc_2_source_cc_value = prefs['GUI_TOOLS_UCCBOACC_SOURCE_CUSTOM_COLUMN_VALUE_2']
        self.uccboacc_2_target_cc = prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_2']
        self.uccboacc_2_target_cc_value = prefs['GUI_TOOLS_UCCBOACC_TARGET_CUSTOM_COLUMN_VALUE_2']

        if DEBUG:
            try:
                print("=====--------------update_cc_based_on_another_cc--------------===== ")
                print("rule_1_is_valid:",self.rule_1_is_valid)
                print(self.uccboacc_1_source_cc)
                print(self.uccboacc_1_source_cc_value)
                print(self.uccboacc_1_target_cc)
                print(self.uccboacc_1_target_cc_value)
                print("rule_2_is_valid:",self.rule_2_is_valid)
                print(self.uccboacc_2_source_cc)
                print(self.uccboacc_2_source_cc_value)
                print(self.uccboacc_2_target_cc)
                print(self.uccboacc_2_target_cc_value)
            except:
                print("some value could not be printed...such as the 'null' symbol...")


        tids = self.get_selected_books()
        if len(tids) == 0:
            del tids
            return

        ids = []
        for id in tids:
            id = int(id)
            ids.append(id)
        #END FOR
        ids.sort()
        del tids
        if DEBUG: print("selected books: ", str(len(ids)))

        self.uccboacc_null = "␀"
        self.uccboacc_asterisk = "*"

        self.custom_columns_metadata_dict = self.maingui.current_db.field_metadata.custom_field_metadata()

        for id in ids:
            self.uccboacc_book_control(id)
        #END FOR

        self.maingui.library_view.model().refresh_ids(ids)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def uccboacc_book_control(self,id):

        value_list = self.uccboacc_get_rule_source_values(1,id)
        passed_filter = self.uccboacc_filter_rule_value(1,value_list)
        if passed_filter:
            self.uccboacc_update_rule_target_value(1,id)

        if self.rule_2_is_valid:
            value_list = self.uccboacc_get_rule_source_values(2,id)
            passed_filter = self.uccboacc_filter_rule_value(2,value_list)
            if passed_filter:
                self.uccboacc_update_rule_target_value(2,id)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def uccboacc_get_rule_source_values(self,rule,id):
        value_list = []

        if rule == 1:
            cc = self.uccboacc_1_source_cc
        else:
            cc = self.uccboacc_2_source_cc

        mi = self.guidb.new_api.get_metadata(id)
        value = mi.get(cc)
        if value is None:
            value_list.append(self.uccboacc_null)
        elif isinstance(value,unicode):  #e.g. comments
            value_list.append(value)
        elif isinstance(value,list):  #e.g. tag-like
            for v in value:
                value_list.append(v)
            #END FOR

        del mi
        del value

        return value_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def uccboacc_filter_rule_value(self,rule,value_list):

        passed_filter = False

        vl_number_rows = len(value_list)

        if vl_number_rows == 0:
            return passed_filter

        if rule == 1:
            criteria = self.uccboacc_1_source_cc_value
        else:
            criteria = self.uccboacc_2_source_cc_value

        criteria_list = []
        criteria = criteria + "|"
        s_split = criteria.split("|")
        for s in s_split:
            s = s.strip()
            if s > " ":
                criteria_list.append(s)
        #END FOR
        del s_split

        if self.uccboacc_null in criteria_list:
            if self.uccboacc_null in value_list:
                passed_filter = True
                return passed_filter

        if self.uccboacc_asterisk in criteria_list:
            if vl_number_rows == 1:
                if self.uccboacc_null in value_list:  #the only value in value_list...
                    passed_filter = False  #because self.uccboacc_null is *not* in criteria_list...
                else:
                    passed_filter = True
                    return passed_filter
            else:
                passed_filter = True
                return passed_filter
        else:
            for criterion in criteria_list:
                if criterion in value_list:
                    passed_filter = True
                    return passed_filter
            #END FOR

        del criteria_list
        del value_list
        del criteria

        return passed_filter
    #---------------------------------------------------------------------------------------------------------------------------------------
    def uccboacc_update_rule_target_value(self,rule,id):

        if rule == 1:
            cc = self.uccboacc_1_target_cc
            value = self.uccboacc_1_target_cc_value
        else:
            cc = self.uccboacc_2_target_cc
            value = self.uccboacc_2_target_cc_value

        mi_field = cc
        mi = Metadata(_('Unknown'))
        custcol = self.custom_columns_metadata_dict[mi_field]
        custcol['#value#']  = value
        mi.set_user_metadata(mi_field, custcol)
        id_map = {}
        id_map[id] = mi
        payload = []
        payload.append(id)
        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=None)
        if DEBUG: print("Rule: ", str(rule), "  edit_metadata_action.apply_metadata_changes        new value for: ", cc, "   is: ", value)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_author_pseudonyms(self,ids=None,source='manual'):
        #~ ---------------------------------------------------------------
        #~ A Calibre book's "Author" may in fact be a pseudonym for a "Real Author".
        #~ The "author" in table _js_pseudonyms is a "Real Author".  The "pseudonym" in table _js_pseudonym is a Calibre book's Author.
        #~ This function finds a Calibre book's Author that matches a Pseudonym in table _js_pseudonyms, and updates a custom column with the "Real Author" for that Pseudonym.
        #~ ---------------------------------------------------------------
        #~                     table _js_pseudonyms
        #~ ---------------------------------------------------------------
        #~ rowid	pseudonym	                    author (real_author)
        #~ ---------------------------------------------------------------
        #~ 369	    Mary Westmacott	        Agatha Christie
        #~ 60	    Bob Hart                        	Al Trace
        #~ 102	    Clem Watts                  	Al Trace
        #~ 16	    Alberto Moravia	            Alberto Pincherle
        #~ 496	    Sonny Powell	                Alfred Bester
        #~ 20	    Algoth Tietäväinen	        Algot Untola
        #~ 233  	Irmari Rantamala	            Algot Untola
        #~ 242	    J.I. Vatanen                      Algot Untola
        #~ 357	    Maiju Lassila                    Algot Untola
        #~ 539	    Väinö Stenberg	            Algot Untola
        #~ 260	    James Tiptree	                Alice Bradley Sheldon
        #~ 437	    Raccoona Sheldon        	Alice Bradley Sheldon
        #~ ---------------------------------------------------------------
        #~ 'Real Author' Custom Column for the Pseudonyms GUI Tool Must Be: Text,Tag-Like, Ampersand Separated People's Names.
        #~ ---------------------------------------------------------------

        if self.pseudonym_matching_in_progress:
            return

        if not ids:
            ids = self.get_selected_books()
            if len(ids) == 0:
                del ids
                msg = "No Books Were Selected"
                return error_dialog(self.gui, _('JS Author Pseudonyms'),_(msg), show=True)

        selected_books_list = []
        for book in ids:
            book = int(book)
            selected_books_list.append(book)
        #END FOR
        del ids

        mi_field = prefs['GUI_TOOLS_AUTHOR_PSEUDONYMS_CUSTOM_COLUMN']

        custom_columns_metadata_dict = self.gui.current_db.field_metadata.custom_field_metadata()

        if not mi_field in custom_columns_metadata_dict:
            del selected_books_list
            del custom_columns_metadata_dict
            del mi_field
            msg = "Customized Pseudonym 'Real Author' Custom Column Does Not Exist in Library: " + mi_field
            if source == 'manual':
                return error_dialog(self.gui, _('Author Pseudonyms'),_(msg), show=True)
            else:
                return info_dialog(self.gui,msg).show()

        self.pseudonym_matching_in_progress = True

        msg = "JS: Matching Calibre Author Pseudonyms to their Real Author Names.  Selected Books: " + str(len(selected_books_list))
        self.gui.status_bar.showMessage(msg)

        custcol = custom_columns_metadata_dict[mi_field]

        del custom_columns_metadata_dict

        is_valid,msg =  self.verify_js_pseudonym_table_exists()
        if not is_valid:
            self.pseudonym_matching_in_progress = False
            return error_dialog(self.gui, _('JS Author Pseudonyms'),_(msg), show=True)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            self.pseudonym_matching_in_progress = False
            return error_dialog(self.gui, _('Author Pseudonyms'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        self.purge_table_selected_books(my_db,my_cursor)

        self.update_table_selected_books(my_db,my_cursor,selected_books_list)

        #~ --------------------------
        pseudonym_author_list = []   # pseudonym,real_author

        mysql = "SELECT pseudonym,author FROM _js_pseudonyms \
                        WHERE pseudonym <> author AND pseudonym NOT NULL AND author NOT NULL;"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            self.pseudonym_matching_in_progress = False
            return error_dialog(self.gui, _('Author Pseudonyms'),_('The JS Pseudonyms Table is empty.  Nothing can be done.'), show=True)
        if len(tmp_rows) == 0:
            self.pseudonym_matching_in_progress = False
            return error_dialog(self.gui, _('Author Pseudonyms'),_('The JS Pseudonyms Table is empty.  Nothing can be done.'), show=True)
        for row in tmp_rows:
            pseudonym,real_author = row
            r = pseudonym,real_author
            pseudonym_author_list.append(r)
        #END FOR
        del tmp_rows

        pseudonym_author_list.sort()
        #~ --------------------------
        author_id_name_dict = {}    # authid = name
        author_id_sort_dict = {}       # authid = sort

        mysql = "SELECT id,name,sort FROM authors \
                       WHERE id IN (SELECT author FROM books_authors_link \
                                             WHERE books_authors_link.author = authors.id \
                                                 AND books_authors_link.book IN (SELECT book FROM _js_selected_books WHERE _js_selected_books.book = books_authors_link.book ) )"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        for row in tmp_rows:
            authid,name,sort = row
            author_id_name_dict[authid] = name
            author_id_sort_dict[authid] = sort
        #END FOR
        del tmp_rows

        if DEBUG:
            n1 = len(author_id_name_dict)
            s1 = str(n1)
            print("Selected Author Count: ", s1)

        #~ --------------------------
        author_id_book_list = []  # row =  authid,book

        mysql = "SELECT book,author FROM books_authors_link \
                       WHERE books_authors_link.book IN (SELECT book FROM _js_selected_books WHERE _js_selected_books.book = books_authors_link.book )"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        for row in tmp_rows:
            book,authid = row
            s = authid,book
            author_id_book_list.append(s)
        #END FOR
        del tmp_rows

        author_id_book_list.sort()

        if DEBUG: print("Number of books/author combinations: ", str(len(author_id_book_list)))

        #~ --------------------------
        #~ Compare Author Names with Pseudonyms, yielding the real_author for very similar values...
        #~ --------------------------
        #~ pseudonym_author_list = []   # pseudonym,real_author
        #~ author_id_name_dict = {}    # authid = name
        #~ author_id_sort_dict = {}      # authid = sort

        matched_author_pseudonyms_results_list = []
        unmatched_authid_name_list = []

        SIMILARITY_MINIMUM = 0.85

        for authid,name in author_id_name_dict.iteritems():  # Mary Westmacott
            match = False
            for row in pseudonym_author_list:
                pseudonym,real_author = row      # Mary Westmacott,Agatha Christie
                p = self.calculate_similarity(name,pseudonym) #Mary Westmacott,Mary Westmacott
                if p >=SIMILARITY_MINIMUM:
                    r = authid,name,real_author,pseudonym   #authid,Mary Westmacott,Agatha Christie,Mary Westmacott
                    matched_author_pseudonyms_results_list.append(r)
                    match = True
                    if DEBUG: print("Pseudonym match:  Book's Author: ", name,"  Pseudonym: ",pseudonym, "   Real Author: ",real_author)
                else:
                    continue
            #END FOR
            if not match:
                r = authid,name  # Mary Westmacott
                unmatched_authid_name_list.append(r)
        #END FOR
        for row in unmatched_authid_name_list:
            authid,name = row
            if authid in author_id_sort_dict:
                sort = author_id_sort_dict[authid]
            else:
                continue
            for row in pseudonym_author_list:
                real_author,pseudonym = row
                p = self.calculate_similarity(sort,pseudonym)
                if p >= SIMILARITY_MINIMUM:
                    r = authid,sort,real_author,pseudonym
                    matched_author_pseudonyms_results_list.append(r)
                    if DEBUG: print("Pseudonym match:  Book's Author: ", sort,"  Pseudonym: ",pseudonym, "   Real Author: ",real_author)
                    break  #a book's author may be a pseudonym for a person, who is the "author" named in table _js_pseudonyms...and there is only 1 possible "author" here...
                else:
                    continue
            #END FOR
        #END FOR
        del unmatched_authid_name_list
        del pseudonym_author_list

        matched_author_pseudonyms_results_list = list(set(matched_author_pseudonyms_results_list))
        matched_author_pseudonyms_results_list.sort()   # r = id,name,sort,pseudonym
        #~ --------------------------
        #~ --------------------------
        #~ multiple Authors could each have a Pseudonym, so the Real Authors custom column must be updated with all of the possible Real Authors for a single book...

        #~ author_id_book_list    row = authid,book

        final_real_authors_dict = {}  #book = list of real authors

        #~ seed the dict for every book
        tmp_list = []  # placeholder for:  real_author_list
        for row in author_id_book_list:
            author_id,book = row
            for row in matched_author_pseudonyms_results_list:
                authid,name,real_author,pseudonym = row
                if author_id <> authid:
                    continue
                if DEBUG: print("authid: ", str(authid), " name: ", name, " real_author: ", real_author, " pseudonym: ", pseudonym)
                if book in final_real_authors_dict:
                    if DEBUG: print("book already in final_real_authors_dict; additional row being added.")
                    tmp_list = final_real_authors_dict[book]
                    tmp_list.append(real_author)
                    final_real_authors_dict[book] = tmp_list
                    del tmp_list
                else:
                    if DEBUG: print("book not in final_real_authors_dict yet; first row will be added.")
                    tmp_list = []
                    tmp_list.append(real_author)
                    final_real_authors_dict[book] = tmp_list
                    del tmp_list
            #END FOR
        #END FOR
        #~ --------------------------
        bookids = []
        for book,real_author_list in final_real_authors_dict.iteritems():
            self.apply_new_pseudonyms(mi_field,custcol,book,real_author_list)
            bookids.append(book)
        #END FOR
        del matched_author_pseudonyms_results_list
        del selected_books_list
        del final_real_authors_dict
        #~ --------------------------
        self.purge_table_selected_books(my_db,my_cursor)
        #~ --------------------------
        my_db.close()
        #~ --------------------------
        if source == 'manual':
            n = len(bookids)
            if n > 0:
                self.maingui.library_view.model().refresh_ids(bookids)
                msg = "JS: " + str(n) + " Books have been updated."
            else:
                msg = "JS: No Matching Pseudonyms Found for any Selected Book."
            self.gui.status_bar.showMessage(msg)
            if DEBUG: print(msg)

        del bookids

        self.pseudonym_matching_in_progress = False
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_new_pseudonyms(self,mi_field,custcol,book,real_author_list):
        #Requires a Tag-Like Custom Column, Ampersand Separated, Like Authors, With Names

        if len(real_author_list) > 1:
            real_author_list = list(set(real_author_list))  #no duplicates
            real_author_list.sort()

        real_author_list_string = ""    # unlike the authors standard column, a string is required and not a list...
        for author in real_author_list:
            real_author_list_string = author + "&" + real_author_list_string
        #END FOR
        real_author_list_string = real_author_list_string[0:-1]

        mi = Metadata(_('Unknown'))
        custcol['#value#']  = real_author_list_string
        mi.set_user_metadata(mi_field, custcol)
        id_map = {}
        id_map[book] = mi
        payload = []
        payload.append(book)
        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=None)

        if DEBUG: print("book: ", str(book), "  new value for: ", mi_field, "   is: ", real_author_list_string)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def verify_js_pseudonym_table_exists(self):

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('Author Pseudonyms'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
            return False

        try:
            my_cursor.execute("begin")
            mysql = "CREATE TABLE _js_pseudonyms (pseudonym TEXT NOT NULL , author TEXT NOT NULL, PRIMARY KEY (pseudonym, author));"
            my_cursor.execute (mysql)
            mysql = "CREATE TABLE _js_selected_books (book INTEGER NOT NULL PRIMARY KEY);"
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            is_valid = False  #if does not already exist, just created but still needs to be seeded with default values
        except:
            is_valid = True   #if already exists, SQL error

        if not is_valid:
            is_valid,msg = self.load_js_pseudonym_table(my_db,my_cursor)
            self.gui.status_bar.showMessage(msg)
            if DEBUG: print(msg)
        else:
            msg = ""

        my_db.close()

        return is_valid,msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    def load_js_pseudonym_table(self,my_db,my_cursor):

        from calibre_plugins.job_spy.sqlobjects_js_pseudonyms import add_js_pseudonyms

        is_valid,msg = add_js_pseudonyms(my_db,my_cursor,DEBUG)

        del add_js_pseudonyms

        if not is_valid:
            msg = "Table Pseudonyms Creation Seeding Error: "  + msg

        return is_valid,msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    def calculate_similarity(self,a,b):
        #returns the probability that string a is the same as string b
        try:
            p = SequenceMatcher(None, a, b).ratio()
            if p:
                return p
            else:
                return 0.0000
        except:
            return 0.0000
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_table_selected_books(self,my_db,my_cursor,selected_books_list):
        try:
            my_cursor.execute("begin")
            mysql = "INSERT OR IGNORE INTO _js_selected_books (book) VALUES(?)"
            for book in selected_books_list:
                my_cursor.execute(mysql,([book]))
            #END FOR
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print("update_table_selected_books [1]: ", str(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def purge_table_selected_books(self,my_db,my_cursor):
        try:
            my_cursor.execute("begin")
            mysql = "DELETE FROM _js_selected_books"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print("purge_table_selected_books: ", str(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def import_pseudonym_csv_file(self):

        if self.pseudonym_matching_in_progress:
            return

        csv_path = self.choose_csv_file_to_import()
        if not csv_path:
            info_dialog(self.gui, 'Import Canceled','No CSV File was was selected; Execution canceled.').show()
            return

        if DEBUG: print("import csv_path selected by user: ", csv_path)

        pseudonyms_csv_list = self.import_csv_file(csv_path)

        n_added = 0

        initials_mode = prefs['GUI_TOOLS_QUALITY_FIXES_UPDATE_AUTHOR_INITIALS_MODE']  # T.S. Elliot or T. S. Elliot or T S Elliot  default is T.S. Elliot

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        try:
            my_cursor.execute("begin")
            mysql = "DROP TABLE IF EXISTS _js_pseudonyms"
            my_cursor.execute(mysql)
            mysql = "DROP TABLE IF EXISTS _js_selected_books"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
            my_cursor.execute("begin")
            mysql = "CREATE TABLE _js_pseudonyms (pseudonym TEXT NOT NULL , author TEXT NOT NULL, PRIMARY KEY (pseudonym, author));"
            my_cursor.execute (mysql)
            mysql = "CREATE TABLE _js_selected_books (book INTEGER NOT NULL PRIMARY KEY);"
            my_cursor.execute (mysql)
            my_cursor.execute("commit")
            my_cursor.execute("begin")
            for row in pseudonyms_csv_list:
                #~ if DEBUG: print("pseudonyms_csv_list row: ", row)
                row = row.replace('" ,','",')          #  must be "," as was exported
                row = row.replace(', "',',"')          #  must be "," as was exported
                s_split = row.split('","')               # split at "," and not  just , due to name formats like  Joe Smith, Jr.
                if not isinstance(s_split,list):
                    if DEBUG: print(">>>>>>>>>error 1: row was not properly formatted to split: ", str(row))
                    continue
                if len(s_split) <> 2:
                    if DEBUG: print(">>>>>>>>>error 2: row was not properly formatted to split: ", str(row))
                    continue
                pseudonym = s_split[0]
                author = s_split[1]
                pseudonym = pseudonym.replace('"','')
                author = author.replace('"','')
                if pseudonym == author:
                    if DEBUG: print("pseudonym: ", pseudonym, "  author: ", author)
                    continue
                if not pseudonym > " ":
                    if DEBUG: print("pseudonym: ", pseudonym, "  author: ", author)
                    continue
                if not author > " ":
                    if DEBUG: print("pseudonym: ", pseudonym, "  author: ", author)
                    continue
                if pseudonym == "Pseudonym" or author == "Author":
                    if DEBUG: print("pseudonym: ", pseudonym, "  author: ", author)
                    continue
                if pseudonym == "pseudonym" or author == "author":
                    if DEBUG: print("pseudonym: ", pseudonym, "  author: ", author)
                    continue
                pseudonym = self.get_formatted_author_initials(initials_mode,pseudonym)
                author = self.get_formatted_author_initials(initials_mode,author)
                mysql = "INSERT OR IGNORE INTO _js_pseudonyms (pseudonym,author) VALUES (?,?)"
                my_cursor.execute(mysql,(pseudonym,author))
                n_added = n_added + 1
            #END FOR
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print("error importing .csv file and then adding new records: ", str(e))

        my_db.close()

        del pseudonyms_csv_list

        msg = "JS: Pseudonyms Table was updated with " + str(n_added) + " row imported from the CSV text file for this Library (only)."
        self.gui.status_bar.showMessage(msg)
        if DEBUG: print(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def choose_csv_file_to_import(self):
        default_user_csv_directory = prefs['GUI_TOOLS_AUTHOR_PSEUDONYMS_DEFAULT_CSV_DIRECTORY']
        import_tuple = QFileDialog.getOpenFileName(None,"Import New Pseudonym Table UTF-8 Encoded CSV Text File ",default_user_csv_directory,("Text File (*pseudonym*.txt)") )
        if not import_tuple:
            return None
        path, dummy = import_tuple
        if not path:
            return None
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        if os.path.isfile(path):
            return path
        else:
            return None
    #---------------------------------------------------------------------------------------------------------------------------------------
    def import_csv_file(self,csv_path):
        pseudonyms_csv_list  = []

        if csv_path == unicode(""):
            if DEBUG: print("csv_path == unicode(""); nothing to do.")
            return pseudonyms_csv_list

        try:
            with open (csv_path,'rb') as csvfile:
                lines = csvfile.readlines()
                for line in lines:
                    pseudonyms_csv_list.append(line)
                    if DEBUG: print("raw csv row: ", str(line))
            #END FOR
            csvfile.close()
            del lines
            del csvfile
            del csv_path
        except Exception as e:
            if DEBUG: print("Import CSV File Error: " + str(e))
            error_dialog(self.gui, _('Import CSV File Error'),_(e), show=True)

        return pseudonyms_csv_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def export_pseudonym_csv_file(self):
        if self.pseudonym_matching_in_progress:
            return

        is_valid,msg =  self.verify_js_pseudonym_table_exists()
        if not is_valid:
            return error_dialog(self.gui, _('JS Author Pseudonyms'),_(msg), show=True)

        msg = self.do_export_of_pseudonym_table()

        self.gui.status_bar.showMessage(msg)
        if DEBUG: print(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def do_export_of_pseudonym_table(self):

        title = "Choose the Directory for the export file' "

        default_user_csv_directory = prefs['GUI_TOOLS_AUTHOR_PSEUDONYMS_DEFAULT_CSV_DIRECTORY']

        chosen_directory_name = QFileDialog.getExistingDirectory(None,title,default_user_csv_directory,QFileDialog.ShowDirsOnly | QFileDialog.DontResolveSymlinks )

        if not chosen_directory_name:
            return

        prefs['GUI_TOOLS_AUTHOR_PSEUDONYMS_DEFAULT_CSV_DIRECTORY'] = chosen_directory_name
        prefs

        head,tail = os.path.split(self.guidb.library_path)
        tail = tail.lower().strip()  # the current calibre library name
        outfilename = "js_pseudonyms_table_exported_from_" + tail + ".txt"    # IMPORTANT:  to guarantee the original UTF-8 encoding is preserved, a .txt is output instead of a .csv so that a text editor is used to open it properly with UTF-8, which does not corrupt it upon opening.  However, it is a comma-separated file.
        outfilename = str(outfilename)

        del head
        del tail

        export_csv_file_full_path = os.path.join(chosen_directory_name,outfilename)
        export_csv_file_full_path = export_csv_file_full_path.replace(os.sep, '/')
        export_csv_file_full_path = export_csv_file_full_path.decode(filesystem_encoding)

        if DEBUG: print("pseudonyms table export file path is: ", export_csv_file_full_path)

        #~ ------------------------------------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
             return error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)

        table_list = []

        mysql = "SELECT pseudonym,author FROM _js_pseudonyms"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        for row in tmp_rows:
            pseudonym,author = row
            if pseudonym:
                if author:
                    if pseudonym <> author:
                        if pseudonym > " " and author > " ":
                            table_list.append(row)
        #END FOR
        del tmp_rows

        #~ ------------------------------------------------------------------
        if os.path.isdir(chosen_directory_name):
            try:
                with open(export_csv_file_full_path, 'wb') as outfile:
                    for row in table_list:
                        pseudonym,author = row
                        r = unicode('"') + pseudonym + unicode('"') + unicode(',') + unicode('"') + author + unicode('"') + "\n"
                        #~ if DEBUG: print(pseudonym,author)
                        outfile.write(r)
                    #END FOR
                outfile.close()
                msg = 'The export of the table was successful.<br><br>File path:'+ export_csv_file_full_path + "<br><br>Number of rows exported: " + str(len(table_list))
                info_dialog(self.gui, 'Export Success',msg).show()
                if DEBUG: print(msg)
                del outfile
            except Exception as e:
                if DEBUG: print("export failure: ", str(e))
                msg = 'The export of the pseudonym table failed due to: ' + str(e)
                info_dialog(self.gui, 'Export Failure',msg).show()
                if DEBUG: print(msg)

        #~ ------------------------------------------------------------------
        n = len(table_list)
        msg = str(n) + " Pseudonyms Exported to: " + str(export_csv_file_full_path)
        #~ ------------------------------------------------------------------
        del table_list
        del export_csv_file_full_path
        del chosen_directory_name

        return msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    def uninstall_pseudonym_table(self):
        if self.pseudonym_matching_in_progress:
            return

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            return error_dialog(self.gui, _('Author Pseudonyms'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
        try:
            my_cursor.execute("begin")
            mysql = "DROP TABLE IF EXISTS _js_pseudonyms"
            my_cursor.execute(mysql)
            mysql = "DROP TABLE IF EXISTS _js_selected_books"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except Exception as e:
            if DEBUG: print("uninstall_pseudonym_table: ", str(e))
        my_db.close()
        msg = "JS: Pseudonyms Table was uninstalled for this Library only.  Reinstallation will be automatic if ever needed."
        self.gui.status_bar.showMessage(msg)
        if DEBUG: print(msg)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_arbitrary_file_dialog(self):
        try:
            self.arbitrary_file_dialog.close()
        except:
            pass
        from calibre_plugins.job_spy.arbitrary_file_dialog import ArbitraryFileDialog
        self.arbitrary_file_dialog = ArbitraryFileDialog(self.gui,self.qaction.icon())
        self.arbitrary_file_dialog.setModal(False)
        self.arbitrary_file_dialog.show()
        del ArbitraryFileDialog
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_save_to_directory_by_library(self,source="library_changed"):
        #~ Calibre saves its last-used save-to directory for Windows in file  C:\Users\username\AppData\Roaming\calibre\dynamic.pickle
         #-------------------------------------
        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY'] == unicode("False"):
            return
        #-------------------------------------
        from calibre.utils.config_base import tweaks
        if not 'job_spy_save_to_directory' in tweaks:
            del tweaks
            if DEBUG: print("'job_spy_save_to_directory' is NOT a key in tweaks; returning; nothing done...")
            msg = "Error in the Tweak 'job_spy_save_to_directory' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_to_directory',msg).show()
        #-------------------------------------
        jsdict = tweaks['job_spy_save_to_directory']
        del tweaks
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak 'job_spy_save_to_directory' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_to_directory',msg).show()
        #----------------
        defaultdir = prefs['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_DIRECTORY_BY_LIBRARY']
        defaultdir = self.standardize_path_format(defaultdir)
        if not os.path.isdir(defaultdir):
            msg = "Error in the Tweak to Save-To Directory: your Default Directory by Library was invalid.<br><br>You should Customize Job Spy preferences for this GUI Tool before proceeding."
            if DEBUG: print(msg)
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_to_directory by Library',msg).show()      #non-modal so does not stop Calibre startup or library switching
        #----------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                newdir = jsdict[libname]
                if DEBUG: print("apply_save_to_directory_by_library:   libname IS tweaked; new directory for: ", libname, "   is: ", newdir)
            else:
                newdir = defaultdir
                if DEBUG: print("apply_save_to_directory_by_library:   libname is NOT tweaked; default directory used for:   ", libname, "   is: ", defaultdir)
        else:
            if DEBUG: print("ERROR in os.path.split(path): ", path, " head: ", str(head), " libname: ", str(libname))
            return
        #----------------
        #~ save_to_disk.py         path = choose_dir(self.gui, 'save to disk dialog', _('Choose destination directory'))
        #~                                                                              'save to disk dialog'  is a key in the in dynamic.pickle dict
        #----------------
        from calibre.utils.config import dynamic      #dynamic >>> class DynamicConfig(dict):
        ans = dynamic.get('save to disk dialog',None)
        if DEBUG:
            if not ans:
                ans = "NOTHING FOUND IN DYNAMIC.PICKLE"
            print("Prior value used for 'save to disk dialog' in dynamic.pickle was:  ", str(ans))

        if not os.path.isdir(newdir):
            newdir = defaultdir
            msg = "Your customized value in Tweaks for this Library is NOT a valid directory. Your customized default directory was used instead: " + defaultdir
            if DEBUG: print(msg)
            info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_to_directory by Library',msg).show()      #non-modal so does not stop Calibre startup or library switching

        if newdir:
            newdir = newdir.replace("/",os.sep)   #the path saved to dynamic.pickle must have the Windows "\", and not  "/"
            dynamic.set('save to disk dialog',newdir)  #does a commit automatically via cPickle.dumps and f.write
            if DEBUG: print("New Save-To Directory for Library:  ",newdir)

        del dynamic
        del jsdict
        del path
        del newdir
        del ans
        del head
        del libname
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_save_to_template_by_library(self,source=None):
        #~ Calibre saves its save_to_template_history for Windows in file  C:\Users\username\AppData\Roaming\calibre\gui.py

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] == unicode("False"):
            if DEBUG: print("--->>>prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY'] = False; nothing to do; returning.")
            return

        defaulttemplate = prefs['GUI_TOOLS_DEFAULT_TWEAK_SAVE_TO_TEMPLATE_BY_LIBRARY']

        if DEBUG: print("--->>>default template is: ", defaulttemplate)

        #-------------------------------------
        from calibre.utils.config_base import tweaks
        if not 'job_spy_save_to_template' in tweaks:
            del tweaks
            if DEBUG: print("--->>>'job_spy_save_to_template' is NOT a key in tweaks; returning; nothing done...")
            msg = "Error in the Tweak 'job_spy_save_to_template' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_to_template',msg).show()
        #-------------------------------------
        jsdict = tweaks['job_spy_save_to_template']
        del tweaks
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("--->>>jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak 'job_spy_save_to_template' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_to_template',msg).show()
        #----------------
        #----------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                newtemplate = jsdict[libname]
                if DEBUG: print("--->>>apply_save_to_template_by_library:   libname IS tweaked; new template for: ", libname, "   is: ", newtemplate)
            else:
                newtemplate = defaulttemplate
                if DEBUG: print("--->>>apply_save_to_template_by_library:   libname is NOT tweaked; default template used for:   ", libname, "   is: ", defaulttemplate)
        else:
            if DEBUG: print("--->>>ERROR in os.path.split(path): ", path, " head: ", str(head), " libname: ", str(libname))
            return
        #----------------
        from calibre.utils.config import Config, StringConfig
        from calibre.gui2.preferences import save_template
        from calibre.library.save_to_disk import DEFAULT_TEMPLATE, DEFAULT_SEND_TEMPLATE, FORMAT_ARGS, config
        c = config(None)
        c.set('template',newtemplate)
        if DEBUG: print("--->>> job_spy_save_to_template was used to set this library's template to: ", newtemplate)

        del c
        del head
        del libname
        del path
        del jsdict
        del defaulttemplate
        del newtemplate
        del Config
        del StringConfig
        del config
        del save_template
        del DEFAULT_TEMPLATE
        del DEFAULT_SEND_TEMPLATE
        del FORMAT_ARGS
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_save_cover_separately_option_by_library(self,source=None):
        #~ Calibre saves its save_cover separately option for Windows in file  C:\Users\username\AppData\Roaming\calibre\gui.py

        if prefs['GUI_TOOLS_ACTIVATE_TWEAK_SAVE_COVER_SEPARATELY_BY_LIBRARY'] == unicode("False"):
            return

        default_value = True

        if DEBUG: print("--->>>job_spy_save_cover_separately default value is: ", default_value)

        #-------------------------------------
        from calibre.utils.config_base import tweaks
        if not 'job_spy_save_cover_separately' in tweaks:
            del tweaks
            if DEBUG: print("--->>>'job_spy_save_cover_separately' is NOT a key in tweaks; returning; nothing done...")
            msg = "Error in the Tweak 'job_spy_save_cover_separately' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_cover_separately',msg).show()
        #-------------------------------------
        jsdict = tweaks['job_spy_save_cover_separately']
        del tweaks
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("--->>>jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak 'job_spy_save_cover_separately' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_save_cover_separately',msg).show()
        #----------------
        #----------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                new_value = jsdict[libname]
                if new_value == unicode("True"):
                    new_value = True
                else:
                    new_value = False
                if DEBUG: print("--->>>apply_save_cover_separately_by_library:   libname IS tweaked; new value for: ", libname, "   is: ", new_value)
            else:
                new_value = default_value
                if DEBUG: print("--->>>apply_save_cover_separately_by_library:   libname is NOT tweaked; default value used for:   ", libname, "   is: ", default_value)
        else:
            if DEBUG: print("--->>>ERROR in os.path.split(path): ", path, " head: ", str(head), " libname: ", str(libname))
            return
        #----------------
        from calibre.utils.config import Config, StringConfig
        from calibre.gui2.preferences import save_template
        from calibre.library.save_to_disk import DEFAULT_TEMPLATE, DEFAULT_SEND_TEMPLATE, FORMAT_ARGS, config
        c = config(None)
        c.set('save_cover',new_value)
        if DEBUG: print("--->>> job_spy_save_cover_separately was used to set this library's value to: ", new_value)

        del c
        del head
        del libname
        del path
        del jsdict
        del default_value
        del new_value
        del Config
        del StringConfig
        del config
        del save_template
        del DEFAULT_TEMPLATE
        del DEFAULT_SEND_TEMPLATE
        del FORMAT_ARGS
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_default_output_format_option_by_library(self,source=None):

        if not prefs['GUI_TOOLS_ACTIVATE_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY'] == unicode("True"):
            return
        #-------------------------------------
        js_default_default = prefs['GUI_TOOLS_DEFAULT_TWEAK_DEFAULT_OUTPUT_FORMAT_BY_LIBRARY']
        if not js_default_default > " ":
            return
        #-------------------------------------
        from calibre.utils.config_base import tweaks
        if not 'job_spy_default_output_format' in tweaks:
            del tweaks
            if DEBUG: print("--->>>'job_spy_default_output_format' is NOT a key in tweaks; returning; nothing done...")
            msg = "Error in the Tweak 'job_spy_default_output_format' in Your Preferences > Tweaks > Plugin Tweaks.<br><br><b>Activated in JS but Tweak is missing.</b><br><br>You should recustomize Job Spy Tweaks and Preferences > Behavior for this GUI Tool before proceeding."
            return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_default_output_format',msg).show()
        #-------------------------------------
        jsdict = tweaks['job_spy_default_output_format']
        del tweaks
        if not isinstance(jsdict,dict): #currently returns a dict
            if DEBUG: print("--->>>jsdict was not a dict")
            jsdict,isvalid = self.convert_string_to_dict(jsdict)
            if not isvalid:
                del jsdict
                msg = "Error in the Tweak 'job_spy_default_output_format' in Your Preferences > Tweaks > Plugin Tweaks value is invalid. <br><br>You should recustomize Job Spy Tweaks and Preferences for this GUI Tool before proceeding."
                return info_dialog(self.gui, 'JS+ GUI Tool: Tweak job_spy_default_output_format',msg).show()
        #-------------------------------------
        path = self.guidb.library_path
        path = self.standardize_path_format(path)
        head,libname = os.path.split(path)
        if libname:
            if libname in jsdict:
                new_format = jsdict[libname]
                if DEBUG: print("--->>>job_spy_default_output_format_by_library:   libname IS tweaked; new value for: ", libname, "   is: ", new_format.lower())
            else:
                new_format = js_default_default
                if DEBUG: print("--->>>job_spy_default_output_format_by_library:   libname is NOT tweaked; default value used for:   ", libname, "   is: ", new_format)
        else:
            if DEBUG: print("--->>>ERROR in os.path.split(path): ", path, " head: ", str(head), " libname: ", str(libname))
            return
        #-------------------------------------
        from calibre.utils.config import prefs as mainprefs
        if DEBUG: old_format = mainprefs.get('output_format')
        mainprefs.set('output_format', new_format.lower())
        if DEBUG: new_format = mainprefs.get('output_format')
        if DEBUG: print("--->>> job spy tweak was used to set this library's default output format from: ", old_format, "   to: ", new_format)
        del mainprefs
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_job_spy_json_backup_file(self):

        dir = prefs['JOB_SPY_JSON_FILE_BACKUP_DIRECTORY']
        title = "Select Directory Where 'Job Spy Customization Backup.json' Should Be Saved"
        dir = QFileDialog.getExistingDirectory(None,title,dir,QFileDialog.ShowDirsOnly | QFileDialog.DontResolveSymlinks )

        if not dir:
            return

        if not os.path.isdir(dir):
            return

        path = dir

        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')

        prefs['JOB_SPY_JSON_FILE_BACKUP_DIRECTORY'] = path
        prefs

        fmt = "%Y-%m-%d_%H-%M-%S     "
        t = str(time.strftime(fmt,time.gmtime(time.time())))   #~ 2018-03-10_13-06-26
        t = t[0:19]

        fname = "Job Spy Backup " + t + ".json"

        path = os.path.join(path, fname)
        dst = path.replace(os.sep, '/')

        path = self.plugin_path
        path = path.replace(".zip",".json")
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        src = path.replace(os.sep, '/')
        if not os.path.isfile(src):
            msg = "ERROR: Job Spy.json Back Up: Source File Not Found:" + src
            if DEBUG: print(msg)
            error_dialog(self.gui, _('JS+ .JSON File Back-Up'),_(msg), show=True)
        else:
            if DEBUG: print("Job Spy.json Back Up: ", src, "  >>>  ", dst)
            import shutil
            shutil.copy(src,dst)
            del shutil
            msg = "Job Spy.json file backed up to: " + dst
            info_dialog(self.gui, 'JS+ .JSON File Back-Up',msg).show()
        del path
        del src
        del dst
        del msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_tagbrowser_custom_icons(self):
        self.tv = self.maingui.tags_view
        self.tvm = self.tv._model
        #~ --------------------------------------------------------------------
        self.state_map_dict = {}
        self.category_list = []
        #~ --------------------------------------------------------------------
        expanded_categories, state_map = self.tv.get_state()
        for category,values in state_map.iteritems():
            if category.startswith("@") or category.startswith("#"):
                self.state_map_dict[category] = values
                self.category_list.append(category)
        #END FOR
        del expanded_categories
        del state_map
        self.category_list.sort()
        #~ --------------------------------------------------------------------
        self.ifc_dict = {}
        #~ --------------------------------------------------------------------
        for category,values in self.state_map_dict.iteritems():
            ifc = self.tvm.index_for_category(category)
            if ifc:
                self.ifc_dict[category] = ifc
        #END FOR
        #~ --------------------------------------------------------------------
        self.ifc_named_path_dict = {}
        #~ --------------------------------------------------------------------
        for category,ifc in self.ifc_dict.iteritems():
            named_path = self.tvm.named_path_for_index(ifc)
            if ifc:
                self.ifc_named_path_dict[ifc] = named_path
        #END FOR
        #~ --------------------------------------------------------------------
        #~ self.index_named_path_dict = {}
        self.index_category_dict = {}
        #~ --------------------------------------------------------------------
        for category in self.category_list:
            ifc = self.ifc_dict[category]
            named_path = self.ifc_named_path_dict[ifc]                             #[u'@MyColors:MyColors']
            index = self.tvm.index_for_named_path(named_path)             #<PyQt5.QtCore.QModelIndex object at 0x0000027BD66AD198>
            if index.isValid():
                self.index_category_dict[category] = index
        #END FOR
        #~ --------------------------------------------------------------------
        self.source_default_icon_dict = {}
        #~ --------------------------------------------------------------------
        self.apply_custom_icons_control()
        #~ --------------------------------------------------------------------
        del self.state_map_dict
        del self.category_list
        del self.ifc_dict
        del self.ifc_named_path_dict
        del self.index_category_dict
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_custom_icons_control(self):

        source_dict = {}

        for category in self.category_list:
            self.current_category = category
            if self.current_category.startswith("@"):
                self.is_ampersand_uc = True
            else:
                self.is_ampersand_uc = False

            if self.is_ampersand_uc:
                use_source_dict = True
                dummy, state_map = self.tv.get_state()
                if self.current_category in state_map:              #~ state_map:  @MyColors >>> {(u'black', u'#mytaglike'): 0, (u'yellow', u'#mytaglike'): 0, (u'blue', u'#mytaglike'): 0, (u'green', u'#mytaglike'): 0}
                    v_dict = state_map[self.current_category]
                    k_list = []
                    for k,v in v_dict.iteritems():
                        k_list = list(k)
                        value = k_list[0]
                        source = k_list[1]
                        source_dict[value] = source                         #~ source:  #real_authors   value:  Julia Pottinger
                        if source.startswith("#"):
                            if source in self.custom_columns_metadata_dict:
                                data_dict = self.custom_columns_metadata_dict[source]
                                is_names = "is_names': True"
                                if is_names in str(data_dict):                    #~ if DEBUG: print(str(data_dict))      # 'display': {u'is_names': True
                                    authors_list = []
                                    authors_list.append(value)                    #already == string_to_authors(authors_string)
                                    author_sort = self.guidb.new_api.author_sort_from_authors(authors_list, key_func=lambda x: x)
                                    source_dict[author_sort] = source        #~ source:  #real_authors   value of values' author-sort:  Pottinger, Julia    #author sort option:    invert
                                    author_sort = author_sort.replace(", "," ")
                                    source_dict[author_sort] = source        #~ source:  #real_authors   value of values' author-sort:  Pottinger Julia     #author sort option:    no comma
                                    source_dict[value] = source                 #~ source:  #real_authors   value of values' author-sort:   Julia Pottinger     #author sort option:    copy as-is
                                    del authors_list
                                    #~ if DEBUG: print("source: ", str(source), "  value of values' author-sort: ", str(author_sort))
                                else:
                                    pass
                                del data_dict
                                dummy = self.get_source_default_icon_file(source)  #builds dict too
                            else:
                                if DEBUG: print("Source Custom Column is NOT in self.custom_columns_metadata_dict......Error: ", source)
                        else:
                            pass
                    #END FOR
                    del v_dict
                    del k_list
                else:
                    pass
                del state_map
                del dummy
            else:
                use_source_dict = False
                cc_source = self.current_category
                dummy = self.get_source_default_icon_file(cc_source)  #builds dict too

            #~ -----------------------

            if self.current_category in self.index_category_dict:
                index = self.index_category_dict[self.current_category]
                for r in xrange(self.tvm.rowCount(index)):
                    child = index.child(r, 0)
                    value = self.tvm.data(child,role=Qt.DisplayRole)
                    if use_source_dict:
                        if value in source_dict:
                            source = source_dict[value]
                        else:
                            if DEBUG: print("UNKNOWN ERROR:   value not in source_dict: ", value, "      ...likely a non-standard author-sort value for an is-names source...")
                            source = "UNKNOWN ERROR"
                    else:
                        source = cc_source
                    new_icon_file = self.get_already_assigned_icon_file_for_value(source,value)
                    if new_icon_file:
                        new_icon = self.create_icon_image_from_file_path(new_icon_file)
                        isvalid = self.tvm.js_change_child_icon(self,self.tvm,child,new_icon,role=Qt.DecorationRole)  #  #~ a monkeypatched generic version of setData to set the value for the decoration role data...........
                        if isvalid:
                            data = self.tvm.data(child,role=Qt.DecorationRole)
                            #~ if DEBUG: print("NEW decoration data for source: ", str(source), "  value: ", str(value), "   data: ", str(data))
                    else:
                        pass
                #END FOR
            else:
                if DEBUG: print("===>>>Skipping an entire category since index was NOT valid: ", self.current_category)
        #END FOR

        del source_dict

        self.tv.repaint()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_decoration_to_tagbrowser(self):
        #~ ---------------------
        jobspyaction = self.restore_treeitem_icons_after_recount
        from calibre_plugins.job_spy.decorated_functions import decorated_tags_view_recount
        decorated_tags_view_recount = decorated_tags_view_recount(self.maingui.tags_view.recount,jobspyaction)
        self.maingui.tags_view.recount = decorated_tags_view_recount
        #~ ---------------------
        self.monkey_patch_tagsviewmodel(self.maingui.tags_view._model)
   #---------------------------------------------------------------------------------------------------------------------------------------
    def monkey_patch_tagsviewmodel(self,tvm):
        def js_change_child_icon(self,tvm,child,new_icon,role=Qt.DecorationRole):
            try:
                node = tvm.get_node(child)
                node.icon_state_map[0] = new_icon               #TagTreeItem.icon_state_map[0] =new_icon
                return True
            except Exception as e:
                if DEBUG: print("js_change_child_icon Exception: ", str(e))
                return False
        #~ -------------------------------------
        tvm.js_change_child_icon = js_change_child_icon
   #---------------------------------------------------------------------------------------------------------------------------------------
    def restore_treeitem_icons_after_recount(self,object=None):  #None is for pyqtsignals that emit something, such as self.maingui.drag_drop_finished (a pyqtsignal, not a function) that was created to handle an object...
        self.apply_tagbrowser_custom_icons()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apply_tagbrowser_recount_delayed(self):
        QTimer.singleShot(100, self.apply_tagbrowser_custom_icons)                 # milliseconds
    #---------------------------------------------------------------------------------------------------------------------------------------
    def ensure_icon_directory_exists(self):
        #~ also used by tagbrowser_icons_dialog.py
        dir = os.path.join(config_dir,'plugins')
        dir =  os.path.join(dir, 'tagbrowser_icons')
        if not os.path.exists(dir):
            os.makedirs(dir)
            if DEBUG: print("directory created: ", dir)
        self.tagbrowser_icon_file_dir = dir
    #-----------------------------------------------------
    #-----------------------------------------------------
    def get_already_assigned_icon_file_for_value(self,source,value):
        #~ also used by tagbrowser_icons_dialog.py
        icon_file_key = self.create_icon_file_key(source,value)
        icon_file = self.get_icon_file_name_for_current_value(icon_file_key)
        if os.path.isfile(icon_file):
            return icon_file
        else:
            if source in self.source_default_icon_dict:
                icon_file = self.source_default_icon_dict[source]
                return icon_file
            else:
                return None
    #-----------------------------------------------------
    #-----------------------------------------------------
    def create_icon_file_key(self,source,value):
        #~ also used by tagbrowser_icons_dialog.py
        icon_file_key = "_" + source + "_" + value + "_"
        icon_file_key = sanitize_file_name_unicode(icon_file_key)
        return icon_file_key
    #-----------------------------------------------------
    #-----------------------------------------------------
    def create_icon_image_from_file_path(self,path,type="icon"):
        #~ also used by tagbrowser_icons_dialog.py
        path = path.replace(os.sep,"/")
        #~ if DEBUG: print("create_icon_image_from_file_path", type, "  ", path)
        if type == "icon":
            p = QIcon(path).pixmap(QSize(20, 20))  # same size as TagBrowser uses...
            icon_image = QIcon(p)                            # QIcon object
            del p
        elif type == "pixmap":
            icon_image = QIcon(path).pixmap(QSize(20, 20))  # QPixMap object
            icon_image.save(path,format = 'PNG',quality = -1)
        else:
            icon_image = None
        return icon_image
    #-----------------------------------------------------
    #-----------------------------------------------------
    def get_icon_file_name_for_current_value(self,icon_file_key):
        #~ also used by tagbrowser_icons_dialog.py
        fname = icon_file_key + ".png"
        icon_file = os.path.join(self.tagbrowser_icon_file_dir,fname)
        icon_file = icon_file.replace(os.sep, '/')
        return icon_file
    #-----------------------------------------------------
    #-----------------------------------------------------
    #-----------------------------------------------------
    def get_source_default_icon_file(self,source):
        value = "default"
        self.source_default_icon_dict[source] = None
        icon_file_key = self.create_icon_file_key(source,value)
        icon_file = self.get_icon_file_name_for_current_value(icon_file_key)
        if icon_file:
            if os.path.isfile(icon_file):
                pixmap = self.create_pixmap_from_icon_file(icon_file)
                if pixmap:
                    self.source_default_icon_dict[source] = icon_file
                    return icon_file
                else:
                    return None
        else:
            return None
    #-----------------------------------------------------
    #-----------------------------------------------------
    def create_pixmap_from_icon_file(self,icon_file):
        pixmap = None
        icon_image = self.create_icon_image_from_file_path(icon_file)
        sizes = icon_image.availableSizes()
        if sizes:
            if len(sizes) == 0:
                pixmap = self.create_icon_image_from_file_path(icon_file,type="pixmap")
            else:
                pixmap = icon_image.pixmap(icon_image.availableSizes()[0])
        else:
            pixmap = self.create_icon_image_from_file_path(icon_file,type="pixmap")
        del icon_image
        del sizes
        return pixmap
    #-----------------------------------------------------
    #-----------------------------------------------------
    #-----------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def customize_tag_browser_icons(self):
        try:
            self.tagbrowsericonsdialog.close()
        except:
            pass

        nothingfound = get_pixmap('images/nothing_found.png')
        filenotfound = get_pixmap('images/filenotfound.png')

        from calibre_plugins.job_spy.tagbrowser_icons_dialog import TagBrowserIconsDialog
        self.tagbrowsericonsdialog = TagBrowserIconsDialog(None,self.maingui,nothingfound,filenotfound,self.tagbrowser_icon_tool_is_running)
        self.tagbrowsericonsdialog.setModal(False)
        self.tagbrowsericonsdialog.show()

        del TagBrowserIconsDialog
        del nothingfound
        del filenotfound
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def remove_identifier_types_tool(self):
        try:
            self.remove_id_types_dialog.close()
        except:
            pass

        from calibre_plugins.job_spy.remove_id_types_dialog import RemoveIdTypesDialog
        self.remove_id_types_dialog = RemoveIdTypesDialog(None,self.maingui,self.restart_remove_id_types_dialog)

        del RemoveIdTypesDialog
    #--------------------------------------------
    #--------------------------------------------
    def restart_remove_id_types_dialog(self):
        #~ sleep(0.25)
        self.remove_identifier_types_tool()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
from PyQt5.Qt import Qt, QCalendarWidget, QLabel, QDate, QVBoxLayout, QPushButton
    #---------------------------------------------------------------------------------------------------------------------------------------
class PopUpCalendar(QDialog):

    def __init__(self,gui,icon,guidb,execute_reset_date_for_selected_books):
        parent = gui
        QDialog.__init__(self, parent)

        self.gui = gui
        self.guidb = guidb

        self.execute_reset_date_for_selected_books = execute_reset_date_for_selected_books

        self.layout_frame = QVBoxLayout()
        self.layout_frame.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout_frame)

        self.my_calendar = QCalendarWidget(self)
        self.my_calendar.setGridVisible(True)
        self.layout_frame.addWidget(self.my_calendar)

        self.today = self.my_calendar.selectedDate().toString("yyyy-MM-dd")

        self.push_button_reset_data = QPushButton("Apply New Date [Selected Books]")
        self.push_button_reset_data.clicked.connect(self.reset_date_for_selected_books)
        self.push_button_reset_data.setDefault(True)
        self.push_button_reset_data.setToolTip("<p style='white-space:wrap'>Apply the chosen date (UTC at 12 Noon) as the new Last-Modified Date.  Future dates will be ignored.")
        self.layout_frame.addWidget(self.push_button_reset_data)

        self.setGeometry(300, 300, 300, 300)
        self.setWindowTitle('New Last-Modified Date')

        self.show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def reset_date_for_selected_books(self):
        d = self.my_calendar.selectedDate()
        new_last_modified_date = d.toString("yyyy-MM-dd")
        if new_last_modified_date > self.today:    # disallow future dates
            return
        self.execute_reset_date_for_selected_books(new_last_modified_date)
    #-------------------------------------------------------------------------------------------------------------------------------------

    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #END of ui.py