# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2016,2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.56"    #Daemon changes

from threading import Thread, Event
import time
from calibre.constants import DEBUG
from calibre_plugins.job_spy.config import prefs
INTERVAL = prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_INTERVAL']
MAXVISIBLEITEMS = 100

#-----------------------------------------------------------------------------------------------
class Abort(Exception):
    pass
#-----------------------------------------------------------------------------------------------
class TweakWidgetPropertiesDaemon(Thread):

    def __init__(self,gui,maingui,myqapplication):
        Thread.__init__(self)
        self.name = "TweakWidgetPropertiesDaemon"
        self.daemon = True
        self.gui = gui
        self.maingui = maingui
        self.stop_running = Event()
        self.already_updated_set = set([])
        self.already_set_criteria = False
        from calibre_plugins.job_spy.gui_objects import JSGetGUIObjects
        self.my_jsgetguiobjects = JSGetGUIObjects(self.gui,self.maingui,myqapplication)
        del JSGetGUIObjects
        s = time.asctime( time.localtime(time.time()) )
        prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_LAST_STARTED'] = unicode(s)
        n = prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_TOTAL_STARTS']
        if isinstance(n,int):
            prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_TOTAL_STARTS'] = int(n + 1)
        else:
            prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_TOTAL_STARTS'] = int(1)
        prefs
        if DEBUG: print("JS+ Tweak Widget Properties Daemon has been STARTED")
    #----------------------------------------
    def stop(self):
        try:
            self.already_updated_set.clear()
        except:
            pass
        try:
            self.stop_running.set()
        except:
            try:
                self.exit()
            except:
                pass
    #----------------------------------------
    def wait(self, interval):
        try:
            if self.stop_running.wait(interval):
                raise Abort()
        except Exception as e:
            if DEBUG: print("JS+ Graceful shutdown of Visible Items Daemon...", str(e))
            try:
                self.exit()
            except:
                pass
    #----------------------------------------
    def run(self):
        try:
            while not self.stop_running.is_set():
                try:
                    self.wait(INTERVAL)
                    try:
                        self.do_tweaks_setmaxvisibleitems()
                        #~ self.do_list_all_current_gui_objects()    # for development use only
                    except Exception as e:
                        self.daemon_run_exception("Source=4  ",e)
                except Abort:
                    if DEBUG: print("Source=Abort Daemon")
                    break
                except Exception as e:
                    if DEBUG: print("Source = 3 daemon:run:while:shutdown_requested: ", str(e))
                    try:
                        self.exit()
                    except:
                        if DEBUG: print("Source=2 daemon self.exit() failed with exception: ", str(e))
                        pass
            #END WHILE
        except Exception as e:
            self.daemon_run_exception("Source=1  ",e)
            try:
                self.exit()
            except Exception as e:
                if DEBUG: print("Source=1 daemon self.exit() failed with exception: ", str(e))
                pass
#-----------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
    def daemon_run_exception(self,source,e):
        if DEBUG: print("def daemon_run_exception: ", source, str(e))
        prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_LAST_FAILURE_SOURCE_EXCEPTION'] = str(source) + str(e)
        prefs['GUI_TOOLS_VISIBLE_ITEMS_EDIT_METADATA_AUTORUN'] = unicode("False")
        s = time.asctime( time.localtime(time.time()) )
        prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_LAST_FAILED'] = unicode(s)
        n = prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_TOTAL_FAILURES']
        if isinstance(n,int):
            prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_TOTAL_FAILURES'] = int(n + 1)
        else:
            prefs['GUI_TOOLS_VISIBLE_ITEMS_DAEMON_TOTAL_FAILURES'] = int(1)
        prefs
#-----------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
    def do_tweaks_setmaxvisibleitems(self):
        try:
            if not self.already_set_criteria:
                #---------------------------------------------------------------------------------------------
                #~ criteria_type:  1 = name; 2 = hasattr; 3 = object_class; NNN = multiple ANDs
                #---------------------------------------------------------------------------------------------
                self.criteria_type = 12      # 1 AND 2
                self.name_criteria_set = set([])
                self.name_criteria_set.add("calibre.gui2.widgets.HistoryLineEdit")
                self.name_criteria_set.add("calibre.gui2.complete2")
                self.name_criteria_set.add("QComboBox")
                self.hasattr_criteria_set =  set([])
                self.hasattr_criteria_set.add("setMaxVisibleItems")
                self.hasattr_criteria_set.add("max_visible_items")
                self.object_class_set =  set([])
                self.iterations = 1
                self.children_level = 1   # sufficient for: 'Edit Metadata' plus *any* QComboBox and QCompleter
                self.already_set_criteria = True
            self.returned_object_set = self.my_jsgetguiobjects.get_objects(self.criteria_type,self.name_criteria_set,self.hasattr_criteria_set,self.object_class_set,self.iterations,self.children_level)
            try:
                if not self.returned_object_set:
                    return
            except:
                return
            #------------------------------------
            #------------------------------------
            #~ self.printsafe("Total returned object items for which to setMaxVisibleItems: " + str(len(self.returned_object_set)))
            try:
                for item in self.returned_object_set:
                    if item:
                        try:
                            key = str(item)
                            #~ if DEBUG: self.printsafe("ClassName: ", item.staticMetaObject.className() + "--" + key + "--" + item.objectName() )
                            if not key in self.already_updated_set:
                                if ( not ".search_box." in key):    #ignore; has its own menu item to change them without needing a daemon...
                                    try:
                                        if hasattr(item, 'setMaxVisibleItems'):
                                            if item.maxCount() < MAXVISIBLEITEMS:
                                                item.setMaxCount(MAXVISIBLEITEMS)
                                            if item.maxVisibleItems() < MAXVISIBLEITEMS:
                                                item.setMaxVisibleItems(MAXVISIBLEITEMS)
                                            try:
                                                item.update()
                                            except:
                                                pass
                                            self.already_updated_set.add(key)
                                            #~ self.printsafe("ClassName: ", item.staticMetaObject.className() + "--" + key + "--" + item.objectName() )
                                            #~ ____________________________________________________________________________________________________________________________________________
                                            #~ As of Version 1.0.12, sets these 'Search & Replace' Tab objects in  'Edit Metadata in Bulk':
                                             #~ ____________________________________________________________________________________________________________________________________________
                                            #~ ClassName:  HistoryLineEdit--<calibre.gui2.widgets.HistoryLineEdit object at 0x000000000B0A91F8>--search_for
                                            #~ ClassName:  HistoryLineEdit--<calibre.gui2.widgets.HistoryLineEdit object at 0x000000000B0A93A8>--replace_with
                                            #~ ClassName:  HistoryLineEdit--<calibre.gui2.widgets.HistoryLineEdit object at 0x000000000B0AA3A8>--test_text
                                            #~ ClassName:  QComboBox--<PyQt5.QtWidgets.QComboBox object at 0x000000000B0A3828>--remove_format
                                            #~ ClassName:  QComboBox--<PyQt5.QtWidgets.QComboBox object at 0x000000000B0A8828>--query_field
                                            #~ ClassName:  QComboBox--<PyQt5.QtWidgets.QComboBox object at 0x000000000B0A8C18>--search_field
                                            #~ ClassName:  QComboBox--<PyQt5.QtWidgets.QComboBox object at 0x000000000B0A8DC8>--search_mode
                                            #~ ClassName:  QComboBox--<PyQt5.QtWidgets.QComboBox object at 0x000000000B0A8F78>--s_r_src_ident
                                            #~ ClassName:  QComboBox--<PyQt5.QtWidgets.QComboBox object at 0x000000000B0A9558>--replace_func
                                            #~ ClassName:  QComboBox--<PyQt5.QtWidgets.QComboBox object at 0x000000000B0A9708>--destination_field
                                            #~ ClassName:  QComboBox--<PyQt5.QtWidgets.QComboBox object at 0x000000000B0A98B8>--replace_mode
                                            #~ ____________________________________________________________________________________________________________________________________________
                                        else:
                                            if hasattr(item, 'max_visible_items'):
                                                item.max_visible_items = MAXVISIBLEITEMS
                                                try:
                                                    item.update()
                                                except:
                                                    pass
                                                self.already_updated_set.add(key)
                                                #~ self.printsafe("ClassName: ", item.staticMetaObject.className() + "--" + key + "--" + item.objectName() )
                                                #~ ____________________________________________________________________________________________________________________________________________
                                                #~ As of Version 1.0.12, sets these 'Edit Metadata for Single Book' and 'Edit Metadata in Bulk' objects:
                                                #~ ____________________________________________________________________________________________________________________________________________                                            #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F259A68>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000FC93678>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000FC93EE8>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F2638B8>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F2694C8>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F269EE8>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F269AF8>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F26D318>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F263D38>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F259558>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F266F78>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F25DB88>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F2633A8>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F25DF78>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F24F318>--
                                                #~ ClassName:  Completer--<calibre.gui2.complete2.Completer object at 0x000000000F25D558>--
                                                #~ ____________________________________________________________________________________________________________________________________________
                                    except Exception as e:  # e.g. object was *just* destroyed
                                        self.already_updated_set.add(key)   # ignore it prospectively
                                        self.printsafe("daemon: set_maxvisibleitems Exception: " + str(item) + str(e))
                                else:
                                    self.already_updated_set.add(key)   # ".search_box."
                            else:
                                pass
                        except Exception as e:
                            self.printsafe("daemon - do_tweaks_setmaxvisibleitems - Failed[0]: "+ str(item) + str(e))
                #END FOR
                try:
                    del self.returned_object_set
                except:
                    pass
            except Exception as e:
                self.printsafe("daemon - do_tweaks_setmaxvisibleitems - Failed[1]: " + str(item) + str(e))
                try:
                    self.exit()
                except:
                    pass
            #------------------------------------
        except Exception as e:
            if DEBUG: print("daemon:do_tweaks_setmaxvisibleitems:exception[0]: ", str(e))
            self.daemon_run_exception("Source=do_tweaks_setmaxvisibleitems  ",e)
            try:
                self.exit()
            except Exception as e:
                if DEBUG: print("Source=do_tweaks_setmaxvisibleitems daemon self.exit() failed with exception: ", str(e))
                pass
            #------------------------------------
#-----------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
    def printsafe(self,*arg):
        if DEBUG:
            try:
                print(arg)
            except:
                pass
#-----------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
    #~ def do_tweaks_other(self):
        #~ return # for future use
#-----------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
    #~ def do_list_all_current_gui_objects(self):
        #~ # for development only...
        #~ try:
            #~ #---------------------------------------------------------------------------------------------
            #~ #criteria_type:  1 = name; 2 = hasattr; 3 = object_class; NNN = multiple ANDs
            #~ #---------------------------------------------------------------------------------------------
            #~ criteria_type = 1
            #~ name_criteria_set = set([])
            #~ name_criteria_set.add("complete")
            #~ hasattr_criteria_set =  set([])
            #~ object_class_set =  set([])
            #~ iterations = 2
            #~ children_level = 2  # extreme - everything (except for the search bar)
            #~ dev_returned_object_set = self.my_jsgetguiobjects.get_objects(criteria_type,name_criteria_set,hasattr_criteria_set,object_class_set,iterations,children_level)
            #~ #------------------------------------
            #~ #------------------------------------
            #~ tmp_list = list(dev_returned_object_set)
            #~ tmp_list.sort()
            #~ try:
                #~ for item in tmp_list:
                    #~ if item:
                        #~ if hasattr(item, 'max_visible_items'):
                            #~ key = str(item)
                            #~ self.printsafe("ClassName: ", item.staticMetaObject.className() + "--" + key + "--" + item.objectName() )
                            #~ item.max_visible_items = 100
                            #~ s = getattr(item, 'max_visible_items', None)
                            #~ self.printsafe(str(s))
                            #~ item.update()
            #~ except:  # caused by closing the dialog exactly when this is trying to change the attribute...
                #~ pass
            #~ del dev_returned_object_set
            #~ del tmp_list
        #~ except Exception as e:
            #~ self.printsafe(str(e))
            #~ pass

#-----------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
# END OF tweak_widget_properties_daemon.py