# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2016, DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.36"

from PyQt5.Qt import ( Qt, QDialog, QRegularExpression, QApplication, QObject, QWidget, QComboBox, QCompleter,
                                         QMetaObject,QMetaProperty, QMainWindow, QTabWidget,
                                         QLayout,QHBoxLayout,QVBoxLayout,QGridLayout)
from calibre.constants import DEBUG
from calibre.gui2.__init__ import ResizableDialog
from calibre.gui2.actions.edit_metadata import EditMetadataAction
from calibre.gui2.actions.edit_collections import EditCollectionsAction
from calibre.gui2.actions import InterfaceAction
from calibre.gui2.complete2 import LineEdit, EditWithComplete, Completer
from calibre.gui2.custom_column_widgets import MultipleWidget, Text, Series, Enumeration, BulkBase, BulkText, BulkSeries, BulkEnumeration
from calibre.gui2.dialogs.metadata_bulk import MetadataBulkDialog
from calibre.gui2.dialogs.metadata_bulk_ui import Ui_MetadataBulkDialog
from calibre.gui2.dialogs.saved_search_editor import SavedSearchEditor
from calibre.gui2.dialogs.search import SearchDialog
from calibre.gui2.main_window import MainWindow
from calibre.gui2.metadata.basic_widgets import AuthorsEdit, SeriesEdit, TagsEdit, PublisherEdit, LanguagesEdit
from calibre.gui2.metadata.single import MetadataSingleDialog, MetadataSingleDialogAlt1, MetadataSingleDialogAlt2
from calibre.gui2.search_box import SearchBox2
from calibre.gui2.ui import Main
from calibre.gui2.widgets import EnComboBox, HistoryLineEdit, ComboBoxWithHelp, LineEditECM, ItemsCompleter, CompleteLineEdit, EnLineEdit
from calibre.gui2.widgets2 import HistoryComboBox, HistoryLineEdit2

SRE = QRegularExpression(".+")

class JSGetGUIObjects(object):

    # Return Calibre's GUI object pointers needed by Job Spy 'GUI Tools' that tweak the attributes of certain GUI objects.

    def __init__(self,gui,main_gui,myqapplication):
        self.gui = gui
        self.main_gui = main_gui
        self.myqapplication = myqapplication
        self.myqapplication_pointer = myqapplication.instance()
        self.tmp_list = []
        s = str("ReadingList")     # *guaranteed* to cause Calibre to 'stop working' when this daemon is running...due to RL's use of pyqtSignals...
        self.tmp_list.append(s)
        s = str("message_box")
        self.tmp_list.append(s)
        s = str(".device.")
        self.tmp_list.append(s)
        s = str(".devices.")
        self.tmp_list.append(s)
        s = str("calibre.ebooks.conversion.")
        self.tmp_list.append(s)
        s = str(".profiles.")
        self.tmp_list.append(s)
        s = str("calibre_plugins")  # *all* plug-ins will be excluded to avoid conflicts...
        self.tmp_list.append(s)
        s = str("JobSpy")
        self.tmp_list.append(s)
        s = str("CustomColumnEditableDialog")  # way too many widgets (1 qcheckbox per cell in its matrix), none of which this daemon needs to look at...
        self.tmp_list.append(s)
        s = str("MultiColumnSearch")  # results tab uses pyqtSignals for combo-box choices...same issue as for RL
        self.tmp_list.append(s)
        s = str("MCSDialog")        # results tab uses pyqtSignals for combo-box choices...same issue as for RL
        self.tmp_list.append(s)
        s = str("MCSResultsTab")  # results tab uses pyqtSignals for combo-box choices...same issue as for RL
        self.tmp_list.append(s)
        s = str("calibre.customize.builtins.Store")
        self.tmp_list.append(s)
        s = str("MetadataReader")
        self.tmp_list.append(s)
        s = str("MetadataWriter")
        self.tmp_list.append(s)
        s = str("QInputDialog")
        self.tmp_list.append(s)
        s = str("QMenu")
        self.tmp_list.append(s)
        s = str("QWizard")
        self.tmp_list.append(s)
        s = str("QAction")
        self.tmp_list.append(s)
        s = str("QUndo")
        self.tmp_list.append(s)
        s = str("QTree")
        self.tmp_list.append(s)
        s = str("QTool")
        self.tmp_list.append(s)
        s = str("QTable")
        self.tmp_list.append(s)
        s = str("QTabWidget")
        self.tmp_list.append(s)
        s = str("Gesture")
        self.tmp_list.append(s)
        s = str("QStyle")
        self.tmp_list.append(s)
        s = str("QStatus")
        self.tmp_list.append(s)
        s = str("QStacked")
        self.tmp_list.append(s)
        s = str("QMessage")
        self.tmp_list.append(s)
        s = str("QList")
        self.tmp_list.append(s)
        s = str("Paint")
        self.tmp_list.append(s)
        s = str("Graphics")
        self.tmp_list.append(s)
        s = str("File")
        self.tmp_list.append(s)
        s = str("Error")
        self.tmp_list.append(s)
        s = str("Spin")
        self.tmp_list.append(s)
        s = str("Date")
        self.tmp_list.append(s)
        s = str("Button")
        self.tmp_list.append(s)
        s = str("Check")
        self.tmp_list.append(s)
        s = str("QThread")
        self.tmp_list.append(s)
        s = str("pyqtSignal")
        self.tmp_list.append(s)

        #~ if DEBUG:
            #~ from calibre.customize.ui import _initialized_plugins as tmp_list2
            #~ for row in tmp_list2:
                #~ s = str(row)
                #~ print(s)
            #~ del tmp_list2

        self.ignore_objects_list = []
        for row in self.tmp_list:
            row = row.lower()
            row = str(row)
            if not row in self.ignore_objects_list:
                self.ignore_objects_list.append(row)
        self.ignore_objects_list.sort()  #so generic Q's are last and a leading period/dot and letters less than Q are first...so loop can be exited more quickly if possible...
        del self.tmp_list

        #~ if DEBUG: print("Total number of object keywords ignored by gui_objects.py: ", str(len(self.ignore_objects_list)))

    def get_objects(self,criteria_type,name_criteria_set,hasattr_criteria_set,object_class_set,iterations,children_level):
        try:
            objects_to_return_set = set([])
            #--------------------------------------------------------------------------------------
            #~ print("Criteria Type: ", str(criteria_type))
            #--------------------------------------------------------------------------------------
            #~ criteria_type:  1 = name; 2 = hasattr; 3 = object_class; NNN = multiple ANDs
            #--------------------------------------------------------------------------------------
            top_set = set([])
            answer_set = set([])
            #------------------------------------
            #------------------------------------
            window_list = self.myqapplication_pointer.topLevelWidgets()
            for window in window_list:
                if window:
                    key = str(window)
                    #~ if DEBUG: print(key)
                    ignore = self.check_ignore_list(key)
                    if ignore:
                        continue
                    top_set.add(window)
            #END FOR
            top_set.add(self.main_gui)
            top_set.add(self.gui)
            desktop = self.myqapplication_pointer.instance().desktop()
            top_set.add(desktop)
            #~ if DEBUG: print("Number of unique topmost objects in top_set: ", str(len(top_set)))
            answer_set = self.get_top_set_children(top_set,answer_set)
            #~ print("Number of unique objects in answer_set: ", str(len(answer_set)))
            for n in range(0,iterations):
                answer_set = self.get_children(answer_set,children_level)
                #~ if DEBUG: print("Iteration: ", str(n+1), " Number of unique objects in answer_set: ", str(len(answer_set)))
            try:
                for item in answer_set:
                    key = str(item)
                    #~ if DEBUG: print("gui_objects.get_objects: ", item.staticMetaObject.className())
                    ignore = self.check_ignore_list(key)
                    if ignore:
                        continue
                    if item:
                        #~ if DEBUG: print(str(item))
                        if criteria_type == 1:
                            if "*" in name_criteria_set:
                                objects_to_return_set.add(item)
                            else:
                                s = str(item)
                                for name in name_criteria_set:
                                    if name in s:
                                        objects_to_return_set.add(item)
                        elif criteria_type == 2:
                            if "*" in hasattr_criteria_set:
                                objects_to_return_set.add(item)
                            else:
                                try:
                                    keep_it = False
                                    for attr in hasattr_criteria_set:
                                        if hasattr(item,attr):
                                            keep_it = True
                                        else:
                                            keep_it = False
                                            break
                                    if keep_it:
                                        objects_to_return_set.add(item)
                                except:  # object was *just* destroyed
                                        pass
                        elif criteria_type == 3:
                            if "*" in object_class_set:
                                objects_to_return_set.add(item)
                            else:
                                try:
                                    if item.staticMetaObject.className() in object_class_set:
                                        objects_to_return_set.add(item)
                                except:  # object was *just* destroyed
                                    pass
                        elif criteria_type == 12:  # 1 AND 2
                            s = str(item)
                            for name in name_criteria_set:             #  1
                                if name in s:
                                    keep_it = False
                                    try:
                                        for attr in hasattr_criteria_set:   #  2
                                            if hasattr(item,attr):
                                                keep_it = True
                                                break
                                            else:
                                                pass
                                        if keep_it:
                                            objects_to_return_set.add(item)
                                    except: # object was *just* destroyed
                                        pass
                    else:
                        pass
            except Exception as e:
                if DEBUG:
                    print("[0] Exception in get_gui_objects: ", str(item), str(e))
            #------------------------------------
            #------------------------------------
        except Exception as e:
            if DEBUG:
                print("[1] EXCEPTION in get_gui_objects: ", str(e))
        try:
            del answer_set
        except:
            pass

        #~ if DEBUG:
            #~ print("returning objects_to_return_set with the following items:")
            #~ for item in objects_to_return_set:
                #~ print(str(item))

        return objects_to_return_set
    #------------------------------------
    #------------------------------------
    #------------------------------------
    def check_ignore_list(self,key):
        key = key.lower()
        ignore = False
        for name in self.ignore_objects_list:
            if name in key:
                ignore = True
                break
        return ignore
    #------------------------------------
    #------------------------------------
    def get_top_set_children(self,top_set,answer_set):
        for anobject in top_set:
            key = str(anobject)
            ignore = self.check_ignore_list(key)
            if ignore:
                continue
            #~ if DEBUG: print("top: ", str(anobject))
            answer_set.add(anobject)
            answer = anobject.findChildren(QDialog,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(MetadataSingleDialog,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(MetadataSingleDialogAlt1,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(MetadataSingleDialogAlt2,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(MetadataBulkDialog,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(Ui_MetadataBulkDialog,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(ResizableDialog,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(QMainWindow,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(MainWindow,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(Main,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(EditMetadataAction,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(EditCollectionsAction,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            answer = anobject.findChildren(InterfaceAction,SRE,Qt.FindChildrenRecursively)
            if answer:
                for item in answer:
                    answer_set.add(item)
            #------------------------
        #END FOR
        del top_set
        return answer_set
    #------------------------------------
    #------------------------------------
    def get_children(self,answer_set,children_level):
        if children_level == 0:
            answer_set = self.get_children_basic(answer_set)                # sufficient for:  Search Bar
        else:
            answer_set = self.get_children_moderate(answer_set)         # sufficient for: 'Edit Metadata' plus *any* QComboBoxes and QCompleters
            if children_level > 1:
                answer_set = self.get_children_extreme(answer_set)        # sufficient for: anything...
        return answer_set
    #------------------------------------
    def get_children_basic(self,answer_set):
        try:
            copy_set = answer_set.copy()
            for anobject in copy_set:
                key = str(anobject)
                ignore = self.check_ignore_list(key)
                if ignore:
                    continue
                answer = anobject.findChildren(SavedSearchEditor,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(SearchDialog,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(SearchBox2,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QComboBox,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                #------------------------
            #END FOR
            del copy_set
        except:
            pass
        return answer_set
    #------------------------------------
    #------------------------------------
    #------------------------------------
    #------------------------------------
    def get_children_moderate(self,answer_set):
        try:
            copy_set = answer_set.copy()
            for anobject in copy_set:
                key = str(anobject)
                ignore = self.check_ignore_list(key)
                if ignore:
                    continue
                answer = anobject.findChildren(QComboBox,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(EnComboBox,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(Completer,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QCompleter,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(EditWithComplete,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(HistoryLineEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                #------------------------
                answer = anobject.findChildren(LineEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(AuthorsEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(SeriesEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(TagsEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(PublisherEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(LanguagesEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                #------------------------
            #END FOR
            del copy_set
        except:
            pass
        return answer_set
    #------------------------------------
    #------------------------------------
    #------------------------------------
    #------------------------------------
    def get_children_extreme(self,answer_set):
        try:
            copy_set = answer_set.copy()
            for anobject in copy_set:
                key = str(anobject)
                ignore = self.check_ignore_list(key)
                if ignore:
                    continue
                answer = anobject.findChildren(QObject,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QWidget,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(ComboBoxWithHelp,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(EnLineEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(CompleteLineEdit,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(ItemsCompleter,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(HistoryComboBox,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(BulkText,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(BulkSeries,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(BulkEnumeration,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(MultipleWidget,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(Text,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(Series,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(Enumeration,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QTabWidget,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QLayout,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QGridLayout,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QHBoxLayout,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                answer = anobject.findChildren(QVBoxLayout,SRE,Qt.FindChildrenRecursively)
                if answer:
                    for item in answer:
                        answer_set.add(item)
                    #------------------------
            #END FOR
            del copy_set
        except:
            pass
        return answer_set
#-----------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
# END OF gui_objects.py