# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2018, DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.129"  # Technical Changes

import os,sys,apsw,ast,copy,json

from PyQt5.Qt import Qt, QDialog, QVBoxLayout, QFont, QWidget, QSize, QPushButton, QComboBox

from calibre import isbytestring
from calibre.constants import preferred_encoding,filesystem_encoding, DEBUG
from calibre.gui2 import gprefs, question_dialog, info_dialog, error_dialog
from calibre.utils.config import to_json, from_json

from calibre_plugins.job_spy.config import prefs

ADD = 'add'
CHANGE = 'change'

#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):

    initial_extra_size = QSize(100, 100)

    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent)
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)

    def resize_dialog(self):
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
            self.save_dialog_geometry()
        else:
            self.restoreGeometry(self.geom)

    def save_dialog_geometry(self):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class CopyVirtualLibrariesDialog(SizePersistedDialog):

    def __init__(self,gui,icon,source_virtual_library_dict,target_library_list):

        parent = gui
        unique_pref_name = 'job_spy:copy_virtual_libraries_dialog'
        SizePersistedDialog.__init__(self, parent, unique_pref_name)

        self.gui = gui

        self.source_virtual_library_dict = source_virtual_library_dict
        self.target_library_list = target_library_list

        self.setWindowTitle('JS+ GUI Tool: Copy Virtual Library to Target Library')
        self.setWindowIcon(icon)

        self.layout = QVBoxLayout()
        self.layout.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout)

        self.setToolTip("<p style='white-space:wrap'>Frequently back up your metadata.db file of your Target Library.")

        font = QFont()
        font.setBold(False)
        font.setPointSize(11)

        self.virtual_libraries_combobox = QComboBox()
        self.virtual_libraries_combobox.setMaximumWidth(500)
        self.virtual_libraries_combobox.setEditable(False)
        self.virtual_libraries_combobox.setFont(font)
        self.virtual_libraries_combobox.setToolTip("<p style='white-space:wrap'>These are the available Virtual Libraries in your Source (Current) Library.")
        self.layout.addWidget(self.virtual_libraries_combobox)

        self.virtual_libraries_combobox.addItem('Choose a Virtual Library')

        self.virtual_library_list = []

        for k,v in self.source_virtual_library_dict.iteritems():
            self.virtual_library_list.append(k)
        #END FOR

        self.virtual_library_list.sort()

        for cat in self.virtual_library_list:
            self.virtual_libraries_combobox.addItem(cat)
        #END FOR

        self.virtual_libraries_combobox.setMaxVisibleItems(len(self.source_virtual_library_dict))

        lastused = prefs['GUI_TOOLS_VIRTUAL_LIBRARIES_COPY_LAST_SOURCE_VIRTUAL_LIBRARY']
        i = self.virtual_libraries_combobox.findText(lastused,Qt.MatchExactly)
        if i >= 0:
            self.virtual_libraries_combobox.setCurrentIndex(i)

        self.layout.addStretch(1)

        self.target_libraries_combobox = QComboBox()
        self.target_libraries_combobox.setMaximumWidth(500)
        self.target_libraries_combobox.setEditable(False)
        self.target_libraries_combobox.setFont(font)
        self.target_libraries_combobox.setToolTip("<p style='white-space:wrap'>These are all of your 'remembered' Calibre Libraries that you may select from to indicate which will be your Target Library.")
        self.layout.addWidget(self.target_libraries_combobox)

        self.target_libraries_combobox.addItem('Choose a Target Library')
        for lib in self.target_library_list:
            self.target_libraries_combobox.addItem(lib)
        #END FOR

        lastused = prefs['GUI_TOOLS_VIRTUAL_LIBRARIES_COPY_LAST_TARGET_LIBRARY']
        i = self.target_libraries_combobox.findText(lastused,Qt.MatchExactly)
        if i >= 0:
            self.target_libraries_combobox.setCurrentIndex(i)

        self.layout.addStretch(4)

        self.push_button_copy_virtual_libraries = QPushButton("Copy the Selected Virtual Library to the Selected Target Library", self)
        self.push_button_copy_virtual_libraries.setMaximumWidth(500)
        self.push_button_copy_virtual_libraries.clicked.connect(self.copy_virtual_libraries)
        self.push_button_copy_virtual_libraries.setFont(font)
        self.push_button_copy_virtual_libraries.setDefault(False)
        self.push_button_copy_virtual_libraries.setToolTip("<p style='white-space:wrap'>This pushbutton will start the copy process.  It will also save the current size and location of this tool's window.")
        self.layout.addWidget(self.push_button_copy_virtual_libraries)

        self.layout.addStretch(3)
        #------------------------------------------------------------------------------------------
        self.push_button_cancel = QPushButton("Exit")
        self.push_button_cancel.setMaximumWidth(500)
        self.push_button_cancel.clicked.connect(self.reject)
        self.push_button_cancel.setDefault(True)
        self.push_button_cancel.setToolTip("<p style='white-space:wrap'>Exit.")
        self.layout.addWidget(self.push_button_cancel)
        #------------------------------------------------------------------------------------------
        self.resize_dialog()
        self.save_dialog_geometry()
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def copy_virtual_libraries(self):

        self.save_dialog_geometry()

        selected_virtual_library = self.virtual_libraries_combobox.currentText()
        if selected_virtual_library == 'Choose a Virtual Library':
            return error_dialog(self.gui, _('JS+ GUI Tool: Copy Virtual Library to Target Library'),_('Choose a Virtual Library.'), show=True)

        selected_target = self.target_libraries_combobox.currentText()
        if selected_target == 'Choose a Target Library':
            return error_dialog(self.gui, _('JS+ GUI Tool: Copy Virtual Library to Target Library'),_('Choose a Target Library.'), show=True)

        if isbytestring(selected_target):
            selected_target = selected_target.decode(filesystem_encoding)
        selected_target = selected_target.replace(os.sep, '/')
        if not os.path.exists(selected_target):
            return error_dialog(self.gui, _('JS+ GUI Tool: Copy Virtual Library to Target Library'),_('Sorry, but the selected Target Library is not a valid directory path.'), show=True)

        prefs['GUI_TOOLS_VIRTUAL_LIBRARIES_COPY_LAST_SOURCE_VIRTUAL_LIBRARY'] = selected_virtual_library
        prefs['GUI_TOOLS_VIRTUAL_LIBRARIES_COPY_LAST_TARGET_LIBRARY'] = selected_target
        prefs

        self.selected_target = selected_target

        if question_dialog(self.gui, "JS+ GUI Tool: Copy Virtual Library to Target Library", "Copy the Selected Virtual Library to the Selected Target Library?"):
            okay,error_msg = self.copy_control(selected_virtual_library,selected_target)
            if okay:
                msg = "Copy of the Selected Virtual Library was Successful to: <br><br>" + selected_target
                msg = msg + "<br><br>Recommended: 'Quick Switch' to the Target Library and confirm the validity of the copied VL."
                info_dialog(self.gui, "JS+ GUI Tool: Copy Virtual Library to Target Library", msg).show()
                if DEBUG: print(msg)
                return
            else:
                if DEBUG: print(error_msg)
                return error_dialog(self.gui, _('JS+ GUI Tool: Copy Virtual Library to Target Library'),_(error_msg), show=True)
        else:
            msg = "Nothing Done."
            info_dialog(self.gui, "JS+ GUI Tool: Copy Virtual Library to Target Library", msg).show()
            if DEBUG: print(msg)
            return
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def copy_control(self,selected_virtual_library,selected_target):

        okay = True
        error_msg = ""

        dbconn_error = self.get_target_preference_key_data(selected_target)
        if dbconn_error:
            okay = False
            error_msg = "Database Connection Error.  Cannot Connect to the Target Library."
            return okay,error_msg

        okay,error_msg = self.update_target_control(selected_virtual_library)

        self.delete_old_objects()

        return okay,error_msg
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def delete_old_objects(self):
        try:
            del selected_virtual_library
            del selected_target
        except:
            pass
        try:
            del self.original_target_virtual_libraries_dict
        except:
            pass
        try:
            del self.revised_target_virtual_libraries_dict
        except:
            pass
        try:
            del self.vl_comparison_was_successful
        except:
            pass
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def get_target_preference_key_data(self,selected_target):
    #-----------------------------------------------------------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_target_library(selected_target)
        if not is_valid:
             error_dialog(self.gui, _('JS+ GUI Tool'),_('Database Connection Error.  Cannot Connect to the Target Library.'), show=True)
             return True
        #-------------------------------------
        #-------------------------------------
        mysql = "SELECT key,val FROM preferences WHERE key = 'virtual_libraries' "
        my_cursor.execute(mysql)
        target_virtual_library_vl_list = my_cursor.fetchall()   #all of them...not just selected_virtual_library...original structure which is a dict...
        if not target_virtual_library_vl_list:
            target_virtual_library_vl_list = []
        self.original_target_virtual_libraries_dict = {}
        for row in target_virtual_library_vl_list:
            key,val = row     # key = 'virtual_libraries'
            val = self.json__raw_to_object(val)
            val = str(val)
            self.original_target_virtual_libraries_dict = ast.literal_eval(val)
            break
        #END FOR
        del target_virtual_library_vl_list
        #-------------------------------------
        #-------------------------------------
        #need the target custom columns to ensure source cc's in the source user category exist in the target...
        mysql = "SELECT label,datatype FROM custom_columns"
        my_cursor.execute(mysql)
        target_custom_column_list = my_cursor.fetchall()
        if not target_custom_column_list:
            target_custom_column_list = []
        self.target_custom_column_dict = {}
        for row in target_custom_column_list:
            label,datatype = row
            self.target_custom_column_dict[label] = datatype
        #END FOR
        del target_custom_column_list
        #-------------------------------------
        my_db.close()

        return False
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def update_target_control(self,selected_virtual_library):
        okay = True
        error_msg = ""
        #-------------------------------
        vl_preexists,vl_action_required,okay,error_msg = self.synthesize_revised_target_virtual_library_key_value(selected_virtual_library)
        if not okay:
            okay = False
            return okay,error_msg
        #-------------------------------
        #-------------------------------
        if not self.vl_comparison_was_successful:  # double-check...
            okay = False
            error_msg = "[UTC1] Program Error: self.vl_comparison_was_successful is ambiguous.  Copy Aborted."
            return okay,error_msg
        #-------------------------------
        msg = "Please review the following facts about the requested copy and then indicate whether to proceed or not."
        msg = msg + "<br><br>The VL already exists in the Target Library:        " + str(vl_preexists)
        msg = msg + "<br><br>The action required for the Target VL:               " + vl_action_required
        msg = msg + "<br><br>Any #names in the VL also exist in the Target?  " + str(self.vl_comparison_was_successful)  # just a teaching factlet for the user...
        msg = msg + "<br><br><br>Do you wish to continue with the actual copy?"

        if not question_dialog(self.gui, "JS+ GUI Tool: Copy Virtual Library to Target Library", msg):
            msg = "Nothing Done."
            info_dialog(self.gui, "JS+ GUI Tool: Copy Virtual Library to Target Library", msg).show()
            okay = True
            error_msg = ""
            return okay,error_msg
        #-------------------------------
        okay,error_msg = self.do_actual_updates_of_target_table_preferences()
        return okay,error_msg
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def synthesize_revised_target_virtual_library_key_value(self,selected_virtual_library):
        vl_action_required = 'none'
        vl_preexists = False
        okay = True
        error_msg = ""

        #~ ----------------------------------------
        #~ self.source_virtual_library_dict
        #~ self.original_target_virtual_libraries_dict
        #~ self.revised_target_virtual_libraries_dict
        #~ ----------------------------------------

        vl_preexists,okay,error_msg = self.compare_existing_target_virtual_library_to_source(selected_virtual_library)

        if not okay:
            vl_preexists = True
            vl_action_required = 'none'
            okay = False
            if error_msg == "":
                error_msg = "[SRTVLKV1] Program Error in self.compare_existing_target_virtual_library_to_source: "
            return vl_preexists,vl_action_required,okay,error_msg
        elif vl_preexists:
                vl_action_required = CHANGE
        else:
            vl_action_required = ADD

        return vl_preexists,vl_action_required,okay,error_msg
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def compare_existing_target_virtual_library_to_source(self,selected_virtual_library):
        okay = True
        error_msg = ""

        self.vl_comparison_was_successful = False

        #~ ----------------------------------------
        #~ self.source_virtual_library_dict
        #~ self.original_target_virtual_libraries_dict
        #~ self.revised_target_virtual_libraries_dict
        #~ ----------------------------------------

        if selected_virtual_library in self.original_target_virtual_libraries_dict:
            vl_preexists = True
        else:
            vl_preexists = False

        self.revised_target_virtual_libraries_dict = copy.deepcopy(self.original_target_virtual_libraries_dict)

        self.revised_target_virtual_libraries_dict[selected_virtual_library] = self.source_virtual_library_dict[selected_virtual_library]

        #~ ----------------------------------------
        source_criteria = self.source_virtual_library_dict[selected_virtual_library]

        if DEBUG: print("source_criteria",source_criteria)

        if "#" in source_criteria:
            source_criteria_list = []
            source_criteria = ":" + source_criteria
            source_criteria_list = source_criteria.split(":")       #     #mytext:false
            for s in source_criteria_list:  #
                s = s.strip()
                if DEBUG: print("source split row: ", str(s))
                if s.startswith("#"):
                    c = s.replace("#","").strip()
                    if s.endswith(":"):
                        s = s[0:-1]
                    if not c in self.target_custom_column_dict:
                        okay = False
                        error_msg = "Source Virtual Library uses a Custom Column that does not exist in the Target Library: " + s   + "  Copy Aborted. "
                        return vl_preexists,okay,error_msg
                    else:
                        pass
                        if DEBUG: print("Source Custom Column also exists in the Target Library:", s)
            #END FOR

        self.vl_comparison_was_successful = True

        return vl_preexists,okay,error_msg
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def do_actual_updates_of_target_table_preferences(self):
        okay = True
        error_msg = ""
        #~ ----------------------------------------
        #~ self.source_virtual_library_dict
        #~ self.original_target_virtual_libraries_dict
        #~ self.revised_target_virtual_libraries_dict
        #~ ----------------------------------------
        if not isinstance(self.revised_target_virtual_libraries_dict,dict):
            okay = False
            error_msg = "[DAUOFTP2] Data Error: revised_target_virtual_libraries_dict is not a valid dict. Nothing done."
            if DEBUG: print(error_msg)
            return okay,error_msg

        if not len(self.revised_target_virtual_libraries_dict) > 0:
            okay = False
            error_msg = "[DAUOFTP3] Data Error: revised_target_virtual_libraries_dict is empty.  Nothing done."
            if DEBUG: print(error_msg)
            return okay,error_msg
        #~ ----------------------------------------
        #~ must mimic what gprefs would end up with in table preferences for the vl keys for their val: pretty-print indented, and unicode now having no u' anywhere.
        #~ ----------------------------------------
        try:
            #give json a real, valid dict to start...
           self.revised_target_virtual_libraries_dict = self.json__to_raw(self.revised_target_virtual_libraries_dict)
           self.revised_target_virtual_libraries_dict = self.json__raw_to_object(self.revised_target_virtual_libraries_dict)
           self.revised_target_virtual_libraries_dict = self.json__to_raw(self.revised_target_virtual_libraries_dict)
        except Exception as e:
            if DEBUG: print(error_msg)
            okay = False
            error_msg = '[DAUOFTP4] JSON self.json__to_raw exception for self.revised_target_virtual_library_dict: ' + str(e)
            return okay,error_msg
        #~ ----------------------------------------
        #~ ----------------------------------------
         #~ ----------------------------------------
        #~ ----------------------------------------
        my_db,my_cursor,is_valid = self.apsw_connect_to_target_library(self.selected_target)
        if not is_valid:
            okay = False
            error_msg = 'Database Connection Error.  Cannot Connect to the Target Library.'
            if DEBUG: print(error_msg)
            return okay,error_msg
        #~ ----------------------------------------
        try:
            my_cursor.execute("begin")
            mysql = "INSERT OR REPLACE INTO preferences (id,key,val) VALUES(null,'virtual_libraries',?)"
            my_cursor.execute(mysql,([self.revised_target_virtual_libraries_dict]))
            my_cursor.execute("commit")
        except Exception as e:
            okay = False
            error_msg = "Target Update Failure.  Reason: " + str(e)
            if DEBUG: print(error_msg)
        #~ ----------------------------------------
        my_db.close()
        #~ ----------------------------------------
        return okay,error_msg
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def json__raw_to_object(self, raw):
        if not isinstance(raw, unicode):
            raw = raw.decode(preferred_encoding)
        return json.loads(raw, object_hook=from_json)
    #-----------------------------------------------------------------------------------------
    def json__to_raw(self, val):
        return json.dumps(val, indent=2, default=to_json)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def apsw_connect_to_target_library(self,selected_target):

        self.selected_target = selected_target

        path = selected_target
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        if isbytestring(path):
            path = path.decode(filesystem_encoding)

        if path.endswith("/"):
            path = path[0:-1]

        try:
            my_db =apsw.Connection(path)
            is_valid = True
        except Exception as e:
            print("path to metadata.db is: ", path)
            print("error: ", str(e))
            is_valid = False
            return None,None,is_valid

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        return my_db,my_cursor,is_valid
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
#END OF copy_virtual_libraries_dialog.py