#!/Python35/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path, sys, platform
from time import sleep
from updater import updateCheck
import options
            
import tkinter as tk
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 

import time
import json

OS = platform.system()

def show_msgbox(title, msg, msgtype='info'):
    """ For general information, warnings and errors
    """
    localRoot = tk.Tk()
    localRoot.withdraw()
    localRoot.option_add('*font', 'Helvetica -12')
    localRoot.quit()
    if msgtype == 'info':
        return(mbox.showinfo(title, msg))
    elif msgtype == 'warning':
        return(mbox.showwarning(title, msg))
    elif msgtype == 'error':
        return(mbox.showerror(title, msg))    
        
def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 75)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))
    
class PrefsEditorGUI(tk.Frame):
    def __init__(self, parent, bk):
        tk.Frame.__init__(self, parent)
        self.parent = parent
        self.bk = bk
        self.parent.title('QuickPrefsEdit')
        centeredWindow(self.parent, 675, 360)
        self.parent.protocol("WM_DELETE_WINDOW", self.onExit)
        self.setup_UI()        
  
    def setup_UI(self):
        
        # add the frame for the text widget
        self.Frame1 = Frame(self, width=550, height=360)
        self.Frame1.grid(sticky='nwes', column=0, row=0,)
  
        # add the text widget
        self.txt = Text(self.Frame1, relief='groove')
        self.txt.config(font=('Courier', 11), undo=True, wrap='word')
        self.txt.grid(row=0, column=0, sticky="nsew", padx=2, pady=2)
    
        # add the vertical scroll bar
        self.scrolly = Scrollbar(self, 
                        orient =VERTICAL, 
                        width  =14,
                        command=self.txt.yview
                        )
        self.scrolly.grid(row=0, column=1, sticky='nswe', pady=2)
        self.txt.config(yscrollcommand=self.scrolly.set)
        
        # mouse roll event
        self.txt.bind_all("<MouseWheel>", self.onMousewheelRoll)
        
        # add the frame for the buttons
        self.Frame2 = Frame(self, 
                        width  = 75,  
                        height = 360, 
                        bg='#ECECEC',  
                        )
        self.Frame2.grid(row=0, column=2, sticky='nsew', padx=2, pady=2)
        
        # simple spacer        
        self.lblSpacer = Label(self.Frame2, 
                        text   ='one', 
                        fg     ='#ECECEC', 
                        bg     ='#ECECEC',
                        font   =('Helvetica', 6)
                            )
        self.lblSpacer.grid(sticky='nwes', column=0, row=0)
        
        # add the buttons
        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', 10), bg='#E0E0E0', width=13, relief=FLAT) 
        SelectButton = ttk.Button(self.Frame2, 
                        text    = "Select", 
                        style   = 'New.TButton', 
                        command = self.onSelect
                        ).grid(sticky='nsew', row=1, column=0, padx=12, pady=1)      
                        
        SaveButton = ttk.Button(self.Frame2, 
                        text    = "Save", 
                        style   = 'New.TButton', 
                        command = self.onSave
                        ).grid(sticky='nsew', row=2, column=0, padx=12, pady=1)                     
        
        ExitButton = ttk.Button(self.Frame2, 
                        text    = "Cancel", 
                        style   = 'New.TButton', 
                        command = self.onExit
                        ).grid(sticky='nsew', row=3, column=0, padx=12, pady=1)          
                        
                        
        self.lblSpacer2 = Label(self.Frame2, 
                        text   ='one', 
                        fg     ='#ECECEC', 
                        bg     ='#ECECEC',
                        font   =('Helvetica', 6)
                            )
        self.lblSpacer2.grid(sticky='nwes', column=0, row=4, pady=100)
        
        self.update_check = BooleanVar()
        self.update_check.set(options.RUN_UPDATE_CHECK)
        chkbUpdateCheck = Checkbutton(self.Frame2, 
                        text     = ' Check for updates',
                        font     = ('Helvetica', 9),
                        bg       = '#ECECEC',                    
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.update_check,                    
                        )
        chkbUpdateCheck.grid(column=0, sticky=E, row=5)                        
                                           
        self.grid_columnconfigure(0, weight=1)
        self.grid_rowconfigure(0, weight=1)   
        self.Frame1.grid_columnconfigure(0, weight=1)
        self.Frame1.grid_rowconfigure(0, weight=1)  
        self.grab_set()      
  
        
    def onMousewheelRoll(self, event):
        if OS == 'Windows':
            self.txt.yview('scroll', -1*(int(event.delta/120)), UNITS)
        
        elif OS == 'Darwin':
            self.txt.yview('scroll', -1*(event.delta), UNITS)
            
        elif OS == 'Linux':
            self.txt.bind('<4>', lambda event : self.txt.xview('scroll', -1, UNITS))
            self.txt.bind('<5>', lambda event : self.txt.xview('scroll', 1, UNITS))    
                    
     
    def onSelect(self):
        
        # clear any previous text in the text widget
        self.txt.delete('1.0', END)
      
        # get the json file path
        options.JSON_FPATH = fdbox.askopenfilename(title='Select JSON File', 
                            parent = self,
                            initialdir = options.PLUGIN_PREFS_DIR, 
                            initialfile= '', 
                            filetypes = [('Text Files', '.json')],
                            defaultextension=".json"
                            )                 
        
        # exit run if cancel is pressed
        if options.JSON_FPATH == '':
            self.parent.destroy()
        
        # get the text data from the json file 
        data = open(options.JSON_FPATH, 'rt', encoding='utf-8').read()
        
        # then add the text data to the text editor
        self.txt.insert(END, data)
        
        self.parent.title('QuickPrefsEdit -- ' + os.path.basename(options.JSON_FPATH))
        
        return(0)       
        
    def onSave(self):
    
        # get the json text data from the editor
        saved_jdata = self.txt.get("1.0",END)
        
        # check for user formatting errors
        if options.JSON_FPATH != '':
            try:
                jtext = json.loads(saved_jdata)
            except ValueError as e:
                print('>>> Error: ' + str(e))
                print('>>> The json data has formatting errors and will not be saved. ' + \
                      'Please try again.\n')                   
                msg = 'Error: ' + str(e) + '\nThe json data has formatting errors and will not be saved. ' +                           'Please try again.'
                show_msgbox('JSON Error', msg, msgtype='error')            
                options.SYS_EXIT = True            
                self.parent.destroy()
                return(0)
            
        prefs = self.bk.getPrefs()      
        if self.update_check.get() == True:
            prefs['run_update_check'] = True
            options.RUN_UPDATE_CHECK = True            
        else:
            prefs['run_update_check'] = False
            options.RUN_UPDATE_CHECK = False              
        self.bk.savePrefs(prefs)
        
        # no text error check
        if options.JSON_FPATH == '':
            msg = 'There was no file selected and no data in the editor. ' + \
                   'First select a json file, modify it, then save it. ' + \
                   'Please try again.'
            show_msgbox('No Data', msg, msgtype='warning')
        else: 
            # save the text data back to the json file   
            if options.SYS_EXIT != True:             
                outfile = options.JSON_FPATH
                outfp = open(outfile, 'wt', encoding='utf-8')
                outfp.writelines(saved_jdata)
                outfp.close()            
                self.txt.delete('1.0', END)
            
        time.sleep(0.25)      
        self.parent.destroy()    
        return(0)          
        
    def onExit(self):
        prefs = self.bk.getPrefs()  
        
        if self.update_check.get() == True:
            prefs['run_update_check'] = True
            options.RUN_UPDATE_CHECK = True            
        else:
            prefs['run_update_check'] = False
            options.RUN_UPDATE_CHECK = False
    
        time.sleep(0.25)    
        self.bk.savePrefs(prefs)    
        self.parent.destroy()     

