#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

#********************************************************************************#
#                                                                                #
# MIT Licence(OSI)                                                               #
# Copyright (c) 2017 Bill Thompson                                               #
#                                                                                #
# Permission is hereby granted, free of charge, to any person obtaining a copy   # 
# of this software and associated documentation files (the "Software"), to deal  # 
# in the Software without restriction, including without limitation the rights   #
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell      #
# copies of the Software, and to permit persons to whom the Software is          #
# furnished to do so, subject to the following conditions:                       # 
#                                                                                #
# The above copyright notice and this permission notice shall be included in all #
# copies or substantial portions of the Software.                                #
#                                                                                # 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR     # 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,       #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE    #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER         # 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  # 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE  # 
# SOFTWARE.                                                                      #
#                                                                                #  
#********************************************************************************#

import os, os.path, sys, shutil, inspect
from tempfile import mkdtemp                  
from dialog import PrefsEditorGUI
import options
from updater import updateCheck
import time
import tkinter as tk
import tkinter.messagebox as mbox


SITE_URL = "https://www.mobileread.com/forums/showpost.php?p=3728675&postcount=1"
PLUGIN_PATH = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))


def show_msgbox(title, msg, msgtype='info'):
    """ For general information, warnings and errors
    """
    localRoot = tk.Tk()
    localRoot.withdraw()
    localRoot.option_add('*font', 'Helvetica -12')
    localRoot.quit()
    if msgtype == 'info':
        return(mbox.showinfo(title, msg))
    elif msgtype == 'warning':
        return(mbox.showwarning(title, msg))
    elif msgtype == 'error':
        return(mbox.showerror(title, msg))

        
def cleanExit(wdir):
    """ Removes the working dir on plugin exit """
    shutil.rmtree(wdir, ignore_errors=True)
    return(0)    
    

def getPluginPrefsDir(bk):
    """ Gets the plugin prefs directory path """
   
    cwd_save = os.getcwd()
    os.chdir(bk._w.plugin_dir)
    os.chdir('..')
    os.chdir('plugins_prefs')
    prefs_dir = os.getcwd()
    os.chdir(cwd_save)
    return(prefs_dir)
    
    
def runPrefsEditorGUI(bk):
    root = tk.Tk()
    root.title('QuickPrefsEdit')
    root.resizable(True, True)
    root.minsize(675, 360)
    root.maxsize(1000, 500)
    root.option_add('*font', 'Arial -12')
    PrefsEditorGUI(root, bk).pack(fill='both', expand=True)
    root.mainloop()
    return(0)        
    
    
def run(bk):  
    print('Python version: ', sys.version, '\n')
    print('Running QuickPrefsEdit...Please wait\n') 
    
    prefs = bk.getPrefs()
    if 'run_update_check' not in prefs:
        prefs['run_update_check'] = False 
    options.RUN_UPDATE_CHECK = prefs['run_update_check']   
    bk.savePrefs(prefs) 
    
    # create a work directory
    WDIR = mkdtemp()
    options.WDIR = WDIR    
    options.PLUGIN_PREFS_DIR = getPluginPrefsDir(bk)
    
    runPrefsEditorGUI(bk)    
    if options.SYS_EXIT == True:
        print('>>> Abort plugin..')
        cleanExit(WDIR)        
        return(-1)
        
    # run version update check       
    if options.RUN_UPDATE_CHECK == True:
        # check for new plugin versions
        latest_version, installed_version = updateCheck(SITE_URL, PLUGIN_PATH)
        if latest_version and latest_version != installed_version:
            options.NEW_PLUGIN_VERSION = True
            options.MSG_NEW_VERSION_AVAILABLE = "A new plugin version is available on MR - v" + latest_version      
        
        # inform user if new plugin version is available
        if options.NEW_PLUGIN_VERSION == True:
            msg = options.MSG_NEW_VERSION_AVAILABLE
            show_msgbox('QuickPrefsEdit', msg, msgtype='info')   
        else:
            msg = 'No new plugin updates were found.'
            show_msgbox('QuickPrefsEdit', msg, msgtype='info')           
            
    print('\n -- Completed SUCCESSFULLY...')
    # remove the temp work dir
    time.sleep(0.25)
    cleanExit(WDIR)
    return(0)                

def main():
    print('I reached main when I should not have\n')
    return(-1)

if __name__ == "__main__":
    sys.exit(main())        