#!/bin/sh
set -x

#get where this script is running and add to path
THISSCRIPTDIR="$( cd "$( dirname "$0" )" >/dev/null && pwd )"
PATH=$THISSCRIPTDIR:$PATH



updateDB () {
	#simulate USB connect/disconnect to update library
	#When the kobo detects USB connection, it seems to disable wifi, so 
	#only run the update after you are finished with uploading/downloading 
	
	echo usb plug add >>/tmp/nickel-hardware-status  # Simulate plugging in the usb
	sleep 8 # Wait 12 sec for user to hit connect, and for any processes to run 
	echo usb plug remove >>/tmp/nickel-hardware-status # Simulate the disconnect of our simulated usb, takes a few sec after the sleep for the change to show up on the device
	
}

intIsUp() {
	#check for ipv4 address of interface
	[ $(ifconfig $1 | grep "inet addr" | wc -l) -gt 0 ] 

}
Y_POS=1
log_message() {
	echo "$*"
	echo "$*" >> "$THISSCRIPTDIR"/sync_gdrive.log
	fbink -S 3 -x 1 -y $Y_POS "\"$*\""
	Y_POS=$(($Y_POS+1))
}
init_error () { 
log_message "Visit this URL to get an authorization code anc copy it in $THISSCRIPTDIR/authcode.txt" echo "https://accounts.google.com/o/oauth2/auth?access_type=offline&client_id=354790962074-7rrlnuanmamgg1i4feed12dpuq871bvd.apps.googleusercontent.com&redirect_uri=urn%3Aietf%3Awg%3Aoauth%3A2.0%3Aoob&response_type=code&scope=https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fdrive"
}

sleep 2;
date > "$THISSCRIPTDIR"/sync_gdrive.log
log_message $(date)
log_message "gdrive sync"
log_message "..."

#read configuration parameters
source "$THISSCRIPTDIR"/config.sh

mkdir -p "$LOCALFOLDER"

#if no /etc/ssl/certs/ca-certificates.crt exists create a new one
#or drive will not be able to authenticate
if [ ! -e /etc/ssl/certs/ca-certificates.crt   ]  ; then 
	log_message "creting ca-certificates.crt" ; 
	mkdir -p  /etc/ssl/certs/
	cp "$THISSCRIPTDIR"/ca-certificates.crt /etc/ssl/certs/; 
fi

if ! intIsUp eth0 ; then
	log_message "eth0 is not connected... exiting"
	return
fi

if [ ! -e "$LOCALFOLDER"/.gd   ]  ; then 
	if [ -e "$THISSCRIPTDIR"/authcode.txt   ]  ; then 
		log_message "authcode.txt found"
		drive init "$LOCALFOLDER" < "$THISSCRIPTDIR"/authcode.txt 
		res=$?
		if [ $res -eq 0 ] ; then 
			log_message "init ok in $LOCALFOLDER"
			init_error
		else 
			log_message "init in $LOCALFOLDER failed"
			init_error
		fi
	else 
		return 
	fi
fi


# cd "$LOCALFOLDER"

#echo y > "$THISSCRIPTDIR"/yes.log 
#echo  >> "$THISSCRIPTDIR"/yes.log 
#drive pull -verbose -exclude-ops "delete" "$LOCALFOLDER/$REMOTEFOLDER" < "$THISSCRIPTDIR"/yes.log 2>&1 | grep -v madvise > "$THISSCRIPTDIR"/drive_pull.log
#drive pull -verbose -exclude-ops "delete" "$LOCALFOLDER/$REMOTEFOLDER" < "$THISSCRIPTDIR"/yes.log >& "$THISSCRIPTDIR"/drive_pull.log
drive pull -no-prompt -verbose -exclude-ops "delete" "$LOCALFOLDER/$REMOTEFOLDER" >& "$THISSCRIPTDIR"/drive_pull.log
res=$?
while read line ; do log_message "$line" ; done < "$THISSCRIPTDIR"/drive_pull.log
log_message "drive pull returned $res"


log_message "forcing DB update"
sleep 5

updateDB 
