#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

#********************************************************************************#
#                                                                                #
# MIT Licence(OSI)                                                               #
# Copyright (c) 2017 Bill Thompson                                               #
#                                                                                #
# Permission is hereby granted, free of charge, to any person obtaining a copy   # 
# of this software and associated documentation files (the "Software"), to deal  # 
# in the Software without restriction, including without limitation the rights   #
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell      #
# copies of the Software, and to permit persons to whom the Software is          #
# furnished to do so, subject to the following conditions:                       # 
#                                                                                #
# The above copyright notice and this permission notice shall be included in all #
# copies or substantial portions of the Software.                                #
#                                                                                # 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR     # 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,       #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE    #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER         # 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  # 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE  # 
# SOFTWARE.                                                                      #
#                                                                                #  
#********************************************************************************#

import os, os.path, sys, shutil, inspect
from tempfile import mkdtemp                  
from cutils import *
from dialog import *
import options
from updater import updateCheck
import tkinter as tk

try:
    from sigil_bs4 import BeautifulSoup
except:
    from bs4 import BeautifulSoup

SITE_URL = "https://www.mobileread.com/forums/showpost.php?p=3715157&postcount=1"
PLUGIN_PATH = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
    
def is_connected():
    try:
        sock = socket.create_connection(('8.8.8.8', 53), 1)
        sock.close()
        return True
    except:
        pass
        
    return False    
    
def runUserDialog1(bk):
    root = tk.Tk()
    root.title('ReworkChapterHeads')
    root.resizable(width=True, height=True)
    UserDialog1(root, bk).pack(fill=tk.BOTH, expand=True)
    root.mainloop()
    return(0)    
    
def runUserDialog2(bk, selected):
    root = tk.Tk()
    root.title('ReworkChapterHeads')
    root.resizable(width=True, height=True)
    UserDialog2(root, bk, selected).pack(fill=tk.BOTH, expand=True)
    root.mainloop()
    return(0)        
    
def run(bk):  
    print('Python version: ', sys.version, '\n')
    print('Running ReworkChapterHeads...Please wait\n') 
   
    """
    if is_connected:
        # check for new plugin versions
        latest_version, installed_version = updateCheck(SITE_URL, PLUGIN_PATH)
        if latest_version and latest_version != installed_version:
            options.NEW_PLUGIN_VERSION = True
            options.MSG_NEW_VERSION_AVAILABLE = "A new version of this plugin is now available from MR - v" + latest_version
    """
    
    # check the epub file
    checkInputFile(bk)
    if options.SYS_EXIT == True:
        print('\n >>> Abort plugin...')
        return(1)
        
    # get selected file list    
    selected_files = list()
    for _, id in bk.selected_iter():
        href = bk.id_to_href(id)
        base = bk.href_to_basename(href)
        selected_files.append(base)        
    
    # check if no files selected    
    if len(selected_files) == 0:
        msg = "You haven't selected any files from the Book Browser. Please try again"
        print('\n>>> Error :' + msg)
        show_msgbox('Error', msg, msgtype='error')
        print('\n >>> Abort plugin...')       
        return(1)
    elif len(selected_files) == 1:
        options.SINGLE_FILE_SELECTED = True
    elif len(selected_files) > 1:
        options.FILE_GROUP_SELECTED = True       
    
    # initialize prefs
    prefs = bk.getPrefs()
    if 'remove_heading_style' not in prefs:
        prefs['remove_heading_style'] = ''
    if 'add_chapter_template' not in prefs:
        prefs['add_chapter_template'] = ''  
    if 'add_heading_style' not in prefs:
        prefs['add_heading_style'] = ''        
    if 'add_chapter_num_style' not in prefs:
        prefs['add_chapter_num_style'] = ''
    if 'add_chapter_num_case' not in prefs:
        prefs['add_chapter_num_case'] = '' 
    if 'add_classes_to_heading_tags' not in prefs:
        prefs['add_classes_to_heading_tags'] = '' 
    if 'add_numbered_headings_only' not in prefs:
        prefs['add_numbered_headings_only'] = ''    
    if 'hide_chapter_text' not in prefs:
        prefs['hide_chapter_text'] = ''     
    bk.savePrefs(prefs)        
    
    # create a working dir
    WDIR = mkdtemp()
    
    # removes existing selected chapter headings
    runUserDialog1(bk)  
    if options.SYS_EXIT == True:
        print('\n >>> Abort plugin...')
        cleanExit(WDIR)
        return(1)
    
    # create chapter heading options dialog
    runUserDialog2(bk, selected_files)    
    if options.SYS_EXIT == True:
        print('\n >>> Abort plugin...')
        cleanExit(WDIR)
        return(1)
    
    # process all plugin tasks
    processAllTasks(bk, WDIR, selected_files)
    if options.SYS_EXIT == True:
        print('\n >>> Abort plugin...')
        cleanExit(WDIR)
        return(1)
      
    msg = "Completed Successfully !!"
    show_msgbox('', msg, msgtype='info')
    print("\n" + msg)
    
    # remove the temp work dir
    cleanExit(WDIR)
    return(0)                

def main():
    print('I reached main when I should not have\n')
    return(-1)

if __name__ == "__main__":
    sys.exit(main())    
    
