#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path
from time import sleep
from updater import updateCheck
import options
            
import tkinter as tk
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 

def show_msgbox(title, msg, msgtype='info'):
    """ For general information, warnings and errors
    """
    localRoot = tk.Tk()
    localRoot.withdraw()
    localRoot.option_add('*font', 'Helvetica -12')
    localRoot.quit()
    if msgtype == 'info':
        return(mbox.showinfo(title, msg))
    elif msgtype == 'warning':
        return(mbox.showwarning(title, msg))
    elif msgtype == 'error':
        return(mbox.showerror(title, msg))
        
        
def populate(self):
    # use last settings
    prefs = self.bk.getPrefs()
    if prefs['add_chapter_template'] != '':
        self.var1.set(prefs['add_chapter_template'])
    if prefs['add_heading_style'] != '':    
        self.cboHeads.set(prefs['add_heading_style'])
    if prefs['add_chapter_num_style'] != '':        
        self.cboNum.set(prefs['add_chapter_num_style'])
    if prefs['add_chapter_num_case'] != '':    
        self.cboCase.set(prefs['add_chapter_num_case'])    
    if prefs['add_classes_to_heading_tags'] != '':
        self.var5.set(', '.join(prefs['add_classes_to_heading_tags']) )
    if prefs['add_numbered_headings_only'] != '':
        self.cboNumOnly.set(prefs['add_numbered_headings_only'])     
    if prefs['hide_chapter_text'] != '':        
        self.cboHide.set(prefs['hide_chapter_text']) 
    self.bk.savePrefs(prefs)
    return(0)
    
def populate2(self):
    # use last settings
    prefs = self.bk.getPrefs()
    if prefs['remove_heading_style'] != '':
        self.cboHeads.set(prefs['remove_heading_style'])
    self.bk.savePrefs(prefs)
    return(0)    
        
def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 75)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))
    
class UserDialog2(tk.Frame):

    def __init__(self, parent, bk, selected):
        tk.Frame.__init__(self, parent, background='#E0E0E0')
        self.parent = parent
        self.bk = bk
        self.selected = selected
        centeredWindow(self.parent, 550, 435)
        parent.minsize(300, 50)
        parent.maxsize(700, 500)
        self.parent.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
       
    def setup_UI(self):
        
        self.labelf1 = LabelFrame(self, text='User Options 2 - Add new heading(s)', 
                        bg     = '#E0E0E0', 
                        font  = ('Helvetica', 10),                        
                        relief = RIDGE
                        )
        self.labelf1.pack(side=TOP, fill=BOTH, expand=True, ipady=27, pady=3, padx=3)
        
        InfoLabel = Label(self.labelf1, text=" ",
                        fg     = '#0000FF',                             
                        bg     = '#E0E0E0', 
                        anchor = W
                        )
        InfoLabel.grid(column=1, sticky=W, row=0, padx=69)       
        
        InfoLabel1 = Label(self.labelf1, text=" ",
                        fg     = '#0000FF',                             
                        bg     = '#E0E0E0', 
                        anchor = W
                        )
        InfoLabel1.grid(columnspan=2, sticky=W, row=1)       
        
        suffixLabel = Label(self.labelf1, 
                        text  = "Add heading name template",
                        font  = ('Helvetica', 10),                        
                        bg    = '#E0E0E0',
                        )
        suffixLabel.grid(row=2, sticky=W, padx=30, pady=5)
        
        self.var1 = StringVar()
        self.var1.set('Chapter')
        self.suffixEntry = Entry(self.labelf1, 
                        font         = ('Helvetica', 10),
                        width        = 20, 
                        textvariable = self.var1, 
                        relief       = FLAT
                        ).grid(sticky=W, row=2, column=1, pady=5)
                        
        lblHeads = Label(self.labelf1, 
                        text     = 'Select heading style',
                        font     = ('Helvetica', 10),
                        justify = CENTER,
                        bg       = '#E0E0E0', 
                        )
        lblHeads.grid(sticky=W, row=3, pady=5, padx=30)  
        
        self.var2 = StringVar()
        self.cboHeads = ttk.Combobox(self.labelf1,  textvariable=self.var2)
        self.cboHeads['values'] = ('Heading 1', 'Heading 2', 'Heading 3', 'Heading 4', 'Heading 5', 'Heading 6')   
        self.cboHeads.current(0)
        self.cboHeads.state(['readonly'])        
        self.cboHeads.grid(column=1, sticky=W, row=3, pady=5)                
        
        headsNum = Label(self.labelf1, 
                        text  = "Select chapter number style",
                        font  = ('Helvetica', 10),                        
                        bg    = '#E0E0E0',
                        )
        headsNum.grid(row=4, sticky=W, padx=30, pady=5)
       
        self.var3 = StringVar()
        self.cboNum = ttk.Combobox(self.labelf1,  textvariable=self.var3)
        self.cboNum['values'] = ('Numeric String', 'Number as Text', 'Roman Numerals')   
        self.cboNum.current(0) 
        self.cboNum.state(['readonly'])          
        self.cboNum.grid(column=1, sticky=W, row=4, pady=5)
              
        lblNumCase = Label(self.labelf1, 
                        text     = 'Select chapter number case',
                        font     = ('Helvetica', 10),
                        justify = CENTER,
                        bg       = '#E0E0E0', 
                        )
        lblNumCase.grid(sticky=W, row=5, pady=5, padx=30)  
        
        self.var4 = StringVar()
        self.cboCase = ttk.Combobox(self.labelf1,  textvariable=self.var4)
        self.cboCase['values'] = ('titlecase', 'uppercase', 'lowercase')   
        self.cboCase.current(0) 
        self.cboCase.state(['readonly'])               
        self.cboCase.grid(column=1, sticky=W, row=5, pady=5)      

        classLabel = Label(self.labelf1, 
                        text  = "Add classes to heading tag(s)",
                        font  = ('Helvetica', 10),                        
                        bg    = '#E0E0E0',
                        )
        classLabel.grid(row=6, sticky=W, padx=30, pady=5)
        
        self.var5 = StringVar()
        self.classEntry = Entry(self.labelf1, 
                        font         = ('Helvetica', 10),
                        width        = 20, 
                        textvariable = self.var5, 
                        relief       = FLAT
                        ).grid(sticky=W, row=6, column=1, pady=5)      
                        
        lblNumOnly = Label(self.labelf1, 
                        text     = 'Use numbered headings only',
                        font     = ('Helvetica', 10),
                        justify = CENTER,
                        bg       = '#E0E0E0', 
                        )
        lblNumOnly.grid(sticky=W, row=7, pady=5, padx=30)  
        
        self.var7 = StringVar()
        self.cboNumOnly = ttk.Combobox(self.labelf1,  textvariable=self.var7)
        self.cboNumOnly['values'] = ('No', 'Yes')   
        self.cboNumOnly.current(0)   
        self.cboNumOnly.state(['readonly'])               
        self.cboNumOnly.grid(column=1, sticky=W, row=7, pady=5)                                

        lblHide = Label(self.labelf1, 
                        text     = 'Hide heading(s)',
                        font     = ('Helvetica', 10),
                        justify = CENTER,
                        bg       = '#E0E0E0', 
                        )
        lblHide.grid(sticky=W, row=8, pady=5, padx=30)  
        
        self.var6 = StringVar()
        self.cboHide = ttk.Combobox(self.labelf1,  textvariable=self.var6)
        self.cboHide['values'] = ('No', 'Yes')   
        self.cboHide.current(0)   
        self.cboHide.state(['readonly'])               
        self.cboHide.grid(column=1, sticky=W, row=8, pady=5)                         
              
        InfoLabel2 = Label(self.labelf1, 
                        text   = "",
                        fg     = '#E0E0E0',                         
                        bg     = '#E0E0E0', 
                        anchor = S
                        )
        InfoLabel2.grid(row=9, columnspan=2, sticky=E)     

        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', 10), background='#E0E0E0', width=15, relief=FLAT) 
        okButton = ttk.Button(self.labelf1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        ).grid(row=10, columnspan=2, sticky=W, padx=210, pady=7)
        
        #**** Create the statusbar *****#
        self.status = Label(self.labelf1, text=" ",
                        font     = ('Helvetica', 10),
                        relief = FLAT,
                        bg     = '#E0E0E0',
                        fg     = '#0000FF',
                        anchor = E
                        )
        self.status.grid(row=11, columnspan=2, padx=5, pady=5, sticky=W) 

        # show new plugin version msg if available
        if options.NEW_PLUGIN_VERSION == True:
            centeredWindow(self.parent, 430, 385)   
            self.status.config(text=options.MSG_NEW_VERSION_AVAILABLE) 
        
        populate(self)
        
        if options.SINGLE_FILE_SELECTED == True:
            prefs = self.bk.getPrefs()
            InfoLabel.config(text="SINGLE FILE", font  = ('Helvetica', 9))
            if self.var1.get() != prefs['add_chapter_template'] and \
                prefs['add_chapter_template'] != '':
                sel.var1.set(prefs['add_chapter_template'])                
                             
        elif options.FILE_GROUP_SELECTED == True:
            prefs = self.bk.getPrefs()
            InfoLabel.config(text="FILE GROUP", font  = ('Helvetica', 9)) 
            if self.var1.get() != prefs['add_chapter_template'] and \
                prefs['add_chapter_template'] != '':
                sel.var1.set(prefs['add_chapter_template'])                  
        
        # do not allow these options for single file selection
        if len(self.selected) == 1:          
            self.cboNum.set('Not Available')
            self.cboNum.config(state=DISABLED) 
            self.cboCase.set('Not Available')
            self.cboCase.config(state=DISABLED)   
            self.cboNumOnly.set('Not Available')   
            self.cboNumOnly.config(state=DISABLED)            
        
        self.grab_set()   

    def onOK(self):  
        
        # save settings     
        options.SUFFIX_CHOICE = self.var1.get().strip()
        options.HEADING_STYLE_CHOICE = self.cboHeads.get()
        options.NUM_STYLE_CHOICE = self.cboNum.get()
        options.WORD_CASE_CHOICE = self.cboCase.get()
        options.ADD_CLASSES  = self.var5.get().replace(',', ' ').split()
        options.NUM_HEADINGS_CHOICE= self.cboNumOnly.get()
        options.HIDE_HEADING_CHOICE = self.cboHide.get()
        
        # ensure no heading name if 
        # numbered headings is chosen
        if options.NUM_HEADINGS_CHOICE == 'Yes':
            options.SUFFIX_CHOICE = ''

        # add current settings to json file
        prefs = self.bk.getPrefs()
        
        prefs['add_chapter_template'] = options.SUFFIX_CHOICE
        prefs['add_heading_style'] = options.HEADING_STYLE_CHOICE\
        
        if options.NUM_STYLE_CHOICE == 'Not Available':
            prefs['add_chapter_num_style'] = 'Numeric String'
        else:        
            prefs['add_chapter_num_style'] = options.NUM_STYLE_CHOICE
        
        if options.WORD_CASE_CHOICE == 'Not Available':
            prefs['add_chapter_num_case'] = 'titlecase' 
        else:    
            prefs['add_chapter_num_case'] = options.WORD_CASE_CHOICE
        
        if options.NUM_HEADINGS_CHOICE == 'Not Available':
            prefs['add_numbered_headings_only'] = 'No'
        else:
            prefs['add_numbered_headings_only'] = options.NUM_HEADINGS_CHOICE
            
        if len(prefs['add_classes_to_heading_tags']) != 0:    
            prefs['add_classes_to_heading_tags'] = []
        
        prefs['hide_chapter_text'] = options.HIDE_HEADING_CHOICE
        
        self.bk.savePrefs(prefs) 
        self.parent.destroy()    
     
    def onCancel(self):
        options.SYS_EXIT = True
        self.parent.destroy()  


class UserDialog1(tk.Frame):

    def __init__(self, parent, bk):
        tk.Frame.__init__(self, parent, background='#E0E0E0')
        self.parent = parent
        self.bk= bk
        centeredWindow(self.parent, 505, 200)
        parent.minsize(300, 50)
        parent.maxsize(700, 450)
        self.parent.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
       
    def setup_UI(self):
        
        self.labelf1 = LabelFrame(self, text='User Options 1 - Remove heading(s)', 
                        bg     = '#E0E0E0', 
                        font  = ('Helvetica', 10),                        
                        relief = RIDGE
                        )
        self.labelf1.pack(side=TOP, fill=BOTH, expand=True, ipady=27, pady=3, padx=3)
        
        InfoLabel = Label(self.labelf1, text=" ",
                        fg     = '#0000FF',                         
                        bg     = '#E0E0E0', 
                        anchor = E
                        )
        InfoLabel.grid(column=1, sticky=W, row=0,padx=322)      

        InfoLabel1 = Label(self.labelf1, text=" ",
                        fg     = '#0000FF',                             
                        bg     = '#E0E0E0', 
                        anchor = W
                        )
        InfoLabel1.grid(column=1, sticky=W, row=1,padx=15)         
                        
        lblHeads = Label(self.labelf1, 
                        text     = 'Remove heading(s) formatted with',
                        font     = ('Helvetica', 10),
                        justify = CENTER,
                        bg       = '#E0E0E0', 
                        )
        lblHeads.grid(column=1, sticky=W, row=2, pady=5, padx=35)  
        
        self.var1 = StringVar()
        self.cboHeads = ttk.Combobox(self.labelf1,  textvariable=self.var1)
        self.cboHeads['values'] = ('Heading 1', 'Heading 2', 'Heading 3', 'Heading 4', 'Heading 5', 'Heading 6')   
        self.cboHeads.current(0) 
        self.cboHeads.state(['readonly'])               
        self.cboHeads.grid(column=1, sticky=W, row=2, padx=290, pady=5)                  
           
        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', 10), background='#E0E0E0', width=12, relief=FLAT) 
        okButton = ttk.Button(self.labelf1, 
                        text    = "Remove", 
                        style   = 'New.TButton', 
                        command = self.onRemove
                        ).grid(row=3, column=1, sticky=W, padx=110, pady=22)
                 
        skipButton = ttk.Button(self.labelf1, 
                        text    = "Skip", 
                        style   = 'New.TButton', 
                        command = self.onSkip
                        ).grid(row=3, column=1, sticky=W, padx=240, pady=22)                
        
        #**** Create the statusbar *****#
        self.status = Label(self.labelf1, text=" ",
                        font     = ('Helvetica', 10),
                        relief = FLAT,
                        bg     = '#E0E0E0',
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.grid(row=4, column=1, padx=5, pady=5, sticky=W)
        
        populate2(self)
        
        if options.SINGLE_FILE_SELECTED == True:
            InfoLabel.config(text="SINGLE FILE", font  = ('Helvetica', 9))             
        elif options.FILE_GROUP_SELECTED == True:
            InfoLabel.config(text="FILE GROUP", font  = ('Helvetica', 9))
           
        self.grab_set()   

    def onRemove(self):    
        options.REMOVE_HEADING_CHOICE = self.cboHeads.get()
        prefs = self.bk.getPrefs()
        prefs['remove_heading_style'] = options.REMOVE_HEADING_CHOICE
        self.bk.savePrefs(prefs)
        self.parent.destroy()    
      
    def onSkip(self):
        options.REMOVE_HEADING_CHOICE = ''
        self.parent.destroy()  
    
    def onCancel(self):
        options.SYS_EXIT = True
        self.parent.destroy()      
  
