#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path
from time import sleep
from updater import updateCheck
import options
            
import tkinter as tk
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 

def show_msgbox(title, msg, msgtype='info'):
    """ For general information, warnings and errors
    """
    localRoot = tk.Tk()
    localRoot.withdraw()
    localRoot.option_add('*font', 'Helvetica -12')
    localRoot.quit()
    if msgtype == 'info':
        return(mbox.showinfo(title, msg))
    elif msgtype == 'warning':
        return(mbox.showwarning(title, msg))
    elif msgtype == 'error':
        return(mbox.showerror(title, msg))

def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 75)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))
    
class UserDialog(tk.Frame):

    def __init__(self, parent):
        tk.Frame.__init__(self, parent, background='#E0E0E0')
        self.parent = parent
        centeredWindow(self.parent, 430, 220)
        parent.minsize(300, 50)
        parent.maxsize(700, 450)
        self.parent.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
       
    def setup_UI(self):
        
        self.labelf1 = LabelFrame(self, text='User Options', 
                        bg     = '#E0E0E0', 
                        font  = ('Helvetica', 10),                        
                        relief = RIDGE
                        )
        self.labelf1.pack(side=TOP, fill=BOTH, expand=True, ipady=27, pady=3, padx=3)
        
        InfoLabel = Label(self.labelf1, text=" ",
                        fg     = '#000000',                         
                        bg     = '#E0E0E0', 
                        anchor = E
                        )
        InfoLabel.grid(columnspan=2, sticky=E, row=0,padx=10)       
        
        suffixLabel = Label(self.labelf1, 
                        text  = "Type heading suffix",
                        font  = ('Helvetica', 10),                        
                        bg    = '#E0E0E0',
                        )
        suffixLabel.grid(row=1, column=1, sticky=W, padx=90, pady=5)
        
        self.var3 = StringVar()
        self.var3.set('Chapter')
        self.htypeEntry = Entry(self.labelf1, 
                        font         = ('Helvetica', 10),
                        width        = 12, 
                        textvariable = self.var3, 
                        relief       = FLAT
                        ).grid(sticky=W, row=1, column=1, pady=5, padx=230)

        
        headsSuffix = Label(self.labelf1, 
                        text  = "Chapter number type",
                        font  = ('Helvetica', 10),                        
                        bg    = '#E0E0E0',
                        )
        headsSuffix.grid(row=2, column=1, sticky=W, padx=90, pady=5)
        
        self.var2 = StringVar()
        self.optionNum = ttk.OptionMenu(self.labelf1,  self.var2, options.NUM_STYLE[0], *options.NUM_STYLE)  
        self.optionNum.grid(column=1, sticky=W, row=2, padx=230, pady=5)
        
        lblHeads = Label(self.labelf1, 
                        text     = 'Heading style',
                        font     = ('Helvetica', 10),
                        justify = CENTER,
                        bg       = '#E0E0E0', 
                        )
        lblHeads.grid(column=1, sticky=W, row=3, pady=5, padx=90)  
        
        self.var1 = StringVar()
        s = ttk.Style()
        s.configure("TOptionMenu", font=('Helvetica', 10),width=12)      
        self.optionHeads = ttk.OptionMenu(self.labelf1,  self.var1, options.HEADING_STYLE[0], *options.HEADING_STYLE)  
        self.optionHeads.grid(column=1, sticky=W, row=3, padx=230, pady=5)
              
      
        InfoLabel2 = Label(self.labelf1, 
                        text   = "",
                        fg     = '#E0E0E0',                         
                        bg     = '#E0E0E0', 
                        anchor = S
                        )
        InfoLabel2.grid(row=4, columnspan=2, sticky=E)     

        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', 10), background='#E0E0E0', width=12, relief=FLAT) 
        okButton = ttk.Button(self.labelf1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        ).grid(row=5, columnspan=2, sticky=W, padx=170, pady=7)
        
        #**** Create the statusbar *****#
        self.status = Label(self.labelf1, text=" ",
                        font     = ('Helvetica', 10),
                        relief = FLAT,
                        bg     = '#E0E0E0',
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.grid(row=6, column=1, padx=5, pady=5, sticky=W) 

        # show new plugin version msg if available
        if options.NEW_PLUGIN_VERSION == True:
            centeredWindow(self.parent, 430, 195)   
            self.status.config(text=options.MSG_NEW_VERSION_AVAILABLE) 
       
        #self.htypeEntry.focus_set()
        self.grab_set()      

    def onOK(self):    
        
        options.HEADING_STYLE = self.var1.get()
        options.NUM_STYLE = self.var2.get()
        options.SUFFIX = self.var3.get()
        self.parent.destroy()    
     
    def onCancel(self):
        options.SYS_EXIT = True
        self.parent.destroy()      
        
        
