#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path, sys, shutil, inspect, re
import options
from PIL import Image
from decimal import *  
import tkinter as tk
import tkinter.messagebox as mbox

try:
    from sigil_bs4 import BeautifulSoup, Comment, Tag
except:
    from bs4 import BeautifulSoup, Comment, Tag
    
    
__all__=["processAllTasks", "copyTextFiles2Dir", "writeFiles2Epub", "show_msgbox", "cleanExit", "prettifyXHTMLFile", "svgAttributes2CamelCase", "AddHeadings"]

def processAllTasks(bk, wdir, t_ids, t_fnames):
    print('\n -- Processing automatic tasks...')
    count = 0
    for fname in t_fnames:
        if 'cover.xhtml' in fname or 'TOC.xhtml' in fname:
            continue
        else:   
            print('\n -- Processing next file...' + fname + '\n')
            file = os.path.join(wdir, fname)
            count = AddHeadings(wdir, file, count)

            # exit on error
            if options.SYS_EXIT == True:
                return(0)
    
            # reformat the svg attributes to appropriate camel case
            svgAttributes2CamelCase(wdir, file)
            prettifyXHTMLFile(wdir, file)     # prettify the html
            
    
    # write files back to the epub         
    writeFiles2Epub(bk, wdir, t_ids, t_fnames)
    return(0)
    
def copyTextFiles2Dir(bk, wdir):

    print('\n -- In copyTextFiles2Dir()...')
    t_ids = list()
    t_hrefs = list()
    t_fnames = list()
    
    for (id, href) in bk.text_iter():
        t_ids.append(id)
        t_hrefs.append(href)
        t_fnames.append(os.path.basename(href))
    
    # copy all xhtml files to the working dir    
    file = str()
    t_fnames_r = list()
    t_ids_r = list()
    i = 0      
    for id in t_ids:
        file = os.path.join(wdir, t_fnames[i])
        if 'cover.xhtml' in file or \
            'cover.html' in file or \
            'cover.htm' in file or \
            'TOC.xhtml' in file or \
            'contents.xhtml' in file or \
            'titlepage.xhtml' in file:
            i = i + 1
            continue    
        
        print(file)
        with open(file, 'wt', encoding='utf-8') as outfp:
            data = bk.readfile(id)
            t_fnames_r.append(t_fnames[i])
            t_ids_r.append(id)
            outfp.writelines(data)
            i = i + 1
    
    return(t_ids_r, t_fnames_r)     
                
    
def writeFiles2Epub(bk, wdir, ids, fnames):

    print('\n -- In writeFiles2Epub()...' )       
    for file in fnames:    
       print(file)    

    count = len(fnames)
    if count == 0: 
        return(0)
    
    i = 0
    for file in fnames:
        file = os.path.join(wdir, file)
        with open(file, 'rt', encoding='utf-8') as fp:
            data = fp.read()           
            bk.writefile(ids[i], data)
            i = i + 1
    
def show_msgbox(title, msg, msgtype='info'):
    """ For general information, warnings and errors
    """
    localRoot = tk.Tk()
    localRoot.withdraw()
    localRoot.option_add('*font', 'Helvetica -12')
    localRoot.quit()
    if msgtype == 'info':
        return(mbox.showinfo(title, msg))
    elif msgtype == 'warning':
        return(mbox.showwarning(title, msg))
    elif msgtype == 'error':
        return(mbox.showerror(title, msg))
 
def cleanExit(wdir):
    shutil.rmtree(wdir, ignore_errors=True)
    return(0)
    
def prettifyXHTMLFile(wdir, file):
    """ Prettifies the html """
    
    # reformat and prettify the XHTML file
    outfile= os.path.join(wdir, 'final_one.css')
    print('\n>>> prettify infile...' + file)
    print('\n>>> prettify outfile...' + outfile)
    outfp = open(outfile, 'wt', encoding='utf-8') 
    infp = open(file, 'rt', encoding='utf-8')
    
    for line in infp:
            
        # prettify the html file
        if line.strip().startswith('<?xml') or \
            line.strip().startswith('<!DOCTYPE') or \
            line.strip().startswith('<html') or \
            line.strip().startswith('<head>') or \
            line.strip().startswith('<meta')or \
            line.strip().startswith('<title>') or \
            line.strip().startswith('<link') or \
            line.strip().startswith('</head>') or \
            line.strip().startswith('<body') or \
            line.strip().startswith('<body>'):
            line = line.strip()
            if not line:
                continue
            if line.startswith('<meta') or \
                line.startswith('<title>') or \
                line.startswith('<link'):
                line = '  ' + line      
            if line.startswith('<body'):
                line = '\n' + line
            if line.startswith('</body>'):
                outfp.write('\n' + line.rstrip() + '\n')
            else:
                outfp.write(line.rstrip() + '\n')   
        else:
            line = line.strip() 
            if not line or line == ';':
                continue
            if line.strip().startswith('<img'):
                line = line.strip().replace('/> <img', '/>\n\n<img')   
                line = line.strip().replace('<img', '  <img')
            if '<image' in line:
                line = line.strip().replace('<image', '\n  <image')                
            if line.strip().startswith('<p'):
                line = '  ' + line.strip()           
            outfp.write('\n' + line + '\n')    
            
    infp.close()
    outfp.close()
    os.remove(file)
    os.rename(outfile, file)
    
    # reformat svg tags
    outfile= os.path.join(wdir, 'final.css')
    outfp = open(outfile, 'wt', encoding='utf-8') 
    with open(file, 'rt', encoding='utf-8') as infp:
        for line in infp:
            if line.strip().startswith('<svg'):
                line = line.replace('<svg', '  <svg')
            outfp.write(line)
            
    outfp.close()
    os.remove(file)
    os.rename(outfile, file)    
    return(0)                 
                  
def svgAttributes2CamelCase(wdir, file):
    """ I wrote this function because of the problems and frustrations caused by 
        bs4 automatically converting all svg attributes to lowercase, causing 
        various epub svg errors. I also tried using bs4's "xml" parser as a remedy 
        and doing this gave me an even bigger mess. So, in the end, I wrote 
        this simple function which just converts certain svg attributes back 
        to proper camel case.
    """       
    
    print(' -- svgAttributes2CamelCase()...')
    #file = os.path.join(wdir, file)
    #file = os.path.join(wdir, os.path.basename(file))       
    output = os.path.join(wdir, 'reformat.html')
    outfp = open(output, 'wt', encoding='utf-8')
    html = open(file, 'rt', encoding='utf-8').read()

    soup = BeautifulSoup(html, 'html.parser')
    
    for svg in soup.find_all('svg'):
    
        # reformat the par to camel case
        if svg.has_attr('preserveaspectratio'):
            par = svg['preserveaspectratio']
            del svg['preserveaspectratio']
            svg['preserveAspectRatio'] = par
        
        # reformat the vb to camel case
        if svg.has_attr('viewbox'):
            vb = svg['viewbox']
            del svg['viewbox']
            svg['viewBox'] = vb
            
        if not svg.has_attr('xmlns:xlink'):
            svg['xmlns:xlink'] = "http://www.w3.org/1999/xlink"        
               
    outfp.writelines(str(soup.prettyprint_xhtml(indent_level=0, eventual_encoding="utf-8", formatter="minimal", indent_chars="  ")))
    outfp.close()
    os.remove(file)
    os.rename(output, file)        
    return(0)          

def AddHeadings(wdir, file, count):
    
    print('>>> In AddHeadings...')
    outfile= os.path.join(wdir, 'add.xhml')
    outfp = open(outfile, 'wt', encoding='utf-8')     
    with open(file, 'rt', encoding='utf-8') as infp:
            
        for line in infp:
            
            print('>>> count...' + str(count))
            
            if '@#' in line:
                
                if options.HEADING_STYLE == 'Heading 1':
                    heading = 'h1'                   
                else:
                    heading = 'h2'                
                
                # Numbered or roman numeral chapter numbering
                if options.NUM_STYLE == 'Roman Numerals':
                    if count > 49:
                        msg = 'You are only allowed to use a maximum of 50 chapters with roman numeral numbering with this plugin. Your epub has exceeded this limit.'
                        print('\n>>> Error: ' + msg)
                        show_msgbox('Overrun Error', msg, msgtype='error')
                        options.SYS_EXIT = True
                        return(0)
                    else:    
                        line = '<' + heading + '>' + options.SUFFIX + ' ' + options.NUMERALS[count] + '</' + heading + '>'   
                else:
                    line = '<' + heading + '>' + options.SUFFIX + ' ' + str(count+1) + '</' + heading + '>'
                
                count += 1
                outfp.write(line)
                 
            else:
                outfp.write(line)
    
    outfp.close()                
    os.remove(file)
    os.rename(outfile, file)
    return(count)