/*
the WorkHorse
; 
; AutoHotkey Version: AutoHotkey "Basic" 1.0.48.3 
; Language:       English 
; Platform:       Win9x/NT through Vista, x86 
; Author:         ECM  (grannyGrump)  AHK novice-at-large
;  
; Script Summary: 
Autofill hotkeys
/*##############################################
################################################
################################################
################################################

AUTO-EXEC			 	

##############################################
################################################
################################################
################################################
*/

; #NoTrayIcon
#NoEnv
#SingleInstance force
#HotkeyInterval 1000
#MaxHotkeysPerInterval 100

Process, Priority, , HIGH
SetKeyDelay, 0, 0
SetBatchLines, -1
SetMouseDelay, 0
SetDefaultMouseSpeed, 0
SetWinDelay,  0
SetControlDelay, 0
SetTitleMatchMode 2
CoordMode, Mouse, Screen
DetectHiddenWindows, On

;#################################
SetWorkingDir %A_ScriptDir%

SplitPath, A_ScriptFullPath, SYS_ScriptNameExt, SYS_ScriptDir, SYS_ScriptExt, SYS_ScriptNameNoExt, SYS_ScriptDrive
SYS_ScriptInfo = %SYS_ScriptNameNoExt%

emptyMem()

RETURN



/*##############################################
################################################
################################################
################################################

FUNCTIONS			 	
*/

; _EmptyWorkingSet() 
; http://www.sevenforums.com/customization/40297-can-copy-path-enabled-permanently-without-shift-2.html
EmptyMem()
{
RETURN DllCall("psapi.dll\EmptyWorkingSet", "UInt", -1)
}

/*
################################################
################################################
################################################
################################################


ROUTINES			 	


################################################
################################################
################################################
################################################
*/
;@@@@@@@@@@@@@@@@@@@@@@@@
;@@@@@@@@@@@@@@@@@@@@@@@@

;;The below items --- Insert characters where cursor is located

INS::
;;emdash
SENDinput 

;;space emdash
;SENDinput {space}       
RETURN

+INS::
;;ENdash
SENDinput   

;;space ENdash 				
; SENDinput {space}			
RETURN

^INS::
;;ellipsis
SENDinput 
RETURN

!INS::
;;nbsp
SENDinput &nbsp;  
RETURN


F5::
send 
RETURN

+F5::
send 
RETURN

^F5::
send 
RETURN

!F5::
send 
RETURN

;@@@@@@@@@@@@@@@@@@@@@@@@
;@@@@@@@@@@@@@@@@@@@@@@@@
;@@@@@@@@@@@@@@@@@@@@@@@@
;@@@@@@@@@@@@@@@@@@@@@@@@
;;The below items --- apply subs to selected text


F6::
gosub AngleQuotes
RETURN

+F6::
gosub CurlyQuotes
RETURN

^F6::
gosub unQuote
RETURN

; !F6::
; RETURN


F7::
 goSub ItalicTagEM
RETURN

+F7::
goSub ItalicTagI 
RETURN

^F7::
gosub unItalic
RETURN

!F7:: 
gosub BoldTag
RETURN


F8::
gosub ParaWrap
RETURN

+F8::
gosub ParaSplit
RETURN

^F8::
gosub ParaToHeader
RETURN

!F8::
gosub HeaderToPara
RETURN


F9::
; ;;Inserts a line above the cursor with div tag
;;;type the class name you want in the line below, name will be used every time:
send {home}<div class="stanza">{enter}

;;;@@@@@@@@
;;Alternatively, type a class name on the fly each time you use the hotkey. Comment out the active code line above, and un-comment the two lines below

;inputBox, DATA, Data_Required, Please_Type, 50, 300, 200, 800,300
;send {home}<div class="%DATA%">{enter}
RETURN
  

+F9::
;;Inserts a line below the cursor with closing div tag
send {Home}{Down}</div>{Enter}
RETURN

^F9::
;;sub wraps selection with div tags, see further down
gosub Divver
RETURN

!F9::
;;sub wraps selection with span tags, see further down
gosub Spanner
RETURN


F10:: 
;;Inserts line above cursor with blockquote tag
send {Home}<blockquote>{Enter}
RETURN

+F10:: 
;;Inserts line below cursor with closing tag
send {Home}{Down}</blockquote>{Enter}
RETURN


^F10:: 
;;Inserts a line above cursor with hr tag 
send {Home}<hr/>{Enter }
RETURN

!F10::
;;Inserts <br/> tag
;;If you want a line break after <br/>, delete the semicolon in front of {enter}
send <br />  ; {Enter}
RETURN


F11::
;;Inserts a class name to existing simple <p> tag;
;;As written here, code must not have indents. 
;;If you have indents you can change how many characters to move {Right}
;;type the class name you want in the line below
send {Home}{Right 2}{Space}class="noindent"

;;;@@@@@@@@
;;Alternatively, type a class name on the fly each time you use the hotkey. Comment out the active code line above, and un-comment the two lines below

;inputBox, DATA, Data_Required, Please_Type, 50, 300, 200, 800,300
;send {Home}{Right 2}{Space}class="%DATA%"


RETURN

+F11::
; Inserts a class name to existing simple <div> tag;
;;As written here, code must not have indents. 
;;If you have indents you can change how many characters to move {Right}
;;;type the class name you want in the line below, name will be used every time:

send {Home}{Right 4}{Space}class="subhead"

;;;@@@@@@@@
;;Alternatively, type a class name on the fly each time you use the hotkey. Comment out the active code line above, and un-comment the two lines below

;inputBox, DATA, Data_Required, Please_Type, 50, 300, 200, 800,300
;send {Home}{Right 4}{Space}class="%DATA%"

RETURN


F12::
gosub CaseTitle
RETURN

+F12::
gosub CASElower
RETURN

^F12::
gosub CaseUPPER
RETURN

; !F12::
; RETURN


/*
################################################
################################################
################################################

SUBs

################################################
################################################
################################################
*/


ItalicTagEM:
;;This will remove <i> tags in the selected text and wrap selection with <em> tags
Clipboard =					
SendInput, ^c 
ClipWait, 50 
AutoTrim, ON 
FixString = %clipboard%

StringReplace, FixString, FixString,<i>,, All 
StringReplace, FixString, FixString,</i>,, All 
StringReplace,FixString,FixString,%FixString%,<em>%FixString%</em>	

clipboard := FixString
SendInput, ^v
RETURN


ItalicTagI:
;;This will remove <em> tags and wrap selected text with <i> tags
Clipboard =					
SendInput, ^c 
ClipWait, 50 
AutoTrim, ON 
FixString = %clipboard%
StringReplace, FixString, FixString,<em>,, All 
StringReplace, FixString, FixString,</em>,, All 

StringReplace,FixString,FixString,%FixString%,<i>%FixString%</i>	
clipboard := FixString
SendInput, ^v
RETURN


unITALIC:
;;This will remove <i> and <em> tags

Clipboard =					
SendInput, ^c 
ClipWait, 50 
AutoTrim, ON 
FixString = %clipboard%
StringReplace, FixString, FixString,<i>,, All 
StringReplace, FixString, FixString,</i>,, All 
StringReplace, FixString, FixString,<em>,, All 
StringReplace, FixString, FixString,</em>,, All 

StringReplace,FixString,FixString,%FixString%,%FixString%,
clipboard := FixString
sleep 100
SendInput, ^v
RETURN


BoldTag:
;;This will remove <strong> tags if they exist, and wrap selected text with <b> tags

Clipboard =					
SendInput, ^c 
ClipWait, 50 
AutoTrim, ON 
FixString = %clipboard%
StringReplace, FixString, FixString,<strong>,, All 
StringReplace, FixString, FixString,</strong>,, All 
StringReplace,FixString,FixString,%FixString%,<b>%FixString%</b>
clipboard := FixString
SendInput, ^v
RETURN


CurlyQuotes:
;;This will wrap curly quotes around selected text
;;if you want to remove existing single quotes, remove the semicolons that comment out those lines of code.  Be careful about removing single quotes, it will remove apostrophes

Clipboard =					
SendInput, ^c 
ClipWait, 50 
AutoTrim, ON 
FixString = %Clipboard%

;;;; These lines remove single quotes:
;StringReplace, FixString, FixString,,, All 
;StringReplace, FixString, FixString,,, All 

;;;; This line will wrap selection with double curly quotes:
StringReplace,FixString,FixString,%FixString%,%FixString%


;;;; These lines remove double quotes: 
;StringReplace, FixString, FixString,,, All 
;StringReplace, FixString, FixString,,, All 

;;;; This line will wrap selection with single curly quotes:
;StringReplace,FixString,FixString,%FixString%,%FixString%

Clipboard := FixString
SendInput, ^v
RETURN



AngleQuotes:
;;This will remove double curly quotes from selected text and wrap double angle quotes around selection
;;if you want to remove existing single curly quotes, remove the semicolons that comment out those lines of code.  Be careful about single quotes, it will remove apostrophes
Clipboard =					
SendInput, ^c 
ClipWait, 50 
AutoTrim, ON 
FixString = %clipboard%
; StringReplace, FixString, FixString,,, All 
; StringReplace, FixString, FixString,,, All 
StringReplace, FixString, FixString,,, All 
StringReplace, FixString, FixString,,, All 

StringReplace,FixString,FixString,%FixString%,%FixString%
;;;; If you want to use single angle quotes instead, comment out the active code line above with a semicolon, and remove the semicolon in front of the line below
;StringReplace,FixString,FixString,%FixString%,%FixString%

clipboard := FixString
SendInput, ^v
RETURN



UNQUOTE:
;;removes curly double-quotes from selection
Clipboard =					
SendInput, ^c 
ClipWait, 50 
FixString = %clipboard%
StringReplace, FixString, FixString,,, All 
StringReplace, FixString, FixString,,, All 

StringReplace,FixString,FixString,%FixString%,%FixString%,
Clipboard := FixString
sleep 100
SendInput, ^v
RETURN


ParaWrap:
;;Removes header, div, and br tags, wraps selected text with <p> tags
Clipboard =					
SendInput, ^c 
ClipWait, 50 
AutoTrim, ON 
FixString = %Clipboard%

StringReplace, FixString, FixString,<h1>,, All 
StringReplace, FixString, FixString,</h1>,, All 
StringReplace, FixString, FixString,<h2>,, All 
StringReplace, FixString, FixString,</h2>,, All 
StringReplace, FixString, FixString,<h3>,, All 
StringReplace, FixString, FixString,</h3>,, All 
StringReplace, FixString, FixString,<h4>,, All 
StringReplace, FixString, FixString,</h4>,, All 
StringReplace, FixString, FixString,<h5>,, All 
StringReplace, FixString, FixString,</h5>,, All 
StringReplace, FixString, FixString,<div>,, All 
StringReplace, FixString, FixString,</div>,, All 
StringReplace, FixString, FixString,<br />,, All 
StringReplace, FixString, FixString,<br/>,, All
 
StringReplace,FixString,FixString,%FixString%,<p>%FixString%</p>	

;;; If you want a certain class name to be used every time, type it in like the example below:
;StringReplace,FixString,FixString,%FixString%,<p class="classname">%FixString%</p>	

;;;@@@@@@@@
;;Alternatively, type a class name on the fly each time you use the hotkey.
;; Comment out the active code line above, and un-comment the two lines below

; inputBox, DATA, Data_Required, Please_Type, 50, 300, 200, 800,300
; StringReplace,FixString,FixString,%FixString%,<p class="%DATA%">%FixString%</p>	

clipboard := FixString
sleep 300
SendInput, ^v
sleep 50
RETURN


ParaSplit:
;;Place cursor where you want to split paragraph, press hotkey
send </p>{Enter 2}<p>
RETURN


ParaToHeader:
;;changes simple paragraph tag to header.
Clipboard =					
SendInput, ^c 
ClipWait, 50 
AutoTrim, ON 
FixString = %clipboard%
StringReplace, FixString, FixString,<p>,, All 
StringReplace, FixString, FixString,</p>,, All 

;;;; Type in the header number you want in the script below where it says h3>, both places
 StringReplace,FixString,FixString,%FixString%,<h3>%FixString%</h3>	

clipboard := FixString
SendInput, ^v
RETURN


HeaderToPara:
;;Changes header tags to para tags
Clipboard =					
SendInput, ^c 
ClipWait, 50 
AutoTrim, ON 
FixString = %Clipboard%

StringReplace, FixString, FixString,<h1>,, All 
StringReplace, FixString, FixString,</h1>,, All 
StringReplace, FixString, FixString,<h2>,, All 
StringReplace, FixString, FixString,</h2>,, All 
StringReplace, FixString, FixString,<h3>,, All 
StringReplace, FixString, FixString,</h3>,, All 
StringReplace, FixString, FixString,<h4>,, All 
StringReplace, FixString, FixString,</h4>,, All 
StringReplace, FixString, FixString,<h5>,, All 
StringReplace, FixString, FixString,</h5>,, All 

 StringReplace,FixString,FixString,%FixString%,<p>%FixString%</p>	

;;;; If you want a class name used every time, type it in like the example below
; StringReplace,FixString,FixString,%FixString%,<p class="classname">%FixString%	

;;;@@@@@@@@
;;Alternatively, type a class name on the fly each time you use the hotkey. Comment out the active code line above, and un-comment the two lines below

;inputBox, DATA, Data_Required, Please_Type, 50, 300, 200, 800,300
; StringReplace,FixString,FixString,%FixString%,<p class="%DATA%">%FixString%
;send {Home}{Right 4}{Space}class="%DATA%"

Clipboard := FixString
SendInput, ^v
RETURN




ParaMerge:
;;This will merge two paragraphs --- but as it is written here, your code can not have indents, and  tags must be plain with no class. You can edit it for your needs, adding number of characters to backspace and delete.
;;Place cursor near end of top paragraph, press hotkey
send {End}{Backspace 4}{Delete 5}{Space}{Home}
RETURN




HeaderBuild:
;;Removes all existing <h >, <div>, <br> tags 
;;Wraps selection in new <h> tags 

Clipboard =					
SendInput, ^c 
ClipWait, 50 
AutoTrim, ON 
FixString = %clipboard%

StringReplace, FixString, FixString,<h1>,, All 
StringReplace, FixString, FixString,</h1>,, All 
StringReplace, FixString, FixString,<h2>,, All 
StringReplace, FixString, FixString,</h2>,, All 
StringReplace, FixString, FixString,<h3>,, All 
StringReplace, FixString, FixString,</h3>,, All 
StringReplace, FixString, FixString,<h4>,, All 
StringReplace, FixString, FixString,</h4>,, All 
StringReplace, FixString, FixString,<h5>,, All 
StringReplace, FixString, FixString,</h5>,, All 
StringReplace, FixString, FixString,<div>,, All 
StringReplace, FixString, FixString,</div>,, All 
StringReplace, FixString, FixString,<br />,, All 
StringReplace, FixString, FixString,<br/>,, All 

;;;; you must type in the header number in the code below where it now says h3> in both places

 StringReplace,FixString,FixString,%FixString%,<h3>%FixString%</h3>	

clipboard := FixString
sleep 300
SendInput, ^v
sleep 50
RETURN



DIVVER:
;;Removes existing div, <br>, <span> tags and wraps selection in new <div> tags
Clipboard =					
SendInput, ^c 
ClipWait, 100 
AutoTrim, ON 
FixString = %clipboard%

StringReplace, FixString, FixString,<div>,, All 
StringReplace, FixString, FixString,</div>,, All 
StringReplace, FixString, FixString,<br />,, All 
StringReplace, FixString, FixString,<br/>,, All 
StringReplace, FixString, FixString,<span>,, All 
StringReplace, FixString, FixString,</span>,, All 

StringReplace,FixString,FixString,%FixString%,<div>%FixString%</div>	


;;;; If you want, type in a class name in the code string like the example below, the name will be used every time
;StringReplace,FixString,FixString,%FixString%,<div class="classname">%FixString%</div>	

;;;@@@@@@@@
;;Alternatively, type a class name on the fly each time you use the hotkey. Comment out the active code line above, and un-comment the two lines below

;inputBox, DATA, Data_Required, Please_Type, 50, 300, 200, 800,300
;StringReplace,FixString,FixString,%FixString%,<div class="%DATA%">%FixString%</div>	

clipboard := FixString
SendInput, ^v
RETURN



SPANNER:
;;Wraps selection in <span> tags

Clipboard =					
SendInput, ^c 
ClipWait, 50 
AutoTrim, ON 
FixString = %clipboard%

;;type in the class name you want in the code line, the name will be used every time
StringReplace,FixString,FixString,%FixString%,<span class="subfont">%FixString%</span>	
; StringReplace,FixString,FixString,%FixString%,<span class="smcaps">%FixString%</span>	

;;;@@@@@@@@
;;Alternatively, you can type a class name on the fly each time you use the hotkey. Comment out the active code line above, and un-comment the two lines below

;inputBox, DATA, Data_Required, Please_Type, 50, 300, 200, 800,300
;StringReplace,FixString,FixString,%FixString%,<span class="%DATA%">%FixString%</span>	

clipboard := FixString
SendInput, ^v
RETURN



CaseUPPER:
;;Converts selected text to all UPPER CASE
AutoTrim, OFF 
Clipboard =			
SendInput, ^c 
; ClipWait
sleep 300
FixString = %clipboard%
StringUpper,FixString,FixString,    ; T 
clipboard := FixString
SLEEP 100
SendInput, ^v
RETURN


CaseTitle:
;;Converts selected text to Title Case -- Every Word Is Capitalized
AutoTrim, OFF 
winget, active_window, id, a 
Clipboard =		
SendInput, ^c 
ClipWait

FixString = %clipboard%
StringLower,FixString,FixString, T 
clipboard := FixString
SLEEP 300
WinActivate, ahk_id %Active_Window% 
SendInput, ^v
RETURN


CASElower:
;;converts selected text to all lower case
AutoTrim, OFF 
winget, active_window, id, a 
Clipboard =			
SendInput, ^c 
ClipWait
Sleep 100
FixString = %clipboard%
stringlower,FixString,FixString ;, ; T 
clipboard := FixString
Sleep 300
WinActivate, ahk_id %Active_Window% 
SendInput, ^v
RETURN



