<?php
// history
//
// 0.01:  first public release. debunked by TadW, written by Alexander/MobileRead. 
//        not yet implemented: a lot. writing to the iRex logserver must come next.

require_once('iLiadBrowser.php');
require_once('misc/Sajax.php');

define('RELEASE', 'Web2iDS V0.01');

function connectiDS($type, $serial, $username, $password) 
{
  if (!isset($serial) || $serial == '') {
    return 'A serial is required';
  }

  $serial = '00167CFFFF00' . strtoupper(str_pad(trim($serial), 4, "0", STR_PAD_LEFT));
  if (isset($username)) $username = trim($username);
  if (isset($password)) $password = trim($password);

  $ids = new iLiadBrowser($serial, $username, $password);

  switch ($type) {

    /* iDS: CMD_PING_SERVER */
    case 'ping':
      $ids->preparePing();
      $ids->exec();

      return $ids->log;

    /* iDS: CMD_GET_SERVERURI */       
    case 'serveruri':
      $ids->preparePing();
      $ids->exec();

      $ids->prepareGetServerURI();
      $ids->exec();

      return $ids->log;

    /* iDS: CMD_GET_UPGRADESOFTWARE */     
    case 'softupgrade':
      $ids->preparePing();
      $ids->exec();

      $ids->prepareGetServerURI();
      $ids->exec();

      $ids->SetServerURI($ids->response_array['Response']['PerformCommands']['SetServerURI']['URI']);

      $ids->prepareGetUpgradeSoftware();
      $ids->exec();

      return $ids->log;

    /* iDS: CMD_GET_CONTENT */     
    case 'getcontent':
      if (!isset($username) || $username == '' OR !isset($password) || $password == '') {
        return 'A user e-mail and a password are required for this operation';
      }

      $ids->preparePing();
      $ids->exec();

      $ids->prepareGetServerURI();
      $ids->exec();

      $ids->SetServerURI($ids->response_array['Response']['PerformCommands']['SetServerURI']['URI']);

      $ids->prepareAssociateUser();
      $ids->exec();

      // wrong user e-mail/password combination
      if ($ids->response_array['Response']['Status']['Code'] == 1003) {
        return $ids->log;
      }
      
      $ids->prepareAnnounceToServer();
      $ids->exec();
    
      $ids->SetUserID($ids->response_array['Response']['PerformCommands']['SetUser']['UserID']);

      $ids->prepareGetContent();
      $ids->exec();

      return $ids->log;
    
    default:
      return 'Unknown type';
  }
}


$sajax_request_type = "POST";
sajax_init();
sajax_export("connectiDS");
sajax_handle_client_request();

display_form();
exit();
  
function display_form() {
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-en">
<head>
<title><?php echo RELEASE ?></title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" type="text/css" href="misc/style.css" />
<script>
<?php
sajax_show_javascript();
?>
function connectiDS(iDSServer) {
  document.getElementById("debug").innerHTML = iDSServer;
}

function clear_debug() {
  document.getElementById("debug").innerHTML = '';
}

function do_process(type) {
  document.getElementById("debug").innerHTML = 'Wait...';  
  x = document.getElementById("serial").value;
  y = document.getElementById("username").value;
  z = document.getElementById("password").value;
  x_connectiDS(type, x, y, z, connectiDS);
}
</script></head>
<body>
<div class="container">
  <h1><?php echo RELEASE ?></h1>
  <h2><?php echo RELEASE ?> is a Web gateway to establish a connection to the iRex Delivery Server (iDS).</h2>
  <div class="input">
  <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
    <label>Enter your iRex iLiad serial number*:</label>
    <br />
    <input type="text" id="serial" name="serial" size="35" maxlength="4" />
    <br />
    <label>Enter your username (optional):</label>
    <br />
    <input type="text" id="username" name="username" size="35" maxlength="60" />
    <br />
    <label>Enter your password (optional):</label>
    <br />
    <input type="password" id="password" name="password" size="35" maxlength="60" />
    <br />    
    <input type="submit" name="do" value="Ping" onclick="do_process('ping'); return false;" /> | <input type="submit" name="do" value="Get Server URI" onclick="do_process('serveruri'); return false;" /> | <input type="submit" name="do" value="Get Software Upgrade" onclick="do_process('softupgrade'); return false;" /> | <input type="submit" name="do" value="Get Content" onclick="do_process('getcontent'); return false;" />
  </form>
  </div>
  <div class="output">
  <h3>Debug Output:</h3>
  <textarea id="debug" name="debug" style="width:100%" rows="18" readonly="true"></textarea>
  <form>
    <input type="submit" value="Clear Output" onclick="clear_debug(); return false;" />
  </form>
  </div>
  <div class="subnote">
  <h3>* Note:</h3>
  <p>Your (unique) serial is a 3- or 4-digit hexadecimal number. If you don't know how to find it out, go to <a href="http://www.mobileread.com/forums/showthread.php?t=7312">this thread</a> and follow the example.</p>
  <h1>Suggestions?</h1>
  <p>Join the discussion in the MobileRead <a href="http://www.mobileread.com/forums/forumdisplay.php?f=106">iRex iLiad Hacks & Development</a> section.</p>
  </div>
</div>
</body>
</html>


<?php
}
?>

