<?php
// history
//
// 0.01:  first public release. debunked by TadW, written by Alexander/MobileRead. 
//        not yet implemented: a lot. writing to the iRex logserver must come next.

require_once('misc/xml.php');

class iLiadBrowser
{
  var $ch;
  
  var $timeout = 30;

  var $protocol = 'https';     
  var $host = 'ids.irexnet.com';
  var $path = '/redirector';
  var $port = '443';

  var $url = '';

  var $cacert = 'misc/irex.crt';

  var $email = '';
  var $password = '';
  var $userid = '';

  var $eui64 = "00167CFFFF000000";
  var $productid = "000000000002";
  var $requestversion = "1";
  var $fsversion = "2600";
  
  var $request = '';
  var $response = '';
  var $response_headers = ''; 
  var $response_array = ''; 
  
  var $log = '';
  /**
   * iLiadBrowser class constructor
   */    

  function iLiadBrowser($eui64 = false, $email = false, $password = false)
  {
    if(!function_exists('curl_init')) 
    {
      die('You must have Curl compiled/loaded into PHP for this class to work.');
    }
      
    $this->ch = curl_init() ;
    curl_setopt($this->ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($this->ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($this->ch, CURLOPT_FOLLOWLOCATION, 1); 
    curl_setopt($this->ch, CURLOPT_HEADER, 1); 
    curl_setopt($this->ch, CURLOPT_CAINFO, $this->cacert);
    curl_setopt($this->ch, CURLOPT_SSL_VERIFYHOST, 1);
    curl_setopt($this->ch, CURLOPT_SSL_CIPHER_LIST, 'AES128-SHA');    

    if ($eui64) $this->eui64 = $eui64;
    if ($email) $this->email = $email;
    if ($password) $this->password = $password;    
  }

  function exec()
  {
    $header= array();
    $header[] = "Host: $this->host";
    $header[] = "Accept: */*";
    $header[] = "Pragma:";
    $header[] = "Cookie:";
    $header[] = "eserver-eui64: $this->eui64";
    $header[] = "eserver-productid: $this->productid";
    $header[] = "eserver-requestversion: $this->requestversion";
    $header[] = "Content-length: " . strlen($this->request);
    $header[] = "Content-type: application/x-www-form-urlencoded";

    curl_setopt($this->ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($this->ch, CURLOPT_POSTFIELDS, $this->request);

    $this->url = $this->protocol . '://' . $this->host . ':' . $this->port . $this->path;
    curl_setopt($this->ch, CURLOPT_URL, $this->url);

    $this->response = curl_exec($this->ch);
    list($this->response_headers, $this->response) = explode("\r\n\r\n", $this->response, 2); 
    $this->response_array = XML_unserialize($this->response);
    $this->log .= $this->response;
  }

  function preparePing()
  {
    $request  = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $request .= "<Request ProtocolType=\"Ereader\" ProtocolVersion=\"1\"/>\n"; 
    $this->request = $request; 
  }

  function prepareGetServerURI()
  {

    $request  = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $request .= "<Request ProtocolType=\"Ereader\" ProtocolVersion=\"1\">\n"; 
    $request .= "  <GetServerURI></GetServerURI>\n";
    $request .= "</Request>\n"; 
    $this->request = $request; 
  }

  function prepareGetUpgradeSoftware()
  {
    $request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $request .= "<Request ProtocolType=\"Ereader\" ProtocolVersion=\"1\">\n";
    $request .= "  <GetSoftwareVersion />\n"; 
    $request .= "</Request>\n"; 
    $this->request = $request;     
  }

  function prepareAssociateUser()
  {
    if (!$this->email || !$this->password)
    {
      die('You must supply an e-mail address and a password for this method to work.');
    }
    
    $request  = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $request .= "<Request ProtocolType=\"Ereader\" ProtocolVersion=\"1\">\n"; 
    $request .= "  <AssociatePrimaryUser>\n";
    $request .= "    <UsernameToken>\n";
    $request .= "      <Username>" . $this->email . "</Username>\n";
    $request .= "      <Password>" . $this->password . "</Password>\n";
    $request .= "    </UsernameToken>\n";
    $request .= "  </AssociatePrimaryUser>\n"; 
    $request .= "</Request>\n"; 
    $this->request = $request; 
  }

  function prepareAnnounceToServer()
  {
    $request  = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $request .= "<Request ProtocolType=\"Ereader\" ProtocolVersion=\"1\">\n"; 
    $request .= "  <AnnounceToServer>\n";
    $request .= "    <ComponentInfoSet>\n";  
    $request .= "      <ComponentInfo ID=\"" . $this->fsversion . "\">\n";
    $request .= "        <Description />\n";  
    $request .= "      </ComponentInfo>\n";  
    $request .= "    </ComponentInfoSet>\n";  
    $request .= "  </AnnounceToServer>\n";
    $request .= "</Request>\n"; 
    $this->request = $request;   
  }
  
  function prepareGetContent()
  {
    if (!$this->userid)
    {
      die('You must supply a userid for this method to work.');
    }

    $request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $request .= "  <Request ProtocolType=\"Ereader\" ProtocolVersion=\"1\">\n"; 
    $request .= "  <GetContent>\n";
    $request .= "    <UserID>" . $this->userid . "</UserID>\n";
    $request .= "  </GetContent>\n";
    $request .= "</Request>\n";    
    $this->request = $request; 
  }

  function prepareTest()
  {
    $request  = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $request .= "  <Request ProtocolType=\"Ereader\" ProtocolVersion=\"1\">\n"; 
    $request .= "    <Internal>\n";
    $request .= "      <DisassociateAllUsers />\n";
    $request .= "    </Internal>\n";
    $request .= "  </Request>\n";    
    $this->request = $request; 
  }
  
  function SetServerURI($url)
  {
    $url = parse_url($url);
    $this->protocol = $url['scheme'];
    $this->host = $url['host'];
    $this->path = $url['path']; 
    $this->port = $url['port'];
  }

  function SetUserID($id)
  {
    $this->userid = $id;
  }

}

?>