#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys, os, re
from os.path import expanduser
try:
    from sigil_bs4 import BeautifulSoup
except:
    from bs4 import BeautifulSoup
# https://github.com/DeepHorizons/tts
import tts.sapi
from tkinter import Tk,  Listbox, Button, ttk, PhotoImage
import subprocess
from subprocess import Popen, PIPE

def GetDesktop():
    # output directory
    home = expanduser('~')
    desktop = os.path.join(home, 'Desktop')
    if os.path.isdir(desktop):
        return desktop
    else:
        return home

# simple subprocess wrapper    
def lameWrapper(*args):
    process = Popen(args, stdout=PIPE, stderr=PIPE, shell=False)
    ret = process.communicate()
    return ret
    
# borrowed from calibre from calibre/src/calibre/__init__.py; 
# updated by KevinH & BeckyEbook
def cleanup_file_name(name):
    import unicodedata
    _filename_sanitize = re.compile(r'[\xae\0\\|\?\*<":>\+/]')
    substitute='_'
    one = ''.join(char for char in unicodedata.normalize(
            'NFKD', name
        ) if unicodedata.category(char) != 'Mn')
    one = one.replace(u'\u2013', '-').replace(u'\u2014', '-')\
                   .replace(u'\u0142', 'l').replace(u'\u0141', 'L')
    one = _filename_sanitize.sub(substitute, one)
    one = re.sub(r'\s', '_', one).strip()
    one = re.sub(r'^\.+$', '_', one)
    one = one.replace('..', substitute)
    # Windows doesn't like path components that end with a period
    if one.endswith('.'):
        one = one[:-1]+substitute
    # Mac and Unix don't like file names that begin with a full stop
    if len(one) > 0 and one[0:1] == '.':
        one = substitute+one[1:]
    return one
    
        
def run(bk):
    if bk.launcher_version() < 20150909:
        print('This plugin requires Sigil 0.8.9 or higher.\n\nClick OK to close the Plugin Runner window.')
        return -1

    lame_path = os.path.join(bk._w.plugin_dir, bk._w.plugin_name, 'lame.exe')
    if not os.path.exists(lame_path):
        lame_path = None
    global selected_voice

    #===============
    # get preferences
    #===============
    
    allFiles = False
    prefs = bk.getPrefs()
    if 'allFiles' in prefs:
        allFiles = prefs['allFiles']

    # voice list index in list box
    if 'list_index' in prefs:
        list_index = prefs['list_index']
    else:
        list_index = 0
        prefs['list_index'] = list_index
        bk.savePrefs(prefs)

    # voice speed range: -10 to 10
    rate = None
    if 'rate' in prefs and prefs['rate'] in range(-10, 11):
        rate = prefs['rate']
        
    # desktop folder location
    if 'desktop_folder' in prefs and os.path.isdir(prefs['desktop_folder']):
        desktop_folder = prefs['desktop_folder']
    else:
        desktop_folder = GetDesktop()
        prefs['desktop_folder'] = desktop_folder
        bk.savePrefs(prefs)
        
    #---------------------------
    # get title and author
    #---------------------------
    title= 'Untitled'
    author = 'Unknown'
    opf_contents = bk.readotherfile('OEBPS/content.opf')
    try:
        title = BeautifulSoup(opf_contents, 'lxml').find('dc:title').string
        author = BeautifulSoup(opf_contents, 'lxml').find('dc:creator').string
    except:
        pass

    # create output directory
    output_dir = os.path.join(desktop_folder, cleanup_file_name(title))
    if not os.path.isdir(output_dir):
        os.mkdir(output_dir)
    
    #==================
    # TTS settings
    #=================
    voice = tts.sapi.Sapi()
    available_voices = voice.get_voice_names()
    if available_voices == []:
        print('No TTS voices found.')
        return -1
    # default to saved voice
    selected_voice = available_voices[list_index]

    #============================
    # display voice selection list box
    #============================
    def get_list(event):
        global selected_voice
        index = Lb1.curselection()[0]
        prefs['list_index'] = index
        selected_voice = Lb1.get(index)
        prefs['selected_voice'] = selected_voice
        bk.savePrefs(prefs)
    
    # define main window
    root = Tk()
    root.title("Voice Selection")
    root.bind('<Escape>', lambda e: root.destroy())
    style = ttk.Style()
    if 'winnative' in style.theme_names():
        style.theme_use('winnative')
    icon_img = PhotoImage(file=os.path.join(bk._w.plugin_dir, bk._w.plugin_name, 'sigil.png'))
    root.tk.call('wm', 'iconphoto', root._w, icon_img)
        
    # define list box
    Lb1 = Listbox(root)
    Lb1.config(width=0, height=0)
    Lb1.bind('<ButtonRelease-1>', get_list)
    position = 0
    # populate list box
    for voice_name in available_voices:
        position += 1
        Lb1.insert(position, voice_name)
    # highlight default voice
    Lb1.select_set(list_index)
    Lb1.pack()
    
    # define OK button
    def close():
        root.destroy()
    ok = Button(root, text="OK", command=close)
    ok.pack()
    root.mainloop()
   
    print('Selected voice:', selected_voice, '\n')
    voice.set_voice(selected_voice)
    
    if rate is not None:
        voice.set_rate(rate)

    #==============
    # file selection
    #==============
    # get list of file names
    selected_files = []
    for file_name in list(bk.selected_iter()):
        if bk.id_to_mime(file_name[1]) == 'application/xhtml+xml':
            selected_files.append((file_name[1], bk.id_to_href(file_name[1]))) 

    # select files to be processed
    if selected_files != [] and not allFiles:
        # only selected files
        file_list = selected_files
    else:
        # ALL files
        file_list = list(bk.text_iter())

    #=====================
    # process all/selected files
    #=====================
    track_number = 0
    for (html_id, href) in file_list:
        file_name = os.path.basename(href)
        root, ext = os.path.splitext(file_name)
        wav_file_name = os.path.join(output_dir,  cleanup_file_name(root) + '.wav')
        mp3_file_name =  os.path.join(output_dir, cleanup_file_name(root) + '.mp3') 
        html = bk.readfile(html_id)
        print('Processing', file_name, '...')

        # use bs4 as a simple tag filter
        soup = BeautifulSoup(html, 'html.parser')
        
        # delete any inline style text
        style = soup.find('style')
        if style is not None:
            style.string = ''
            
        # get rid of the tags
        text = soup.get_text()
        
        # make sure that the file actually contains text
        if text.strip() != '':
            #voice.say(text)
            
            # generate WAV file
            print('Generating wave file...')
            voice.create_recording(wav_file_name, text)
            if os.path.exists(wav_file_name):
                print(wav_file_name, 'sucessfully generated.')
                track_number += 1
                # generate MP3 file
                if lame_path is not None:
                    print('Generating mp3 file...')
                    args = [lame_path, '--tt', file_name, '--ta', author, '--tl', title, '--tn', str(track_number), wav_file_name, mp3_file_name]
                    stdout, stderr = lameWrapper(*args)
                    if os.path.exists(mp3_file_name):
                        print(mp3_file_name, 'sucessfully generated.\n')
                        os.remove(wav_file_name)
                    else:
                        print('MP3 file couldn\'t be generated!', stdout, stderr)
                else:
                    print('LAME encoder not found!')
                
            else:
                print(wav_file_name, 'couldn\'t be generated.\n')
        else:
            print('No text found in', file_name, '\n')
    
    print('Click OK to close the Plugin Runner window.')
    
    return 0
        
def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())