#!/bin/sh

export SD_PATH=/media/cf/newspapers/SundayTimes
export DOWNLOADER_DIR=/mnt/free/download/SundayTimes

nextIssueFileName="$DOWNLOADER_DIR/script/next-issue-to-download.txt"

nextIssueToDownload=`cat $nextIssueFileName`
i="SundayTimes$nextIssueToDownload"
url="http://www.sdtimes.com/content/SoftwareDevelopmentTimesPDFEdition.aspx?File=sdtimes"$nextIssueToDownload".pdf"

wget -O /tmp/$i.pdf $url

if [ "$?" = "0" ]
then
	size=`ls -l /tmp/$i.pdf | cut -d' ' -f5`
	echo "size:$size"
	if [ $size -gt 1 ]
	then
		mkdir -p $SD_PATH/$i.pdf
		echo "<?xml version=\"1.0\" encoding=\"utf-8\"?><package><metadata><dc-metadata><Title>Sunday Times Software Development #"$nextIssueToDownload"</Title><Description>Description: `echo \`date\``</Description></dc-metadata><y-metadata><startpage>$i.pdf</startpage><image>icon.png</image><version>000</version></y-metadata></metadata></package>" > $SD_PATH/$i.pdf/manifest.xml
		mv /tmp/$i.pdf $SD_PATH/$i.pdf/$i.pdf
		cp /mnt/free/download/SundayTimes/icon.png $SD_PATH/$i.pdf/icon.png
		nextIssueToDownload=`expr $nextIssueToDownload + 1`
		echo $nextIssueToDownload > $nextIssueFileName
	fi
fi
rm /tmp/$i.pdf
