#include <Xlib.h>
#include "Xlibint.h"

/* Copy of the one in Synchro.c */

static int _XSyncFunction(register Display *dpy)
{
        XSync(dpy,0);
        return 0;
}

int (*XSynchronize(
			    Display *dpy            /* display */,
			        Bool onoff                /* onoff */
			))(
			    Display*            /* display */
			)
{
        int (*temp)(Display *);
        int (*func)(Display *) = NULL;

        if (onoff)
            func = _XSyncFunction;

        LockDisplay(dpy);
        if (dpy->flags & XlibDisplayPrivSync) {
            temp = dpy->savedsynchandler;
            dpy->savedsynchandler = func;
        } else {
            temp = dpy->synchandler;
            dpy->synchandler = func;
        }
        UnlockDisplay(dpy);
        return (temp);

}

/* Simplification of the one in lcWrap.c (this one always fails) */
#include "Xlcint.h"
XrmMethods
_XrmInitParseInfo(
		    XPointer *state)
{
        return (XrmMethods) NULL;
}

