/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** As a special exception, The Qt Company gives you certain additional
** rights. These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QtGui>
#include <QtNetwork>
#include "lightmaps.h"
#include "mapzoom.h"

MapZoom::MapZoom()
    : QMainWindow(0)
{
    map = new LightMaps(this);
    setCentralWidget(map);
    map->setFocus();

    QAction *MadridAction = new QAction(tr("&Madrid"), this);
    QAction *BarcelonaAction = new QAction(tr("&Barcelona"), this);
    QAction *IbizaAction = new QAction(tr("&Ibiza"), this);
    QAction *ParisAction = new QAction(tr("&Paris"), this);
    QAction *RomeAction = new QAction(tr("&Rome"), this);
    QAction *CityofSanMarinoAction = new QAction(tr("&City of San Marino "), this);
    QAction *BerlinAction = new QAction(tr("&Berlin"), this);
    QAction *LondonAction = new QAction(tr("&London"), this);
    QAction *MoscowAction = new QAction(tr("&Moscow"), this);
    QAction *NewYorkAction = new QAction(tr("&New York"), this);
    QAction *MontevideoAction = new QAction(tr("&Montevideo"), this);
    QAction *SidneyAction = new QAction(tr("&Sidney"), this);
    QAction *nightModeAction = new QAction(tr("Night Mode"), this);
    nightModeAction->setCheckable(true);
    nightModeAction->setChecked(false);
    QAction *ExitAction = new QAction(tr("Exit"), this);
    connect(MadridAction, SIGNAL(triggered()), SLOT(chooseMadrid()));
    connect(BarcelonaAction, SIGNAL(triggered()), SLOT(chooseBarcelona()));
    connect(IbizaAction, SIGNAL(triggered()), SLOT(chooseIbiza()));
    connect(ParisAction, SIGNAL(triggered()), SLOT(chooseParis()));
    connect(RomeAction, SIGNAL(triggered()), SLOT(chooseRome()));
    connect(CityofSanMarinoAction, SIGNAL(triggered()), SLOT(chooseCityofSanMarino()));
    connect(BerlinAction, SIGNAL(triggered()), SLOT(chooseBerlin()));
    connect(LondonAction, SIGNAL(triggered()), SLOT(chooseLondon()));
    connect(MoscowAction, SIGNAL(triggered()), SLOT(chooseMoscow()));
    connect(NewYorkAction, SIGNAL(triggered()), SLOT(chooseNewYork()));
    connect(MontevideoAction, SIGNAL(triggered()), SLOT(chooseMontevideo()));
    connect(SidneyAction, SIGNAL(triggered()), SLOT(chooseSidney()));
    connect(nightModeAction, SIGNAL(triggered()), map, SLOT(toggleNightMode()));
    connect(ExitAction, SIGNAL(triggered()), SLOT(close()));

#if defined(Q_OS_SYMBIAN) || defined(Q_OS_WINCE_WM)
    menuBar()->addAction(MadridAction);
    menuBar()->addAction(BarcelonaAction);
    menuBar()->addAction(IbizaAction);
    menuBar()->addAction(ParisAction);
    menuBar()->addAction(RomeAction);
    menuBar()->addAction(CityofSanMarinoAction);
    menuBar()->addAction(BerlinAction);
    menuBar()->addAction(LondonAction);
    menuBar()->addAction(MoscowAction);
    menuBar()->addAction(NewYorkAction);
    menuBar()->addAction(MontevideoAction);
    menuBar()->addAction(SidneyAction);
    menuBar()->addAction(nightModeAction);
    menuBar()->addAction(ExitAction);
#else
    QMenu *menu = menuBar()->addMenu(tr("&Options"));
    menu->addAction(MadridAction);
    menu->addAction(BarcelonaAction);
    menu->addAction(IbizaAction);
    menu->addAction(ParisAction);
    menu->addAction(RomeAction);
    menu->addAction(CityofSanMarinoAction);
    menu->addAction(BerlinAction);
    menu->addAction(LondonAction);
    menu->addAction(MoscowAction);
    menu->addAction(NewYorkAction);
    menu->addAction(MontevideoAction);
    menu->addAction(SidneyAction);
    menu->addSeparator();
    menu->addAction(nightModeAction);
    menu->addAction(ExitAction);
#endif

    QNetworkConfigurationManager manager;
    if (manager.capabilities() & QNetworkConfigurationManager::NetworkSessionRequired) {
        // Get saved network configuration
        QSettings settings(QSettings::UserScope, QLatin1String("Trolltech"));
        settings.beginGroup(QLatin1String("QtNetwork"));
        const QString id =
            settings.value(QLatin1String("DefaultNetworkConfiguration")).toString();
        settings.endGroup();

        // If the saved network configuration is not currently discovered use the system
        // default
        QNetworkConfiguration config = manager.configurationFromIdentifier(id);
        if ((config.state() & QNetworkConfiguration::Discovered) !=
            QNetworkConfiguration::Discovered) {
            config = manager.defaultConfiguration();
        }

        networkSession = new QNetworkSession(config, this);
        connect(networkSession, SIGNAL(opened()), this, SLOT(sessionOpened()));

        networkSession->open();
    } else {
        networkSession = 0;
    }

    setWindowTitle(tr("Light Maps"));
}

void MapZoom::sessionOpened()
{
    // Save the used configuration
    QNetworkConfiguration config = networkSession->configuration();
    QString id;
    if (config.type() == QNetworkConfiguration::UserChoice) {
        id = networkSession->sessionProperty(
                QLatin1String("UserChoiceConfiguration")).toString();
    } else {
        id = config.identifier();
    }

    QSettings settings(QSettings::UserScope, QLatin1String("Trolltech"));
    settings.beginGroup(QLatin1String("QtNetwork"));
    settings.setValue(QLatin1String("DefaultNetworkConfiguration"), id);
    settings.endGroup();
}

void MapZoom::chooseMadrid()
{
    map->setCenter(40.4778, -3.7038);
}

void MapZoom::chooseBarcelona()
{
    map->setCenter(41.3927, 2.1404);
}

void MapZoom::chooseIbiza()
{
    map->setCenter(38.9068, 1.4240);
}

void MapZoom::chooseParis()
{
    map->setCenter(48.8589, 2.3469);
}

void MapZoom::chooseRome()
{
    map->setCenter(41.8988, 12.5451);
}

void MapZoom::chooseCityofSanMarino()
{
    map->setCenter(43.9293, 12.4357);
}

void MapZoom::chooseBerlin()
{
    map->setCenter(52.5173, 13.3889);
}

void MapZoom::chooseLondon()
{
    map->setCenter(51.5076, -0.1276);
}

void MapZoom::chooseMoscow()
{
    map->setCenter(55.7251, 37.6290);
}

void MapZoom::chooseNewYork()
{
    map->setCenter(40.6971, -73.9796);
}

void MapZoom::chooseMontevideo()
{
    map->setCenter(-34.8200, -56.2270);
}

void MapZoom::chooseSidney()
{
    map->setCenter(47.7128, -104.1727);
}