#!/bin/sh

####
# Uncomment one of the following depending on storage device
export MINUTOS_PATH=/media/cf/newspapers/20minutos   # CF storage
#export MINUTOS_PATH=/mnt/free/newspapers/20minutos   # Internal storage

dia=`date +%d`
mes=`date +%m`
ano=`date +%y`
i="20minutos"
url="http://static.20minutos.es/edicionimpresa/madrid/$ano/$mes/MADR_"$dia"_"$mes"_"$ano".pdf"

wget -O /tmp/$i.pdf $url

if [ "$?" = "0" ]
then
	rm -rf $MINUTOS_PATH/$i.pdf
	mkdir -p $MINUTOS_PATH/$i.pdf
	echo "<?xml version=\"1.0\" encoding=\"utf-8\"?><package><metadata><dc-metadata><Title>20minutos</Title><Description>Descargado: `echo \`date\``</Description></dc-metadata><y-metadata><startpage>$i.pdf</startpage><image>icon.png</image><version>000</version></y-metadata></metadata></package>" > $MINUTOS_PATH/$i.pdf/manifest.xml
	mv /tmp/$i.pdf $MINUTOS_PATH/$i.pdf/$i.pdf
	cp /mnt/free/download/20minutos/icon.png $MINUTOS_PATH/$i.pdf/icon.png
fi
