# v0.2 - Initial plugin by nrapallo (Sept 2008)
#
# Uses PDFRead (dos command) to convert .djvu to .imp (EBW1150/REB1200) 'on the fly'...
# Must have PDFRead 1.8 fully installed (to C: drive perferrably) or must edit .bat used.
# See thread http://www.mobileread.com/forums/showthread.php?t=21906 for how to install.

from ebookutils import impserve

class DjvuConverterportrait(impserve.ProxyResponse):
    def __init__(self):
        # register our own mime-types here for the Content-Disposition header; this will
        # override any Content-Type which is sent by the server.
        import mimetypes
        #mimetypes.add_type('image/x-djvu', '.djvu')

    def get_response(self, url, headers, data):
        #debug statements
        #print " URL: ", url
        #print " HEAD: ", headers
        #print " DATA: ", data
        # check if we got a Content-Type
        if not 'Content-Type' in headers:
            return headers, data

        ctype = headers['Content-Type']
        found = False
        #filename should end with .djvu, if not return.
        if 'djvu' in ctype:
            found = True        
        if not found:
            return headers, data
            
        import os, subprocess, shutil, re, urllib
        from os.path import getsize

	if impserve.config.ebook_type == 1:
           ext = '_1200.imp'                     #For REB1200
        else:
           ext = '.imp'                          #For EBW1150   
        
        #Extract suggested .djvu filename and use it to save a copy to the local 'shelf'
        if 'Content-Disposition' in headers:
            m = headers['Content-Disposition']
            name = re.compile('filename="?([^"]+)"?').search(m).group(1)
        else:
            fname, name = os.path.split(url)
        name = urllib.unquote(name)

        #filename should end with .djvu, if not return.
        if not name.lower().endswith('.djvu'):
            return headers, data                 #IGNORING: no compatible .djvu file found

        fname, extorig = os.path.splitext(name)
        open(name, 'wb').write(data)

        #uses local copy of .bat file to call PDFRead from install directory and passes up to 9 parameters.
        #Double quotes are a problem so are reversed for parameters 2, 4, 6; otherwise no spaces allowed!
        #Currently using 9 parameters below (not including the command).  
	if impserve.config.ebook_type == 1:
            if subprocess.call(['pdfread-cmd.bat', '-t', fname, '-a', 'Impserve PDFRead plugin', '-c', 'Converted DJVU', '-p reb1200Cp -i djvu -f imp1 -m portrait-full -o', fname+'_1200', name]) or not os.path.isfile(fname+ext):   #For REB1200
                print " IGNORING: pdfread unable to convert selected file"
                return headers, data
        else:
            if subprocess.call(['pdfread-cmd.bat', '-t', fname, '-a', 'Impserve PDFRead plugin', '-c', 'Converted DJVU', '-p ebw1150-p -i djvu -f imp2 -m portrait-full -o', fname, name]) or not os.path.isfile(fname+ext):           #For EBW1150
                print " IGNORING: pdfread unable to convert selected file"
                return headers, data

        #Send back converted .imp file instead with new filesize.
        headers['Content-Type'] = 'application/x-softbook'
        headers['Content-Length'] = str(getsize(fname+ext))
        data = open(fname+ext, 'rb').read()

        #Cleanup and leave no evidence of 'on-the-fly' conversion.
        os.remove(name)
        #TODO: need to do error-checking if file already exists and if so, append to '_1' or '_2' and so on...
        path, shelf = os.path.split(impserve.config.shelf_dirs[0])
        shutil.move(fname+ext, shelf+'/impserve-'+fname+ext)

        #Store just downloaded .imp in (first) local bookshelf and printout ebook Meta data
        info = impserve.get_ebook_info(shelf+'/impserve-'+fname+ext)  
        print '', info.title, '-by-', info.author, '-Category-', info.category
        print ' Downloaded:', fname+ext, 'and transferred to:', shelf, 'directory'

        return headers, data
