# v0.1 - Initial plugin idea by ashkulz; modifications by nrapallo (Sept 2008)
#
# Uses Lit2sb (dos command) to convert .lit to .imp (EBW1150/REB1200) 'on the fly'...
# Must have s32lit2sb fully installed (to C: drive preferrably) or must edit .bat used.
# See thread http://www.mobileread.com/forums/showthread.php?t=20592 for how to install.
#
# TODO: when saving a copy to the local 'shelf' need to do error-checking if file already exists and if so, append to '_1' or '_2' and so on...
# TODO: remove files or not after lit2sb conversion with a batch file?

from ebookutils import impserve

class LitConverter(impserve.ProxyResponse):
    def __init__(self):
        # register our own mime-types here for the Content-Disposition header; this will
        # override any Content-Type which is sent by the server.
        import mimetypes
        #mimetypes.add_type('application/octet-stream', '.lit')

    def get_response(self, url, headers, data):
        #debug statements
        #print " URL: ", url
        #print " HEAD: ", headers
        #print " DATA: ", data
        # check if we got a Content-Type
        if not 'Content-Type' in headers:
            return headers, data

        ctype = headers['Content-Type']
        found = False
        if 'application/octet-stream' in ctype:       
            found = True
        if not found:
            return headers, data
            
        import os, subprocess, shutil, re, urllib
        from os.path import getsize

	if impserve.config.ebook_type == 1:
           ext = '_1200.imp'                     #For REB1200
        else:
           ext = '.imp'                          #For EBW1150   
        
        #Extract suggested .lit filename and use it to save a copy to the local 'shelf'
        if 'Content-Disposition' in headers:
            m = headers['Content-Disposition']
            name = re.compile('filename="?([^"]+)"?').search(m).group(1)
        else:
            fname, name = os.path.split(url)
        name = urllib.unquote(name)

        #filename should end with .lit, if not return.
        if not name.lower().endswith('.lit'):
            return headers, data              #IGNORING: no compatible .lit file found

        fname, extorig = os.path.splitext(name)
        open(name, 'wb').write(data)

        #uses local copy of .bat file to call Mobi2IMP from install directory and passes up to 9 parameters.
        #Double quotes are a problem so .bat must be fixed to make them work; otherwise no spaces allowed!
        #Currently using 3 parameters below (not including the command).  
	if impserve.config.ebook_type == 1:
            if subprocess.call(['dolit1200.bat', name]) or not os.path.isfile(fname+'.imp'):     #For REB1200
                print " IGNORING: lit2sb unable to convert selected file"
                return headers, data
        else:
            if subprocess.call(['dolit1150.bat', name]) or not os.path.isfile(fname+ext):        #For EBW1150
                print " IGNORING: lit2sb unable to convert selected file"
                return headers, data
        
        #For REB1200 only
        shutil.move(fname+'.imp', fname+ext)

        #Send back converted .imp file instead with new filesize.
        headers['Content-Type'] = 'application/x-softbook'
        headers['Content-Length'] = str(getsize(fname+ext))
        data = open(fname+ext, 'rb').read()
        
        #Cleanup and leave no evidence of 'on-the-fly' conversion.
        os.remove(name)
        shutil.rmtree(fname, True)
	#if impserve.config.ebook_type == 1:
        #    os.remove(fname+'_1200.opf')         #For REB1200
        #else:
        #    os.remove(fname+'.opf')              #For EBW1150
        
        #move .imp ebook to local 'shelf' directory using suggested filename
        #TODO: need to do error-checking if file already exists and if so, append to '_1' or '_2' and so on...
        path, shelf = os.path.split(impserve.config.shelf_dirs[0])
        shutil.move(fname+ext, shelf+'/impserve-'+fname+ext)

        #Store just downloaded .imp in (first) local bookshelf and printout ebook Meta data
        info = impserve.get_ebook_info(shelf+'/impserve-'+fname+ext)  
        print '', info.title, '-by-', info.author, '-Category-', info.category
        print ' Downloaded:', fname+ext, 'and transferred to:', shelf, 'directory'

        return headers, data
