# v0.2 - Initial plugin by nrapallo (Sept 2008)
# Converts any large image (bigger than 128x128) down to 128x128 and
# converts it to a 256 color PNG, if not already!

from ebookutils import impserve

size = 128, 128

class AdjustImageSize(impserve.ProxyResponse):
    def get_response(self, url, headers, data):
        #print headers       #debug statement

        if not 'image/' in headers['Content-Type']:
            return headers, data

        import os
        from os.path import getsize
        from PIL import Image

	# save a copy locally so that can 'open' image
        open('plugins/impserve.image', 'wb').write(data)
	
        im = Image.open('plugins/impserve.image')

        if im.size > size:
                print  "Old image --> ", im.format, im.size, im.mode
                
        	if impserve.config.ebook_type == 1:
                    #convert image to 8-bit color, paletted for REB1200 
                    im = im.convert('P', palette=Image.ADAPTIVE, colors=256, dither=Image.FLOYDSTEINBERG)
                else:
                    #convert image to 8-bit grayscale, paletted for EBW1150
                    im = im.convert('L', palette=Image.ADAPTIVE, colors=256, dither=Image.FLOYDSTEINBERG)
                
                #convert image to 128x128 thumbnail
                im.thumbnail(size, Image.ANTIALIAS)
                
        	im.format = "PNG"    #Kludge: must tell im what format it was after convert
        	
        	im.save('plugins/impserve.thumbnail.png', 'PNG', optimize=1)

                print "New image --> ", im.format, im.size, im.mode
        
        	# save a copy locally so that can return image
         	data = open('plugins/impserve.thumbnail.png', 'rb').read()                
                headers['Content-Type'] = 'image/png'
                headers['Content-Length'] = str(getsize('plugins/impserve.thumbnail.png'))
                
                os.remove('plugins/impserve.thumbnail.png')
         	
	del im
        os.remove('plugins/impserve.image')  
        
        return headers, data
