# v0.1 - Initial plugin idea by ashkulz; modifications by nrapallo (Sept 2008)
#
# When downloading .imp to the ebook reader, also save a copy of it in the
# local 'shelf' directory

from ebookutils import impserve
import os, re, urllib

class ImpSaver(impserve.ProxyResponse):
    def get_response(self, url, headers, data):
        if not 'application/x-softbook' in headers['Content-Type']:
            return headers, data
       
        #Extract suggested .imp filename and use it to save to the local 'shelf'
        if 'Content-Disposition' in headers:
            m = headers['Content-Disposition']
            name = re.compile('filename="?([^"]+)"?').search(m).group(1)
        else:
            fname, name = os.path.split(url)
        name = urllib.unquote(name)

        #filename should end with .imp, if not return.
        if not name.lower().endswith('.imp'):         
            return headers, data              #IGNORING: no compatible .imp file found

        #TODO: need error-checking to see if file already exists and, if so, append to '_1' or '_2' and so on...
        path, shelf = os.path.split(impserve.config.shelf_dirs[0])
        open(shelf+'/impserve-'+name, 'wb').write(data)
        
        #Store just downloaded .imp in (first) local bookshelf and printout ebook Meta data
        info = impserve.get_ebook_info(shelf+'/impserve-'+name)  
        print '', info.title, '-by-', info.author, '-Category-', info.category
        print ' Downloaded:', name, 'and transferred to:', shelf, 'directory'

        return headers, data
