"""
 Create Sony collections using Filenames

"""


import xml.dom.minidom, sys, os, uuid

def process(infile):
    f = open(infile, 'r')
    doc = xml.dom.minidom.parse(f)
    f.close()
    savefile = infile + ".sav"

    if not os.path.exists(savefile):
        os.rename(infile, savefile)
    else:
        print "Save file already exists:", savefile
        return
    
    records = doc.getElementsByTagName('records')[0]
    nextId = int(doc.firstChild.getAttribute('nextID'))
    books = doc.getElementsByTagName('xs1:text')
    print "Books =", books.length
    
    # Collections = dictionary, with key=Series Name & val=SeriesDict
    #   SeriesDict = dictionary, with key=Series Index & val=bookId
    # Filename expected format = "<author> - [<series> - ]<title>.<ext>"
    #
    collections = {}
    for b in books:
        path = b.getAttribute('path')
        bookId = b.getAttribute('id')
        name = path[path.rindex('/')+1:]
        parts = name.split(' - ')
        if len(parts) == 3:  # in a Series
            pos = parts[1].rindex(' ')
            series = parts[1][:pos]
            seriesIndex = parts[1][pos+1:]
            d = {}
            if series in collections:
                d = collections[series]
            else:
                collections[series] = d
            d[seriesIndex] = bookId


    playlists = doc.getElementsByTagName('xs1:playlist')
    existingCollections = [p.getAttribute('title') for p in playlists]

    #    For each collection:
    #        if exists in dom:
    #            Delete contents
    #        Else
    #            Create new collection node
    #
    #        Get keys of SeriesIndex & Sort
    #        For each key:
    #            Add item

    cols = collections.keys()
    cols.sort()

    for title in cols:
        # print "Title=", title
        if title in existingCollections:
            # delete existing contents
            colNode = playlists[existingCollections.index(title)]
            lastChild = colNode.lastChild
	    while colNode.firstChild: 
	        colNode.removeChild(colNode.firstChild)
            colNode.appendChild(lastChild)
        else:
            # add node
            txtNode = doc.createTextNode('\n\t\t')
            records.insertBefore(txtNode, records.lastChild)
            colNode = doc.createElement('xs1:playlist')
	    colTitle = (title+" Series",title)[title.endswith("Trilogy")]
            colNode.setAttribute("title", colTitle)
            colNode.setAttribute("sourceid", "1")
            colNode.setAttribute("id", str(nextId))
            nextId += 1
            # make a random UUID then tweak it to make Sony's format
            colNode.setAttribute("uuid", str(uuid.uuid4()).replace('-','',1).upper()) 
            colNode.appendChild(doc.createTextNode('\n\t\t'))
            records.insertBefore(colNode, records.lastChild)

        items = collections[title]
        positions = items.keys()
        positions.sort() # Alphabetic sort
        for pos in positions:
            id = items[pos]
            txtNode = doc.createTextNode('\n\t\t\t')
            colNode.insertBefore(txtNode, colNode.lastChild)
            itemNode = doc.createElement('xs1:item')
            itemNode.setAttribute("id", id)
            colNode.insertBefore(itemNode, colNode.lastChild)

    # Update attribute               
    doc.firstChild.setAttribute('nextID', str(nextId))

    # Output file
    outfile = open(infile, 'w')
    doc.writexml(UnicodeWriter(outfile), encoding='UTF-8')
    outfile.close()

class UnicodeWriter:
    def __init__(self, file):
        self.file = file
    def write(self, text):
        text = text.replace(u"'", u"&apos;")
        self.file.write(text.encode('UTF-8'))

        
def main(args=sys.argv):
    process(args[1])
    print "Processed", args[1]
    return 0
    
if __name__ == '__main__':
    sys.exit(main())
