#~ # -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.54"  #Added RIS Export Tag L1 for .PDF Files (Only)

from PyQt5 import QtCore, QtGui, QtWidgets
from PyQt5.Qt import (Qt, QDialog, QFileDialog, QObject, QApplication,
                                        QLabel, QWidget, QPushButton, QSpinBox, QInputDialog,
                                        QGridLayout, QTabWidget, QVBoxLayout, QScrollArea, QLayout,
                                        QPalette, QColor, QMargins, QSize, QSizePolicy, QHBoxLayout, QProgressDialog,
                                        QIcon, QGroupBox, QLineEdit, QDialogButtonBox, QProgressBar,
                                        QCheckBox, QButtonGroup, QToolTip, QFont, QRadioButton, QComboBox, QTextEdit, QTextOption,
                                        QTableWidget, QTableWidgetItem)
import os,sys
import apsw
import ast
import atexit
import csv
import codecs
import collections
from contextlib import contextmanager
from copy import deepcopy
import datetime
from datetime import datetime
from functools import partial
import platform
import re
import shutil
from shutil import copy, copyfile
import tempfile
from tempfile import TemporaryFile
import time
from time import sleep
import unicodedata
import zipfile

from calibre import isbytestring, force_unicode, prints
from calibre.constants import filesystem_encoding, DEBUG, iswindows, get_version
from calibre.db.backend import DB
from calibre.db.cache import Cache
dbcache = Cache
from calibre.ebooks.metadata.meta import set_metadata
from calibre.ebooks.metadata.book.base import Metadata
from calibre.gui2 import error_dialog, info_dialog, question_dialog, FileDialog, __init__, gprefs
from calibre.ptempfile import PersistentTemporaryDirectory, PersistentTemporaryFile, base_dir
from calibre.utils.config import JSONConfig
from calibre.utils.html2text import html2text

from calibre_plugins.zotero_metadata_importer.config import prefs
from calibre_plugins.zotero_metadata_importer.zmi_cli_custom_columns import zmi_cli_add_custom_column, send_rc_message

PLAIN_TEXT_CALIBRE_VERSION = str("2.64")
PLAIN_TEXT_COMMENTS_DISPLAY = '{"description": "[DESCRIPTION_GOES_HERE]", "interpret_as": "long-text", "heading_position": "side"}'


#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):
    initial_extra_size = QSize(25, 275)  # w,h

    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent)
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)

    def resize_dialog(self):

        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)

    def save_dialog_geometry(self):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class ZoteroMetadataImporterDialog(SizePersistedDialog):
    #-----------------------------------------------------------------------------------------
    def __init__(self,gui,icon,guidb,plugin_path,ui_exit,action_type):
        parent = gui
        unique_pref_name = 'zotero_metadata_importer:gui_zmi_dialog'
        SizePersistedDialog.__init__(self, parent, unique_pref_name)
        #-----------------------------------------------------
        self.gui = gui
        self.guidb = guidb
        #-----------------------------------------------------
        self.icon = icon
        #-----------------------------------------------------
        self.plugin_path = plugin_path
        #-----------------------------------------------------
        self.ui_exit = ui_exit
        #-----------------------------------------------------
        self.action_type = action_type
        #-----------------------------------------------------
        self.myparentprefs = collections.OrderedDict([])
        prefsdefaults = deepcopy(prefs.defaults)
        tmp_list = []
        for k,v in prefs.iteritems():
            tmp_list.append(k)
        #END FOR
        for k,v in prefsdefaults.iteritems():
            tmp_list.append(k)
        #END FOR
        tmp_set = set(tmp_list)
        tmp_list = list(tmp_set)  #no duplicates
        del tmp_set
        tmp_list.sort()
        for k in tmp_list:
            self.myparentprefs[k] = " "  # ordered by key
        #END FOR
        del tmp_list
        for k,v in prefs.iteritems():
            self.myparentprefs[k] = v
        #END FOR
        for k,v in prefsdefaults.iteritems():
            if not k in prefs:
                prefs[k] = v
            else:
                if not prefs[k] > " ":
                    prefs[k] = v
            if not k in self.myparentprefs:
                self.myparentprefs[k] = v
            else:
                if not self.myparentprefs[k] > " ":
                    self.myparentprefs[k] = v
        #END FOR
        for k,v in self.myparentprefs.iteritems():
            prefs[k] = v
        #END FOR
        prefs  #prefs now synched

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.param_dict = collections.OrderedDict([])
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.init_tooltips_for_parent()
        self.setToolTip(self.parent_tooltip)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab 0: ZoteroMetadataImporterTab
        #-----------------------------------------------------
        #-----------------------------------------------------
        from calibre_plugins.zotero_metadata_importer.zmi_dialog import ZoteroMetadataImporterTab
        self.ZoteroMetadataImporterTab = ZoteroMetadataImporterTab(self.gui,self.guidb,self.myparentprefs,self.ui_exit,self.save_dialog_geometry,self.icon)

        self.validate_custom_columns = self.ZoteroMetadataImporterTab.validate_custom_columns
        self.apsw_connect_to_library = self.ZoteroMetadataImporterTab.apsw_connect_to_library
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab 1: ZoteroOptionsTab
        #-----------------------------------------------------
        #-----------------------------------------------------
        from calibre_plugins.zotero_metadata_importer.zmi_dialog import ZoteroOptionsTab
        self.ZoteroOptionsTab = ZoteroOptionsTab(self.gui,self.guidb,self.myparentprefs,self.save_all_prefs,self.ui_exit,self.save_dialog_geometry)

        self.return_option_prefs = self.ZoteroOptionsTab.return_option_prefs
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab 2: ZoteroComparisonTab
        #-----------------------------------------------------
        #-----------------------------------------------------
        from calibre_plugins.zotero_metadata_importer.zmi_dialog import ZoteroComparisonTab
        self.ZoteroComparisonTab = ZoteroComparisonTab(self.gui,self.guidb,self.myparentprefs,self.save_all_prefs,self.ui_exit,self.save_dialog_geometry)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab 3: ZoteroMetadataExporterTab
        #-----------------------------------------------------
        #-----------------------------------------------------
        from calibre_plugins.zotero_metadata_importer.zmi_dialog import ZoteroMetadataExporterTab
        self.ZoteroMetadataExporterTab = ZoteroMetadataExporterTab(self.gui,self.guidb,self.myparentprefs,self.save_all_prefs,self.ui_exit,self.save_dialog_geometry,self.apsw_connect_to_library)

        self.return_export_prefs = self.ZoteroMetadataExporterTab.return_export_prefs
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #    Parent             ZoteroMetadataImporterDialog
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)

        tablabel_font = QFont()
        tablabel_font.setBold(False)
        tablabel_font.setPointSize(10)

        #-----------------------------------------------------
        self.setWindowTitle('Zotero Metadata Importer')
        self.setWindowIcon(icon)
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout_frame)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        n_width = 600

        self.ZMITabWidget = QTabWidget()
        self.ZMITabWidget.setMaximumWidth(n_width)
        self.ZMITabWidget.setFont(tablabel_font)

        self.ZMITabWidget.addTab(self.ZoteroMetadataImporterTab,"ZMI: Import Books && Metadata")
        self.ZoteroMetadataImporterTab.setToolTip(self.parent_tooltip)
        self.ZoteroMetadataImporterTab.setMaximumWidth(n_width)

        self.ZMITabWidget.addTab(self.ZoteroOptionsTab,"ZMI: Options     ")
        self.ZoteroOptionsTab.setToolTip(self.parent_tooltip)
        self.ZoteroOptionsTab.setMaximumWidth(n_width)

        self.ZMITabWidget.addTab(self.ZoteroComparisonTab,"ZMI: Comparison     ")
        self.ZoteroComparisonTab.setMaximumWidth(n_width)

        self.ZMITabWidget.addTab(self.ZoteroMetadataExporterTab,"ZMI: Export RIS     ")
        self.ZoteroMetadataExporterTab.setMaximumWidth(n_width)

           #-----------------------------------------------------
        self.layout_frame.addWidget(self.ZMITabWidget)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.auto_validate_at_startup()
        #-----------------------------------------------------
        self.resize_dialog()      # inherited from SizePersistedDialog

        self.ZMITabWidget.currentChanged.connect(self.event_tab_index_changed)

        if "ZMI_LAST_TAB_SELECTED" in prefs:
            n = int(prefs["ZMI_LAST_TAB_SELECTED"])
            self.ZMITabWidget.setCurrentIndex(n)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    # EVENTS
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def event_tab_index_changed(self,event):
        n = self.ZMITabWidget.currentIndex()
        prefs["ZMI_LAST_TAB_SELECTED"] = unicode(n)
        prefs
        #~ if DEBUG: print("Tab Changed to: ", prefs["ZMI_LAST_TAB_SELECTED"])
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def auto_validate_at_startup(self):
        if  prefs['ZMI_AUTO_VALIDATE_CUSTOM_COLUMNS_AT_STARTUP'] == unicode("True"):
            self.validate_custom_columns(False)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def init_tooltips_for_parent(self):
        self.setStyleSheet("QToolTip { color: #ffffff; background-color: #2a82da; border: 1px solid white; }")
        self.parent_tooltip = "<p style='white-space:wrap'>ZMI will add Zotero's file attachments and their Zotero metadata to Calibre via the use of a Zotero CSV export file.  It also has the ability to export an RIS file for importing into Zotero.\
                                                                                        <br><br>Periodically click 'Calibre > Library Icon > Library Maintenance > Check Library' to compress your Calibre database."
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def save_all_prefs(self):
        allprefs = self.myparentprefs.copy()
        allprefs = self.return_option_prefs(allprefs)
        for k,v in allprefs.iteritems():
            prefs[k] = v
            self.myparentprefs[k] = v
        #END FOR
        del allprefs
        allprefs = self.myparentprefs.copy()
        allprefs = self.return_export_prefs(allprefs)
        for k,v in allprefs.iteritems():
            prefs[k] = v
            self.myparentprefs[k] = v
        #END FOR
        del allprefs
        prefs
        return self.myparentprefs
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class ZoteroMetadataImporterTab(QWidget):
    def __init__(self,mygui,myguidb,mymainprefs,myuiexit,mysavedialoggeometry,myicon):
        super(ZoteroMetadataImporterTab, self).__init__()
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.gui = mygui
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.guidb = myguidb
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.lib_path = self.gui.library_view.model().db.library_path
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.mytabprefs = mymainprefs
        #-----------------------------------------------------
        self.icon = myicon
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.ui_exit = myuiexit
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.save_dialog_geometry = mysavedialoggeometry
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)
        #-----------------------------------------------------
        self.layout_top = QVBoxLayout()
        self.layout_top.setSpacing(0)
        self.layout_top.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout_top)
        #-----------------------------------------------------
        self.scroll_area_frame = QScrollArea()
        self.scroll_area_frame.setAlignment(Qt.AlignCenter)
        self.scroll_area_frame.setWidgetResizable(True)
        self.scroll_area_frame.ensureVisible(300,300)

        self.layout_top.addWidget(self.scroll_area_frame)       # the scroll area is now the child of the parent of self.layout_top

        # NOTE: the self.scroll_area_frame.setWidget(self.scroll_widget) is at the end of the init() AFTER all children have been created and assigned to a layout...

        #-----------------------------------------------------
        self.scroll_widget = QWidget()
        self.layout_top.addWidget(self.scroll_widget)           # causes automatic reparenting of QWidget to the parent of self.layout_top, which is:  self .
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setAlignment(Qt.AlignCenter)

        self.scroll_widget.setLayout(self.layout_frame)        # causes automatic reparenting of any widget later added to self.layout_frame to the parent of self.layout_frame, which is:  QWidget .

        #-----------------------------------------------------
        self.zmi_groupbox = QGroupBox('Sequential Steps:')
        self.zmi_groupbox.setMinimumWidth(510)
        self.zmi_groupbox.setToolTip("<p style='white-space:wrap'>Each pushbutton must be executed in a strict Top-Down sequence.  If you make a mistake or change your mind, simply click the 'Restart ZMI' pushbutton to begin again.")
        self.layout_frame.addWidget(self.zmi_groupbox)

        self.zmi_layout = QVBoxLayout()
        self.zmi_groupbox.setLayout(self.zmi_layout)

        self.push_button_validate_zotero_custom_columns = QPushButton("Validate/Auto-Generate Current Library Zotero Custom Columns")
        self.push_button_validate_zotero_custom_columns.clicked.connect(self.validate_zotero_custom_columns)
        self.push_button_validate_zotero_custom_columns.setDefault(True)
        self.push_button_validate_zotero_custom_columns.setFont(font)
        self.push_button_validate_zotero_custom_columns.setToolTip("<p style='white-space:wrap'>Verify that the many Calibre Custom Columns specific to Zotero already exist.  If not, ZMI will automatically create them, and then Calibre will be restarted.")
        self.zmi_layout.addWidget(self.push_button_validate_zotero_custom_columns)

        self.push_button_validate_zotero_custom_columns.hide()
        if not prefs['ZMI_AUTO_VALIDATE_CUSTOM_COLUMNS_AT_STARTUP'] == unicode("True"):
            self.push_button_validate_zotero_custom_columns.show()

        self.zmi_custom_columns_generation_label = QLabel()
        s = ""
        self.zmi_custom_columns_generation_label.setText(s)
        self.zmi_custom_columns_generation_label.setAlignment(Qt.AlignCenter)
        self.zmi_custom_columns_generation_label.setMinimumWidth(400)
        self.zmi_custom_columns_generation_label.setFont(font)
        self.zmi_layout.addWidget(self.zmi_custom_columns_generation_label)

        self.zmi_custom_columns_generation_label.hide()

        self.validation_generation_complete = False

        self.zmi_layout.addStretch(1)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.zmi_groupbox1 = QGroupBox('Add Zotero Books and Metadata:')
        self.zmi_groupbox1.setMinimumWidth(510)
        self.zmi_groupbox1.setToolTip("<p style='white-space:wrap'>Each pushbutton must be executed in a strict Top-Down sequence.  If you make a mistake or change your mind, simply click the 'Restart ZMI' pushbutton to begin again.")
        self.zmi_layout.addWidget(self.zmi_groupbox1)

        self.zmi_layout1 = QVBoxLayout()
        self.zmi_groupbox1.setLayout(self.zmi_layout1)

        #-----------------------------------------------------
        #-----------------------------------------------------

        self.zmi_mode_layout = QHBoxLayout()
        self.zmi_mode_layout.setAlignment(Qt.AlignCenter)
        self.zmi_layout1.addLayout(self.zmi_mode_layout)

        self.zmi_mode_single_step_radio = QRadioButton('Single-Step Mode')
        self.zmi_mode_single_step_radio.setToolTip("<p style='white-space:wrap'>Each step will only be executed after you click its button.<br><br>If you are experiencing problems, use this mode.")
        self.zmi_mode_layout.addWidget(self.zmi_mode_single_step_radio)

        self.zmi_mode_auto_step_radio = QRadioButton('Auto-Step Mode')
        self.zmi_mode_auto_step_radio.setToolTip("<p style='white-space:wrap'>Most of the following steps will be executed sequentially and automatically for all newly imported books after you click the next button.\
                                                               <br><br>If you are experiencing problems, do not use this mode.")
        self.zmi_mode_layout.addWidget(self.zmi_mode_auto_step_radio)

        self.zmi_mode_manual_radio = QRadioButton('Manual Mode')
        self.zmi_mode_manual_radio.setToolTip("<p style='white-space:wrap'>For a single book, the specific row in the Zotero CSV file will be chosen from which to import the metadata.")
        self.zmi_mode_layout.addWidget(self.zmi_mode_manual_radio)

        self.zmi_mode_button_group = QButtonGroup(self.zmi_mode_layout)
        self.zmi_mode_button_group.setExclusive(True)
        self.zmi_mode_button_group.addButton(self.zmi_mode_single_step_radio)
        self.zmi_mode_button_group.addButton(self.zmi_mode_auto_step_radio)
        self.zmi_mode_button_group.addButton(self.zmi_mode_manual_radio)

        if prefs['ZMI_PREFER_AUTO_STEP_MODE'] == unicode("True"):
            self.zmi_mode_auto_step_radio.setChecked(True)
        else:
            self.zmi_mode_single_step_radio.setChecked(True)

        if prefs['ZMI_PREFER_AUTO_STEP_MODE'] <> unicode("True"):
            self.zmi_mode_auto_step_radio.hide()

        self.show_manual_pushbutton_after_restart = False
        if prefs['ZMI_MANUAL_MODE_REQUESTED_AFTER_RESTART'] == unicode("True"):
            self.zmi_mode_single_step_radio.hide()
            self.zmi_mode_auto_step_radio.hide()
            self.zmi_mode_manual_radio.show()
            self.zmi_mode_manual_radio.setChecked(True)
            self.show_manual_pushbutton_after_restart = True
            prefs['ZMI_MANUAL_MODE_REQUESTED_AFTER_RESTART'] = unicode("False")
            prefs

        self.auto_select_csv_import_directory_text_auto_mode = "Auto-Select All CSV Export Files then Add Missing Books to Calibre"
        self.auto_select_csv_import_directory_text_manual_mode   = "Auto-Select All CSV Export Files [Manual Mode]"

        self.push_button_auto_select_csv_import_directory = QPushButton(self.auto_select_csv_import_directory_text_auto_mode)
        self.push_button_auto_select_csv_import_directory.clicked.connect(self.execute_auto_select_csv_import_directory)
        self.push_button_auto_select_csv_import_directory.setDefault(False)
        self.push_button_auto_select_csv_import_directory.setFont(font)
        self.push_button_auto_select_csv_import_directory.setToolTip("<p style='white-space:wrap'>Automatically select all of the CSV files currently in the Import Directory specified in Options, and combine them in order to process all of them simultaneously (instead of one CSV file at a time). The ToolTips for the 'Select Single' button, below, also pertain to this button.")
        self.zmi_layout1.addWidget(self.push_button_auto_select_csv_import_directory)

        if self.zmi_mode_manual_radio.isChecked():
            self.push_button_auto_select_csv_import_directory.setText(self.auto_select_csv_import_directory_text_manual_mode)

        self.select_zotero_export_csv_file_text_auto_mode = "Select Single CSV Export File then Add Missing Books to Calibre"
        self.select_zotero_export_csv_file_text_manual_mode   = "Select Single CSV Export File [Manual Mode]"

        self.push_button_select_zotero_export_csv_file = QPushButton(self.select_zotero_export_csv_file_text_auto_mode)
        self.push_button_select_zotero_export_csv_file.clicked.connect(self.select_zotero_export_csv_file)
        self.push_button_select_zotero_export_csv_file.setDefault(False)
        self.push_button_select_zotero_export_csv_file.setFont(font)
        self.push_button_select_zotero_export_csv_file.setToolTip("<p style='white-space:wrap'>Select the Zotero CSV file containing the books and metadata that you want to import to Calibre.\
                                                                                                    <br><br>You cannot change the selected CSV file once the next step has been executed without first restarting ZMI.\
                                                                                                    <br><br>Because of potential duplicate file attachment filenames in Zotero, you should always execute this <b>at least twice</b> for each CSV file to ensure that all of its books have been added by ZMI.\
                                                                                                    <br><br>To see an exact list of what Zotero books are still missing, you must execute this function in Single-Step Mode, not Auto-Step Mode.")
        self.zmi_layout1.addWidget(self.push_button_select_zotero_export_csv_file)

        if self.zmi_mode_manual_radio.isChecked():
            self.push_button_select_zotero_export_csv_file.setText(self.select_zotero_export_csv_file_text_manual_mode)

        if prefs['ZMI_AUTO_SELECT_CSV_IMPORT_DIRECTORY'] == unicode("True"):
            self.push_button_auto_select_csv_import_directory.setFont(font)
            font.setPointSize(7)
            self.push_button_select_zotero_export_csv_file.setFont(font)
            font.setPointSize(10)
        else:
            self.push_button_auto_select_csv_import_directory.hide()
            self.push_button_select_zotero_export_csv_file.setFont(font)

        self.zmi_selected_export_csv_file_label = QLabel()
        s = ""
        self.zmi_selected_export_csv_file_label.setText(s)
        self.zmi_selected_export_csv_file_label.setAlignment(Qt.AlignCenter)
        self.zmi_selected_export_csv_file_label.setMinimumWidth(400)
        self.zmi_selected_export_csv_file_label.setFont(font)
        self.zmi_layout1.addWidget(self.zmi_selected_export_csv_file_label)

        self.zotero_export_csv_selection_complete = False

        self.zmi_layout1.addStretch(2)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_automatically_update_calibre_metadata = QPushButton("Automatically Add Zotero Metadata Using Selected CSV File(s) [Selected Books]")
        self.push_button_automatically_update_calibre_metadata.clicked.connect(self.automatically_update_calibre_metadata_control)
        self.push_button_automatically_update_calibre_metadata.setDefault(False)
        self.push_button_automatically_update_calibre_metadata.setFont(font)
        self.push_button_automatically_update_calibre_metadata.setToolTip("<p style='white-space:wrap'>This automatically updates the many Calibre Custom Columns for Zotero using the Zotero CSV file that was exported from Zotero.  The book files in Zotero must have already been added to Calibre.")
        self.zmi_layout1.addWidget(self.push_button_automatically_update_calibre_metadata)

        self.zmi_automatically_update_calibre_metadata_label = QLabel()
        s = ""
        self.zmi_automatically_update_calibre_metadata_label.setText(s)
        self.zmi_automatically_update_calibre_metadata_label.setToolTip("<p style='white-space:wrap'>The number of books actually added to Calibre may be less than the number of rows in the Zotero CSV file due to: (a) missing Zotero files  in the 'storage' directory; (b) CSV file that is not encoded in Unicode UTF-8; and/or other data-related reasons.  ")
        self.zmi_automatically_update_calibre_metadata_label.setAlignment(Qt.AlignCenter)
        self.zmi_automatically_update_calibre_metadata_label.setMinimumWidth(400)
        self.zmi_automatically_update_calibre_metadata_label.setFont(font)
        self.zmi_layout1.addWidget(self.zmi_automatically_update_calibre_metadata_label)

        self.calibre_metadata_auto_update_complete = False

        self.push_button_manually_update_calibre_metadata = QPushButton("Manual Mode: Add Calibre Metadata Using Zotero CSV File [Single Book]")
        self.push_button_manually_update_calibre_metadata.clicked.connect(self.manually_update_calibre_metadata_control)
        self.push_button_manually_update_calibre_metadata.setDefault(False)
        self.push_button_manually_update_calibre_metadata.setFont(font)
        self.push_button_manually_update_calibre_metadata.setToolTip("<p style='white-space:wrap'>This manually updates (a single step at a time) the many Calibre Custom Columns for Zotero for a single book using the Zotero CSV file that was exported from Zotero.  The book files in Zotero must have already been added <b>MANUALLY</b>, one book at a time, to Calibre using standard Calibre functionality 'Add Books'.  This is the <b>only</b> exception to the rule that only ZMI adds books to Calibre. ")
        self.zmi_layout1.addWidget(self.push_button_manually_update_calibre_metadata)

        if not self.zmi_mode_manual_radio.isChecked():
            self.push_button_manually_update_calibre_metadata.hide()
        else:
            self.push_button_automatically_update_calibre_metadata.hide()

        if self.show_manual_pushbutton_after_restart:
            self.push_button_manually_update_calibre_metadata.show()

        self.zmi_mode_single_step_radio.clicked.connect(self.hide_show_manual_mode_pushbutton)
        self.zmi_mode_auto_step_radio.clicked.connect(self.hide_show_manual_mode_pushbutton)
        self.zmi_mode_manual_radio.clicked.connect(self.hide_show_manual_mode_pushbutton)

        self.zmi_layout.addStretch(1)

        self.zmi_groupbox2 = QGroupBox('Update Calibre Metadata Using Zotero Metadata:')
        self.zmi_groupbox2.setMinimumWidth(510)
        self.zmi_groupbox2.setMinimumHeight(250)
        self.zmi_groupbox2.setToolTip("<p style='white-space:wrap'>This may be performed for newly added (above) or pre-existing books in Calibre.")
        self.zmi_layout.addWidget(self.zmi_groupbox2)

        self.zmi_layout2 = QVBoxLayout()
        self.zmi_groupbox2.setLayout(self.zmi_layout2)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_update_calibre_title = QPushButton("Update Calibre Title Using Zotero Title [Selected Books]")
        self.push_button_update_calibre_title.clicked.connect(self.update_calibre_title)
        self.push_button_update_calibre_title.setDefault(False)
        self.push_button_update_calibre_title.setFont(font)
        self.push_button_update_calibre_title.setToolTip("<p style='white-space:wrap'>Change the Calibre Title to be the same as the Zotero Title.  This has a profound impact on the Path of the book itself in Calibre.")
        self.zmi_layout2.addWidget(self.push_button_update_calibre_title)

        self.update_calibre_title_complete = False

        self.push_button_update_calibre_author = QPushButton("Update Calibre Author Using Zotero Author [Selected Books]")
        self.push_button_update_calibre_author.clicked.connect(self.update_calibre_author)
        self.push_button_update_calibre_author.setDefault(False)
        self.push_button_update_calibre_author.setFont(font)
        self.push_button_update_calibre_author.setToolTip("<p style='white-space:wrap'>Change the Calibre Author to be the same as the Zotero Author.  This has a profound impact on the Path of the book itself in Calibre.")
        self.zmi_layout2.addWidget(self.push_button_update_calibre_author)

        self.update_calibre_author_complete = False

        self.zmi_layout2.addStretch(1)

        self.zmi_show_incomplete_layout = QHBoxLayout()
        self.zmi_show_incomplete_layout.setAlignment(Qt.AlignCenter)
        self.zmi_layout2.addLayout(self.zmi_show_incomplete_layout)

        font.setPointSize(7)

        self.push_button_search_for_incomplete_books = QPushButton("Show Incomplete Books")
        self.push_button_search_for_incomplete_books.setMinimumWidth(200)
        self.push_button_search_for_incomplete_books.setMaximumWidth(200)
        self.push_button_search_for_incomplete_books.clicked.connect(self.show_incomplete_books_pushbutton)
        self.push_button_search_for_incomplete_books.setDefault(False)
        self.push_button_search_for_incomplete_books.setFont(font)
        self.push_button_search_for_incomplete_books.setToolTip("<p style='white-space:wrap'>Always click this after adding new books.  This will search for all books still with an Identifier of 'zmi:new'.  That means that the next three (3) steps have not been completed for all of those books.  \
                                                                                                        Afterwards, 'Select All' of the found incomplete books, then execute the next three (3) steps.")
        self.zmi_show_incomplete_layout.addWidget(self.push_button_search_for_incomplete_books)

        font.setPointSize(10)

        self.push_button_update_calibre_identifiers = QPushButton("Convert ZIsbn/ZIssn/ZDoi to ISBN/ISSN/DOI [Selected Books]")
        self.push_button_update_calibre_identifiers.clicked.connect(self.convert_zisbn_zissn_zdoi_to_identifiers)
        self.push_button_update_calibre_identifiers.setDefault(False)
        self.push_button_update_calibre_identifiers.setFont(font)
        self.push_button_update_calibre_identifiers.setToolTip("<p style='white-space:wrap'>Update the Calibre Identifiers ISBN and/or ISSN and/or DOI using ZIsbn and/or ZIssn and/or ZDoi.<br><br>Important: you should always execute this function manually for all new books.")
        self.zmi_layout2.addWidget(self.push_button_update_calibre_identifiers)

        self.push_button_update_calibre_miscellaneous_standard_columns = QPushButton("Copy Miscellaneous ZColumns to Standard Calibre Columns [Selected Books]")
        self.push_button_update_calibre_miscellaneous_standard_columns.clicked.connect(self.update_miscellaneous_standard_columns)
        self.push_button_update_calibre_miscellaneous_standard_columns.setDefault(False)
        self.push_button_update_calibre_miscellaneous_standard_columns.setFont(font)
        self.push_button_update_calibre_miscellaneous_standard_columns.setToolTip("<p style='white-space:wrap'>Currently supported:\
                                                                                                                                        <br><br>Copy ZPublisher to Publisher if the selected books have a value in ZPublisher.\
                                                                                                                                        <br><br>Copy ZPublication Year to Published Date if the selected books have a value in ZPublication Year.\
                                                                                                                                        <br><br>Copy ZAutomaticTags and/or ZManualTags to Tags if the ZMI Options so specify.\
                                                                                                                                        <br><br>Important: You should always execute this function <b>manually</b> for all new books.")
        self.zmi_layout2.addWidget(self.push_button_update_calibre_miscellaneous_standard_columns)

        self.push_button_update_calibre_identifiers = QPushButton("Copy Miscellaneous ZColumns to Calibre Custom Columns [Selected Books]")
        self.push_button_update_calibre_identifiers.clicked.connect(self.copy_misc_zcolumns_to_custom_columns_control)
        self.push_button_update_calibre_identifiers.setDefault(False)
        self.push_button_update_calibre_identifiers.setFont(font)
        self.push_button_update_calibre_identifiers.setToolTip("<p style='white-space:wrap'>You may copy any ZColumn to most Custom Columns.\
                                                                                                <br><br>You may copy as many ZColumns as you wish, but each may only be used one (1) time per execution. That means that you may copy a specific ZColumn to only one specific Custom Column per execution.\
                                                                                                <br><br>You may copy ZColumns to Custom Columns that have the following datatypes:  integer; float; text; comments; datetime; boolean.\
                                                                                                <br><br>The syntax for specifying the 'From:To' pairs is: '#zotero_xxxxxx:#anycustomcolumn'. \
                                                                                                 <br><br><br>If you wish, you could copy the ZItem Type Custom Column.\
                                                                                                 <br><br>IMPORTANT:  In Auto-Step Mode, this function is <b>not</b> performed.  You must execute this function manually for whatever books you wish to select.")
        self.zmi_layout2.addWidget(self.push_button_update_calibre_identifiers)

        self.zmi_remove_incomplete_layout = QHBoxLayout()
        self.zmi_remove_incomplete_layout.setAlignment(Qt.AlignCenter)
        self.zmi_layout2.addLayout(self.zmi_remove_incomplete_layout)

        font.setPointSize(7)

        self.push_button_set_new_covers = QPushButton("Set Covers")
        self.push_button_set_new_covers.setMinimumWidth(60)
        self.push_button_set_new_covers.setMaximumWidth(60)
        self.push_button_set_new_covers.clicked.connect(self.show_message_about_covers)
        self.push_button_set_new_covers.setDefault(False)
        self.push_button_set_new_covers.setFont(font)
        self.push_button_set_new_covers.setToolTip("<p style='white-space:wrap'>You must use the Standard Calibre Bulk Metadata Edit functionality to set the appropriate 'cover' for each book newly imported from Zotero by ZMI.")
        self.zmi_remove_incomplete_layout.addWidget(self.push_button_set_new_covers)

        self.push_button_delete_zmi_new_identifiers = QPushButton("Mark as Fully Complete [All Books]")
        self.push_button_delete_zmi_new_identifiers.setMinimumWidth(200)
        self.push_button_delete_zmi_new_identifiers.setMaximumWidth(200)
        self.push_button_delete_zmi_new_identifiers.clicked.connect(self.delete_identifier_zmi_new)
        self.push_button_delete_zmi_new_identifiers.setDefault(False)
        self.push_button_delete_zmi_new_identifiers.setFont(font)
        self.push_button_delete_zmi_new_identifiers.setToolTip("<p style='white-space:wrap'>This will remove the Identifier of 'zmi:new' from all books, indicating they they have completed the Zotero Metadata Import process.\
                                                                                                   <br><br>Note: You might want to use the Calibre 'Embed Metadata' function to update your imported .pdf and other book files themselves with all of the current Calibre metadata for them prior to removing the 'zmi:new' identifier.")
        self.zmi_remove_incomplete_layout.addWidget(self.push_button_delete_zmi_new_identifiers)

        self.push_button_archive_csv_files = QPushButton("Archive/Delete Original CSV Files [All]")
        self.push_button_archive_csv_files.setMinimumWidth(200)
        self.push_button_archive_csv_files.setMaximumWidth(200)
        self.push_button_archive_csv_files.clicked.connect(self.archive_original_csv_files)
        self.push_button_archive_csv_files.setDefault(False)
        self.push_button_archive_csv_files.setFont(font)
        self.push_button_archive_csv_files.setToolTip("<p style='white-space:wrap'>This will either move the Zotero CSV files to the archive directory specified in Options, or will otherwise delete them.")
        self.zmi_remove_incomplete_layout.addWidget(self.push_button_archive_csv_files)

        if not prefs['ZMI_AUTO_SELECT_CSV_IMPORT_DIRECTORY'] == unicode("True"):
            self.push_button_archive_csv_files.hide()

        font.setPointSize(10)

        self.zmi_layout2.addStretch(1)

        #-----------------------------------------------------
        #-----------------------------------------------------
        version = get_version()
        s_split = version.split(" ")
        self.calibre_version = s_split[0]
        self.calibre_version = self.calibre_version.strip()
        self.calibre_version = str(self.calibre_version)
        if DEBUG: print("calibre version: ", self.calibre_version)
        if self.calibre_version >= PLAIN_TEXT_CALIBRE_VERSION:
            self.zmi_layout.addStretch(5)
        else:
            self.zmi_groupbox9 = QGroupBox('Add Book Detail View Labels:')
            self.zmi_groupbox9.setMaximumHeight(250)
            self.zmi_groupbox9.setToolTip("<p style='white-space:wrap'>Pending the implementation of an already-approved enhancement to Calibre that would make this step unnecessary, the following buttons allow you to add or remove Calibre Book Detail View Labels.")
            self.zmi_layout.addWidget(self.zmi_groupbox9)

            self.zmi_layout9 = QVBoxLayout()
            self.zmi_groupbox9.setLayout(self.zmi_layout9)

            self.push_button_convert_zcolumns_to_html_with_label = QPushButton("Add ZColumn Labels for Book Detail View [Selected Books]")
            self.push_button_convert_zcolumns_to_html_with_label.clicked.connect(self.convert_zcolumns_to_html_with_label)
            self.push_button_convert_zcolumns_to_html_with_label.setDefault(False)
            self.push_button_convert_zcolumns_to_html_with_label.setFont(font)
            s = "<p style='white-space:wrap'>This should be done only after all other steps have been completed for a book.  This will <b>corrupt</b> the data from the Zotero CSV file by adding HTML to the column values so that a label can be shown in the Calibre book details.  However, if necessary, you can easily remove it via the pushbutton below. "
            self.push_button_convert_zcolumns_to_html_with_label.setToolTip(s)
            self.zmi_layout9.addWidget(self.push_button_convert_zcolumns_to_html_with_label)

            self.push_button_convert_zcolumns_to_simple_text = QPushButton("Remove ZColumn Labels for Book Detail View [Selected Books]")
            self.push_button_convert_zcolumns_to_simple_text.clicked.connect(self.convert_zcolumns_to_simple_text)
            self.push_button_convert_zcolumns_to_simple_text.setDefault(False)
            self.push_button_convert_zcolumns_to_simple_text.setFont(font)
            s = "<p style='white-space:wrap'>If you need to de-corrupt the ZColumns by removing the HTML, use this.  It will again match the Zotero CSV file."
            self.push_button_convert_zcolumns_to_simple_text.setToolTip(s)
            self.zmi_layout9.addWidget(self.push_button_convert_zcolumns_to_simple_text)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.zmi_layout.addStretch(1)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.button_box = QDialogButtonBox()
        self.button_box.setOrientation(Qt.Horizontal)
        self.button_box.setCenterButtons(True)

        self.layout_frame.addWidget(self.button_box)

        self.push_button_restart_zmi = QPushButton("Restart ZMI")
        self.push_button_restart_zmi.clicked.connect(self.restart_zmi)
        self.push_button_restart_zmi.setDefault(False)
        self.push_button_restart_zmi.setFont(font)
        self.push_button_restart_zmi.setToolTip("<p style='white-space:wrap'>Exit ZMI and automatically Restart ZMI.  The current geometry of this window will be saved.")
        self.button_box.addButton(self.push_button_restart_zmi,0)

        self.push_button_exit_zmi = QPushButton("Exit ZMI")
        self.push_button_exit_zmi.clicked.connect(self.exit_zmi)
        self.push_button_exit_zmi.setDefault(False)
        self.push_button_exit_zmi.setFont(font)
        self.push_button_exit_zmi.setToolTip("<p style='white-space:wrap'>Exit.  The current geometry of this window will be saved.")
        self.button_box.addButton(self.push_button_exit_zmi,0)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_widget.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.setWidget(self.scroll_widget)    # now that all widgets have been created and assigned to a layout...
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.create_zotero_custom_column_dicts()
        self.build_generic_custom_column_dicts()
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.empty_txt_file_dir = base_dir()
        self.empty_txt_file_dir = self.empty_txt_file_dir.replace(os.sep,'/')
        self.proceed_if_errors = True
        self.okay_to_continue = True
        self.completed_auto = False
        self.newly_added_books_list = []
        self.selected_books_list = []
        self.original_imported_csv_filenames_list = []
        self.combined_zotero_csv_list = []

        #~ -----------------
        if prefs['ZMI_CSV_IMPORT_TEXT_ALSO'] == unicode("True"):
            self.import_text_too = True
        else:
            self.import_text_too = False
        if 'ZMI_CSV_IMPORT_HTML_TEXT_ALSO' in prefs:      #html no longer supported by zmi...
            del prefs['ZMI_CSV_IMPORT_HTML_TEXT_ALSO']
        #~ -----------------

        if prefs['ZMI_CSV_IMPORT_EMPTY_FILE_ATTACHMENTS'] == unicode("True"):
            self.import_empty_items = True
        else:
            self.import_empty_items = False

        self.create_list_of_formats()

        self.clear_all_marked_books()

        if DEBUG: print("ZMI Version: ", __my_version__)

    #-----------------------------------------------------------------------------------------
    def create_list_of_formats(self):
        self.formats = []
        self.formats.append(".pdf")        # always first in list for performance
        self.formats.append(".epub")     # always second
        if self.import_text_too:
            self.formats.append(".text")
            self.formats.append(".txt")
            self.formats.append(".txtz")
            self.formats.append(".markdown")
        self.formats.append(".doc")
        self.formats.append(".docx")
        self.formats.append(".lit")
        self.formats.append(".prc")
        self.formats.append(".azw")
        self.formats.append(".mobi")
        self.formats.append(".pobi")
        self.formats.append(".azw1")
        self.formats.append(".azw2")
        self.formats.append(".azw3")
        self.formats.append(".azw4")
        self.formats.append(".tpz")
        self.formats.append(".fb2")
        self.formats.append(".rtf")
        self.formats.append(".odt")
        self.formats.append(".snb")
        self.formats.append(".djv")
        self.formats.append(".djvu")
        self.formats.append(".opml")
        self.formats.append(".xps")
        self.formats.append(".oxps")
        self.formats.append(".cbz")
        self.formats.append(".cbr")
        self.formats.append(".lrf")
        self.formats.append(".lrx")
        self.formats.append(".zip")
        self.formats.append(".rar")
        self.formats.append(".ppt")
        self.formats.append(".pptx")
        self.formats.append(".xlsx")
        self.formats.append(".pub")
        self.formats.append(".one")
        self.formats.append(".vsdx")
        self.formats.append(".mso")
        self.formats.append(".xls")
        self.formats.append(".mpp")
        self.formats.append(".vsd")
        self.formats.append(".pptm")
        self.formats.append(".ppsx")
        self.formats.append(".docm")
        self.formats.append(".pps")
        self.formats.append(".vst")
        self.formats.append(".vdx")
        self.formats.append(".potm")
        self.formats.append(".xlc")
        self.formats.append(".fodt")
        self.formats.append(".ods")
        self.formats.append(".fods")
        self.formats.append(".odp")
        self.formats.append(".fodp")
        self.formats.append(".odg")
        self.formats.append(".fodg")
        self.formats.append(".odf")
        self.formats.append(".csv")

        from calibre.customize.ui import all_input_formats
        all_input_formats_set = all_input_formats()
        for format in all_input_formats_set:
            if not "text" in format and not "txt" in format and not "htm" in format and not "markdown" in format:
                format = "." + format
                format = str(format.lower())
                if not format in self.formats:
                    self.formats.append(format)
                    #~ if DEBUG: print(format)
        del all_input_formats
        del all_input_formats_set
    #-----------------------------------------------------------------------------------------
    def hide_show_manual_mode_pushbutton(self,event):
        if self.zmi_mode_manual_radio.isChecked():
            self.push_button_manually_update_calibre_metadata.show()
            self.push_button_automatically_update_calibre_metadata.hide()
            self.push_button_select_zotero_export_csv_file.setText(self.select_zotero_export_csv_file_text_manual_mode)
            self.push_button_auto_select_csv_import_directory.setText(self.auto_select_csv_import_directory_text_manual_mode)
        else:
            self.push_button_manually_update_calibre_metadata.hide()
            self.push_button_automatically_update_calibre_metadata.show()
            self.push_button_select_zotero_export_csv_file.setText(self.select_zotero_export_csv_file_text_auto_mode)
            self.push_button_auto_select_csv_import_directory.setText(self.auto_select_csv_import_directory_text_auto_mode)
    #-----------------------------------------------------------------------------------------
    def validate(self):
        return True
    #-----------------------------------------------------------------------------------------
    def create_zotero_custom_column_dicts(self):

        self.zotero_custom_column_list = []
        self.zotero_custom_column_list.append("zotero_author")
        self.zotero_custom_column_list.append("zotero_automatic_tags")
        self.zotero_custom_column_list.append("zotero_date")
        self.zotero_custom_column_list.append("zotero_date_added")
        self.zotero_custom_column_list.append("zotero_date_modified")
        self.zotero_custom_column_list.append("zotero_doi")
        self.zotero_custom_column_list.append("zotero_extra")
        self.zotero_custom_column_list.append("zotero_file_attachments")
        self.zotero_custom_column_list.append("zotero_isbn")
        self.zotero_custom_column_list.append("zotero_issn")
        self.zotero_custom_column_list.append("zotero_issue")
        self.zotero_custom_column_list.append("zotero_item_type")
        self.zotero_custom_column_list.append("zotero_key")
        self.zotero_custom_column_list.append("zotero_manual_tags")
        self.zotero_custom_column_list.append("zotero_notes")
        self.zotero_custom_column_list.append("zotero_pages")
        self.zotero_custom_column_list.append("zotero_place")
        self.zotero_custom_column_list.append("zotero_publication_title")
        self.zotero_custom_column_list.append("zotero_publication_year")
        self.zotero_custom_column_list.append("zotero_publisher")
        self.zotero_custom_column_list.append("zotero_series")
        self.zotero_custom_column_list.append("zotero_series_number")
        self.zotero_custom_column_list.append("zotero_series_text")
        self.zotero_custom_column_list.append("zotero_series_title")
        self.zotero_custom_column_list.append("zotero_title")
        self.zotero_custom_column_list.append("zotero_url")
        self.zotero_custom_column_list.append("zotero_volume")

        self.zotero_custom_column_dict = {}                         #    [label] = id
        self.zotero_custom_column_name_dict = {}              #     [label] = name
        self.zotero_custom_column_description_dict = {}     #     [label] = description
        self.zotero_csv_header_names_mapping_dict = {}     #    [csvcolname] = label

        for label in self.zotero_custom_column_list:
            label = str(label)
            self.zotero_custom_column_dict[label] = str(0)
            csvcol = label.replace("zotero_","")
            csvcol = csvcol.replace("_"," ")
            csvcol = csvcol.strip()
            self.zotero_csv_header_names_mapping_dict[csvcol] = label
        #END FOR

        self.zotero_custom_column_name_dict["zotero_author"] = str("ZAuthor")
        self.zotero_custom_column_name_dict["zotero_automatic_tags"] = str("ZAutomatic Tags")
        self.zotero_custom_column_name_dict["zotero_date"] = str("ZDate")
        self.zotero_custom_column_name_dict["zotero_date_added"] = str("ZDate Added")
        self.zotero_custom_column_name_dict["zotero_date_modified"] = str("ZDate Modified")
        self.zotero_custom_column_name_dict["zotero_doi"] = str("ZDoi")
        self.zotero_custom_column_name_dict["zotero_extra"] = str("ZExtra")
        self.zotero_custom_column_name_dict["zotero_file_attachments"] = str("ZFile Attachments")
        self.zotero_custom_column_name_dict["zotero_isbn"] = str("ZIsbn")
        self.zotero_custom_column_name_dict["zotero_issn"] = str("Zissn")
        self.zotero_custom_column_name_dict["zotero_issue"] = str("ZIssue")
        self.zotero_custom_column_name_dict["zotero_item_type"] = str("ZItemType")
        self.zotero_custom_column_name_dict["zotero_key"] = str("ZKey")
        self.zotero_custom_column_name_dict["zotero_manual_tags"] = str("ZManual Tags")
        self.zotero_custom_column_name_dict["zotero_notes"] = str("ZNotes")
        self.zotero_custom_column_name_dict["zotero_pages"] = str("ZPages")
        self.zotero_custom_column_name_dict["zotero_place"] = str("ZPlace")
        self.zotero_custom_column_name_dict["zotero_publication_title"] = str("ZPublication Title")
        self.zotero_custom_column_name_dict["zotero_publication_year"] = str("ZPublication Year")
        self.zotero_custom_column_name_dict["zotero_publisher"] = str("ZPublisher")
        self.zotero_custom_column_name_dict["zotero_series"] = str("ZSeries")
        self.zotero_custom_column_name_dict["zotero_series_number"] = str("ZSeries Number")
        self.zotero_custom_column_name_dict["zotero_series_text"] = str("ZSeries Text")
        self.zotero_custom_column_name_dict["zotero_series_title"] = str("ZSeries Title")
        self.zotero_custom_column_name_dict["zotero_title"] = str("ZTitle")
        self.zotero_custom_column_name_dict["zotero_url"] = str("ZUrl")
        self.zotero_custom_column_name_dict["zotero_volume"] = str("ZVolume")

        self.zotero_custom_column_description_dict["zotero_author"] = str("The Author specified in Zotero for a particular file attachment.")
        self.zotero_custom_column_description_dict["zotero_automatic_tags"] = str("When items are saved to a Zotero library via a web translator, tags are sometimes automatically attached. For example, OPAC library catalogs provide subject headings for their records, which are saved as Zotero tags. Automatic tags behave the same as manually added tags.")
        self.zotero_custom_column_description_dict["zotero_date"] = str("A year associated with an item that may or may not be identical to the Published Year.")
        self.zotero_custom_column_description_dict["zotero_date_added"] = str("The date that a particular item was added to Zotero.")
        self.zotero_custom_column_description_dict["zotero_date_modified"] = str("The date that a particular item was last modified in Zotero.")
        self.zotero_custom_column_description_dict["zotero_doi"] = str("Digital Object Identifier.  A DOI is a type of persistent identifier used to uniquely identify objects. The DOI system is particularly used for electronic documents such as journal articles.")
        self.zotero_custom_column_description_dict["zotero_extra"] = str("Additional information concerning the item.")
        self.zotero_custom_column_description_dict["zotero_file_attachments"] = str("The full file path within Zotero of one or more files attached to an item.  ZMI will only import the first 'book' file attachment found in the CSV file. The remaining will be ignored.")
        self.zotero_custom_column_description_dict["zotero_isbn"] = str("The ISBN associated with a particular File Attachment within Zotero.")
        self.zotero_custom_column_description_dict["zotero_issn"] = str("The ISSN associated with a particular File Attachment within Zotero.")
        self.zotero_custom_column_description_dict["zotero_issue"] = str("The Issue Number or Issue Identifier of a periodical File Attachment within Zotero.")
        self.zotero_custom_column_description_dict["zotero_item_type"] = str("The type of the item within Zotero.  Examples:  webpage; book; thesis; conferencePaper; journalArticle; etc.")
        self.zotero_custom_column_description_dict["zotero_key"] = str("A unique identifier within Zotero for each File Attachment associated with any item.")
        self.zotero_custom_column_description_dict["zotero_manual_tags"] = str("Tags assigned manually by selecting one or multiple tags in the tag selector.")
        self.zotero_custom_column_description_dict["zotero_notes"] = str("Descriptive text concerning an item that might or might not include HTML.")
        self.zotero_custom_column_description_dict["zotero_pages"] = str("A page number, or a range of page numbers, associated with the item.")
        self.zotero_custom_column_description_dict["zotero_place"] = str("The geographical location pertaining to the ris_tag of the item.")
        self.zotero_custom_column_description_dict["zotero_publication_title"] = str("The title of the published item.")
        self.zotero_custom_column_description_dict["zotero_publication_year"] = str("The year in which an item was published.")
        self.zotero_custom_column_description_dict["zotero_publisher"] = str("The Publisher of an item.")
        self.zotero_custom_column_description_dict["zotero_series"] = str("The Series of a File Attachment.")
        self.zotero_custom_column_description_dict["zotero_series_number"] = str("The Series Number of a File Attachment.")
        self.zotero_custom_column_description_dict["zotero_series_text"] = str("The Series Text of a File Attachment.")
        self.zotero_custom_column_description_dict["zotero_series_title"] = str("The Series Title of a File Attachment.")
        self.zotero_custom_column_description_dict["zotero_title"] = str("The Title of an item's File Attachment within Zotero.")
        self.zotero_custom_column_description_dict["zotero_url"] = str("The URL that was the ris_tag of the item.")
        self.zotero_custom_column_description_dict["zotero_volume"] = str("The published Volume (e.g. VI or 6) of a File Attachment.")
#-----------------------------------------------------------------------------------------
    def validate_zotero_custom_columns(self):
        self.validate_custom_columns(True)
    def validate_custom_columns(self,proceed):

        self.proceed_if_errors = proceed

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('Automatically Add Custom Columns'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        my_cursor.execute("begin")
        mysql = "UPDATE custom_columns SET editable = 0 WHERE label LIKE 'zotero_%' AND editable = 1 "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")

        mysql = "SELECT id,label,datatype FROM custom_columns  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        if not tmp_rows:
            pass
        else:
            if len(tmp_rows) == 0:
                pass
            else:
                for row in tmp_rows:
                    id,label,datatype = row
                    label = str(label)
                    if label in self.zotero_custom_column_dict:
                        if datatype == 'comments':
                            self.zotero_custom_column_dict[label] = str(id)
                #END FOR
                del tmp_rows

        self.need_to_add_custom_columns = False
        for label,id in self.zotero_custom_column_dict.iteritems():
            if id == str(0):
                self.need_to_add_custom_columns = True
                break
        #END FOR

        if not self.need_to_add_custom_columns:
            s = ""
            self.zmi_custom_columns_generation_label.setText(s)
            self.push_button_validate_zotero_custom_columns.hide()
            self.update()
            self.validation_generation_complete = True
            self.update_custom_column_descriptions_in_display()
            return
        else:
            self.push_button_validate_zotero_custom_columns.show()
            self.zmi_custom_columns_generation_label.show()
            s = "...Some or All Zotero Custom Columns Are Missing..."
            self.zmi_custom_columns_generation_label.setText(s)
            self.update()
            msg = "Some or All Zotero Custom Customs Must Be Generated Now...Wait..."
            self.gui.status_bar.show_message(_(msg), 10000)
            self.validation_generation_complete = False
            sleep(0)

        if not self.proceed_if_errors:
            self.push_button_validate_zotero_custom_columns.show()
            self.zmi_custom_columns_generation_label.show()
            s =  ">>>>> Auto-Validation Found Missing Custom Column(s) <<<<<"
            self.zmi_custom_columns_generation_label.setText(s)
            self.update()
            return

        self.autoadd_custom_columns()
    #-----------------------------------------------------------------------------------------
    def autoadd_custom_columns(self):
        self.calibre_param_list = self.create_calibre_parameters()
        is_valid,restart_required = self.create_new_zmi_custom_columns(self.calibre_param_list)
        if is_valid:
            self.validation_generation_complete = True
            self.update_custom_column_descriptions_in_display()
            if restart_required:
                self.zmi_custom_columns_generation_label.setText("Addition of Custom Columns Complete.  Restart Calibre Now.")
            else:
                self.zmi_custom_columns_generation_label.setText("Selected Custom Columns Already Exist.  Nothing Done.")
            self.repaint()
            if restart_required:
                info_dialog(self.gui, 'Restart Required','Calibre will now restart...').show()
                sleep(2.0)
                self.gui.quit(restart=True)
        else:
            self.zmi_custom_columns_generation_label.setText("Not Completed.  Please Restart Calibre, then Add Manually.")
            self.repaint()
            msg = "Fatal error experienced in adding new ZMI Custom Columns."
            error_dialog(self.gui, _('Automatically Add Custom Columns'),_(msg), show=True)
    #-----------------------------------------------------------------------------------------
    def create_calibre_parameters(self):

        self.zmi_custom_columns_generation_label.setText("...Adding Custom Columns...")
        self.update()

        cc_to_add_list = []

        for label,id in self.zotero_custom_column_dict.iteritems():
            if str(id) == str(0):
                cc_to_add_list.append(label)
        #END FOR

        try:
            del self.calibre_param_list
        except:
            pass

        self.calibre_param_list = []

        if len(cc_to_add_list) == 0:
            return self.calibre_param_list

        cc_to_add_list.sort()

        for label in cc_to_add_list:
            if isinstance(label,unicode):
                label = unicodedata.normalize('NFKD', label).encode('ascii','ignore')
            label = unicode(label)
            label = label.lower()
            name = label.upper()  #default
            if label in self.zotero_custom_column_name_dict:
                name = self.zotero_custom_column_name_dict[label]
            name = str(name)
            name = str(str(' "') + str(name) + str('" '))    #spaces in the name...quotes get confused with unicode quotes during cli parsing...
            datatype = str("comments")
            #~ param = 'calibre add_custom_column --library-path="[LIBRARY]"  ' + label + ' ' + name + ' ' +  datatype
            #~ param = param.replace("[LIBRARY]",self.lib_path)
            param = label + '|||' + name + '|||' +  datatype
            self.calibre_param_list.append(param)
            #~ if DEBUG: print(str(param))
        #END FOR

        del cc_to_add_list

        return self.calibre_param_list
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def create_new_zmi_custom_columns(self,execution_param_list):

        if len(execution_param_list) == 0:
            return True,False    # successful since the labels already exist; no restart is required.

        dbpath = self.lib_path

        was_successful = True
        restart_required = True

        for param in execution_param_list:
            try:
                zmi_cli_add_custom_column(self.guidb,param,dbpath)
            except Exception as e:
                if DEBUG: print("Exception: ", str(e))
                was_successful = False
                break
        #END FOR

        self.update_custom_column_descriptions_in_display()

        return was_successful,restart_required
    #-----------------------------------------------------------------------------------------
    def update_custom_column_descriptions_in_display(self):
        #~ '{"description": "[DESCRIPTION_GOES_HERE]", "interpret_as": "long-text", "heading_position": "side"}'
        #~  the display MUST be json compatible or calibre will crash and keep metadata.db from being usable to start calibre (fix is to manually fix table custom_columns).  example 'real' display:  {"description": "Author Pseudonyms", "is_names": true}
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('ZMI'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        my_cursor.execute("begin")
        mysql = "UPDATE custom_columns SET display = ? WHERE (datatype = 'comments' AND label = ? ) AND ( (display NOT LIKE ? ) OR (display NOT LIKE ? ) OR (display NOT LIKE ? ) ) "
        for label,description in self.zotero_custom_column_description_dict.iteritems():
            display = PLAIN_TEXT_COMMENTS_DISPLAY
            display = display.replace("[DESCRIPTION_GOES_HERE]",description)
            pattern1 = '%"long-text"%'
            pattern2 = '%"side"%'
            pattern3 = '%' + description + '%'
            my_cursor.execute(mysql,(display,label,pattern1,pattern2,pattern3))
            #~ if DEBUG: print(display,label,pattern1,pattern2,pattern3)
        #END FOR
        my_cursor.execute("commit")
        my_db.close()

        if self.calibre_version >= PLAIN_TEXT_CALIBRE_VERSION:
            self.convert_zcolumns_to_simple_text(all=True)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def select_zotero_export_csv_file(self):
        if not self.validation_generation_complete:
            error_dialog(self.gui, _('Import Zotero CSV File'),_('Prior Step Not Yet Performed. Execution canceled.'), show=True)
            return

        if self.calibre_metadata_auto_update_complete or self.update_calibre_title_complete or self.update_calibre_author_complete:
            error_dialog(self.gui, _('Import Zotero CSV File'),_('Later Step Was Already Performed.  Execution canceled.'), show=True)
            return

        self.import_exported_csv(combined=False)

        self.calibre_metadata_auto_update_complete = False
    #-----------------------------------------------------------------------------------------
    def import_exported_csv(self,combined=False):

        if not combined:
            chosen_files = self.choose_csv_file_to_import()
            if not chosen_files:
                self.zotero_export_csv_selection_complete = False
                info_dialog(self.gui, 'Canceled','No CSV File was was selected; Execution canceled.').show()
                return
            else:
                csv_path = chosen_files[0]
                if DEBUG: print("csv_path selected by user: ", csv_path)
            del chosen_files
            zotero_csv_list = self.import_csv_file(csv_path)
            if DEBUG:
                for row in zotero_csv_list:
                    print("zotero_csv_list: ", str(row))
            self.zotero_csv_list = zotero_csv_list
            del zotero_csv_list
        else:
            n = len(self.original_imported_csv_filenames_list)
            csv_path = "Combined " + str(n) + " CSV Files in Import Directory"
            self.zotero_csv_list = self.combined_zotero_csv_list

        if not len(self.zotero_csv_list) > 0:
            if DEBUG: print("CSV File was empty.  Nothing done.")
            self.zmi_selected_export_csv_file_label.setText("CSV File Was Empty: Error")
            self.update()
            self.zotero_export_csv_selection_complete = False
            msg = "CSV File was empty.  Nothing done."
            self.gui.status_bar.show_message(_(msg), 10000)
            return
        else:
            if DEBUG: print("CSV File was NOT empty.")
            self.zmi_selected_export_csv_file_label.setText(csv_path)
            self.update()
            self.zotero_export_csv_selection_complete = True

        msg = "Total CSV Rows Selected: " + str(len(self.zotero_csv_list))
        self.gui.status_bar.show_message(_(msg), 10000)
        if DEBUG: print(msg)

        if self.zmi_mode_manual_radio.isChecked():
            return

        self.check_csv_for_keys_missing_from_calibre_zkeys()

        if self.zmi_mode_single_step_radio.isChecked():
            self.show_incomplete_books()
    #-----------------------------------------------------------------------------------------
    def choose_csv_file_to_import(self):

        name = "choose_zotero_csv_file"
        title = "Choose Zotero Exported CSV File"
        all_files=True
        select_only_single_file=True
        filters=[]
        window = None   # parent = None

        mode = QFileDialog.ExistingFile if select_only_single_file else QFileDialog.ExistingFiles
        fd = FileDialog(title=title, name=name, filters=filters, parent=window, add_all_files_filter=all_files, mode=mode)
        fd.setParent(None)
        if fd.accepted:
            return fd.get_files()
        return None
    #-----------------------------------------------------------------------------------------
    def import_csv_file(self,csv_path):

        tmp_list = []
        zotero_csv_list  = []

        if csv_path == unicode(""):
            if DEBUG: print("csv_path == unicode(""); nothing to do.")
            return zotero_csv_list

        try:
            self.zmi_selected_export_csv_file_label.setText(csv_path)
            self.update()
            sleep(0)
            with open (csv_path,'rb') as csvfile:
                zmi_csv_unicode_reader = self.unicode_csv_reader(csvfile)
                for row in zmi_csv_unicode_reader:
                    tmp_list.append(row)
                    if DEBUG: print("raw csv row: ", str(row))
                #END FOR
            csvfile.close()
            del csv_path
            del zmi_csv_unicode_reader
            if len(zotero_csv_list) == 0:
                self.csv_header = None
            for row in tmp_list:
                if isinstance(row,list):
                    if not self.csv_header:
                        self.csv_header = row
                    zotero_csv_list.append(row)
            #END FOR
            del tmp_list
        except Exception as e:
            if DEBUG: print("Import CSV File Error: " + str(e))
            error_dialog(self.gui, _('Import CSV File Error'),_(e), show=True)

        return zotero_csv_list
    #-----------------------------------------------------------------------------------------
    def unicode_csv_reader(self,unicode_csv_data, dialect=csv.excel, **kwargs):
        csv_reader = csv.reader(self.utf_8_encoder(unicode_csv_data),
                                dialect=dialect, **kwargs)
        for row in csv_reader:
            # decode UTF-8 back to Unicode, cell by cell:
            yield [unicode(cell, 'utf-8') for cell in row]
    #-----------------------------------------------------------------------------------------
    def utf_8_encoder(self,unicode_csv_data):
        for line in unicode_csv_data:
            yield line.encode('utf-8')
    #-----------------------------------------------------------------------------------------
    def check_csv_for_keys_missing_from_calibre_zkeys(self):

        self.map_csv_columns_to_custom_columns()

        if not self.okay_to_continue:
            return

        #~ self.csvcol_to_cc_mapping_dict = {}    # [label] = csv row column number

        k = str("zotero_file_attachments")
        if k in self.csvcol_to_cc_mapping_dict:
            self.file_attachment_column = self.csvcol_to_cc_mapping_dict[k]
        else:
            if DEBUG: print("Error: file atttachments column not found in dict.  Cannot proceed.")
            msg = "Error: file atttachments column not found in dict.  Cannot proceed."
            error_dialog(self.gui, _('CSV File Error'),_(msg), show=True)
            return

        k = str("zotero_key")
        if k in self.csvcol_to_cc_mapping_dict:
            self.key_column = self.csvcol_to_cc_mapping_dict[k]
        else:
            if DEBUG: print("Error: zotero key column not found in dict.  Cannot proceed.")
            msg = "Error: zotero key column not found in dict.  Cannot proceed."
            error_dialog(self.gui, _('CSV File Error'),_(msg), show=True)
            return

        self.csv_file_attachments_by_key_dict = {}

        if prefs['ZMI_CSV_IMPORT_HTML_AS_EMPTY_FILE_ATTACHMENTS'] == unicode("True"):   # "1.0.53"  #Option to create an empty book if the file attachment is a .html
            self.blank_out_html = True
            if DEBUG: print("self.blank_out_html = True")
        else:
            self.blank_out_html = False

        for row in self.zotero_csv_list:
            s = row[self.file_attachment_column]
            if DEBUG: print("row in self.zotero_csv_list: ", str(s))
            if self.blank_out_html:
                if s.count("/") > 1 or s.count("\\") > 1 :
                    if s.count(".htm") > 0:
                        s = self.blank_out_html_file_attachment(s)
            if s.count("/") > 1 or s.count("\\") > 1 :
                for format in self.formats:
                    if format in s:
                        key = row[0].strip()
                        file_list = self.extract_single_filename_from_multiple_filenames(s)
                        self.csv_file_attachments_by_key_dict[key] = file_list
                #END FOR
            else:
                #~ if DEBUG: print("row has no '/' and no '\\'...", str(s))
                if self.import_empty_items:
                    key = row[0].strip()
                    if key.count("Key") == 0 :  # header row of csv...
                        prefix = str("__empty__Zotero - " + str(key))
                        suffix = ".txt"
                        empty_file_path = self.create_empty_txt_file(suffix,prefix)
                        if DEBUG: print("empty_file_path", empty_file_path)
                        empty_file_list = []
                        empty_file_list.append(empty_file_path)
                        self.csv_file_attachments_by_key_dict[key] = empty_file_list
                        del empty_file_list
        #END FOR

        self.zkey_custom_column = None

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('Automatically Add Zotero Books'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        mysql = "SELECT id, label FROM custom_columns WHERE datatype = 'comments'  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id, label = row
            label = str(label)
            if label in self.zotero_custom_column_dict:
                self.zotero_custom_column_dict[label] = id     # dict was originally initialized with id = 0
        #END FOR

        k = str("zotero_key")
        if k in self.zotero_custom_column_dict:
            self.zkey_custom_column = self.zotero_custom_column_dict[k]
        else:
            my_db.close()
            error_dialog(self.gui, _('Automatically Add Zotero Books'),_('zotero_key not found in self.zotero_custom_column_dict; program error.'), show=True)
            return

        mysql = "SELECT id,val FROM identifiers WHERE type = 'zkey'  "      # CSV column 0 key, which is the key of the whole item/row
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        tmp_listzkey = []
        for row in tmp_rows:
            id,value = row
            tmp_listzkey.append(value)
        del tmp_rows

        mysql = "SELECT id,val FROM identifiers WHERE type = 'zkey_file'  "  # file attachment next higher folder in its path that is also a different key, the file's personal key
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        if not tmp_rows:
            tmp_rows = []
        tmp_listzkey_file = []
        for row in tmp_rows:
            id,value = row
            tmp_listzkey_file.append(value)
        del tmp_rows

        self.missing_zotero_books_dict = collections.OrderedDict([])                               # [fullkey] = single file attachment file       where fullkey = zkey + zkey_file

        for zkey,file_list in self.csv_file_attachments_by_key_dict.iteritems():
            file_list = self.sort_file_list_extensions_by_priority(file_list)
            for path in file_list:
                if "__empty__" in path:  # user has chosen to import empty book using ptempfile...
                    zkey_file = zkey
                    if zkey_file in tmp_listzkey_file or str(zkey_file) in tmp_listzkey_file:
                        if zkey in tmp_listzkey or str(zkey) in tmp_listzkey:
                            continue
                    fullkey = zkey + "||" + zkey
                    self.missing_zotero_books_dict[fullkey] = path
                else:
                    zkey_file = self.extract_zkey_file_from_path(path)
                    if zkey_file in tmp_listzkey_file or str(zkey_file) in tmp_listzkey_file:
                        if zkey in tmp_listzkey or str(zkey) in tmp_listzkey:
                            continue
                    fullkey = zkey + "||" + zkey_file
                    self.missing_zotero_books_dict[fullkey] = path          # ordereddict...
            #END FOR
        #END FOR
        del tmp_listzkey
        del tmp_listzkey_file

        n = len(self.missing_zotero_books_dict)
        if n == 0:
            return

        self.do_all_that_is_possible = False
        if prefs['ZMI_PREFER_AUTO_STEP_MODE'] == unicode("True"):
            if not self.completed_auto:
                self.do_all_that_is_possible = True

        if self.zmi_mode_single_step_radio.isChecked():
            self.do_all_that_is_possible = False

        if self.do_all_that_is_possible:
            self.auto_do_everything_possible()
        else:
            if question_dialog(self.gui, "ZMI", (str(n) + "  Zotero files have no matching Calibre book.<br><br>Do you want Calibre to add the missing Zotero files now before proceeding?  This is <b>highly recommended</b>.  To decline is to agree to enter the metadata manually after adding the missing book manually into Calibre.")):
                was_okay = self.add_missing_books_via_zmi_new_add_book()
            else:
                return
    #-----------------------------------------------------------------------------------------
    def sort_file_list_extensions_by_priority(self,file_list):
        new_file_list = []
        tmp_list = []
        for file in file_list:
            file = file.strip()
            file = file.replace(os.sep,'/')
            if file.endswith("/"):
                continue
            if file.endswith(".html") or file.endswith(".htm") or file.endswith(".xhtml") or file.endswith(".xhtm")  or file.endswith(".htmlz"):
                newrow = 9,file
            elif file.endswith(".txt") or file.endswith(".text"):
                newrow = 8,file
            else:
                newrow = 0,file
            tmp_list.append(newrow)
        #END FOR

        tmp_list.sort()
        for row in tmp_list:
            dummy,file = row
            if file > " ":
                new_file_list.append(file)
        #END FOR

        del file_list
        return new_file_list
    #-----------------------------------------------------------------------------------------
    def auto_do_everything_possible(self):

        was_okay = self.add_missing_books_via_zmi_new_add_book()
        if not was_okay:
            return

        self.get_all_newly_added_books()

        self.automatically_update_calibre_metadata_control(auto=True)

        self.update_calibre_title(auto=True,callback=self.run_update_author_next)

        self.completed_auto = True
    #-----------------------------------------------------------------------------------------
    def run_update_author_next(self,dummy):
        self.update_calibre_author(auto=True,callback=self.run_update_identifiers)
    def run_update_identifiers(self,dummy):
        self.show_incomplete_books()
        self.convert_zisbn_zissn_zdoi_to_identifiers(auto=True,callback=self.run_update_publisher_pubdate)
    def run_update_publisher_pubdate(self,dummy):
        self.show_incomplete_books()
        self.update_miscellaneous_standard_columns(auto=True,callback=self.run_remaining_next)
    def run_remaining_next(self,dummy):
        # Finally...
        self.list_failed_adds()
    #-----------------------------------------------------------------------------------------
    def get_all_newly_added_books(self):

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('ZMI'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        try:
            del self.newly_added_books_list
        except:
            pass

        self.newly_added_books_list = []

        mysql = "SELECT id,book FROM identifiers WHERE type = 'zmi' AND val = 'new' "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id,book = row
            self.newly_added_books_list.append(book)
        del tmp_rows
    #-----------------------------------------------------------------------------------------
    def show_incomplete_books_pushbutton(self):
        self.gui.search.clear()
        self.gui.library_view.clearSelection()
        self.gui.esc()  # version 1.0.51       shortcut ESC
        self.show_incomplete_books()
        self.gui.library_view.select_rows(self.pushbutton_marked_ids)  # version 1.0.52

        #-----------------------------------------------------------------------------------------

    def show_incomplete_books(self):
        #get all books that still have the zmi:new identifier and do a 'select all' on them

        self.clear_all_marked_books()      # do not mark...just select...version 1.0.47

        self.gui.search.clear()
        self.gui.library_view.clearSelection()

        self.gui.esc()  # version 1.0.51       shortcut ESC

        self.get_all_newly_added_books()

        found_dict = {}
        s_true = 'true'
        for row in self.newly_added_books_list:
            key = int(row)
            found_dict[key] = s_true
        #END FOR

        marked_ids = dict.fromkeys(found_dict, s_true)
        #~ self.gui.current_db.set_marked_ids(marked_ids)        #never mark any books "marked:true"
        self.gui.search.clear()
        self.gui.search.set_search_string('identifiers:"=zmi:new"')
        self.gui.do_search_button()     # version 1.0.52   same as hitting enter to search...
        self.gui.library_view.clearSelection()
        self.gui.library_view.select_rows(marked_ids)
        self.pushbutton_marked_ids = marked_ids  # version 1.0.52

        del found_dict
    #-----------------------------------------------------------------------------------------
    def delete_identifier_zmi_new(self):

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('ZMI'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        my_cursor.execute("begin")
        mysql = "DELETE FROM identifiers WHERE type = 'zmi' AND val = 'new' "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        my_db.close()

        self.force_refresh_of_cache(self.newly_added_books_list)

        self.show_incomplete_books()

        self.gui.library_view.model().start_metadata_backup()
    #-----------------------------------------------------------------------------------------
    def extract_single_filename_from_multiple_filenames(self,multiple):

        file_list = []

        multiple = multiple.strip()
        multiple = multiple.replace(os.sep,'/')

        for i in range(0,10):
            if multiple.startswith(";"):
                multiple = multiple[1: ]
                multiple = multiple.strip()
            if multiple.endswith(";"):
                multiple = multiple[0:-1]
                multiple = multiple.strip()
        #END FOR

        if multiple.endswith("/"):
            multiple = multiple[0:-1]
            multiple = multiple.strip()

        s_split = multiple.split(";")
        n = len(s_split)
        if not n > 1:
            file_list.append(multiple)
            return file_list
        for path in s_split:
            for format in self.formats:
                if format in path:
                    path = path.strip()
                    path = path.replace(os.sep,'/')
                    if "/" in path:
                        if path.endswith("/"):
                            path = path[0:-1]
                            path = path.strip()
                        if isbytestring(path):
                            path = path.decode(filesystem_encoding)
                        file_list.append(path)
                        break
            #END FOR
        #END FOR

        return file_list
    #-----------------------------------------------------------------------------------------
    def blank_out_html_file_attachment(self,s):
        if DEBUG: print("[1] blank_out_html_file_attachment - before: ", str(s))
        final_s = ""
        file_list = self.extract_single_filename_from_multiple_filenames(s)
        for path in file_list:
            if path.count(".htm") > 0:
                if DEBUG: print(".htm found in file attachment, and will be ignored/blanked: ", str(path))
                pass
            else:
                final_s = final_s + path + ";"
        #END FOR
        if DEBUG: print("[2] blank_out_html_file_attachment - after: ", str(final_s))
        return final_s
    #-----------------------------------------------------------------------------------------
    def extract_zkey_file_from_path(self,path):
        #~ /Users/peterb/Library/Application Support/Firefox/Profiles/6kbcf8zv.Standard/zotero/storage/FCQ22QCV/dig_erlass_bl1.pdf
        zkey_file = "none"
        s_split = path.split("/")
        n =len(s_split)
        if n > 1:
            zkey_file = s_split[n-2]      #  FCQ22QCV
            zkey_file = zkey_file.strip()
            zkey_file = zkey_file.upper()
        return zkey_file
    #-----------------------------------------------------------------------------------------
    def automatically_update_calibre_metadata_control(self,auto=False):

        if self.update_calibre_title_complete or self.update_calibre_author_complete:
            error_dialog(self.gui, _('Update Calibre Metadata from Zotero'),_('If you have <b>just</b> Updated Calibre Title and/or Updated Calibre Author, you must exit from ZMI, then click its icon again to start a new ZMI session.<br><br>The Sequential Steps must be performed Top-Down, not Bottom-Up.'), show=True)
            return

        if self.zotero_export_csv_selection_complete and self.validation_generation_complete:
            pass
        else:
            error_dialog(self.gui, _('Update Calibre Metadata from Zotero'),_('The Sequential Steps must be performed Top-Down.  You have missed at least one Step.'), show=True)
            return

        if self.zmi_mode_single_step_radio.isChecked():
            auto = False
            self.zmi_mode_auto_step_radio.hide()
            self.zmi_mode_manual_radio.hide()
            self.push_button_manually_update_calibre_metadata.hide()
        elif self.zmi_mode_auto_step_radio.isChecked():
            self.zmi_mode_single_step_radio.hide()
            self.zmi_mode_manual_radio.hide()
            self.push_button_manually_update_calibre_metadata.hide()
        elif self.zmi_mode_manual_radio.isChecked():
            auto = False

        if not auto:
            self.get_selected_books()
        else:
            try:
                del self.selected_books_list
            except:
                pass
            self.selected_books_list = deepcopy(self.newly_added_books_list)

        self.map_csv_columns_to_custom_columns()
        self.map_books_to_csv_rows()
        self.update_zotero_custom_columns()
        s = "Total Selected Books Actually Updated: " + str(self.total_books_actually_updated)
        self.zmi_automatically_update_calibre_metadata_label.setText(s)
        self.update()
        self.gui.status_bar.show_message(_(s), 10000)
        self.force_refresh_of_cache(self.selected_books_list)
        self.show_incomplete_books()

        self.calibre_metadata_auto_update_complete = True
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def manually_update_calibre_metadata_control(self):

        if not self.zmi_mode_manual_radio.isChecked():
            self.zmi_mode_manual_radio.setChecked(True)

        self.zmi_mode_single_step_radio.hide()
        self.zmi_mode_auto_step_radio.hide()

        s = self.zmi_automatically_update_calibre_metadata_label.text()
        if self.calibre_metadata_auto_update_complete or  s > "":
            self.gui.search.clear()
            prefs['ZMI_MANUAL_MODE_REQUESTED_AFTER_RESTART'] = unicode("True")
            prefs
            self.restart_zmi()

        s = self.zmi_selected_export_csv_file_label.text()
        if not  s > "":
            return error_dialog(self.gui, _('ZMI Manual Update'),_('You have not yet selected the CSV file to use via the step above.  Manual Mode is required.  Avoid adding missing books while working in Manual Mode.'), show=True)

        self.get_selected_books()
        n = len(self.selected_books_list)
        if n <> 1:
            self.gui.library_view.clearSelection()
            return error_dialog(self.gui, _('ZMI Manual Update'),_('You must select a single book to perform this action.'), show=True)

        zkey_list = []
        for row in self.zotero_csv_list:
            s = row[0] + "," + row[1] + "," + row[2] + "," + row[3][0:20] + "," + row[4][0:20]
            s = s.strip()
            zkey_list.append(s)
        #END FOR

        selected_row,ok = QInputDialog.getItem(self,"CSV File","Select CSV Row for Single Book",zkey_list,0,False)
        if ok and selected_row:
            s_split = selected_row.split(",")
            self.selected_zkey = s_split[0].strip()
        else:
            return

        self.map_csv_columns_to_custom_columns()

        try:
            del self.bookid_to_csv_row_mapping_dict
        except:
            pass

        self.bookid_to_csv_row_mapping_dict = {}   # [Calibre book id] = csvrowdata

        book = self.selected_books_list[0]

        for row in self.zotero_csv_list:
            if row[0] == self.selected_zkey:
                self.bookid_to_csv_row_mapping_dict[book] = row
                break
        #END FOR

        if len(self.bookid_to_csv_row_mapping_dict) <> 1:
            if DEBUG: print("Error: len(self.bookid_to_csv_row_mapping_dict) <> 1")
            return

        self.update_zotero_custom_columns()

        self.force_refresh_of_cache(self.selected_books_list)

        s = "Selected book updated for ZKey: " + self.selected_zkey
        self.gui.status_bar.show_message(_(s), 10000)

        self.calibre_metadata_auto_update_complete = True
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def map_csv_columns_to_custom_columns(self):

        try:
            del self.csvcol_to_cc_mapping_dict
        except:
            pass

        self.csvcol_to_cc_mapping_dict = {}    # [label] = csv row column number

        bad_column_heading_list = []

        i = 0
        for colname in self.csv_header:
            if not colname:
                colname = "None"
            csvcol = colname.lower()
            csvcol = csvcol.replace('"',"")
            csvcol = csvcol.strip()
            csvcol = str(csvcol)
            if csvcol == "none" or (not csvcol > " "):
                s = "Invalid CSV column header name: -->>" + str(csvcol) + "<<--"
                s = str(s)
                if DEBUG: print(s)
                bad_column_heading_list.append(s)
                break
            if csvcol in self.zotero_csv_header_names_mapping_dict:
                label = self.zotero_csv_header_names_mapping_dict[csvcol]
                label = str(label)
                self.csvcol_to_cc_mapping_dict[label] = i
            else:
                if i == 0:   #always Key, but may have a leading non-displayable character as an artifact
                    if csvcol.endswith("key"):
                        k = str("key")
                        label = self.zotero_csv_header_names_mapping_dict[k]
                        label = str(label)
                        self.csvcol_to_cc_mapping_dict[label] = i
                    else:
                        pass
                else:
                    pass
            i = i + 1
        #END FOR

        if len(bad_column_heading_list) > 0:
            msg = ""
            for s in bad_column_heading_list:
                msg = msg + str(s) + "\n\n"
            #END FOR
            self.okay_to_continue = False
            msg = msg + "Cannot continue processing this corrupt CSV file."
            return error_dialog(self.gui, _('ZMI'),_(msg), show=True)
        else:
            self.okay_to_continue = True
    #-----------------------------------------------------------------------------------------
    def map_books_to_csv_rows(self):

        if not self.okay_to_continue:
            return

        k = str("zotero_file_attachments")    # label
        if k in self.csvcol_to_cc_mapping_dict:
            self.file_attachment_column = self.csvcol_to_cc_mapping_dict[k]
        else:
            if DEBUG: print("Error: file atttachments column not found in dict.  Cannot proceed.")
            error_dialog(self.gui, _('ZMI: Map Books to CSV Rows'),_('Error: file attachments column not found.  CSV file format is invalid for ZMI. Cannot proceed.'), show=True)
            self.file_attachment_column = None
            return

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('Update Calibre Metadata from Zotero'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        self.book_zkey_dict = {}

        mysql = "SELECT book,val FROM identifiers WHERE type = 'zkey' "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            book,val = row
            self.book_zkey_dict[book] = val
        #END FOR

        try:
            del self.bookid_to_csv_row_mapping_dict  #also used by manual update...
        except:
            pass

        self.bookid_to_csv_row_mapping_dict = {}   # [Calibre book id] = csvrowdata

        for row in self.zotero_csv_list:
            for book,zkey in self.book_zkey_dict.iteritems():
                key = row[0]  # key is always column 0 in the CSV file.
                if key == zkey:
                    self.bookid_to_csv_row_mapping_dict[book] = row   # [Calibre book id] = csvrowdata
            #END FOR
        #END FOR
    #-----------------------------------------------------------------------------------------
    def update_zotero_custom_columns(self):

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('Update Calibre Metadata from Zotero'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        #~ self.zotero_custom_column_dict = {}    #    [label] = id

        mysql = "SELECT id, label FROM custom_columns WHERE datatype = 'comments'  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id, label = row
            label = str(label)
            if label in self.zotero_custom_column_dict:
                self.zotero_custom_column_dict[label] = id     # dict was originally initialized with id = 0
        #END FOR

        #~ self.bookid_to_csv_row_mapping_dict = {}   # [Calibre book id] = csvrowdata
        #~ self.csvcol_to_cc_mapping_dict = {}              # [label] = csvrowdata column number

        self.total_books_actually_updated = 0

        my_cursor.execute("begin")
        for book,csvrowdata in self.bookid_to_csv_row_mapping_dict.iteritems():
            #~ if DEBUG: print("processing book id: ", str(book))
            for label,id in self.zotero_custom_column_dict.iteritems():
                label = str(label)
                if label in self.csvcol_to_cc_mapping_dict:
                    csvcolnum = self.csvcol_to_cc_mapping_dict[label]
                    csvcoldata = csvrowdata[csvcolnum]
                    csvcoldata = html2text(csvcoldata)
                    csvcoldata = csvcoldata.strip()
                    if str(label) == str("zotero_file_attachments"):
                        csvcoldata = csvcoldata.replace(os.sep,'/')
                    if csvcoldata > " ":
                        mysql = "INSERT OR REPLACE INTO custom_column_[N] (id,book,value) VALUES (null,?,?) "
                        mysql = mysql.replace("[N]",str(id))
                        my_cursor.execute(mysql,(book,csvcoldata))
                        if str(label) == str("zotero_key"):
                            self.total_books_actually_updated = self.total_books_actually_updated + 1
                else:
                    if DEBUG: print("Error: label from self.zotero_custom_column_dict is not in self.csvcol_to_cc_mapping_dict: ", label)
            #END FOR
        #END FOR
        my_cursor.execute("commit")
        my_db.close()
    #-----------------------------------------------------------------------------------------
    def update_calibre_title(self,auto=False,callback=None):

        self.clear_all_marked_books()

        if not auto:
            self.get_selected_books()

        if auto:
            self.show_incomplete_books()

        n = len(self.selected_books_list)
        if n == 0:
            return error_dialog(self.gui, _('ZMI Update Calibre Title from Zotero Title'),
                                                          _('You must select one or more books to perform this action.'), show=True)

        payload = self.selected_books_list
        zotero_dict_title = self.get_zotero_titles()
        id_map = {}
        n_total_updated = 0
        for book in self.selected_books_list:
            book = int(book)
            mi = Metadata(_('Unknown'))
            title = zotero_dict_title[book]
            if not title:
                title = "Zotero"
            if str(title) == str("?"):
                title = "Zotero"
            title = html2text(title)
            mi.title = title
            id_map[book] = mi
            n_total_updated =  n_total_updated + 1
        #END FOR

        edit_metadata_action = self.gui.iactions['Edit Metadata']

        edit_metadata_action.apply_metadata_changes(id_map, callback=callback)

        msg = "Book Titles Updated from Zotero: " + str(n_total_updated)
        self.gui.status_bar.show_message(_(msg), 10000)

        if n_total_updated > 0:
            self.zotero_export_csv_selection_complete = False
            self.calibre_metadata_auto_update_complete = False
            self.update_calibre_title_complete = True

        self.clear_all_marked_books()
    #-----------------------------------------------------------------------------------------
    def get_zotero_titles(self):

        db = self.gui.current_db.new_api

        zotero_dict_title = {}

        name = "#zotero_title"

        for book in self.selected_books_list:
            book = int(book)
            zotero_title = db.field_for(name, book, default_value=None)
            if not zotero_title:
                zotero_title = "?"
            if zotero_title == "":
                zotero_title = "?"
            zotero_title = zotero_title.replace("*","")
            #~ <p class="description"><b>ZTitle:</b> Harvard University in 1700</p>
            if zotero_title.count(":</b>") > 0:
                s_split = zotero_title.split(":</b>")
                n = len(s_split)
                if n == 2:
                    zotero_title = s_split[1]
            zotero_title = html2text(zotero_title)
            zotero_title = zotero_title.strip()
            if not isinstance(zotero_title, unicode):
                zotero_title = "u'" + zotero_title + "'"
            zotero_dict_title[book] = zotero_title
        #END FOR

        return zotero_dict_title
    #-----------------------------------------------------------------------------------------
    def update_calibre_author(self,auto=False,callback=None):

        self.clear_all_marked_books()

        if not auto:
            self.get_selected_books()

        if auto:
            self.show_incomplete_books()

        n = len(self.selected_books_list)
        if n == 0:
            return error_dialog(self.gui, _('ZMI Update Calibre Author from Zotero Author'),
                                                          _('You must select one or more books to perform this action.'), show=True)

        payload = self.selected_books_list
        zotero_dict_author = self.get_zotero_author()
        id_map = {}
        n_total_updated = 0
        for book in self.selected_books_list:
            book = int(book)
            mi = Metadata(_('Unknown'))
            author = zotero_dict_author[book]
            auth_list = []
            if not author:
                author = "Zotero"
            if str(author) == str("?"):
                author = "Zotero"
            author = author.replace(";"," & ")
            author = html2text(author)
            auth_list.append(author)
            mi.authors = auth_list
            id_map[book] = mi
            del auth_list
            n_total_updated =  n_total_updated + 1
        #END FOR

        edit_metadata_action = self.gui.iactions['Edit Metadata']

        edit_metadata_action.apply_metadata_changes(id_map, callback=callback)

        msg = "Book Authors Updated from Zotero: " + str(n_total_updated)
        self.gui.status_bar.show_message(_(msg), 10000)

        if n_total_updated > 0:
            self.zotero_export_csv_selection_complete = False
            self.calibre_metadata_auto_update_complete = False
            self.update_calibre_author_complete = True

        self.clear_all_marked_books()

        if not self.zmi_mode_manual_radio.isChecked():   #don't 'select all' when in manual mode...
            self.show_incomplete_books()

        self.clear_all_marked_books()

    #-----------------------------------------------------------------------------------------
    def get_zotero_author(self):

        db = self.gui.current_db.new_api                         #see:  http://manual.calibre-ebook.com/db_api.html

        zotero_dict_author = {}

        name = "#zotero_author"

        for book in self.selected_books_list:
            book = int(book)
            zotero_author = db.field_for(name, book, default_value=None)
            if not zotero_author:
                zotero_author = "?"
            if zotero_author == "":
                zotero_author = "?"
            zotero_author = zotero_author.replace("*","")
            #~ <p class="description"><b>ZAuthor:</b> Harvard University</p>
            if zotero_author.count(":</b>") > 0:
                s_split = zotero_author.split(":</b>")
                n = len(s_split)
                if n == 2:
                    zotero_author = s_split[1]
            zotero_author = html2text(zotero_author)
            zotero_author = zotero_author.strip()
            if not isinstance(zotero_author, unicode):
                zotero_author = "u'" + zotero_author + "'"
            zotero_dict_author[book] = zotero_author
        #END FOR

        return zotero_dict_author
    #-----------------------------------------------------------------------------------------
    def update_miscellaneous_standard_columns(self,auto=False,callback=None):
        self.update_calibre_publisher_and_pubdate(auto,callback=None)
        self.update_calibre_tags_from_ztags(auto)
        # for future use:  add others here.

        if self.zmi_mode_auto_step_radio.isChecked():   #don't 'select all' when in single-step mode...or manual mode...
            self.show_incomplete_books()
    #-----------------------------------------------------------------------------------------
    def update_calibre_publisher_and_pubdate(self,auto=False,callback=None):

        if not auto:
            self.get_selected_books()
        n = len(self.selected_books_list)
        if n == 0:
            return error_dialog(self.gui, _('ZMI Update Calibre Pubdate from Zotero Publication Year'),
                                                          _('You must select one or more books to perform this action.'), show=True)

        payload = self.selected_books_list
        zotero_dict_publication_year = self.get_zotero_publisher()
        id_map = {}
        n_total_updated = 0
        for book in self.selected_books_list:
            book = int(book)
            mi = Metadata(_('Unknown'))
            pubdate = zotero_dict_publication_year[book]
            do_pubdate = True
            if not pubdate:
                do_pubdate = False
            if str(pubdate) == str("?"):
                do_pubdate = False
            if do_pubdate:
                pubdate = html2text(pubdate)
                mi.pubdate = pubdate

            if do_pubdate:
                id_map[book] = mi
                n_total_updated =  n_total_updated + 1
        #END FOR

        edit_metadata_action = self.gui.iactions['Edit Metadata']

        edit_metadata_action.apply_metadata_changes(id_map, callback=callback)

        msg = "Book Publishers/Published Date Updated from Zotero: " + str(n_total_updated)
        self.gui.status_bar.show_message(_(msg), 10000)

        #~ if self.zmi_mode_auto_step_radio.isChecked():   #don't 'select all' when in single-step mode...
            #~ self.show_incomplete_books()
    #-----------------------------------------------------------------------------------------
    def get_zotero_publisher(self):

        db = self.gui.current_db.new_api

        try:
            del zotero_dict_publisher
        except:
            pass

        zotero_dict_publisher = {}

        name = "#zotero_publisher"

        for book in self.selected_books_list:
            book = int(book)
            zotero_publisher = db.field_for(name, book, default_value=None)
            if not zotero_publisher:
                continue
            zotero_publisher = zotero_publisher.replace("*","")
            #~ <p class="description"><b>ZPublisher:</b> Harvard University</p>
            if zotero_publisher.count(":</b>") > 0:
                s_split = zotero_publisher.split(":</b>")
                n = len(s_split)
                if n == 2:
                    zotero_publisher = s_split[1]
            zotero_publisher = html2text(zotero_publisher)
            zotero_publisher = zotero_publisher.strip()
            if not isinstance(zotero_publisher, unicode):
                zotero_publisher = unicode(zotero_publisher)
            zotero_dict_publisher[book] = zotero_publisher

        #END FOR

        try:
            del zotero_dict_publication_year
        except:
            pass

        zotero_dict_publication_year = {}

        name = "#zotero_publication_year"

        for book in self.selected_books_list:
            book = int(book)
            zotero_publication_year = db.field_for(name, book, default_value=None)
            if not zotero_publication_year:
                zotero_publication_year = "?"
            if zotero_publication_year == "":
                zotero_publication_year = "?"
            zotero_publication_year = zotero_publication_year.replace("*","")
            #~ <p class="description"><b>Zpublication_year:</b> Harvard University</p>
            if zotero_publication_year.count(":</b>") > 0:
                s_split = zotero_publication_year.split(":</b>")
                n = len(s_split)
                if n == 2:
                    zotero_publication_year = s_split[1]
            zotero_publication_year = html2text(zotero_publication_year)
            value = zotero_publication_year.strip()
            if value.isdigit():
                published_date = value + "-01-01 12:00:00.000000+00:00"           # 2016-06-19 12:00:00.000000+00:00
            else:
                published_date = "?"
            if not isinstance(published_date, unicode):
                published_date = unicode(published_date)
            zotero_dict_publication_year[book] = published_date
        #END FOR

        if len(zotero_dict_publisher) > 0:
            self.add_publisher_directly(zotero_dict_publisher)

        return zotero_dict_publication_year
    #-----------------------------------------------------------------------------------------
    def add_publisher_directly(self,zotero_dict_publisher):

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('ZMI'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        mysql = "INSERT OR IGNORE INTO publishers (id,name,sort) VALUES (null,?,?)"
        my_cursor.execute("begin")
        for book,publisher in zotero_dict_publisher.iteritems():
            my_cursor.execute(mysql,(publisher,publisher))
        #END FOR
        my_cursor.execute("commit")
        mysql = "INSERT OR REPLACE INTO books_publishers_link (id,book,publisher) VALUES (null,?,(SELECT id FROM publishers WHERE name = ?))"
        my_cursor.execute("begin")
        for book,publisher in zotero_dict_publisher.iteritems():
            book = int(book)
            my_cursor.execute(mysql,(book,publisher))
        #END FOR
        my_cursor.execute("commit")
        my_db.close()

        self.force_refresh_of_cache(self.selected_books_list)

        msg = "Publishers updated from ZPublisher: " + str(len(zotero_dict_publisher))
        self.gui.status_bar.show_message(_(msg), 10000)
    #-----------------------------------------------------------------------------------------
    def convert_zisbn_zissn_zdoi_to_identifiers(self,auto=False,callback=None):

        self.clear_all_marked_books()

        if not auto:
            self.get_selected_books()
        n = len(self.selected_books_list)
        if n == 0:
            return error_dialog(self.gui, _('ZMI Update Identifiers'),
                                                          _('You must select one or more books to perform this action.'), show=True)


        db = self.gui.current_db.new_api

        self.zisbn_dict = {}   # [book] = zisbn

        name = "#zotero_isbn"

        for book in self.selected_books_list:
            book = int(book)
            zotero_isbn = db.field_for(name, book, default_value=None)
            if not zotero_isbn:
                continue
            zotero_isbn = html2text(zotero_isbn)
            self.zisbn_dict[book] = zotero_isbn.strip()
        #END FOR

        self.zissn_dict = {}   # [book] = zissn

        name = "#zotero_issn"

        for book in self.selected_books_list:
            book = int(book)
            zotero_issn = db.field_for(name, book, default_value=None)
            if not zotero_issn:
                continue
            zotero_issn = html2text(zotero_issn)
            self.zissn_dict[book] = zotero_issn.strip()
        #END FOR


        self.zdoi_dict = {}   # [book] = zdoi

        name = "#zotero_doi"

        for book in self.selected_books_list:
            book = int(book)
            zotero_doi = db.field_for(name, book, default_value=None)
            if not zotero_doi:
                continue
            zotero_doi = html2text(zotero_doi)
            self.zdoi_dict[book] = zotero_doi.strip()
        #END FOR

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('Update ISBN/ISSN'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        my_cursor.execute("begin")
        mysql = "INSERT OR REPLACE INTO identifiers (id,book,type,val) VALUES (null,?,'isbn',?) "
        for book,isbn in self.zisbn_dict.iteritems():
            if isbn > " ":
                isbn = isbn.lower()
                isbn = isbn.replace("-","")
                isbn = isbn.replace("isbn","")
                isbn = isbn.replace("none","")
                isbn = isbn.replace(":","")
                isbn = isbn.replace(";","")
                isbn = isbn.replace(",","")
                isbn = isbn.replace(".","")
                isbn = isbn.replace("|","")
                isbn = isbn.replace("(","")
                isbn = isbn.replace(")","")
                isbn = isbn.replace(" ","")
                isbn = isbn.strip()
                if isbn > " ":
                    my_cursor.execute(mysql,(book,isbn))
        #END FOR
        my_cursor.execute("commit")

        my_cursor.execute("begin")
        mysql = "INSERT OR REPLACE INTO identifiers (id,book,type,val) VALUES (null,?,'issn',?) "
        for book,issn in self.zissn_dict.iteritems():
            if issn > " ":
                issn = issn.lower()
                issn = issn.replace("issn","")
                issn = issn.replace("none","")
                issn = issn.replace(":","")
                issn = issn.replace(";","")
                issn = issn.replace(",","")
                issn = issn.replace(".","")
                issn = issn.replace("|","")
                issn = issn.replace("(","")
                issn = issn.replace(")","")
                issn = issn.replace(" ","")
                issn = issn.strip()
                if issn > " ":
                    my_cursor.execute(mysql,(book,issn))
        #END FOR
        my_cursor.execute("commit")

        my_cursor.execute("begin")
        mysql = "INSERT OR REPLACE INTO identifiers (id,book,type,val) VALUES (null,?,'doi',?) "
        for book,doi in self.zdoi_dict.iteritems():
            if doi > " ":
                doi = doi.lower()
                doi = doi.replace("doi","")
                doi = doi.replace("none","")
                doi = doi.replace("%2"," ")
                doi = doi.replace("  "," ")
                doi = doi.strip()
                if doi > " ":
                    my_cursor.execute(mysql,(book,doi))
        #END FOR
        my_cursor.execute("commit")

        my_db.close()

        self.force_refresh_of_cache(self.selected_books_list)

        s = "Selected books were updated for ISBN/ISSN/DOI"
        self.gui.status_bar.show_message(_(s), 10000)

        del self.zisbn_dict
        del self.zissn_dict

        if self.zmi_mode_auto_step_radio.isChecked():   #don't 'select all' when in single-step mode...or manual mode...
            self.show_incomplete_books()

        self.clear_all_marked_books()
    #-----------------------------------------------------------------------------------------
    def update_calibre_tags_from_ztags(self,auto=False):

        if prefs['ZMI_PREFER_AUTO_TAGS_AS_STANDARD_TAGS'] == unicode("True"):
            self.prefer_autotags = True
        else:
            self.prefer_autotags = False

        if prefs['ZMI_PREFER_MANUAL_TAGS_AS_STANDARD_TAGS'] == unicode("True"):
            self.prefer_manualtags = True
        else:
            self.prefer_manualtags = False

        if self.prefer_autotags or self.prefer_manualtags:
            pass
        else:
            return

        if not auto:
            self.get_selected_books()
        n = len(self.selected_books_list)
        if n == 0:
            return error_dialog(self.gui, _('ZMI Update Tags'),
                                                          _('You must select one or more books to perform this action.'), show=True)


        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('ZMI'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        self.get_custom_column_ids(my_db,my_cursor)

        new_tags_list,tags_by_book_list = self.get_ztags_by_book(my_db,my_cursor)

        tmp_set = set(new_tags_list)
        new_tags_list = list(tmp_set)
        del tmp_set

        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO tags (id,name) VALUES (null,?) "
        for tag in new_tags_list:
            my_cursor.execute(mysql,([tag]))
        #END FOR
        my_cursor.execute("commit")
        del new_tags_list

        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO books_tags_link (id,book,tag) VALUES (null,?,(SELECT id FROM tags WHERE name = ?)) "
        for row in tags_by_book_list:
            book,tags_list = row
            for tag in tags_list:
                my_cursor.execute(mysql,(book,tag))
            #END FOR
            del tags_list
        #END FOR
        my_cursor.execute("commit")
        del tags_by_book_list

        my_db.close()

        self.force_refresh_of_cache(self.selected_books_list)


    #-----------------------------------------------------------------------------------------
    def get_custom_column_ids(self,my_db,my_cursor):
        mysql = "SELECT id,label FROM custom_columns WHERE label LIKE 'zotero%tags' "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        for row in tmp_rows:
            id,label = row
            if label == "zotero_automatic_tags":
                self.autotags_id = str(id)
            if label == "zotero_manual_tags":
                self.manualtags_id = str(id)
        #END FOR
    #-----------------------------------------------------------------------------------------
    def get_ztags_by_book(self,my_db,my_cursor):
        new_tags_list = []
        tags_by_book_list = []

        mysql_auto = "SELECT book,value FROM custom_column_[N] WHERE book = ?"
        mysql_auto = mysql_auto.replace("[N]",self.autotags_id)

        mysql_manual = "SELECT book,value FROM custom_column_[N] WHERE book = ?"
        mysql_manual = mysql_manual.replace("[N]",self.manualtags_id)

        for book in self.selected_books_list:
            new_tags_list,tags_list = self.get_ztags(my_db,my_cursor,mysql_auto,mysql_manual,book,new_tags_list)
            item = book,tags_list
            tags_by_book_list.append(item)
        #END FOR

        return new_tags_list,tags_by_book_list
    #-----------------------------------------------------------------------------------------
    def get_ztags(self,my_db,my_cursor,mysql_auto,mysql_manual,book,new_tags_list):
        tags_list = []
        raw_tags_list = []

        if self.prefer_autotags:
            my_cursor.execute(mysql_auto,([book]))
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                tmp_rows = []
            for row in tmp_rows:
                book,value = row
                value = value + ";"
                raw_tags_list.append(value)
            #END FOR
            del tmp_rows

        if self.prefer_manualtags:
            my_cursor.execute(mysql_manual,([book]))
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                tmp_rows = []
            for row in tmp_rows:
                book,value = row
                value = value + ";"
                raw_tags_list.append(value)
            #END FOR
            del tmp_rows

        for row in raw_tags_list:
            raw = row.replace(";",",")
            s_split = raw.split(",")
            for tag in s_split:
                tag = tag.replace("'","")
                tag = tag.replace('"','')
                tag = tag.strip()
                if tag > " ":
                    tags_list.append(tag)
                    new_tags_list.append(tag)
            #END FOR
        #END FOR

        del raw_tags_list

        return new_tags_list,tags_list
    #-----------------------------------------------------------------------------------------
    def copy_misc_zcolumns_to_custom_columns_control(self,auto=False):

        s = "Please enter one (1) line for each pair of from:to custom columns."
        saved_pairs = prefs['ZMI_ZCOLUMNS_TO_CUSTOM_COLUMNS_MAPPING_PAIRS']
        saved_pairs = str(saved_pairs)
        qid = QInputDialog()
        qid.setOption(QInputDialog.UsePlainTextEditForTextInput)
        text,ok = qid.getMultiLineText(self,"ZColumns to Custom Columns",s,saved_pairs,inputMethodHints=Qt.ImhMultiLine|Qt.ImhLowercaseOnly|Qt.ImhLatinOnly)
        if not text:
            return
        if ok and"#zotero_" in text:
            pass
        else:
            if not text > "":
                prefs['ZMI_ZCOLUMNS_TO_CUSTOM_COLUMNS_MAPPING_PAIRS'] = unicode("")
                prefs
                return
            else:
                error = "From:To pairs must be in the format '#zotero_xxxxx:#custom_column_lookup_name'.  Refer to: Calibre > Preferences > Add Your Own Columns."
                msg = "You have incorrectly specified From:To pairs." + error
                return error_dialog(self.gui, _('Invalid From:To Pairs'),_(msg), show=True)

        text = text.replace(";","\n")
        text = text.replace(",","\n")
        text = text.replace("|","\n")
        text = text.replace(".","")
        text = text.replace(" ","")

        text_prefs = text.strip()

        text_pairs_are_valid = True

        text = "\n" + text + "\n"
        s_split = text.split("\n")
        try:
            del column_pairs_list
        except:
            pass
        column_pairs_list = []
        for row in s_split:
            row = row.strip()
            if row == "" or len(row) == 0:
                continue
            if "zotero_" in row:
                row = row.strip()
                if row.count(":") <> 1:
                    text_pairs_are_valid = False
                    continue
                column_pairs_list.append(row)
            else:
                continue
        #END FOR

        if not text_pairs_are_valid:
            msg = "You have incorrectly specified From:To pairs." + "\n" + text
            return error_dialog(self.gui, _('Invalid From:To Pairs'),_(msg), show=True)

        try:
            del validated_pairs_dict
        except:
            pass

        self.validated_pairs_dict = {}   # [zfrom]:[zto]
        for row in column_pairs_list:
            s = str(row).strip()
            s = s.lower()
            s = s.replace(" ","")
            if not s > " ":
                continue
            s = s.replace("\n","")
            n = s.find(":")
            zfrom = s[0:n].strip()
            zto = s[n+1: ].strip()
            self.validated_pairs_dict[zfrom] = zto
        #END FOR

        #~ self.custom_column_id_dict[label] = str(id)
        #~ self.custom_column_datatype_dict[label] = str(datatype)
        #~ self.zotero_custom_column_dict[label] = id (0 at this point...but does not matter here)

        error = None

        for zc,cc in self.validated_pairs_dict.iteritems():
            zc = zc.replace("#","")
            cc = cc.replace("#","")
            if zc == cc:
                text_pairs_are_valid = False
                break
            if cc in self.zotero_custom_column_dict:
                text_pairs_are_valid = False
                error = "Custom Column cannot be a Zotero Custom Column: " + cc + "\n" + text_prefs
                break
            if not cc in self.custom_column_id_dict:
                text_pairs_are_valid = False
                error = "Custom Column is Not a Custom Column: " + cc + "\n" + text_prefs
                break
            if not zc in self.zotero_custom_column_dict:
                text_pairs_are_valid = False
                error = "Zotero Custom Column is Not a Zotero Custom Column: " + zc + "\n" + text_prefs
                break
            if not zc in self.custom_column_id_dict:
                text_pairs_are_valid = False
                error = "Zotero Custom Column is Not a Custom Column: " + zc + "\n" + text_prefs
                break
            ztodt = self.custom_column_datatype_dict[cc]
            if ztodt == 'rating' or ztodt == 'series' or ztodt == 'enumeration' or ztodt == 'composite':
                text_pairs_are_valid = False
                error = "Custom Column may NOT be a datatype of rating, series, enumeration or composite: " + cc + "\n" + text_prefs
                break
        #END FOR

        if not error:
            error = ""
        else:
            error = "\n" + error

        if not text_pairs_are_valid:
            msg = "You have an invalid From:To pair: " + error
            return error_dialog(self.gui, _('Invalid From:To Pairs'),_(msg), show=True)

        prefs['ZMI_ZCOLUMNS_TO_CUSTOM_COLUMNS_MAPPING_PAIRS'] = unicode(text_prefs)
        prefs

        if not auto:
            self.get_selected_books()
        n = len(self.selected_books_list)
        if n == 0:
            return error_dialog(self.gui, _('ZMI Copy ZColumn to Custom Column'),_('You must select one or more books to perform this action.'), show=True)

        self.copy_misc_zcolumns_to_custom_columns()
    #-----------------------------------------------------------------------------------------
    def copy_misc_zcolumns_to_custom_columns(self):

        #~ self.custom_column_id_dict[label] = str(id)
        #~ self.custom_column_datatype_dict[label] = str(datatype)
        #~ self.custom_column_is_multiple_dict[label] = is_multiple
        #~ self.custom_column_normalized_dict[label] = normalized

        self.conversion_error_list = []
        del self.conversion_error_list
        self.conversion_error_list = []

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('ZMI'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        for zc,cc in self.validated_pairs_dict.iteritems():
            zc = zc.replace("#","")
            cc = cc.replace("#","")
            fdt = self.custom_column_datatype_dict[zc]
            tdt = self.custom_column_datatype_dict[cc]
            fromcolid = self.custom_column_id_dict[zc]
            tocolid = self.custom_column_id_dict[cc]
            toismultiple = self.custom_column_is_multiple_dict[cc]
            toisnormalized = self.custom_column_normalized_dict[cc]
            my_cursor.execute("begin")
            for book in self.selected_books_list:
                self.update_target_custom_columns_from_zcolumns(my_db,my_cursor,book,fromcolid,fdt,tocolid,tdt,toisnormalized,toismultiple)
            #END FOR
            my_cursor.execute("commit")
        #END FOR
        my_db.close()

        if not self.zmi_mode_manual_radio.isChecked():   #don't 'select all' when in manual mode...
            self.force_refresh_of_cache(self.selected_books_list)
            self.mark_selected_books()

        s = "Zotero Custom Columns were copied to Calibre Custom Columns..."
        self.gui.status_bar.show_message(_(s), 10000)

        if len(self.conversion_error_list) > 0:
            if len(self.conversion_error_list) > 25:
                self.conversion_error_list = self.conversion_error_list[0:25]
            msg = ""
            for error in self.conversion_error_list:
                msg = msg + error + "\n"
            #END FOR
            error_dialog(self.gui, _('ZMI Data Conversion Errors'),_(msg), show=True)
    #-----------------------------------------------------------------------------------------
    def convert_textual_to_simple_text(self,value):
        #~ <p class="description"><b>Zissn:</b> 417-436</p>
        if value.count(":</b>") > 0:
            s_split = value.split(":</b>")
            n = len(s_split)
            if n == 2:
                value = s_split[1]
        value = html2text(value)
        value = value.replace(" ","")
        value = value.strip()
        #~ if DEBUG: print("textual: ", value)
        return value,None
    #-----------------------------------------------------------------------------------------
    def convert_textual_to_integer(self,value):
        newint = None
        error = None
        #~ <p class="description"><b>Zissn:</b> 417-436</p>
        if value.count(":</b>") > 0:
            s_split = value.split(":</b>")
            n = len(s_split)
            if n == 2:
                value = s_split[1]
        value = html2text(value)
        value = value.replace(" ","")
        value = value.strip()
        try:
            newint = int(value)
        except:
            error = "ZColumn value of " + str(value) + " could NOT be converted to an integer..."
            if DEBUG: print(error)
        #~ if DEBUG: print("newint: ", str(newint))
        return newint,error
    #-----------------------------------------------------------------------------------------
    def convert_textual_to_float(self,value):
        newfloat = None
        error = None
        #~ <p class="description"><b>Zissn:</b> 417-436</p>
        if value.count(":</b>") > 0:
            s_split = value.split(":</b>")
            n = len(s_split)
            if n == 2:
                value = s_split[1]
        value = html2text(value)
        value = value.replace(" ","")
        value = value.strip()
        try:
            newfloat = float(value)
        except:
            error = "ZColumn value of " + str(value) + " could NOT be converted to a float..."
            if DEBUG: print(error)
        #~ if DEBUG: print("newfloat: ", str(newfloat))
        return newfloat,error
    #-----------------------------------------------------------------------------------------
    def convert_textual_to_datetime(self,value):

        newdatetime = None
        #~ <p class="description"><b>Zissn:</b> 417-436</p>
        if value.count(":</b>") > 0:
            s_split = value.split(":</b>")
            n = len(s_split)
            if n == 2:
                value = s_split[1]
        value = html2text(value)
        value = value.replace(" ","")
        value = value[0:19]
        value = value.strip()
        try:
            newdatetime = datetime.strptime(value, "%a %b %d %H:%M:%S")           #  2016-06-19 20:18:33
        except:
            value = value[0:10]
            newdatetime = value + " 12:00:00.000000+00:00"           # 2016-06-19 12:00:00.000000+00:00
        #~ if DEBUG: print("newdatetime: ", newdatetime)
        return newdatetime,None
    #-----------------------------------------------------------------------------------------
    def convert_textual_to_boolean(self,value):
        newboolean = None
        error = None
        #~ <p class="description"><b>Zissn:</b> 417-436</p>
        if value.count(":</b>") > 0:
            s_split = value.split(":</b>")
            n = len(s_split)
            if n == 2:
                value = s_split[1]
        value = html2text(value)
        value = value.replace(" ","")
        value = value.strip()
        value = value.lower()
        if str(value) == str("yes") or value == "yes" or str(value) == str(1) or str(value) == str("true") or value == "true":
            newboolean = 1
        elif str(value) == str("no") or value == "no" or str(value) == str(0) or str(value) == str("false") or value == "false":
            newboolean = 0
        else:
            error = "ZColumn value of " + str(value) + " could NOT be converted to a boolean..."
            if DEBUG: print(error)
        #~ if DEBUG: print("newboolean: ", str(newboolean))
        return newboolean,error
    #-----------------------------------------------------------------------------------------
    def update_target_custom_columns_from_zcolumns(self,my_db,my_cursor,book,fromcolid,fdt,tocolid,tdt,toisnormalized,toismultiple):
        # a single ZColumn can ONLY be copied into a single Custom Column in one execution.
        # If the user wants to copy 1 zcolumn to 2 places, they have to do the first one, then change the pairs, then do the second one.
        # frankly, it makes no sense to copy 1 into 2.  however...
        book = int(book)
        fromcolid = str(fromcolid)
        tocolid = str(tocolid)
        mysql = "SELECT book,value FROM custom_column_[N] WHERE book = ? AND value NOT NULL "
        mysql = mysql.replace("[N]",fromcolid)
        my_cursor.execute(mysql,([book]))
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            return
        if len(tmp_rows) == 0:
            return
        error = None
        for row in tmp_rows:
            book,value= row
            error = None
            #~ if DEBUG: print("book: ", str(book), " value: ", str(value), " tdt: ", tdt)
            if not value:
                return
            if tdt == "comments":
                pass
            elif tdt == "text":
                value,error = self.convert_textual_to_simple_text(value)
            elif tdt == "int":
                value,error = self.convert_textual_to_integer(value)
            elif tdt == "float":
                value,error = self.convert_textual_to_float(value)
            elif tdt == "datetime":
                value,error = self.convert_textual_to_datetime(value)
            elif tdt == "bool":
                value,error = self.convert_textual_to_boolean(value)
            else:
                if DEBUG: print("update_target_custom_columns_from_zcolumns --- unsupported to-custom column datatype conversion: " + tdt)
                return
            break  #should only ever be 1 row; apsw has no fetchone()...
        #END FOR

        if not error:
            pass
        else:
            self.conversion_error_list.append(error)
            return

        if toisnormalized == 1:
            if toismultiple == 1:
                value_list = self.format_taglike_data(value)
                value = None
            else:
                value_list = None
            self.update_normalized_custom_column(my_db,my_cursor,book,tocolid,value,value_list)
        else:
            if toisnormalized == 0:
                self.update_non_normalized_custom_column(my_db,my_cursor,book,tocolid,value)
            else:
                return
    #-----------------------------------------------------------------------------------------
    def update_normalized_custom_column(self,my_db,my_cursor,book,tocolid,value,value_list):
        #~ if DEBUG: print("normalized")
        if not value and not value_list:
            return
        if value:
            if not value > " ":
                value = None
        if value_list:
            if len(value_list) == 0:
                value_list == None

        if value:
            self.update_basic_table(my_db,my_cursor,book,tocolid,value)
            self.update_book_link_table(my_db,my_cursor,book,tocolid,value)

        if value_list:
            for value in value_list:
                self.update_basic_table(my_db,my_cursor,book,tocolid,value)
                self.update_book_link_table(my_db,my_cursor,book,tocolid,value)
            #END FOR
    #-----------------------------------------------------------------------------------------
    def update_basic_table(self,my_db,my_cursor,book,tocolid,value):
        mysql = "INSERT OR IGNORE INTO custom_column_[N] (id,value) VALUES (null,?) "
        mysql = mysql.replace("[N]",str(tocolid))
        my_cursor.execute(mysql,([value]))
        my_cursor.execute("commit")
        my_cursor.execute("begin")
    #-----------------------------------------------------------------------------------------
    def update_book_link_table(self,my_db,my_cursor,book,tocolid,value):
        mysql = "INSERT OR REPLACE INTO books_custom_column_[N]_link (id,book,value) VALUES (null,?,(SELECT id FROM custom_column_[N] WHERE value = ?) )  "
        mysql = mysql.replace("[N]",str(tocolid))
        my_cursor.execute(mysql,(book,value))
    #-----------------------------------------------------------------------------------------
    def update_non_normalized_custom_column(self,my_db,my_cursor,book,tocolid,value):
        if not value:
            return
        if not str(value) > " ":
            return
        mysql = "INSERT OR REPLACE INTO custom_column_[N] (id,book,value) VALUES (null,?,?) "
        mysql = mysql.replace("[N]",str(tocolid))
        my_cursor.execute(mysql,(book,value))
    #-----------------------------------------------------------------------------------------
    def format_taglike_data(self,value):

        try:
            del value_list
        except:
            pass

        value_list = []

        value = value.replace(";",",")
        value = value.strip()
        if not "," in value:
            if value > " ":
                value_list.append(value)
        else:
            s_split = value.split(",")
            n = len(s_split)
            if n > 0:
                for row in s_split:
                    if row:
                        if row > " ":
                            row = row.strip()
                            value_list.append(row)
                #END FOR
        return value_list
    #-----------------------------------------------------------------------------------------
    def build_generic_custom_column_dicts(self):

        self.custom_column_id_dict = {}
        self.custom_column_datatype_dict = {}
        self.custom_column_is_multiple_dict = {}
        self.custom_column_normalized_dict = {}

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('Automatically Add Custom Columns'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        mysql = "SELECT id,label,datatype,is_multiple,normalized FROM custom_columns  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        if not tmp_rows:
            pass
        else:
            if len(tmp_rows) == 0:
                pass
            else:
                for row in tmp_rows:
                    id,label,datatype,is_multiple,normalized = row
                    label = str(label)
                    self.custom_column_id_dict[label] = str(id)
                    self.custom_column_datatype_dict[label] = str(datatype)
                    self.custom_column_is_multiple_dict[label] = is_multiple
                    self.custom_column_normalized_dict[label] = normalized
                #END FOR
                del tmp_rows
    #-----------------------------------------------------------------------------------------
    def get_selected_books(self):

        try:
            del self.selected_books_list
        except:
            pass

        self.selected_books_list = []

        book_ids_list = []

        book_ids_list = map( partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() )
        n = len(book_ids_list)
        if n == 0:
            del book_ids_list
            return self.selected_books_list
        for item in book_ids_list:
            s = str(item['calibre_id'])
            self.selected_books_list.append(s)
        #END FOR

        del book_ids_list

        n_books = len(self.selected_books_list)
        if n_books == 0:
             return error_dialog(my_gui, _('ZMI'),_('No Calibre Books Were Selected.'), show=True)

        self.selected_books_list.sort()
    #-----------------------------------------------------------------------------------------
    def convert_id_to_book(self, idval):
        book = {}
        book['calibre_id'] = idval
        return book
#-----------------------------------------------------------------------------------------
    def mark_selected_books(self):

        self.clear_all_marked_books()

        try:
            n = len(self.selected_books_list)
        except:
            self.show_incomplete_books()
            self.selected_books_list = deepcopy(self.newly_added_books_list)

        found_dict = {}
        s_true = 'true'
        for row in self.selected_books_list:
            key = int(row)
            found_dict[key] = s_true
        #END FOR

        marked_ids = dict.fromkeys(found_dict, s_true)
        self.gui.current_db.set_marked_ids(marked_ids)
        self.gui.search.clear()
        #~ self.gui.search.set_search_string('marked:true')  #never mark any books "marked:true"
        self.gui.search.set_search_string('identifiers:"=zmi:new"')

        self.gui.library_view.clearSelection()
        self.gui.library_view.select_rows(marked_ids)

        del found_dict
    #-----------------------------------------------------------------------------------------
    def clear_all_marked_books(self):
        self.gui.current_db.data.set_marked_ids(())
        if unicode(self.gui.search.text()).startswith('marked:'):
            self.gui.search.set_search_string('identifiers:"=zmi:new"')

    #-----------------------------------------------------------------------------------------
    def force_refresh_of_cache(self,selected_book_list):
        backend = self.gui.library_view.model().db.backend
        mydbcache = dbcache(self.gui.library_view.model().db.backend)
        mydbcache.init()
        self.gui.library_view.model().refresh_ids(selected_book_list)
        self.gui.tags_view.recount()
        self.gui.update()
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def apsw_connect_to_library(self):

        my_db = self.gui.library_view.model().db

        self.lib_path = my_db.library_path
        self.lib_path = self.lib_path.replace(os.sep, '/')
        if isbytestring(self.lib_path):
            self.lib_path = self.lib_path.decode(filesystem_encoding)

        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        if isbytestring(path):
            path = path.decode(filesystem_encoding)

        if path.endswith("/"):
            path = path[0:-1]

        if path.count("metadata.db") == 0:
            path = path + "/metadata.db"

        try:
            my_db =apsw.Connection(path)
            is_valid = True
        except Exception as e:
            if DEBUG: print("path to metadata.db is: ", path)
            if DEBUG: print("error: ", str(e))
            is_valid = False
            return None,None,is_valid

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        return my_db,my_cursor,is_valid
    #-----------------------------------------------------------------------------------------
    def exit_zmi(self):
        prefs['ZMI_MANUAL_MODE_REQUESTED_AFTER_RESTART'] = unicode("False")
        prefs
        self.save_prefs()
        self.save_dialog_geometry()
        self.ui_exit(restart=False)
    #-----------------------------------------------------------------------------------------
    def restart_zmi(self):
        self.save_prefs()
        self.save_dialog_geometry()
        self.clear_all_marked_books()
        self.gui.search.clear()
        self.gui.library_view.clearSelection()
        self.ui_exit(restart=True)
    #-----------------------------------------------------------------------------------------
    def add_temp_directory_to_remove_list(self):
        try:
            if not self.tmp_directory_to_delete_at_exit:
                return
            s = prefs['ZMI_TEMP_DIRECTORY_TO_DELETE_AT_SHUTDOWN']
            tmp_directory_list = ast.literal_eval(s)
            if isinstance(tmp_directory_list,list):
                s = self.tmp_directory_to_delete_at_exit
                tmp_directory_list.append(s)
                prefs['ZMI_TEMP_DIRECTORY_TO_DELETE_AT_SHUTDOWN'] = str(tmp_directory_list)
                prefs
                #~ if DEBUG:
                    #~ for dir in tmp_directory_list:
                        #~ print("temporary directory to be deleted at Calibre shutdown: ", dir)
                self.tmp_directory_to_delete_at_exit = None
        except Exception as e:
            if DEBUG: print(e)
    #-----------------------------------------------------------------------------------------
    def save_prefs(self):
        return
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def add_missing_books_via_zmi_new_add_book(self):

        n = len(self.missing_zotero_books_dict)
        self.initialize_progress_bar(n)
        n_progress_counter = 0
        s = "ZMI: Processing " + str(n) + " CSV File Items "
        self.zmiprogress_bar_dialog.setLabelText(s)
        self.zmiprogress_bar_dialog.setValue(0)

        p1 = prefs['ZMI_TEMP_DIRECTORY_SAME_AS_CALIBRE']
        p2 = prefs['ZMI_TEMP_DIRECTORY_SPECIAL_SET']
        p3 = prefs['ZMI_TEMP_DIRECTORY_SPECIAL_TO_USE']
        p4 = prefs['ZMI_TEMP_DIRECTORY_USE_TMPDIR']

        # must first copy the Zotero files to a temp directory so they can be renamed to ascii names so calibre can find them with certainty...
        try:
            msg = ""
            if p1 == unicode("True"):
                msg = "[Same as Calibre is using]"
                tmp_directory = PersistentTemporaryDirectory(suffix='_zotero_', prefix='', dir=None)
                self.tmp_directory_to_delete_at_exit = None
            elif p2 == unicode("True"):
                msg = "[User Specified]"
                tmp_directory = PersistentTemporaryDirectory(suffix='_zotero_', prefix='', dir=p3)
                self.tmp_directory_to_delete_at_exit = tmp_directory
                self.add_temp_directory_to_remove_list()
            elif p4 == unicode("True"):
                tmp_directory =  tempfile.mkdtemp(suffix='_zotero_', prefix='', dir=None)  # generic Python default decision tree.  see:  https://docs.python.org/2/library/tempfile.html#tempfile.mkdtemp
                self.tmp_directory_to_delete_at_exit = tmp_directory
                self.add_temp_directory_to_remove_list()
        except Exception as e:
            self.tmp_directory_to_delete_at_exit = None
            s =  "Creation of tmp_directory failed for rule: ",msg, "  Exception: ", str(e)
            if DEBUG: print(s)
            error_dialog(self.gui, _('ZMI'),_(s), show=True)
            return False

        if DEBUG: print("tmp_directory is: ", tmp_directory)

        self.zipped_files_to_delete_at_end_list = []

        if isbytestring(tmp_directory):
            tmp_directory = tmp_directory.decode(filesystem_encoding)
        tmp_directory = tmp_directory.replace(os.sep, '/')
        self.missing_zotero_books_dict_copy = self.missing_zotero_books_dict.copy()         # self.missing_zotero_books_dict is an ordereddict...
        for full_key,fileattachment in self.missing_zotero_books_dict_copy.iteritems():
            try:
                if isbytestring(fileattachment):
                    fileattachment = fileattachment.decode(filesystem_encoding)
                fileattachment = fileattachment.replace(os.sep, '/')
                fileattachment = self.compress_whole_directory_if_needed(fileattachment)
                if not fileattachment:
                    self.missing_zotero_books_dict[full_key] = "ERROR: HTML file attachments cannot be imported via ZMI..."
                    if DEBUG: print("ERROR: HTML file attachments cannot be imported via ZMI...",str(full_key))
                    continue
                if DEBUG: print("Prior to attempt to copy(fileattachment,tmp_directory): ", fileattachment, " to: ",  tmp_directory)
                copy(fileattachment,tmp_directory)
                if DEBUG: print("copy to tmp_directory was successful: ", fileattachment, tmp_directory)
                original_filename = os.path.basename(fileattachment)
                if isbytestring(original_filename):
                    original_filename = original_filename.decode(filesystem_encoding)
                oldpath = os.path.join(tmp_directory,original_filename)
                new_filename = unicodedata.normalize('NFKD', original_filename).encode('ascii','ignore')
                new_filename = new_filename.strip()
                needs_text_written = False
                if "__empty__" in new_filename:
                    s_split = new_filename.split("__empty__")
                    if len(s_split) == 2:
                        new_filename = s_split[1].strip()
                        needs_text_written = True
                        if DEBUG: print("empty file name: ", new_filename)
                if new_filename.startswith(str(".")):
                    new_filename = new_filename[1: ]
                if new_filename.startswith(str("_")):
                    new_filename = new_filename[1: ]
                if new_filename.startswith(str(".")):
                    new_filename = new_filename[1: ]
                new_filename = new_filename.replace(str("]")," ")
                new_filename = new_filename.replace(str("[")," ")
                new_filename = new_filename.replace(str(")")," ")
                new_filename = new_filename.replace(str("(")," ")
                new_filename = new_filename.replace(str("}")," ")
                new_filename = new_filename.replace(str("{")," ")
                new_filename = new_filename.replace(str("&")," ")
                new_filename = new_filename.replace(str("%")," ")
                new_filename = new_filename.replace(str("'"),"")          # no single quotes
                new_filename = new_filename.replace(str('"'),"")           # no double quotes
                n = new_filename.count(str("."))
                if n > 1:
                    if DEBUG: print("new_filename has too many periods: ", str(n), "   ", new_filename)
                    new_filename = new_filename.replace(str("."),"_",(n-1))  # example:  KlausurLoesungUeT1-1_4.4.2003.dvi_-_Unknown.pdf
                    if DEBUG: print("new_filename with extra periods removed: ", new_filename)
                new_filename = new_filename.strip()
                new_filename = new_filename.replace("  "," ")
                new_filename = new_filename.replace(" ","_")
                new_filename = new_filename.replace("__","_")
                new_filename = new_filename.replace("__","_")
                if new_filename.startswith(str("_")):
                    new_filename = new_filename[1: ]
                if new_filename[1:1] == "_":
                    if DEBUG: print("_ :", new_filename)
                    new_filename[1:1] = ""
                if isbytestring(new_filename):
                    new_filename = new_filename.decode(filesystem_encoding)
                newpath = os.path.join(tmp_directory,new_filename)
                if isbytestring(newpath):
                    newpath = newpath.decode(filesystem_encoding)
                newpath = newpath.replace(os.sep, '/')
                s = datetime.now()  # 2016-06-28 12:10:15.608000
                s = str(s)
                s = s[19:22]
                s = s.replace(".","").strip()
                s = unicode(s)
                s = unicodedata.normalize('NFKD', s).encode('ascii','ignore')
                new_new_filename = str(s) + str(new_filename)
                newpath = str(newpath)
                newpath = newpath.replace(str(new_filename),new_new_filename)
                newpath = str(newpath)
                if isbytestring(newpath):
                    newpath = newpath.decode(filesystem_encoding)
                if isbytestring(oldpath):
                    oldpath = oldpath.decode(filesystem_encoding)
                try:
                    if not os.path.isfile(oldpath):
                        if DEBUG: print(">>>>>>oldpath is NOT a valid file: ", oldpath)
                    os.rename(oldpath,newpath)
                    #~ ------------------------
                    if needs_text_written:
                        if not newpath.endswith(".txt"):
                            newpath = newpath + ".txt"
                            if DEBUG: print(".txt added: ", newpath)
                        with open(newpath, "w") as text_file:
                            text_file.write(str("This file is an empty file created by ZMI for Zotero CSV items with an empty file attachment column.\n"))
                            text_file.close()
                    #~ ------------------------
                    self.missing_zotero_books_dict[full_key] = newpath
                except Exception as e:
                    self.missing_zotero_books_dict[full_key] = "ERROR: Zotero file could not be renamed in temp directory: " + tmp_directory
                    if DEBUG: print("os.rename error: ", str(e))
                    if DEBUG: print("oldpath: ", oldpath, "   newpath:  ", newpath)
                    continue
            except Exception as e:
                # if a .pdf is a child of a .pdf so there are 2 KEYS associated with it in its path, this will happen..."C:\Users\DaltonST\Zotero\storage\4SDWVWDV\4XPKGM9B\5-2_Kirihata.pdf"
                self.missing_zotero_books_dict[full_key] = "ERROR: Zotero file could not be copied to the temp directory: " + tmp_directory + "   " + fileattachment
                if DEBUG: print("Message 1 of 2: ", self.missing_zotero_books_dict[full_key], " for file attachment: ", fileattachment)
                if DEBUG: print("Message 2 of 2: In: add_missing_books_via_zmi_new_add_book - Other exception: ", str(e))
                continue
        #END FOR

        del self.missing_zotero_books_dict_copy

        try:
            del self.calibre_param_list
        except:
            pass
        try:
            del parameter_execution_list
            del filenames_to_be_removed_list
        except:
            pass

        msg = ('ZMI: calibre is adding the selected books.')
        self.gui.status_bar.showMessage(msg)

        if DEBUG: print(msg)

        s_add_param =  "zkey:[XXX]|||zkey_file:[YYY]|||zmi:new|||"         # and the fileattachment will be appended at the end

        parameter_execution_list = []
        filenames_to_be_removed_list = []
        for full_key,fileattachment in self.missing_zotero_books_dict.iteritems():
            if fileattachment.startswith("ERROR"):
                if DEBUG: print("Erroneous ris_tag Zotero file is being skipped: ", fileattachment)
                continue
            if isbytestring(fileattachment):
                fileattachment = fileattachment.decode(filesystem_encoding)
            fileattachment = fileattachment.replace(os.sep, '/')
            s_split = full_key.split("||")
            zkey = s_split[0].strip()
            zkey_file = s_split[1].strip()
            s = s_add_param.replace("[XXX]",zkey)
            s = s.replace("[YYY]",zkey_file)
            s = s + str('"') + fileattachment + str('"') # double quotes
            if isbytestring(s):
                s = s.decode(filesystem_encoding)
            parameter_execution_list.append(s)
            filenames_to_be_removed_list.append(fileattachment)
            if DEBUG: print("s is: ", s)
        #END FOR

        #~ # parameter_execution_list.sort()      # do *not* sort since need the original order of the ordereddict...

        self.gui.library_view.model().stop_metadata_backup()

        my_db = self.gui.library_view.model().db
        self.lib_path = my_db.library_path
        self.lib_path = self.lib_path.replace(os.sep, '/')
        if isbytestring(self.lib_path):
            self.lib_path = self.lib_path.decode(filesystem_encoding)

        if prefs['ZMI_AUTO_SELECT_CSV_IMPORT_DIRECTORY'] == unicode("True"):
            if prefs['ZMI_IGNORE_MAXIMUM_FILE_ATTACHMENTS_TO_AUTO_PROCESS'] == unicode("True"):
                ignore_maximum = True
            else:
                ignore_maximum = False
        else:
            ignore_maximum = False

        exception_error_message = ""

        if len(self.missing_zotero_books_dict) > 0:
            self.zmiprogress_bar_dialog.show()
        sleep(0)
        try:
            n_max_allowed = int(prefs['ZMI_MAXIMUM_FILE_ATTACHMENTS_TO_ADD_AUTOMATICALLY'])
            n_total_added = 0
            for s_add_param in parameter_execution_list:
                sleep(0)
                n_total_added = n_total_added + 1
                msg = "Adding Book: " + str(n_total_added)
                self.gui.status_bar.showMessage(msg)
                sleep(0)
                try:
                    is_valid = self.zmi_new_add_book(s_add_param)    # New for Calibre 3.0.0 ........................................................................
                    if not is_valid:
                        if DEBUG: print("NOT is_valid = zmi_new_add_book(s_add_param) :", s_add_param)
                except Exception as e:
                    x = "ADD TERMINATED PREMATURELY.  "
                    x = x + "ERROR: " +  "  >>>>" + str(e)
                    if DEBUG: print(x)
                    exception_error_message = exception_error_message + x + "<br><br>"
                #~ ----------------------------------------
                if self.show_zmi_progress_bar:
                    n_progress_counter = n_progress_counter + 1
                    self.zmiprogress_bar_dialog.setValue(n_progress_counter)
                    sleep(0)
                    if self.zmiprogress_bar_dialog.wasCanceled():
                        self.user_clicked_cancel = True
                        break
                #~ ----------------------------------------
                if not ignore_maximum:
                    if n_total_added == n_max_allowed:
                        if DEBUG: print("maximum reached: ", str(n_max_allowed))
                        break
            #END FOR
        except Exception as e:
            x = "ADD TERMINATED PREMATURELY.  "
            x = x + "ERROR: " +  "  >>>>" + str(e)
            if DEBUG: print(x)
            exception_error_message = exception_error_message + x + "<br><br>"
            #~ try:
                #~ del s_add_param
            #~ except:
                #~ pass
        # -----------------------------------

        if self.user_clicked_cancel:
            msg = "User Clicked Cancel.  No more Zotero books will be added to Calibre, but those already added will be allowed to complete."
            self.gui.status_bar.showMessage(msg)
            sleep(0)

        try:
            self.zmiprogress_bar_dialog.close()
        except:
            pass

        msg = 'ZMI: calibre has tried to add ' + str(n_total_added) + ' missing book(s)'
        self.gui.status_bar.showMessage(msg)
        self.gui.search.clear()

        for s in filenames_to_be_removed_list:
            if isbytestring(s):
                s = s.decode(filesystem_encoding)
            if os.path.isfile(s):
                os.remove(s)
        #END FOR

        for f in self.zipped_files_to_delete_at_end_list:
            if os.path.isfile(f):
                os.remove(f)
                if DEBUG: print("zip file deleted: ", f)
        #END FOR

        self.show_incomplete_books()

        if exception_error_message <> "":
            msg = exception_error_message
            error_dialog(self.gui, _('ZMI'),_(msg), show=True)
            return False
        else:
            if not self.do_all_that_is_possible:
                self.list_failed_adds()
            return True
    #-----------------------------------------------------------------------------------------
    def compress_whole_directory_if_needed(self,file):

        if file.endswith(".html") or file.endswith(".htm") or file.endswith(".xhtml") or file.endswith(".xhtm"):
            return None   # Calibre 3.0.0 change...no longer supported...
        else:
            return file

    #-----------------------------------------------------------------------------------------
    def list_failed_adds(self):

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('ZMI'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        mysql = "SELECT id,val FROM identifiers WHERE type = 'zkey'  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        tmp_set1 = set([])
        for row in tmp_rows:
            id,val = row
            tmp_set1.add(val)
        del tmp_rows

        mysql = "SELECT id,val FROM identifiers WHERE type = 'zkey_file'  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()  #...
        if not tmp_rows:
            tmp_rows = []
        tmp_set2 = set([])
        for row in tmp_rows:
            id,val = row
            tmp_set2.add(val)
        del tmp_rows

        found_missing = False
        for full_key,fileattachment in self.missing_zotero_books_dict.iteritems():
            s_split = full_key.split("||")
            zkey = s_split[0].strip()
            zkey_file = s_split[1].strip()
            if (not zkey in tmp_set1) and (not zkey_file in tmp_set2) :
                msg = full_key + " -->> " + fileattachment + "<br><br>"   #   WI3R9B5T -->> X:/Zotero/calibre_testing_books/Expertenefragung - Unknown.pdf
                if DEBUG: print(msg)
                found_missing = True
        #END FOR

        del tmp_set1
        del tmp_set2

        self.show_incomplete_books()

        if found_missing:
            msg = "Missing CSV Books not found in Zotero.\
                        Repeat the 'Select CSV' process <b>after changing the Titles and Authors for the successful books</b>, and restarting ZMI.\
                        <b>After restarting ZMI and repeating this process</b>, if there are still missing books, you must update their metadata <b>manually</b> using the 'manual' pushbutton.  Read its 'ToolTips'. <br><br>" + msg
            error_dialog(self.gui, _('ZMI'),_(msg), show=True)
        else:
            info_dialog(self.gui, 'ZMI','All Missing Zotero Books Were Added.').show()
    #-----------------------------------------------------------------------------------------
    def remove_dir(self,x):
        try:
            shutil.rmtree(x, ignore_errors=True)
        except:
            pass
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def convert_zcolumns_to_html_with_label(self):
        #~ <p class="description"><b>Zissn:</b> 417-436</p>
        NEWHTML = '<p class="description"><b>[ZCOLUMN]:</b> [DATA]</p>'

        self.get_selected_books()
        n = len(self.selected_books_list)
        if n == 0:
            return error_dialog(self.gui, _('ZMI'),
                                                          _('You must select one or more books to perform this action.'), show=True)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('ZMI'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        try:
            n = len(self.zotero_custom_column_dict)
        except:
            self.zotero_custom_column_dict = {}

        mysql = "SELECT id, label FROM custom_columns WHERE datatype = 'comments'  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id, label = row
            label = str(label)
            if label in self.zotero_custom_column_dict:
                self.zotero_custom_column_dict[label] = id     # dict was originally initialized with id = 0, and still be 0 based on previous user actions this session...
        #END FOR

        my_cursor.execute("begin")
        for book in self.selected_books_list:
            book = int(book)
            for label,id in self.zotero_custom_column_dict.iteritems():
                mysql = "SELECT book,value FROM custom_column_[N] WHERE book = ?"
                mysql = mysql.replace("[N]",str(id))
                my_cursor.execute(mysql,([book]))
                tmp_rows = my_cursor.fetchall()
                if not tmp_rows:
                    continue
                else:
                    if len(tmp_rows) == 0:
                        continue
                    else:
                        for row in tmp_rows:
                            book,value = row
                            value = value.replace("*","")
                            #~ <p class="description"><b>Zissn:</b> 417-436</p>
                            if value.count(":</b>") > 0:
                                s_split = value.split(":</b>")
                                n = len(s_split)
                                if n == 2:
                                    value = s_split[1]     #  417-436
                            value = html2text(value)
                            value = value.strip()
                            newval = NEWHTML
                            newlabel = label.replace("_"," ")
                            newlabel = newlabel.replace("zotero ","z")
                            newlabel = newlabel.title()
                            newlabel = newlabel[0:2].upper() + newlabel[2: ]
                            newlabel = newlabel.strip()
                            newval = newval.replace("[ZCOLUMN]",newlabel)
                            newval = newval.replace("[DATA]",value)
                            mysql = "INSERT OR REPLACE INTO custom_column_[N] (id,book,value) VALUES (null,?,?) "
                            mysql = mysql.replace("[N]",str(id))
                            my_cursor.execute(mysql,(book,newval))
                        #END FOR
                        del tmp_rows
            #END FOR
        #END FOR
        my_cursor.execute("commit")
        my_db.close()
        self.force_refresh_of_cache(self.selected_books_list)
        self.mark_selected_books()
    #-----------------------------------------------------------------------------------------
    def convert_zcolumns_to_simple_text(self,all=False):
        #~ <p class="description"><b>Zissn:</b> 417-436</p>

        if all:
            db = self.gui.current_db.new_api
            work_book_ids_frozenset = db.all_book_ids()
            for row in work_book_ids_frozenset:
                self.selected_books_list.append(row)
            del work_book_ids_frozenset
            tmp_set = set(self.selected_books_list)
            self.selected_books_list = list(tmp_set)
            del tmp_set
        else:
            self.get_selected_books()
            n = len(self.selected_books_list)
            if n == 0:
                return error_dialog(self.gui, _('ZMI'),
                                                              _('You must select one or more books to perform this action.'), show=True)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('ZMI'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        try:
            n = len(self.zotero_custom_column_dict)
        except:
            self.zotero_custom_column_dict = {}

        mysql = "SELECT id, label FROM custom_columns WHERE datatype = 'comments'  "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            id, label = row
            label = str(label)
            if label in self.zotero_custom_column_dict:
                self.zotero_custom_column_dict[label] = id     # dict was originally initialized with id = 0, and may still be 0 based on previous user actions this session...
        #END FOR

        my_cursor.execute("begin")
        for book in self.selected_books_list:
            book = int(book)
            for label,id in self.zotero_custom_column_dict.iteritems():
                mysql = "SELECT book,value FROM custom_column_[N] WHERE book = ?"
                mysql = mysql.replace("[N]",str(id))
                my_cursor.execute(mysql,([book]))
                tmp_rows = my_cursor.fetchall()
                if not tmp_rows:
                    continue
                else:
                    if len(tmp_rows) == 0:
                        continue
                    else:
                        for row in tmp_rows:
                            book,value = row
                            if value.count("<p class=") == 0:
                                continue
                            value = value.replace("*","")
                            #~ <p class="description"><b>Zissn:</b> 417-436</p>
                            if value.count(":</b>") > 0:
                                s_split = value.split(":</b>")
                                n = len(s_split)
                                if n == 2:
                                    value = s_split[1]
                            value = html2text(value)
                            value = value.strip()
                            mysql = "INSERT OR REPLACE INTO custom_column_[N] (id,book,value) VALUES (null,?,?) "
                            mysql = mysql.replace("[N]",str(id))
                            my_cursor.execute(mysql,(book,value))
                        #END FOR
                        del tmp_rows
            #END FOR
        #END FOR
        my_cursor.execute("commit")
        my_db.close()
        self.force_refresh_of_cache(self.selected_books_list)

        if all:
            self.gui.search.clear()
            self.gui.library_view.clearSelection()
        else:
            self.mark_selected_books()
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
    def initialize_progress_bar(self,n_total):

        if n_total > 0:
            self.show_zmi_progress_bar = True
        else:
            self.show_zmi_progress_bar = False
            self.user_clicked_cancel = False
            return

        self.zmiprogress_bar_dialog = QProgressDialog()
        self.zmiprogress_bar_dialog.setWindowTitle('ZMI Progress')
        self.zmiprogress_bar_dialog.setWindowIcon(self.icon)
        self.zmiprogress_bar_dialog.setLabelText("Zotero Books Added to Calibre")
        self.zmiprogress_bar_dialog.setWindowModality(Qt.WindowModal)
        self.zmiprogress_bar_dialog.setRange(0,n_total)
        self.zmiprogress_bar_dialog.setValue(0)
        self.zmiprogress_bar_dialog.setAutoClose(False)
        self.zmiprogress_bar_dialog.setAutoReset(False)
        self.user_clicked_cancel = False
        self.zmiprogress_bar_dialog.hide()
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
    def execute_auto_select_csv_import_directory(self):
        if prefs['ZMI_AUTO_SELECT_CSV_IMPORT_DIRECTORY'] == unicode("True"):
            self.auto_select_csv_import_directory()
#-----------------------------------------------------------------------------------------
    def auto_select_csv_import_directory(self):
        #~ prefs.defaults['ZMI_CSV_ARCHIVE_DIRECTORY_TO_USE'] = unicode("")
        #~ prefs.defaults['ZMI_CSV_ARCHIVE_ORIGINALS'] = S_TRUE

        if not self.validation_generation_complete:
            error_dialog(self.gui, _('Import Zotero CSV File'),_('Prior Step Not Yet Performed. Execution canceled.'), show=True)
            return

        if self.calibre_metadata_auto_update_complete or self.update_calibre_title_complete or self.update_calibre_author_complete:
            error_dialog(self.gui, _('Import Zotero CSV File'),_('Later Step Was Already Performed.  Execution canceled.'), show=True)
            return

        dir = prefs['ZMI_CSV_IMPORT_DIRECTORY_TO_USE']
        dir = dir.replace(os.sep, '/')
        if isbytestring(dir):
            dir = dir.decode(filesystem_encoding)
        for dirpath, dirs, files in os.walk(dir):      # yields  3-tuple: (dirpath, dirnames, filenames)
            if dirpath == dir:
                for f in files:
                    f = os.path.join(dirpath, f)
                    if f.endswith(".csv"):
                        f = f.replace(os.sep, '/')
                        self.original_imported_csv_filenames_list.append(f)
                        if DEBUG: print("original csv filename to import:",f)
                #END FOR
        #END FOR

        for f in self.original_imported_csv_filenames_list:
            zotero_csv_list = self.import_csv_file(f)
            for row in zotero_csv_list:
                self.combined_zotero_csv_list.append(row)
            #END FOR
            del zotero_csv_list
        #END FOR

        if DEBUG: print("rows in self.combined_zotero_csv_list: ",str(len(self.combined_zotero_csv_list)))

        self.import_exported_csv(combined=True)

        self.calibre_metadata_auto_update_complete = False
#-----------------------------------------------------------------------------------------
    def archive_original_csv_files(self):

        if not prefs['ZMI_AUTO_SELECT_CSV_IMPORT_DIRECTORY'] == unicode("True"):
            return

        if prefs['ZMI_CSV_ARCHIVE_ORIGINALS'] == unicode("True"):
            do_archive = True
            archive_dir = prefs['ZMI_CSV_ARCHIVE_DIRECTORY_TO_USE']
            msg = "All Original CSV Files in the Import Directory Have Been Archived"
        else:
            do_archive = False
            msg = "All Original CSV Files in the Import Directory Have Been Deleted"

        # will often be invoked after ZMI has been restarted once or more, so original list will usually have been lost...
        dir = prefs['ZMI_CSV_IMPORT_DIRECTORY_TO_USE']
        dir = dir.replace(os.sep, '/')
        if isbytestring(dir):
            dir = dir.decode(filesystem_encoding)
        for dirpath, dirs, files in os.walk(dir):
            if dirpath == dir:
                for f in files:
                    f = os.path.join(dirpath, f)
                    if f.endswith(".csv"):
                        f = f.replace(os.sep, '/')
                        self.original_imported_csv_filenames_list.append(f)
                #END FOR
        #END FOR

        import_dir = prefs['ZMI_CSV_IMPORT_DIRECTORY_TO_USE']
        for f in self.original_imported_csv_filenames_list:
            if do_archive:
                if os.path.isfile(f):
                    fnew = f.replace(import_dir,archive_dir)
                else:
                    continue
                if os.path.isfile(fnew):
                    os.remove(fnew)
                shutil.move(f,fnew)
                if DEBUG: print(f,"  was archived as:  ", fnew)
            else:
                if os.path.isfile(f):
                    os.remove(f)
                    if DEBUG: print(f, " was deleted")
        #END FOR

        self.gui.status_bar.show_message(_(msg), 10000)
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
    def create_empty_txt_file(self,suffix='.txt',prefix="_Zotero",dir=None):
        suffix = ".txt"
        dir = self.empty_txt_file_dir
        f,path = tempfile.mkstemp(suffix=suffix,prefix=prefix,dir=dir)
        path = path.replace(os.sep,'/')    #  X:/calibre_temp_dir/calibre_zy5qry/__empty__Zotero - ABCD2345vu09us.txt
        if DEBUG: print("path of tempfile for empty_txt_file: ", path)
        return path
#-----------------------------------------------------------------------------------------
    def zmi_new_add_book(self,param):

        param = param.strip()
        args = param.split("|||")
        args_list = []
        for row in args:
            s = row.strip()
            if s > " ":
                s = s.strip()
                args_list.append(s)
        #END FOR

        identifiers_dict = {}

        identifiers_dict["zkey"] = args_list[0].replace("zkey:","")
        identifiers_dict["zkey_file"] = args_list[1].replace("zkey_file:","")
        identifiers_dict["zmi"] = args_list[2].replace("zmi:","")

        zkey_file = identifiers_dict["zkey_file"]

        path = args_list[3]       # fileattachment
        path = path.replace('"',"")  # no double quotes

        file_name,file_extension = os.path.splitext(path)

        format_map = {file_extension: path}

        mi = Metadata(_('Unknown'))

        mi.identifiers = identifiers_dict

        authors_list = []
        authors_list.append(zkey_file)
        mi.authors = authors_list

        books = []
        book = mi,format_map
        books.append(book)

        db = self.gui.current_db.new_api

        try:
            ids, duplicates = db.add_books(books, add_duplicates=True, apply_import_tags=True, preserve_uuid=False, run_hooks=True, dbapi=None)
            book_id = ids[0]
            if DEBUG: print("db.add_books complete for new book id: ", str(book_id), "  zkey_file: ", str(zkey_file))
            #~ self.set_cover_from_format_file(db,book_id)     # deprecated as of Calibre 3.8 due to standard Calibre deprecation of cover function...
            db.embed_metadata(ids)
            self.force_refresh_of_cache(ids)
        except Exception as e:
            if DEBUG: print(">>>>>>>>>>Exception in db.add_books: ", path, "    ", str(e) )
            return False

        self.send_rc_message('')

        del args
        del args_list
        del identifiers_dict
        del authors_list

        return True

#-----------------------------------------------------------------------------------------
    def send_rc_message(self,msg):

        from calibre.utils.ipc import RC
        t = RC(print_error=False)
        t.start()
        t.join(3)
        if t.done:
            t.conn.send('refreshdb:'+msg)
            t.conn.close()

#-----------------------------------------------------------------------------------------
    def show_message_about_covers(self):

        msg = "You must use the Standard Calibre 'Bulk Metadata Edit' functionality to add the covers of the new 'books' to Calibre's metadata.\
                   <br><br>You may set the covers at any time, now or later, based on your personal work flow.\
                   <br><br>Menu Path:  Edit Metadata > Edit Metadata in Bulk > Change Cover > Set from e-book file(s) > OK/Apply"
        info_dialog(self.gui, 'ZMI - Covers for Books',msg).show()
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class ZoteroOptionsTab(QWidget):

    def __init__(self,mygui,myguidb,mymainprefs,mysave_all_prefs,myui_exit,mysave_dialog_geometry):
        super(ZoteroOptionsTab, self).__init__()
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.gui = mygui
        #-----------------------------------------------------
        self.guidb = myguidb
        #-----------------------------------------------------
        self.mytabprefs = mymainprefs
        #-----------------------------------------------------
        self.save_all_prefs = mysave_all_prefs
        #-----------------------------------------------------
        self.save_dialog_geometry = mysave_dialog_geometry
        #-----------------------------------------------------
        self.ui_exit = myui_exit
        #-----------------------------------------------------
        self.setToolTip("<p style='white-space:wrap'>This Tab allows you to set various customization options to control how, when, and where ZMI performs its functions. ")
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)
        #-----------------------------------------------------
        self.layout_top = QVBoxLayout()
        self.layout_top.setSpacing(0)
        self.layout_top.setAlignment(Qt.AlignTop)
        self.setLayout(self.layout_top)
        #-----------------------------------------------------
        self.scroll_area_frame = QScrollArea()
        self.scroll_area_frame.setAlignment(Qt.AlignTop)
        self.scroll_area_frame.setWidgetResizable(True)
        self.scroll_area_frame.ensureVisible(300,300)

        self.layout_top.addWidget(self.scroll_area_frame)       # the scroll area is now the child of the parent of self.layout_top

        # NOTE: the self.scroll_area_frame.setWidget(self.scroll_widget) is at the end of the init() AFTER all children have been created and assigned to a layout...

        #-----------------------------------------------------
        self.scroll_widget = QWidget()
        self.layout_top.addWidget(self.scroll_widget)           # causes automatic reparenting of QWidget to the parent of self.layout_top, which is:  self .
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setAlignment(Qt.AlignTop)

        self.scroll_widget.setLayout(self.layout_frame)        # causes automatic reparenting of any widget later added to self.layout_frame to the parent of self.layout_frame, which is:  QWidget .

        #-----------------------------------------------------
        self.zmi_groupbox = QGroupBox('')
        self.zmi_groupbox.setToolTip("<p style='white-space:wrap'>This Tab allows you to set various customization options to control how, when, and where ZMI performs its functions. ")
        self.layout_frame.addWidget(self.zmi_groupbox)

        self.zmi_layout = QVBoxLayout()
        self.zmi_layout.setAlignment(Qt.AlignTop)
        self.zmi_groupbox.setLayout(self.zmi_layout)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.zmi_groupbox1 = QGroupBox('General:')
        self.zmi_groupbox1.setMaximumHeight(200)
        self.zmi_groupbox1.setToolTip("<p style='white-space:wrap'>This section allows you to set customization options to control how and when ZMI performs its functions. ")
        self.zmi_layout.addWidget(self.zmi_groupbox1)

        self.zmi_layout1 = QVBoxLayout()
        self.zmi_layout1.setAlignment(Qt.AlignTop)
        self.zmi_groupbox1.setLayout(self.zmi_layout1)

        self.zmi_checkbox_layout1 = QHBoxLayout()
        self.zmi_checkbox_layout1.setAlignment(Qt.AlignLeft)
        self.zmi_layout1.addLayout(self.zmi_checkbox_layout1)

        self.checkbox_auto_validate_custom_columns = QCheckBox("Automatically validate custom columns at ZMI startup?")
        self.zmi_checkbox_layout1.addWidget(self.checkbox_auto_validate_custom_columns)

        if self.mytabprefs['ZMI_AUTO_VALIDATE_CUSTOM_COLUMNS_AT_STARTUP'] == unicode("True"):
            self.checkbox_auto_validate_custom_columns.setChecked(True)

        self.zmi_checkbox_layout2 = QHBoxLayout()
        self.zmi_checkbox_layout2.setAlignment(Qt.AlignLeft)
        self.zmi_layout1.addLayout(self.zmi_checkbox_layout2)

        self.checkbox_prefer_auto_step_mode = QCheckBox("Enable Auto-Step Mode?")
        self.checkbox_prefer_auto_step_mode.setToolTip("<p style='white-space:wrap'>Automatically do all steps possible immediately after the Zotero CSV has been selected?<br><br>If you are experiencing problems, do not use this mode.")
        self.zmi_checkbox_layout2.addWidget(self.checkbox_prefer_auto_step_mode)

        if self.mytabprefs['ZMI_PREFER_AUTO_STEP_MODE'] == unicode("True"):
            self.checkbox_prefer_auto_step_mode.setChecked(True)

        self.zmi_layout1.addStretch(2)

        self.max_file_attachments_to_process_automatically_spinbox = QSpinBox(self)
        self.max_file_attachments_to_process_automatically_spinbox.setMinimum(00001)
        self.max_file_attachments_to_process_automatically_spinbox.setMaximum(20000)
        self.max_file_attachments_to_process_automatically_spinbox.setSuffix("   Maximum File Attachments to Process Automatically?")
        self.max_file_attachments_to_process_automatically_spinbox.setSingleStep(1)
        self.max_file_attachments_to_process_automatically_spinbox.setFont(font)
        self.max_file_attachments_to_process_automatically_spinbox.setMaximumWidth(400)
        self.max_file_attachments_to_process_automatically_spinbox.setToolTip("<p style='white-space:wrap'>The CSV file may have a huge number of rows.  This limits the number that it processes at one time.")
        self.zmi_layout1.addWidget(self.max_file_attachments_to_process_automatically_spinbox)

        n = prefs['ZMI_MAXIMUM_FILE_ATTACHMENTS_TO_ADD_AUTOMATICALLY']     # must be unicode, not an int...
        if int(n) > 0:
            self.max_file_attachments_to_process_automatically_spinbox.setProperty('value',n)

        self.zmi_layout1.addStretch(2)

        self.zmi_checkbox_layout3 = QHBoxLayout()
        self.zmi_checkbox_layout3.setAlignment(Qt.AlignLeft)
        self.zmi_layout1.addLayout(self.zmi_checkbox_layout3)

        self.checkbox_import_html_text_also = QCheckBox("Import .txt and .text attachments too?")
        s = "<p style='white-space:wrap'>You might wish to have Calibre create 'books' for file attachments that are not usually considered 'books'."
        self.checkbox_import_html_text_also.setToolTip(s)
        self.zmi_checkbox_layout3.addWidget(self.checkbox_import_html_text_also)

        if self.mytabprefs['ZMI_CSV_IMPORT_TEXT_ALSO'] == unicode("True"):
            self.checkbox_import_html_text_also.setChecked(True)

        self.zmi_checkbox_layout4 = QHBoxLayout()
        self.zmi_checkbox_layout4.setAlignment(Qt.AlignLeft)
        self.zmi_layout1.addLayout(self.zmi_checkbox_layout4)

        self.checkbox_import_empty_file_attachments = QCheckBox("Create an 'empty book' for CSV items with no file attachments?")
        s ="<p style='white-space:wrap'>If checked, ZMI will create a Calibre 'book' that is nothing but an empty .txt file whenever a CSV item has no file attachments whatsoever."
        self.checkbox_import_empty_file_attachments.setToolTip(s)
        self.zmi_checkbox_layout4.addWidget(self.checkbox_import_empty_file_attachments)

        if self.mytabprefs['ZMI_CSV_IMPORT_EMPTY_FILE_ATTACHMENTS'] == unicode("True"):
            self.checkbox_import_empty_file_attachments.setChecked(True)

        self.zmi_checkbox_layout4a = QHBoxLayout()
        self.zmi_checkbox_layout4a.setAlignment(Qt.AlignLeft)
        self.zmi_layout1.addLayout(self.zmi_checkbox_layout4a)

        self.checkbox_import_html_as_empty_file_attachments = QCheckBox("Create an 'empty book' for HTML items?")
        s ="<p style='white-space:wrap'>If checked, ZMI will create a Calibre 'book' that is nothing but an empty .txt file whenever a CSV item has an HTML file attachment and no other type of file (e.g. .pdf) whatsoever.\
                                                            <br><br>The Option above, Create an 'empty book' for CSV items with no file attachment, must also be checked, since ZMI will treat any HTML file attachment as if it does not exist."
        self.checkbox_import_html_as_empty_file_attachments.setToolTip(s)
        self.zmi_checkbox_layout4a.addWidget(self.checkbox_import_html_as_empty_file_attachments)

        if self.mytabprefs['ZMI_CSV_IMPORT_HTML_AS_EMPTY_FILE_ATTACHMENTS'] == unicode("True"):
            self.checkbox_import_html_as_empty_file_attachments.setChecked(True)


        self.zmi_checkbox_layout5 = QHBoxLayout()
        self.zmi_checkbox_layout5.setAlignment(Qt.AlignLeft)
        self.zmi_layout1.addLayout(self.zmi_checkbox_layout5)

        self.checkbox_prefer_auto_tags_as_tags = QCheckBox("Create Tags from ZAutomatic Tags?")
        s ="<p style='white-space:wrap'>If checked, ZMI will copy ZAutomatic Tags to Tags after converting semi-colons (';') to commas (','), since in Calibre Tags are comma-separated."
        self.checkbox_prefer_auto_tags_as_tags.setToolTip(s)
        self.zmi_checkbox_layout5.addWidget(self.checkbox_prefer_auto_tags_as_tags)

        self.checkbox_prefer_manual_tags_as_tags = QCheckBox("Create Tags from ZManual Tags?")
        s ="<p style='white-space:wrap'>If checked, ZMI will copy ZManual Tags to Tags after converting semi-colons (';') to commas (','), since in Calibre Tags are comma-separated."
        self.checkbox_prefer_manual_tags_as_tags.setToolTip(s)
        self.zmi_checkbox_layout5.addWidget(self.checkbox_prefer_manual_tags_as_tags)

        if prefs['ZMI_PREFER_AUTO_TAGS_AS_STANDARD_TAGS'] == unicode("True"):
            self.checkbox_prefer_auto_tags_as_tags.setChecked(True)

        if prefs['ZMI_PREFER_MANUAL_TAGS_AS_STANDARD_TAGS'] == unicode("True"):
            self.checkbox_prefer_manual_tags_as_tags.setChecked(True)

        self.zmi_layout1.addStretch(1)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
        self.zmi_groupbox3 = QGroupBox('Auto-Select Multiple CSV Files:')
        self.zmi_groupbox3.setMaximumHeight(300)
        s = "<p style='white-space:wrap'>This section allows you to specify an import directory where your CSV files will have been exported from Zotero prior to processing by ZMI.   Many CSV files may be processed simultaneously if so desired. Afterwards, they can either be archived in the designated directory, or deleted."
        self.zmi_groupbox3.setToolTip(s)
        self.zmi_layout.addWidget(self.zmi_groupbox3)

        self.zmi_layout3 = QVBoxLayout()
        self.zmi_layout3.setAlignment(Qt.AlignTop)
        self.zmi_groupbox3.setLayout(self.zmi_layout3)

        self.checkbox_auto_select_csv_import_directory = QCheckBox("Enable Option to Auto-Select All CSV Files in Import Directory?")
        self.zmi_layout3.addWidget(self.checkbox_auto_select_csv_import_directory)

        if self.mytabprefs['ZMI_AUTO_SELECT_CSV_IMPORT_DIRECTORY'] == unicode("True"):
            self.checkbox_auto_select_csv_import_directory.setChecked(True)

        self.zmi_lineedit_layout3a = QHBoxLayout()
        self.zmi_lineedit_layout3a.setAlignment(Qt.AlignLeft)
        self.zmi_layout3.addLayout(self.zmi_lineedit_layout3a)

        self.push_button_select_import_directory = QPushButton("CSV Import Directory:")
        self.push_button_select_import_directory.clicked.connect(self.select_import_directory)
        self.push_button_select_import_directory.setDefault(False)
        self.push_button_select_import_directory.setFont(font)
        self.push_button_select_import_directory.setMinimumWidth(150)
        self.push_button_select_import_directory.setMaximumWidth(150)
        self.push_button_select_import_directory.setToolTip("<p style='white-space:wrap'>Select the directory where Zotero will export its CSV files for use by ZMI.")
        self.zmi_lineedit_layout3a.addWidget(self.push_button_select_import_directory)

        self.csv_import_dir_lineedit = QLineEdit(self)
        self.csv_import_dir_lineedit.setMaximumWidth(400)
        self.csv_import_dir_lineedit.setText(self.mytabprefs['ZMI_CSV_IMPORT_DIRECTORY_TO_USE'])
        self.csv_import_dir_lineedit.setToolTip("<p style='white-space:wrap'>This is the directory where Zotero will export its CSV files for use by ZMI.")
        self.zmi_lineedit_layout3a.addWidget(self.csv_import_dir_lineedit)

        self.zmi_disposition_layout = QHBoxLayout()
        self.zmi_disposition_layout.setAlignment(Qt.AlignLeft)
        self.zmi_layout3.addLayout(self.zmi_disposition_layout)

        self.zmi_disposition_archive_radio = QRadioButton('Archive Imported CSVs')
        self.zmi_disposition_archive_radio.setToolTip("<p style='white-space:wrap'>Select this option if you wish the CSV files in the Import Directory to be archived, and not deleted.  If the same filename already exists in the Archive Directory, it will be replaced by the file in the Import Directory with that same name.")
        self.zmi_disposition_layout.addWidget(self.zmi_disposition_archive_radio)

        self.zmi_disposition_delete_radio = QRadioButton('Delete Imported CSVs')
        self.zmi_disposition_delete_radio.setToolTip("<p style='white-space:wrap'>Select this option if you wish the CSV files in the Import Directory to be deleted, and not archived.")
        self.zmi_disposition_layout.addWidget(self.zmi_disposition_delete_radio)

        self.zmi_disposition_button_group = QButtonGroup(self.zmi_disposition_layout)
        self.zmi_disposition_button_group.setExclusive(True)
        self.zmi_disposition_button_group.addButton(self.zmi_disposition_archive_radio)
        self.zmi_disposition_button_group.addButton(self.zmi_disposition_delete_radio)

        if prefs['ZMI_CSV_ARCHIVE_ORIGINALS'] == unicode("True"):
            self.zmi_disposition_archive_radio.setChecked(True)
        else:
            self.zmi_disposition_delete_radio.setChecked(True)

        self.zmi_lineedit_layout3b = QHBoxLayout()
        self.zmi_lineedit_layout3b.setAlignment(Qt.AlignLeft)
        self.zmi_layout3.addLayout(self.zmi_lineedit_layout3b)

        self.push_button_select_archive_directory = QPushButton("CSV Archive Directory:")
        self.push_button_select_archive_directory.clicked.connect(self.select_archive_directory)
        self.push_button_select_archive_directory.setDefault(False)
        self.push_button_select_archive_directory.setFont(font)
        self.push_button_select_archive_directory.setMinimumWidth(150)
        self.push_button_select_archive_directory.setMaximumWidth(150)
        self.push_button_select_archive_directory.setToolTip("<p style='white-space:wrap'>Select the directory where the exported CSV files will be archived after ZMI has processed them.")
        self.zmi_lineedit_layout3b.addWidget(self.push_button_select_archive_directory)

        self.csv_archive_dir_lineedit = QLineEdit(self)
        self.csv_archive_dir_lineedit.setMaximumWidth(400)
        self.csv_archive_dir_lineedit.setText(self.mytabprefs['ZMI_CSV_ARCHIVE_DIRECTORY_TO_USE'])
        self.csv_archive_dir_lineedit.setToolTip("<p style='white-space:wrap'>This is the directory where the exported CSV files will be moved after ZMI has imported and processed them.")
        self.zmi_lineedit_layout3b.addWidget(self.csv_archive_dir_lineedit)

        self.checkbox_ignore_max_file_attachments = QCheckBox("Ignore 'Maximum File Attachments to Process Automatically' Specified Above?")
        self.zmi_layout3.addWidget(self.checkbox_ignore_max_file_attachments)

        if self.mytabprefs['ZMI_IGNORE_MAXIMUM_FILE_ATTACHMENTS_TO_AUTO_PROCESS'] == unicode("True"):
            self.checkbox_ignore_max_file_attachments.setChecked(True)

        self.zmi_layout3.addStretch(1)


    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
        self.zmi_groupbox2 = QGroupBox('Temporary Directory For Zotero Books in Transit:')
        self.zmi_groupbox2.setMaximumHeight(200)
        s = "<p style='white-space:wrap'>This section allows you to specify where ZMI stores the Zotero books that are in transit to Calibre.  This option does <b>not</b> apply to where Calibre stores its temporary files while adding the Zotero books into Calibre.  Calibre always uses whatever Calibre decides to use.\
                                                                                                        <br><br>This option applies only to where ZMI temporarily stores copies of the Zotero file attachments while it sanitizes their filenames for Calibre, and then runs Calibre's API to add the books.\
                                                                                                        <br><br>If you are importing metadata for a large number of Zotero file attachments (e.g. 15,000), and you have RAMDISK or SSD or hard-drive space limitations, you may want ZMI to use a different temporary file drive/directory than Calibre is using.  Be advised that Calibre too makes a temporary copy of the books it is adding in order to rename them prior to adding them, and then the renamed copy is added into the Calibre Library."
        self.zmi_groupbox2.setToolTip(s)
        self.zmi_layout.addWidget(self.zmi_groupbox2)

        self.zmi_layout2 = QVBoxLayout()
        self.zmi_layout2.setAlignment(Qt.AlignTop)
        self.zmi_groupbox2.setLayout(self.zmi_layout2)

        self.zmi_temp_directory_radio1 = QRadioButton('Use the same Temporary Directory as Calibre?')
        s = "<p style='white-space:wrap'>If you do not care what the temporary directory is, select this option.  If you want ZMI to use the same path that you have set using CALIBRE_TEMP_DIR, select this option."
        self.zmi_temp_directory_radio1.setToolTip(s)
        if self.mytabprefs['ZMI_TEMP_DIRECTORY_SAME_AS_CALIBRE'] == unicode("True"):
            self.zmi_temp_directory_radio1.setChecked(True)
        self.zmi_layout2.addWidget(self.zmi_temp_directory_radio1)

        self.zmi_layout2.addStretch(1)

        s = "<p style='white-space:wrap'>If you do not want to, or know how to, set an environmental variable, but still want to set the temporary directory for ZMI to use for Zotero books in-transit, just add a currently existing, valid directory path here.  ZMI will check it with your OS to ensure it exists before proceeding.  Double-quotes for paths with spaces (as used in Windows) should <b>not</b> be used here."

        self.zmi_temp_directory_radio2 = QRadioButton('Use a Specific Temporary Directory for ZMI?')
        self.zmi_temp_directory_radio2.setToolTip(s)
        if self.mytabprefs['ZMI_TEMP_DIRECTORY_SPECIAL_SET'] == unicode("True"):
            self.zmi_temp_directory_radio2.setChecked(True)
        self.zmi_layout2.addWidget(self.zmi_temp_directory_radio2)

        self.calibre_temp_dir_lineedit = QLineEdit(self)
        self.calibre_temp_dir_lineedit.setMaximumWidth(300)
        self.calibre_temp_dir_lineedit.setText(self.mytabprefs['ZMI_TEMP_DIRECTORY_SPECIAL_TO_USE'])
        self.calibre_temp_dir_lineedit.setToolTip(s)
        self.zmi_layout2.addWidget(self.calibre_temp_dir_lineedit)

        self.zmi_layout2.addStretch(1)

        self.zmi_temp_directory_radio3 = QRadioButton('Use Generic Default Selection Logic?')
        if self.mytabprefs['ZMI_TEMP_DIRECTORY_USE_TMPDIR'] == unicode("True"):
            self.zmi_temp_directory_radio3.setChecked(True)
        self.zmi_layout2.addWidget(self.zmi_temp_directory_radio3)

        s = "<p style='white-space:wrap'> The Generic Python Default Selection Sequence is the first that it finds in the following order of search:\
                                                                <br>TMPDIR\
                                                                <br>TEMP\
                                                                <br>TMP\
                                                                <br>On Windows, the directories C:\TEMP, C:\TMP, \TEMP, and \TMP, in that order.\
                                                                <br>On all other platforms, the directories /tmp, /var/tmp, and /usr/tmp, in that order.\
                                                                <br>As a last resort, the current working directory.  That could be where Calibre's executable is located.\
                                                                <br>\
                                                                 "

        self.zmi_temp_directory_radio3.setToolTip(s)

        self.zmi_temp_directory_button_group = QButtonGroup(self.zmi_layout2)
        self.zmi_temp_directory_button_group.addButton(self.zmi_temp_directory_radio1)
        self.zmi_temp_directory_button_group.addButton(self.zmi_temp_directory_radio2)
        self.zmi_temp_directory_button_group.addButton(self.zmi_temp_directory_radio3)

        self.zmi_layout2.addStretch(5)

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
        self.zmi_layout.addStretch(1)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
        self.push_button_save_options = QPushButton("Save ZMI Options")
        self.push_button_save_options.clicked.connect(self.save_options)
        self.push_button_save_options.setDefault(True)
        self.push_button_save_options.setFont(font)
        self.push_button_save_options.setToolTip("<p style='white-space:wrap'>Save the ZMI options, the current geometry of this window, and then restart ZMI.")
        self.zmi_layout.addWidget(self.push_button_save_options)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
        #-----------------------------------------------------
        self.scroll_widget.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.setWidget(self.scroll_widget)    # now that all widgets have been created and assigned to a layout...
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def select_import_directory(self):
        title = "Choose CSV Import Directory"
        dir = self.choose_csv_directory_generic(title)
        self.csv_import_dir_lineedit.setText(dir)
    #-----------------------------------------------------------------------------------------
    def select_archive_directory(self):
        title = "Choose CSV Archive Directory"
        dir = self.choose_csv_directory_generic(title)
        self.csv_archive_dir_lineedit.setText(dir)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def choose_csv_directory_generic(self,title):
        fd = QFileDialog()
        fd.setFileMode(QFileDialog.Directory)
        fd.setOption(QFileDialog.ShowDirsOnly)
        fd.setParent(None)
        dir = fd.getExistingDirectory(caption=title)
        if fd.accepted:
            return dir
        return None
    #-----------------------------------------------------------------------------------------
    def save_options(self):

        #----------------
        #~ GENERAL OPTIONS:
        #----------------
        if self.checkbox_auto_validate_custom_columns.isChecked():
            self.mytabprefs['ZMI_AUTO_VALIDATE_CUSTOM_COLUMNS_AT_STARTUP'] = unicode("True")
        else:
            self.mytabprefs['ZMI_AUTO_VALIDATE_CUSTOM_COLUMNS_AT_STARTUP'] = unicode("False")

        if self.checkbox_prefer_auto_step_mode.isChecked():
            self.mytabprefs['ZMI_PREFER_AUTO_STEP_MODE'] = unicode("True")
        else:
            self.mytabprefs['ZMI_PREFER_AUTO_STEP_MODE'] = unicode("False")

        n = self.max_file_attachments_to_process_automatically_spinbox.value()
        self.mytabprefs['ZMI_MAXIMUM_FILE_ATTACHMENTS_TO_ADD_AUTOMATICALLY'] = unicode(self.max_file_attachments_to_process_automatically_spinbox.value())

        if self.checkbox_import_html_text_also.isChecked():
            self.mytabprefs['ZMI_CSV_IMPORT_TEXT_ALSO'] = unicode("True")
        else:
            self.mytabprefs['ZMI_CSV_IMPORT_TEXT_ALSO'] = unicode("False")

        if self.checkbox_import_empty_file_attachments.isChecked():
            self.mytabprefs['ZMI_CSV_IMPORT_EMPTY_FILE_ATTACHMENTS'] = unicode("True")
        else:
            self.mytabprefs['ZMI_CSV_IMPORT_EMPTY_FILE_ATTACHMENTS'] = unicode("False")

        if self.checkbox_import_html_as_empty_file_attachments.isChecked():
            self.mytabprefs['ZMI_CSV_IMPORT_HTML_AS_EMPTY_FILE_ATTACHMENTS'] = unicode("True")
        else:
            self.mytabprefs['ZMI_CSV_IMPORT_HTML_AS_EMPTY_FILE_ATTACHMENTS'] = unicode("False")

        if self.checkbox_prefer_auto_tags_as_tags.isChecked():
            self.mytabprefs['ZMI_PREFER_AUTO_TAGS_AS_STANDARD_TAGS'] = unicode("True")
        else:
            self.mytabprefs['ZMI_PREFER_AUTO_TAGS_AS_STANDARD_TAGS'] = unicode("False")

        if self.checkbox_prefer_manual_tags_as_tags.isChecked():
            self.mytabprefs['ZMI_PREFER_MANUAL_TAGS_AS_STANDARD_TAGS'] = unicode("True")
        else:
            self.mytabprefs['ZMI_PREFER_MANUAL_TAGS_AS_STANDARD_TAGS'] = unicode("False")

        #----------------
        #~ AUTO-SELECT CSV OPTIONS:
        #----------------
        if self.checkbox_auto_select_csv_import_directory.isChecked():
            self.mytabprefs['ZMI_AUTO_SELECT_CSV_IMPORT_DIRECTORY'] = unicode("True")
        else:
            self.mytabprefs['ZMI_AUTO_SELECT_CSV_IMPORT_DIRECTORY'] = unicode("False")

        self.mytabprefs['ZMI_CSV_IMPORT_DIRECTORY_TO_USE'] = self.csv_import_dir_lineedit.text()
        self.mytabprefs['ZMI_CSV_ARCHIVE_DIRECTORY_TO_USE'] = self.csv_archive_dir_lineedit.text()

        self.mytabprefs['ZMI_CSV_IMPORT_DIRECTORY_TO_USE']= self.mytabprefs['ZMI_CSV_IMPORT_DIRECTORY_TO_USE'].replace(os.sep, '/')
        self.mytabprefs['ZMI_CSV_ARCHIVE_DIRECTORY_TO_USE']= self.mytabprefs['ZMI_CSV_ARCHIVE_DIRECTORY_TO_USE'].replace(os.sep, '/')

        is_valid = self.validate_directory_path(self.mytabprefs['ZMI_CSV_IMPORT_DIRECTORY_TO_USE'])
        if not is_valid:
            if self.checkbox_auto_select_csv_import_directory.isChecked():
                return error_dialog(self.gui, _('ZMI Options'),_('The specified Import directory is invalid.'), show=True)
            else:
                self.csv_import_dir_lineedit.setText("")
                self.mytabprefs['ZMI_CSV_IMPORT_DIRECTORY_TO_USE'] = unicode("")

        if self.zmi_disposition_archive_radio.isChecked():
            self.mytabprefs['ZMI_CSV_ARCHIVE_ORIGINALS'] = unicode("True")
        else:
            self.mytabprefs['ZMI_CSV_ARCHIVE_ORIGINALS'] = unicode("False")

        is_valid = self.validate_directory_path(self.mytabprefs['ZMI_CSV_ARCHIVE_DIRECTORY_TO_USE'])
        if not is_valid:
            if self.checkbox_auto_select_csv_import_directory.isChecked() and self.zmi_disposition_archive_radio.isChecked():
                return error_dialog(self.gui, _('ZMI Options'),_('The specified Archive directory is invalid.'), show=True)
            else:
                self.csv_archive_dir_lineedit.setText("")
                self.mytabprefs['ZMI_CSV_ARCHIVE_DIRECTORY_TO_USE'] = unicode("")

        if self.checkbox_ignore_max_file_attachments.isChecked():
            self.mytabprefs['ZMI_IGNORE_MAXIMUM_FILE_ATTACHMENTS_TO_AUTO_PROCESS'] = unicode("True")
        else:
            self.mytabprefs['ZMI_IGNORE_MAXIMUM_FILE_ATTACHMENTS_TO_AUTO_PROCESS'] = unicode("False")

        #----------------
        #~ TEMPORARY DIRECTORY OPTIONS:
        #----------------
        if self.zmi_temp_directory_radio1.isChecked():
            self.mytabprefs['ZMI_TEMP_DIRECTORY_SAME_AS_CALIBRE'] = unicode("True")
        else:
            self.mytabprefs['ZMI_TEMP_DIRECTORY_SAME_AS_CALIBRE'] = unicode("False")

        if self.zmi_temp_directory_radio2.isChecked():
            self.mytabprefs['ZMI_TEMP_DIRECTORY_SPECIAL_SET'] = unicode("True")
        else:
            self.mytabprefs['ZMI_TEMP_DIRECTORY_SPECIAL_SET'] = unicode("False")

        self.mytabprefs['ZMI_TEMP_DIRECTORY_SPECIAL_TO_USE'] = self.calibre_temp_dir_lineedit.text()

        if self.zmi_temp_directory_radio3.isChecked():
            self.mytabprefs['ZMI_TEMP_DIRECTORY_USE_TMPDIR'] = unicode("True")
        else:
            self.mytabprefs['ZMI_TEMP_DIRECTORY_USE_TMPDIR'] = unicode("False")

        is_valid = self.validate_directory_path(self.mytabprefs['ZMI_TEMP_DIRECTORY_SPECIAL_TO_USE'])
        if not is_valid:
            if self.zmi_temp_directory_radio2.isChecked():
                return error_dialog(self.gui, _('ZMI Options'),_('The specified temporary directory is invalid.'), show=True)
            else:
                self.calibre_temp_dir_lineedit.setText("")
                self.mytabprefs['ZMI_TEMP_DIRECTORY_SPECIAL_TO_USE'] = unicode("")

        myparentprefs = self.save_all_prefs()

        for k,v in myparentprefs.iteritems():
            self.mytabprefs[k] = v
        #END FOR

        self.save_dialog_geometry()

        self.ui_exit(restart=True)

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def validate(self):
        return True
    #-----------------------------------------------------------------------------------------
    def validate_directory_path(self,path):
        is_valid = False
        if os.path.isdir(path):
            is_valid = True
        return is_valid
    #-----------------------------------------------------------------------------------------
    def return_option_prefs(self,myparentprefs):
        for k,v in self.mytabprefs.iteritems():
            if "ZMI_AUTO" in k:
                myparentprefs[k] = v
            elif "ZMI_PREFER" in k:
                myparentprefs[k] = v
            elif "ZMI_CSV" in k:
                myparentprefs[k] = v
            elif "ZMI_MAXIMUM" in k:
                myparentprefs[k] = v
            elif "ZMI_TEMP_DIRECTORY" in k:
                myparentprefs[k] = v
        #END FOR
        return myparentprefs
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class ZoteroComparisonTab(QWidget):

    def __init__(self,mygui,myguidb,mymainprefs,mysave_all_prefs,myui_exit,mysave_dialog_geometry):
        super(ZoteroComparisonTab, self).__init__()
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.gui = mygui
        #-----------------------------------------------------
        self.guidb = myguidb
        #-----------------------------------------------------
        self.mytabprefs = mymainprefs
        #-----------------------------------------------------
        self.save_all_prefs = mysave_all_prefs
        #-----------------------------------------------------
        self.save_dialog_geometry = mysave_dialog_geometry
        #-----------------------------------------------------
        self.ui_exit = myui_exit
        #-----------------------------------------------------
        self.setToolTip("<p style='white-space:wrap'>This Tab shows you Zotero items that are not in the current Calibre Library.<br><br>Matching books in Calibre have an Identifier of the type 'zcollection' automatically updated with their current matching Zotero collection name.<br><br>If you rename your Zotero collections, then the next time that you execute this comparison, the Calibre Identifiers will be changed to reflect their new name. ")
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)
        #-----------------------------------------------------
        self.layout_top = QVBoxLayout()
        self.layout_top.setSpacing(0)
        self.layout_top.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout_top)
        #-----------------------------------------------------
        self.scroll_area_frame = QScrollArea()
        self.scroll_area_frame.setAlignment(Qt.AlignCenter)
        self.scroll_area_frame.setWidgetResizable(True)
        self.scroll_area_frame.ensureVisible(300,300)

        self.layout_top.addWidget(self.scroll_area_frame)       # the scroll area is now the child of the parent of self.layout_top

        # NOTE: the self.scroll_area_frame.setWidget(self.scroll_widget) is at the end of the init() AFTER all children have been created and assigned to a layout...

        #-----------------------------------------------------
        self.scroll_widget = QWidget()
        self.layout_top.addWidget(self.scroll_widget)           # causes automatic reparenting of QWidget to the parent of self.layout_top, which is:  self .
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setAlignment(Qt.AlignCenter)

        self.scroll_widget.setLayout(self.layout_frame)        # causes automatic reparenting of any widget later added to self.layout_frame to the parent of self.layout_frame, which is:  QWidget .

        #-----------------------------------------------------
        self.zmi_groupbox = QGroupBox('')
        self.zmi_groupbox.setToolTip("<p style='white-space:wrap'>Find Zotero items that do not exist in the current Calibre Library by matching their Zotero item 'key' with Calibre Identifier 'zkey' or 'zkey_file' with the same value.\
                                                          <br><br>The ZMI Options you have chosen regarding 'adding empty books' and 'importing text files' will impact the results of this comparison.\
                                                          <br>")
        self.layout_frame.addWidget(self.zmi_groupbox)

        self.zmi_layout = QVBoxLayout()
        self.zmi_layout.setAlignment(Qt.AlignCenter)
        self.zmi_groupbox.setLayout(self.zmi_layout)

        self.zmi_lineedit_layout = QHBoxLayout()
        self.zmi_lineedit_layout.setAlignment(Qt.AlignCenter)
        self.zmi_layout.addLayout(self.zmi_lineedit_layout)

        self.push_button_select_zotero_database_directory = QPushButton("Zotero DB Directory:")
        self.push_button_select_zotero_database_directory.setMinimumWidth(150)
        self.push_button_select_zotero_database_directory.setMaximumWidth(150)
        self.push_button_select_zotero_database_directory.clicked.connect(self.select_zotero_database_directory)
        self.push_button_select_zotero_database_directory.setDefault(False)
        self.push_button_select_zotero_database_directory.setFont(font)
        self.push_button_select_zotero_database_directory.setToolTip("<p style='white-space:wrap'>Select the directory where Zotero keeps its database.<br><br>Caution: You must close any Zotero software, including the browser that supports the Zotero add-on, before executing this Comparison.  Otherwise, the comparison process will 'hang' waiting for Zotero to release its lock on its database. ")
        self.zmi_lineedit_layout.addWidget(self.push_button_select_zotero_database_directory)

        self.zotero_database_dir_lineedit = QLineEdit(self)
        self.zotero_database_dir_lineedit.setMinimumWidth(350)
        self.zotero_database_dir_lineedit.setMaximumWidth(350)
        self.zotero_database_dir_lineedit.setText(self.mytabprefs['ZMI_ZOTERO_DATABASE_DIRECTORY'])
        self.zotero_database_dir_lineedit.setToolTip("<p style='white-space:wrap'>This is the directory where Zotero keeps its database")
        self.zmi_lineedit_layout.addWidget(self.zotero_database_dir_lineedit)

        self.zotero_db_path = self.zotero_database_dir_lineedit.text()

        self.zmi_combobox_layout = QHBoxLayout()
        self.zmi_combobox_layout.setAlignment(Qt.AlignCenter)
        self.zmi_layout.addLayout(self.zmi_combobox_layout)

        self.push_button_get_zotero_database_data = QPushButton("Zotero Collection:")
        self.push_button_get_zotero_database_data.setMinimumWidth(150)
        self.push_button_get_zotero_database_data.setMaximumWidth(150)
        self.push_button_get_zotero_database_data.clicked.connect(self.get_zotero_collections)
        self.push_button_get_zotero_database_data.setDefault(False)
        self.push_button_get_zotero_database_data.setFont(font)
        self.push_button_get_zotero_database_data.setToolTip("<p style='white-space:wrap'>Select the directory where Zotero keeps its database.<br><br>Caution: You must close any Zotero software, including the browser that supports the Zotero add-on, before executing this Comparison.  Otherwise, the comparison process will 'hang' waiting for Zotero to release its lock on its database. ")
        self.zmi_combobox_layout.addWidget(self.push_button_get_zotero_database_data)

        self.zotero_collections_combobox = QComboBox()
        self.zotero_collections_combobox.setMinimumWidth(350)
        self.zotero_collections_combobox.setMaximumWidth(350)
        self.zotero_collections_combobox.setEditable(False)
        self.zotero_collections_combobox.setFont(font)
        self.zotero_collections_combobox.setToolTip("<p style='white-space:wrap'>Select the Zotero Collection that you wish to compare to the current Calibre Library.<br>")
        self.zmi_combobox_layout.addWidget(self.zotero_collections_combobox)

        self.zmi_compare_button_layout = QHBoxLayout()
        self.zmi_compare_button_layout.setAlignment(Qt.AlignCenter)
        self.zmi_layout.addLayout(self.zmi_compare_button_layout)

        self.push_button_compare_zotero_database_data = QPushButton("Compare Zotero Collection Items to Calibre Books")
        self.push_button_compare_zotero_database_data.clicked.connect(self.compare_zotero_selected_collection_to_calibre)
        self.push_button_compare_zotero_database_data.setDefault(False)
        self.push_button_compare_zotero_database_data.setFont(font)
        self.push_button_compare_zotero_database_data.setToolTip("<p style='white-space:wrap'>Compare the Zotero Collection's item 'keys' to all of the Calibre values for Identifiers 'zkey' and 'zkey_file'.<br><br>Matching books in Calibre have an Identifier of the type 'zcollection' automatically updated with their current matching Zotero collection name.<br><br>If you rename your Zotero collections, then the next time that you execute this comparison, the Calibre Identifiers will be changed to reflect their new name.<br><br>Caution: You must close any Zotero software, including the browser that supports the Zotero add-on, before executing this Comparison.  Otherwise, the comparison process will 'hang' waiting for Zotero to release its lock on its database. ")
        self.zmi_compare_button_layout.addWidget(self.push_button_compare_zotero_database_data)

        self.zmi_qtextedit =  QTextEdit("")
        self.zmi_qtextedit.setMinimumHeight(500)
        self.zmi_qtextedit.setAcceptRichText(True)
        self.zmi_qtextedit.setReadOnly(True)
        self.zmi_qtextedit.setFont(font)
        self.zmi_qtextedit.setWordWrapMode(QTextOption.WordWrap)
        self.zmi_qtextedit.clear()

        s_text = ""

        self.zmi_qtextedit.setPlainText(s_text)

        self.zmi_layout.addWidget(self.zmi_qtextedit)

        self.zmi_qtextedit.setToolTip("<p style='white-space:wrap'>To save this list, 'Right Click' > 'Select All' > 'Copy' to the clipboard. \
                                                        <br><br>Note[1]: The ZMI Options you have chosen regarding 'adding empty books' and 'importing text files' will impact the results of this comparison.\
                                                        <br><br>Note[2]: File Attachments in Zotero that have a content type/file extension that Calibre cannot or will not import will impact the results of this comparison. \
                                                        <br><br>Note[3]: The exported .csv file from Zotero may not have all of the items that you expected it to have.  Try exporting at the Zotero Library level rather than at the Collection level.  This commonly resolves most missing items.\
                                                        <br><br>")


    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
        self.push_button_exit = QPushButton("Exit ZMI")
        self.push_button_exit.clicked.connect(self.compare_ui_exit)
        self.push_button_exit.setDefault(True)
        self.push_button_exit.setFont(font)
        self.push_button_exit.setToolTip("<p style='white-space:wrap'>Save the current geometry of this window, then exit from ZMI.")
        self.zmi_layout.addWidget(self.push_button_exit)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
        #-----------------------------------------------------
        self.scroll_widget.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.setWidget(self.scroll_widget)    # now that all widgets have been created and assigned to a layout...
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.good_to_continue = False

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def select_zotero_database_directory(self):
        title = "Choose Zotero Data Directory"
        dir = self.choose_directory_generic(title)
        if not dir:
            return
        self.zotero_database_dir_lineedit.setText(dir)
    #-----------------------------------------------------------------------------------------
    def choose_directory_generic(self,title):
        fd = QFileDialog()
        fd.setFileMode(QFileDialog.Directory)
        fd.setOption(QFileDialog.ShowDirsOnly)
        fd.setParent(None)
        dir = fd.getExistingDirectory(caption=title)
        if fd.accepted:
            return dir
        return None
    #-----------------------------------------------------------------------------------------
    def validate_directory_path(self,path):
        is_valid = False
        if os.path.isdir(path):
            is_valid = True
        return is_valid
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def save_choices(self):

        self.mytabprefs['ZMI_ZOTERO_DATABASE_DIRECTORY'] = self.zotero_database_dir_lineedit.text()
        is_valid = self.validate_directory_path(self.mytabprefs['ZMI_ZOTERO_DATABASE_DIRECTORY'])
        if not is_valid:
            self.good_to_continue = False
            return error_dialog(self.gui, _('ZMI Options'),_('The specified Zotero Database Directory is invalid.'), show=True)

        prefs['ZMI_ZOTERO_DATABASE_DIRECTORY'] = self.zotero_database_dir_lineedit.text()
        prefs

        self.zotero_db_path = self.zotero_database_dir_lineedit.text()

    #-----------------------------------------------------------------------------------------
    def validate(self):
        return True
    #-----------------------------------------------------------------------------------------
    def get_zotero_collections(self):

        self.mytabprefs['ZMI_ZOTERO_DATABASE_DIRECTORY'] = self.zotero_database_dir_lineedit.text()
        is_valid = self.validate_directory_path(self.mytabprefs['ZMI_ZOTERO_DATABASE_DIRECTORY'])
        if not is_valid:
            self.good_to_continue = False
            return error_dialog(self.gui, _('ZMI Options'),_('The specified Zotero Database Directory is invalid.'), show=True)

        prefs['ZMI_ZOTERO_DATABASE_DIRECTORY'] = self.zotero_database_dir_lineedit.text()
        prefs

        self.zotero_db_path = self.zotero_database_dir_lineedit.text()

        my_db,my_cursor,is_valid = self.apsw_connect_to_zotero()
        if not is_valid:
            self.good_to_continue = False
            error_dialog(self.gui, _('Connect to Zotero Database'),_('Database Connection Error.  Close Zotero Software then Retry.'), show=True)
            return

        self.drop_zotero_zmi_views(my_db,my_cursor)  # obsolete...zmi views no longer used...

        try:
            del self.zotero_collections_list
            del self.collection_id_dict
            del self.calibre_book_zkey_dict
            del self.calibre_book_zkey_file_dict
            del self.calibre_book_collection_dict
            del self.zotero_key_collectionname_dict
            del self.zotero_collection_item_dict
            del self.zotero_item_title_dict
        except:
            pass

        self.zotero_collections_list = []      # all collections in Zotero
        self.collection_id_dict = {}             # [collectionName] = collectionID

        self.zotero_collections_combobox.clear()

        mysql = "SELECT collectionID, collectionName, parentCollectionID, libraryID FROM collections "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        my_db.close()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            collectionID, collectionName, parentCollectionID, libraryID = row
            self.zotero_collections_combobox.addItem(collectionName)
            self.zotero_collections_list.append(row)
            self.collection_id_dict[collectionName] = collectionID
        #END FOR
        del tmp_rows
        self.zotero_collections_combobox.setMaxVisibleItems(len(self.zotero_collections_list))
        self.update()
        if len(self.zotero_collections_list) > 0:
            self.good_to_continue = True
        else:
            self.good_to_continue = False
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def compare_zotero_selected_collection_to_calibre(self):

        if not self.good_to_continue:
            return

        self.collection = self.zotero_collections_combobox.currentText()

        if not self.collection in self.collection_id_dict:
            self.good_to_continue = False
            return

        self.get_zotero_data()

        if not self.good_to_continue:
            return

        self.get_calibre_data()

        self.update_calibre_collection_identifier()

        self.find_missing_keys()

        self.list_missing_keys()

    #-----------------------------------------------------------------------------------------
    def get_zotero_data(self):
        my_db,my_cursor,is_valid = self.apsw_connect_to_zotero()
        if not is_valid:
            self.good_to_continue = False
            error_dialog(self.gui, _('Connect to Zotero Database'),_('Database Connection Error.  Close Zotero Software, including Firefox itself, then Retry.'), show=True)
            return

        self.get_zotero_database_data(my_db,my_cursor)

        my_db.close()
    #-----------------------------------------------------------------------------------------
    def get_calibre_data(self):
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            self.good_to_continue = False
            error_dialog(self.gui, _('Connect to Calibre Current Library'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        self.get_calibre_identifiers(my_db,my_cursor)

        my_db.close()
    #-----------------------------------------------------------------------------------------
    def get_calibre_identifiers(self,my_db,my_cursor):
        self.calibre_book_zkey_dict = {}           # [book] = zkey
        self.calibre_book_zkey_file_dict = {}     # [book] = zkey_file
        self.calibre_zkeys_list = []

        mysql = "SELECT book,val FROM identifiers WHERE type = 'zkey' "  # same as zkey_file for non-file attachments...
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            book,val = row
            self.calibre_book_zkey_dict[book] = val
            self.calibre_zkeys_list.append(val)
        #END FOR
        del tmp_rows

        mysql = "SELECT book,val FROM identifiers WHERE type = 'zkey_file' "  # different than zkey for file attachments...so this supercedes zkey if book has 2 different values...
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            book,val = row
            self.calibre_book_zkey_file_dict[book] = val
            self.calibre_zkeys_list.append(val)
        #END FOR
        del tmp_rows

        self.calibre_zkeys_set = set(self.calibre_zkeys_list)  # no duplicates...
        del self.calibre_zkeys_list
    #-----------------------------------------------------------------------------------------
    def update_calibre_collection_identifier(self):

        #~ self.calibre_book_zkey_dict                           [book] = key
        #~ self.zotero_key_collectionname_dict            [key] = collectionName

        self.calibre_book_collection_dict = {}                #[book] = collectionName

        for book,key in self.calibre_book_zkey_dict.iteritems():
            if key in self.zotero_key_collectionname_dict:
                collectionName = self.zotero_key_collectionname_dict[key]
                self.calibre_book_collection_dict[book] = collectionName
        #END FOR
        for book,key in self.calibre_book_zkey_file_dict.iteritems():
            if key in self.zotero_key_collectionname_dict:
                collectionName = self.zotero_key_collectionname_dict[key]
                self.calibre_book_collection_dict[book] = collectionName
        #END FOR

        #~ if DEBUG: print("number of books in self.calibre_book_collection_dict: ", str(len(self.calibre_book_collection_dict)))

        if len(self.calibre_book_collection_dict) == 0:
            return

        books_list = []

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            self.good_to_continue = False
            error_dialog(self.gui, _('Connect to Calibre Current Library'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        my_cursor.execute("begin")
        mysql = "INSERT OR REPLACE INTO identifiers (id,book,type,val) VALUES (null,?,'zcollection',?) "
        for book,collection in self.calibre_book_collection_dict.iteritems():
            if collection > " ":
                my_cursor.execute(mysql,(book,collection))
                books_list.append(book)
                #~ if DEBUG: print("Calibre book updated for identifier zcollection: ", str(book), "  ", collection)
        #END FOR
        my_cursor.execute("commit")

        my_db.close()

        self.force_refresh_of_cache(books_list)

        del books_list
    #-----------------------------------------------------------------------------------------
    def find_missing_keys(self):

        self.missing_keys_list = []

        for zkey,collectionname in self.zotero_key_collectionname_dict.iteritems():      # only has current specified collection
             if not zkey in self.calibre_zkeys_set:   # all zkeys in calibre; not just for those in current collection...
                self.missing_keys_list.append(zkey)
        #END FOR
        self.missing_keys_list = list(set(self.missing_keys_list))
        self.missing_keys_list.sort()

    #-----------------------------------------------------------------------------------------
    def list_missing_keys(self):

        n_total_zotero_items = len(self.zotero_key_collectionname_dict)                      # only has zotero current collection data
        n_total_calibre_keys = len(self.calibre_book_collection_dict)                              # only has calibre keys currently existing in the currently selected collection

        n_missing = n_total_zotero_items - n_total_calibre_keys
        n_target_missing = n_missing

        s_text =  "\nTotal Collection items in Zotero: \t" + str(n_total_zotero_items) + "\n"
        s_text = s_text + "Total Collection items in Calibre: \t" + str(n_total_calibre_keys) + "\n\n"

        #~ self.zotero_collection_item_dict = {}             #key = row = collectionname,collectionid,itemid,key,typename,path,contenttype

        for zkey in self.missing_keys_list:
            if zkey in self.zotero_collection_item_dict:      # only has zotero current specified collection data
                row = self.zotero_collection_item_dict[zkey]
                collectionname,collectionid,itemid,key,typename,path,contenttype = row
                title = self.zotero_item_title_dict[itemid]
                s_text = s_text + "Key: " + key + "\t type: " + typename + "\t  title:  " + title +  "\t content: " + str(contenttype) + "\t path: "  + str(path) + "\n\n"
                n_missing = n_missing - 1
            else:
                s_text = s_text + "Erroneous Missing key: " + key + "\n\n"
        #END FOR

        if n_missing <> 0:
            s_text = s_text + "\n\nExpected differences are not equal to the actual differences listed above due to complexities of Zotero that this comparison is unable to unwind." + "\n\n"
        else:
            if n_target_missing <> 0:
                s_text = s_text + "\n\nExpected differences are equal to the actual differences listed above." + "\n\n"
            else:
                 s_text = s_text + "\n\nNo differences were found." + "\n\n"


        self.zmi_qtextedit.setPlainText(s_text)
        self.update()
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def get_zotero_database_data(self,my_db,my_cursor):
        #~ get everything to be known about *every* zotero item in the selected collectionID

        collectionID = self.collection_id_dict[self.collection]         # self.collection is the selected combobox value...

        self.zotero_collection_item_dict = {}                 #key = row = collectionname,collectionid,itemid,key,typename,path,contenttype
        self.zotero_key_collectionname_dict = {}          #key = collectionname
        self.zotero_itemids_list = []

        mysql = "SELECT \
                       (SELECT collectionName FROM collections WHERE collectionID = collectionItems.collectionID) AS collectionName, \
                       collectionID, itemID, \
                        (SELECT key FROM items WHERE itemID = collectionItems.itemID) AS key, \
                        (SELECT typeName FROM itemTypes WHERE itemTypeID = (SELECT itemTypeID FROM items WHERE itemID = collectionItems.itemID)) AS typeName \
                        FROM collectionItems WHERE collectionID = ?"
        my_cursor.execute(mysql,([collectionID]))
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            collectionname,collectionid,itemid,key,typename = row
            contenttype, path, valid_version = self.get_path_if_exists(my_db,my_cursor,itemid)
            if not valid_version:
                self.good_to_continue = False
                return error_dialog(self.gui, _('Zotero Not 5.0+'),_('Database error because you are not using Zotero 5.0+.  Please upgrade to use the ZMI Comparison Tab.  Sorry.'), show=True)
            self.zotero_collection_item_dict[key] = collectionname,collectionid,itemid,key,typename,path,contenttype
            self.zotero_key_collectionname_dict[key] = collectionname
            self.zotero_itemids_list.append(itemid)
            #~ if DEBUG: print(str(self.zotero_collection_item_dict[key]))
        #END FOR
        del tmp_rows

        self.title_fieldID = 110  #default

        mysql = "SELECT fieldID,fieldName from fields WHERE fieldName = 'title' "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            fieldID,fieldName = row
            self.title_fieldID = fieldID
        #END FOR
        del tmp_rows

        self.zotero_item_title_dict = {}   #itemID = title

        mysql = "SELECT itemID, fieldID, (SELECT value  FROM itemDataValues WHERE valueID = itemData.valueID) AS title \
                        FROM itemData WHERE itemData.fieldID = ? AND itemID = ?"
        for itemid in self.zotero_itemids_list:
            my_cursor.execute(mysql,(self.title_fieldID,itemid))
            tmp_rows = my_cursor.fetchall()
            if not tmp_rows:
                tmp_rows = []
                self.zotero_item_title_dict[itemid] = "....title not found...."
            for row in tmp_rows:
                itemID,fieldID,title = row
                self.zotero_item_title_dict[itemid] = title
                #~ if DEBUG: print("title: ", title)
            #END FOR
            del tmp_rows
        #END FOR

    #-----------------------------------------------------------------------------------------
    def get_path_if_exists(self,my_db,my_cursor,itemid):
        path = None
        contenttype = None
        valid_version = True
        mysql = "SELECT contentType, path FROM itemAttachments WHERE itemID = ? "
        try:
            my_cursor.execute(mysql,([itemid]))
        except:    # Zotero 5 renamed mimeType to contentType in the itemAttachments table...
            valid_version = False
            return contenttype, path, valid_version
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        for row in tmp_rows:
            contenttype, path = row
            path = path.replace("storage:", "")
            path = str(path.strip())
        #END FOR
        return contenttype, path, valid_version
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def force_refresh_of_cache(self,books_list):
        backend = self.gui.library_view.model().db.backend
        mydbcache = dbcache(self.gui.library_view.model().db.backend)
        mydbcache.init()
        self.gui.library_view.model().refresh_ids(books_list)
        self.gui.tags_view.recount()
        self.gui.update()
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def apsw_connect_to_zotero(self):

        self.zotero_db_path = self.zotero_db_path.replace(os.sep, '/')
        if isbytestring(self.zotero_db_path):
            self.zotero_db_path = self.zotero_db_path.decode(filesystem_encoding)

        path = os.path.join(self.zotero_db_path, 'zotero.sqlite')
        path = path.replace(os.sep, '/')

        if isbytestring(path):
            path = path.decode(filesystem_encoding)

        try:
            my_db =apsw.Connection(path)
            is_valid = True
        except Exception as e:
            if DEBUG: print("path to Zotero database is: ", path)
            if DEBUG: print("error: ", str(e))
            is_valid = False
            return None,None,is_valid

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        return my_db,my_cursor,is_valid
    #-----------------------------------------------------------------------------------------
    def apsw_connect_to_library(self):

        my_db = self.gui.library_view.model().db

        self.lib_path = my_db.library_path
        self.lib_path = self.lib_path.replace(os.sep, '/')
        if isbytestring(self.lib_path):
            self.lib_path = self.lib_path.decode(filesystem_encoding)

        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        if isbytestring(path):
            path = path.decode(filesystem_encoding)

        if path.endswith("/"):
            path = path[0:-1]

        if path.count("metadata.db") == 0:
            path = path + "/metadata.db"

        try:
            my_db =apsw.Connection(path)
            is_valid = True
        except Exception as e:
            if DEBUG: print("path to metadata.db is: ", path)
            if DEBUG: print("error: ", str(e))
            is_valid = False
            return None,None,is_valid

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        return my_db,my_cursor,is_valid
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def drop_zotero_zmi_views(self,my_db,my_cursor):

        my_cursor.execute("begin")
        my_cursor.execute("DROP VIEW IF EXISTS zmi_view_0")      #obsolete
        my_cursor.execute("DROP VIEW IF EXISTS zmi_view_10")    #obsolete
        my_cursor.execute("DROP VIEW IF EXISTS zmi_view_20")    #obsolete
        my_cursor.execute("DROP VIEW IF EXISTS zmi_view_30")    #obsolete
        my_cursor.execute("commit")

    #-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
    def compare_ui_exit(self):
        self.save_dialog_geometry()
        self.ui_exit()
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class ZoteroMetadataExporterTab(QWidget):

    def __init__(self,mygui,myguidb,mymainprefs,mysave_all_prefs,myui_exit,mysave_dialog_geometry,myapsw_connect_to_library):
        super(ZoteroMetadataExporterTab, self).__init__()
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.gui = mygui
        #-----------------------------------------------------
        self.guidb = myguidb
        #-----------------------------------------------------
        self.mytabprefs = mymainprefs
        #-----------------------------------------------------
        self.save_all_prefs = mysave_all_prefs
        #-----------------------------------------------------
        self.save_dialog_geometry = mysave_dialog_geometry
        #-----------------------------------------------------
        self.ui_exit = myui_exit
        #-----------------------------------------------------
        self.apsw_connect_to_library = myapsw_connect_to_library
        #-----------------------------------------------------
        self.setToolTip("<p style='white-space:wrap'>This Tab exports an RIS file for selected books and for selected Calibre metadata that is (mostly) user-defined.  The RIS file may be imported by Zotero.")
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)
        #-----------------------------------------------------
        self.layout_top = QVBoxLayout()
        self.layout_top.setSpacing(0)
        self.layout_top.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout_top)
        #-----------------------------------------------------
        self.scroll_area_frame = QScrollArea()
        self.scroll_area_frame.setAlignment(Qt.AlignCenter)
        self.scroll_area_frame.setWidgetResizable(True)
        self.scroll_area_frame.ensureVisible(300,300)

        self.layout_top.addWidget(self.scroll_area_frame)       # the scroll area is now the child of the parent of self.layout_top

        # NOTE: the self.scroll_area_frame.setWidget(self.scroll_widget) is at the end of the init() AFTER all children have been created and assigned to a layout...

        #-----------------------------------------------------
        self.scroll_widget = QWidget()
        self.layout_top.addWidget(self.scroll_widget)           # causes automatic reparenting of QWidget to the parent of self.layout_top, which is:  self .
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setAlignment(Qt.AlignCenter)

        self.scroll_widget.setLayout(self.layout_frame)        # causes automatic reparenting of any widget later added to self.layout_frame to the parent of self.layout_frame, which is:  QWidget .

        #-----------------------------------------------------
        self.zmi_groupbox = QGroupBox('')
        self.zmi_groupbox.setToolTip("<p style='white-space:wrap'>RIS is a simple plain-text reference format. It is nearly universally supported by reference management software and journal databases.\
                                                          See 'https://en.wikipedia.org/wiki/RIS_(file_format)' for more information.\
                                                          For basic Zotero mappings from RIS to Zotero, see 'https://www.zotero.org/support/kb/field_mappings'. \
                                                          <br><br>Zotero developers decide how to map RIS file 'tags' to Zotero.  Issues with how Zotero maps RIS tags should be addressed directly by you to Zotero Support \
                                                          at 'www.zotero.org/support'.  ZMI is a Calibre plug-in, not a Zotero plug-in or 'import translator'.\
                                                           <br><br>The default Calibre Source values delivered by ZMI <b>must be changed by you</b> as you see appropriate.  However, a few cannot be edited to guarantee the integrity of the RIS file format.\
                                                           <br><br>Any desired literal (constant) values that you wish may be used instead of 'template' values, such as {title}, {comments} or {#pages}.  Any Custom Column template may be specified using its search name within brackets (e.g. {#genre}). \
                                                           Any Standard Column may be specified in the same way (e.g. '{publisher}'). There is a special template for Today's Date: {today}. Any RIS tag description with '(;)' means that multiple values may be specified if they are separated with a semi-colon, ';'.\
                                                           <br><br>Literal (constant) values may be placed in front of a template if it is followed by a colon, ':'.  Multiple templates with or without literals may be used if separated with a '/'. \
                                                           <br><br>Example: Dewey Decimal Code:{#ddc}\
                                                           <br>Example: DDC:{#ddc}/LCC:{#lcc}/LCEAD:{#lcead}\
                                                           <br>Example: {#ddc}/{#lcc}/{#lcead} \
                                                           <br>Example: OCLC_OWI:{identifiers:oclc_owi}\
                                                           <br>Example: ABCH:{#abc_hierarchy}\
                                                           <br>Example: {#abc_hierarchy}\
                                                           <br><br>If invalid syntax is encountered, an error message will be included in the output .ris export file, and a Calibre Error message will appear telling you so. \
                                                           <br><br>Helpful note:  ensure that templates use only brackets '{}', and never parentheses '()'.  Otherwise, the output will be blank.  ")
        self.layout_frame.addWidget(self.zmi_groupbox)

        self.zmi_layout = QVBoxLayout()
        self.zmi_layout.setAlignment(Qt.AlignCenter)
        self.zmi_groupbox.setLayout(self.zmi_layout)

        #--------------------------------------------------
        #-----------------------------------------------------
        ris_assignments_list,ris_assignments_dict = self.get_ris_assignments()

        self.n_ris_rows = len(ris_assignments_list)
        #-----------------------------------------------------
        column_label_list = []
        column_label_list.append("RIS Tag")
        column_label_list.append("Zotero Field Name")
        column_label_list.append("Calibre Source")

        self.n_total_cols = 3
        #-----------------------------------------------------

        self.ristable = QTableWidget(self.n_ris_rows,self.n_total_cols)

        self.ristable.setSortingEnabled(False)

        self.ristable.setHorizontalHeaderLabels(column_label_list)

        self.ristable.setColumnWidth(0, 65)
        self.ristable.setColumnWidth(1, 150)
        self.ristable.setColumnWidth(2, 250)

        self.ristable.clearContents()
        #--------------------------------------------------


        myflags = Qt.ItemFlags()
        myflags != Qt.ItemIsEnabled  # not enabled; read-only

        r = int(0)
        for row in ris_assignments_list:
            try:
                #~ if DEBUG: print(str(row))
                #---------------------------
                #---------------------------
                tag,name = row
                item = ris_assignments_dict[tag]

                ris_tag,ris_name,calibre_source = item

                ris_tag = ris_tag.upper()
                ris_tag = str(ris_tag)
                ris_name = str(ris_name)

                #---------------------------
                #---------------------------
                ris_tag_ = QTableWidgetItem(ris_tag)
                ris_tag_.setFlags(myflags)                    # not enabled; read-only
                ris_name_ = QTableWidgetItem(ris_name)
                ris_name_.setFlags(myflags)                # not enabled; read-only
                calibre_source_ = QTableWidgetItem(calibre_source)
                if ris_tag in self.tags_to_disallow_edits_list:
                    calibre_source_.setFlags(myflags)    # not enabled; read-only

                #---------------------------
                #---------------------------
                self.ristable.setItem(r,0,ris_tag_)
                self.ristable.setItem(r,1,ris_name_)
                self.ristable.setItem(r,2,calibre_source_)

                #--------------------------------------
                r = r + 1
                #--------------------------------------
            except Exception as e:
                if DEBUG: print("Exception>>>>", str(e))
                return
        #END FOR

        self.n_total_rows = int(r)

        self.zmi_layout.addWidget(self.ristable)

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
        self.push_button_save_options = QPushButton("Save RIS Export Configuration")
        self.push_button_save_options.clicked.connect(self.save_preferences)
        self.push_button_save_options.setDefault(True)
        self.push_button_save_options.setFont(font)
        self.push_button_save_options.setToolTip("<p style='white-space:wrap'>Save the current RIS export configuration that you have customized.")
        self.zmi_layout.addWidget(self.push_button_save_options)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
        self.push_button_export = QPushButton("Export RIS File [Selected Books]")
        self.push_button_export.clicked.connect(self.export_ris_file)
        self.push_button_export.setDefault(False)
        self.push_button_export.setFont(font)
        self.push_button_export.setToolTip("<p style='white-space:wrap'>Save the current configuration and export an RIS formatted file for import into Zotero.\
                                                                    <br><br>RIS is a simple plain-text reference format. It is nearly universally supported by reference management software and journal databases.")
        self.zmi_layout.addWidget(self.push_button_export)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
        #-----------------------------------------------------
        self.scroll_widget.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.setWidget(self.scroll_widget)    # now that all widgets have been created and assigned to a layout...
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        from calibre.gui2.ui import get_gui
        self.maingui = get_gui()
        del get_gui

        self.selected_books_list = []

        self.export_last_file_path = None
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def get_ris_assignments(self):
        ris_assignments_list = self.build_ris_assignments_list()
        ris_assignments_dict = self.build_ris_assignments_dict(ris_assignments_list)
        return ris_assignments_list,ris_assignments_dict
    #-----------------------------------------------------------------------------------------
    def build_ris_assignments_list(self):
        ris_assignments_list = []
        self.tags_to_disallow_edits_list = []
        self.tags_to_semicolon_explode_list = []

        row = "TY","Type of reference"
        self.tags_to_disallow_edits_list.append("TY")
        ris_assignments_list.append(row)
        row = "AU","creators/author"
        self.tags_to_disallow_edits_list.append("AU")
        self.tags_to_semicolon_explode_list.append("AU")
        ris_assignments_list.append(row)
        row = "A2","creators/seriesEditor (;)"     # (each author on its own line preceded by the tag)
        self.tags_to_semicolon_explode_list.append("A2")
        ris_assignments_list.append(row)
        row = "A3","creators/editor (;)"            # (each author on its own line preceded by the tag)
        self.tags_to_semicolon_explode_list.append("A3")
        ris_assignments_list.append(row)
        row = "A4","creators/translator (;)"        # (each author on its own line preceded by the tag)
        self.tags_to_semicolon_explode_list.append("A4")
        ris_assignments_list.append(row)
        row = "AB","abstractNote"
        ris_assignments_list.append(row)
        row = "AV","archiveLocation"
        ris_assignments_list.append(row)
        row = "CN","callNumber"
        ris_assignments_list.append(row)
        row = "CR","rights"
        ris_assignments_list.append(row)
        row = "CY","place"
        ris_assignments_list.append(row)
        row = "DA","date"       # (YYYY-MM-DD)  published date
        self.tags_to_disallow_edits_list.append("DA")
        ris_assignments_list.append(row)
        row = "DB","archive"
        ris_assignments_list.append(row)
        row = "DP","libraryCatalog"
        ris_assignments_list.append(row)
        row = "ET","edition"
        ris_assignments_list.append(row)
        row = "KW","tags (;)"
        self.tags_to_semicolon_explode_list.append("KW")
        ris_assignments_list.append(row)
        row = "LA","language"
        self.tags_to_disallow_edits_list.append("LA")
        ris_assignments_list.append(row)
        row = "L1","PDF filePath"         #special functionality in Zotero for L1 if a .pdf file; see build_book_record()
        self.tags_to_disallow_edits_list.append("L1")
        ris_assignments_list.append(row)
        row = "M1","seriesNumber"
        ris_assignments_list.append(row)
        row = "M2","extra"
        ris_assignments_list.append(row)
        row = "N1","notes"
        self.tags_to_disallow_edits_list.append("N1")
        ris_assignments_list.append(row)
        row = "N2","abstractNote"
        ris_assignments_list.append(row)
        row = "NV","numberOfVolumes"
        ris_assignments_list.append(row)
        row = "PB","publisher"
        self.tags_to_disallow_edits_list.append("PB")
        ris_assignments_list.append(row)
        row = "R0","note (additional)"   #changed to RN upon export; each RN line becomes its own "note" in Zotero...
        ris_assignments_list.append(row)
        row = "R1","note (additional)"   #changed to RN upon export; each RN line becomes its own "note" in Zotero...
        ris_assignments_list.append(row)
        row = "R2","note (additional)"   #changed to RN upon export; each RN line becomes its own "note" in Zotero...
        ris_assignments_list.append(row)
        row = "R3","note (additional)"   #changed to RN upon export; each RN line becomes its own "note" in Zotero...
        ris_assignments_list.append(row)
        row = "R4","note (additional)"   #changed to RN upon export; each RN line becomes its own "note" in Zotero...
        ris_assignments_list.append(row)
        row = "R5","note (additional)"   #changed to RN upon export; each RN line becomes its own "note" in Zotero...
        ris_assignments_list.append(row)
        row = "R6","note (additional)"   #changed to RN upon export; each RN line becomes its own "note" in Zotero...
        ris_assignments_list.append(row)
        row = "R7","note (additional)"   #changed to RN upon export; each RN line becomes its own "note" in Zotero...
        ris_assignments_list.append(row)
        row = "R8","note (additional)"   #changed to RN upon export; each RN line becomes its own "note" in Zotero...
        ris_assignments_list.append(row)
        row = "R9","note (additional)"   #changed to RN upon export; each RN line becomes its own "note" in Zotero...
        ris_assignments_list.append(row)
        row = "SN","ISBN"
        self.tags_to_disallow_edits_list.append("SN")
        ris_assignments_list.append(row)
        row = "SP","numPages"
        ris_assignments_list.append(row)
        row = "ST","shortTitle"
        ris_assignments_list.append(row)
        row = "T1","title"
        self.tags_to_disallow_edits_list.append("T1")
        ris_assignments_list.append(row)
        row = "T2","series"
        ris_assignments_list.append(row)
        row = "UR","url"
        ris_assignments_list.append(row)
        row = "VL","volume"
        ris_assignments_list.append(row)
        row = "Y2","accessDate"
        ris_assignments_list.append(row)
        row = "ER","End of Reference"
        self.tags_to_disallow_edits_list.append("ER")
        ris_assignments_list.append(row)


        return ris_assignments_list
    #-----------------------------------------------------------------------------------------
    def build_ris_assignments_dict(self,ris_assignments_list):

        ris_assignments_dict = {}

        for row in ris_assignments_list:
            tag,name = row
            calibre_source = self.get_calibre_source(tag)
            ris_assignments_dict[tag] = tag,name,calibre_source
        #END FOR

        del ris_assignments_list

        return ris_assignments_dict
    #-----------------------------------------------------------------------------------------
    def get_calibre_source(self,tag):

        if len(tag) <> 2:
            return "ERROR in tag length"

        default = None

        if tag == "AU":
            default = "{authors}"
        elif tag == "DA":
            default = "{pubdate}"
        elif tag == "DB":
            default = "Calibre"
        elif tag == "KW":
            default = "{tags}"
        elif tag == "LA":
            default = "{language}"
        elif tag == "L1":
            default = "{path}"
        elif tag == "M1":
            default = "{series_index}"
        elif tag == "M2":
            default = "{path}"
        elif tag == "N1":
            default = "{comments}"
        elif tag == "PB":
            default = "{publisher}"
        elif tag == "PY":
            default = "{pubdate}"
        elif tag == "RI":
            default = None
        elif tag == "SN":
            default = "{identifiers:isbn}"
        elif tag == "SP":
            default = "{#pages}"
        elif tag == "T1":
            default = "{title}"
        elif tag == "T2":
            default = "{series}"
        elif tag == "TY":
            default = "BOOK"
        elif tag == "Y2":
            default = "{date}"
        else:
            pass

        if default is None:
            default = ""

        source = default

        #~ testing only.......reset prefs.........
        #~ if tag in self.mytabprefs:
            #~ del self.mytabprefs[tag]

        if not tag in self.mytabprefs:
            self.mytabprefs[tag] = source
        else:
            source = self.mytabprefs[tag]

        return source
    #-----------------------------------------------------------------------------------------
    def save_preferences(self):

        for r in xrange(0, self.n_total_rows):
            tag = self.ristable.item(r,0).text()
            source = self.ristable.item(r,2).text()
            if "{identifier:" in source:   #user error; easily corrected here...
                source = source.replace("{identifier:","{identifiers:")
            self.mytabprefs[tag] = source
        #END FOR

        myparentprefs = self.save_all_prefs()

        for k,v in myparentprefs.iteritems():
            self.mytabprefs[k] = v
        #END FOR

        self.ui_exit(restart=True)
    #-----------------------------------------------------------------------------------------
    def return_export_prefs(self,myparentprefs):
        for k,v in self.mytabprefs.iteritems():
            if len(k) == 2:  #only touch prefs for this tab...
                if isinstance(k,str):
                    k = unicode(k)
                myparentprefs[k] = v
                #~ if DEBUG: print("parent prefs updated: ", k, str(v))
        #END FOR

        if self.export_last_file_path is not None:
            myparentprefs['RIS_EXPORT_FILE_LAST_SELECTED_PATH'] = self.export_last_file_path
            self.mytabprefs['RIS_EXPORT_FILE_LAST_SELECTED_PATH'] = self.export_last_file_path

        return myparentprefs
    #-----------------------------------------------------------------------------------------
    def validate(self):
        return True
    #-----------------------------------------------------------------------------------------
    def export_ris_file(self):

        self.fatal_errors_found = False

        self.get_selected_books()
        if len(self.selected_books_list) == 0:
            return

        msg = ('ZMI is preparing the .ris export file...')
        self.gui.status_bar.showMessage(msg)

        self.build_current_template()

        self.my_db,self.my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('ZMI: Export RIS File for Zotero'),_('Database Connection Error.  Restart Calibre.'), show=True)
            return

        my_db = self.gui.library_view.model().db

        self.lib_path = my_db.library_path
        self.lib_path = self.lib_path.replace(os.sep, '/')
        if isbytestring(self.lib_path):
            self.lib_path = self.lib_path.decode(filesystem_encoding)

        ris_export_book_record_list = []  #list of lists

        for book in self.selected_books_list:
            book_record_list = self.build_book_record(book)
            ris_export_book_record_list.append(book_record_list)
        #END FOR

        self.my_db.close()

        msg = ('ZMI is about to export the .ris file...')
        self.gui.status_bar.showMessage(msg)

        self.write_ris_file(ris_export_book_record_list)

        if self.fatal_errors_found:
            return error_dialog(self.gui, _('ZMI: Export RIS File for Zotero'),_('Fatal syntax errors were found.  You must search the export .ris file for the word ERROR, and fix your ZMI Calibre Source accordingly.'), show=True)
    #-----------------------------------------------------------------------------------------
    def build_book_record(self,book):
        mi = self.get_book_metadata(book)
        book_record = []  #never sort
        for row in self.current_template_list:
            tag,source = row
            value = self.expand_source(tag,source,mi)   # value may have many semi-colon separated values to be exploded into discrete values at the very end...
            if tag == "L1":
                p = value.lower()
                if not ".pdf" in p:
                    continue
                value = value.strip()
                #~ value = "file:///" + value  #~ example:     file:///D:/Livros do Doutoramento/A. Attrill/The Manipulation of Online Self-Pre (595)/The Manipulation of Online Self - A. Attrill.pdf
                value = value.replace('/',os.sep)
            item = tag,value
            book_record.append(item)
            if "ERROR" in value:
                self.fatal_errors_found = True
        #END FOR
        del mi
        return book_record
    #-----------------------------------------------------------------------------------------
    def expand_source(self,tag,source,mi):
        # example: {#pages}                                                         having only a template
        # example: This is a note about something                     having only a literal
        # example:  Dewey Decimal Code:{#ddc}                         having both a single literal and a single template
        # example:  DDC:{#ddc}/LCC:{#lcc}/LCEAD:{#lcead)         having multiple templates, each with a leading literal
        # example:  {#ddc}/{#lcc}/{#lcead)                                    having multiple templates with no literals
        # note that trailing literals are NOT supported.
        # note that identifiers separated by a ":" must be supported:     OCLC_OWI:{identifiers:oclc_owi}

        if "{" in source:
            has_template = True
            source_count = source.count("{")
            if source_count > 1:
                has_multiple = True
            else:
                has_multiple = False
        else:
            has_template = False
            has_multiple = False

        if not source.startswith("{"):
            has_literal = True
        else:
            has_literal = False

        value = ""
        value_list = []
        literal = ""

        source = source.replace("{identifiers:","{identifiers|")   #colons are significant...
        source = source.replace("{identifier:","{identifiers|")    #and user should have used the plural of identifier...
        if has_literal:
            source = source.replace(": {",":{")
            source = source.replace(":  {",":{")
            if has_multiple:       # example:  DDC:{#ddc}/LCC:{#lcc}/LCEAD:{#lcead)         having multiple templates, each with a leading literal
                if not "/" in source:
                    source = "ERROR in SYNTAX for Literal With Multiple Templates: " + tag + "  " + source
                    value_list.append(source)
                else:
                    source_split_list =source.split("/")
                    for s in source_split_list:
                        s = s.strip()
                        if not ":" in s:
                            source = "ERROR in SYNTAX for Literal With Multiple Templates: " + tag + "  " + source
                            value_list.append(source)
                        else:
                            s_split_list = s.split(":")
                            if len(s_split_list) <> 2:
                                source = "ERROR in SYNTAX for Literal With Multiple Templates: " + tag + "  " + source
                                value_list.append(source)
                            else:
                               literal = s_split_list[0].strip()
                               if DEBUG: print("literal is: ", literal)
                               source = s_split_list[1].strip()
                               if DEBUG: print("raw value is: ", source)
                               value = self.expand_column(source,mi)
                               if DEBUG: print("expanded value is: ", value)
                               value = literal + ":" + value
                               value_list.append(value)
                               if DEBUG: print("final full value is: ", value)
                            del s_split_list
                    #END FOR
                    del source_split_list
            else:
                if has_template:  # example:  Dewey Decimal Code:{#ddc}                     having both a single literal with a single template
                    if not ":" in source:
                        source = "ERROR in SYNTAX for Literal With Multiple Templates: " + tag + "  " + source
                        value_list.append(source)
                    else:
                        source_split_list =source.split(":")
                        if len(source_split_list) <> 2:
                            source = "ERROR in SYNTAX for Literal With Multiple Templates: " + tag + "  " + source
                            value_list.append(source)
                        else:
                            literal = source_split_list[0].strip()
                            if DEBUG: print("literal is: ", literal)
                            source = source_split_list[1].strip()
                            if DEBUG: print("raw value is: ", source)
                            value = self.expand_column(source,mi)
                            if DEBUG: print("expanded value is: ", value)
                            value = literal + ":" + value
                            value_list.append(value)
                            if DEBUG: print("final full value is: ", value)
                        #END FOR
                        del source_split_list
                else:                   # example: This is a note about something                 having only a literal
                    value_list.append(source)
        else:
            if has_multiple:      # example:  {#ddc}/{#lcc}/{#lcead)                               having only multiple templates
                if not "/" in source:
                    source = "ERROR in SYNTAX for Multiple Templates: " + tag + "  " + source
                    value_list.append(source)
                else:
                    source_split_list =source.split("/")
                    for s in source_split_list:
                       source = s.strip()
                       value = self.expand_column(source,mi)
                       value_list.append(value)
                    #END FOR
                    del source_split_list
            else:
                if has_template:  # example: {#pages}                                                   having only a single template
                    value = self.expand_column(source,mi)
                    value_list.append(value)

        value = ""

        for val in value_list:
            value = value + val + "        "
        #END FOR
        del value_list

        return value
    #-----------------------------------------------------------------------------------------
    def expand_column(self,value,mi):
        #~ value = source

        value = value.replace("{identifiers|","{identifiers:")  #already split on colon...

        if value == "{authors}":
            value = ""
            for author in mi.authors:
                value = value + ";" + author
            #END FOR
        elif value == "{title}":
            value = mi.title
        elif value == "{series}":
            value = mi.series
        elif value == "{series_index}":
            if value is None:
                value = ""
            else:
                value = str(mi.series_index)
        elif value == "{publisher}":
            value = mi.publisher
        elif value == "{pubdate}" or value == "{published}":
            value = str(mi.pubdate)  #2008-06-15 05:00:00+00:00
            value = value[0:10]   #2008-06-15
        elif value == "{comments}":
            value = mi.comments
        elif value == "{path}":
            value = self.get_book_path(mi)
        elif value.startswith("{identifiers:"):     # Identifiers         : isbn:9780816063864, isni:0000000050667162, loc_lccn:2007005158
            if DEBUG: print("raw identifiers value: ", str(value))
            value = value.replace("{identifiers:","")
            value = value.replace("}","")
            value = value.strip()
            was_found = False
            if value in mi.identifiers:
                if DEBUG: print("value found in mi.identifiers: ", value)
                value = mi.identifiers[value]
                if DEBUG: print("final identifiers value: ", value)
                was_found = True
            if was_found:
                value = str(value)
            else:
                value = ""
        elif value == "{language}":
            if isinstance(mi.languages,list):
                if len(mi.languages) > 0:
                    value = mi.languages[0]
            else:
                value = ""
        elif value == "{tags}":
            value = ""
            if isinstance(mi.tags,list):
                for tag in mi.tags:
                    value = value + tag + ";"
                #END FOR
            value = value.replace(",",";")
        elif value == "{rating}":
            value = str(mi.rating)
        elif value == "{timestamp}":
            value = str(mi.rating)
        elif value == "{last_modified}":
            value = str(mi.rating)
        elif value == "{today}":
            s = datetime.now()  # 2017-08-02 12:10:15.608000
            s = str(s)
            s = s[0:10]
            value = s
        elif value.startswith("{#"):         # any custom column    {#pages}
            colname = value.replace("{","")
            colname = colname.replace("}","")
            colname = colname.strip()
            value = mi.get(colname)
            if isinstance(value,unicode):
                pass
            elif isinstance(value,list):  #e.g. tag-like
                newval = ""
                for r in value:
                    newval = newval + r + ","
                #END FOR
                value = newval
                if value.endswith(","):
                    value = value[0:-1]
            elif isinstance(value,bool):
                if value:
                    value = "True"
                else:
                    value = "False"
                value = str(value)
            else:
                value = str(value) #int;float
        elif value.startswith("{"):            # any standard column without a specific rule above...
            colname = value.replace("{","")
            colname = colname.replace("}","")
            colname = colname.strip()
            try:
                value = mi.get(colname)
                if isinstance(value,unicode):
                    pass
                elif isinstance(value,list):  #e.g. tag-like
                    newval = ""
                    for r in value:
                        newval = newval + r + ","
                    #END FOR
                    value = newval
                    if value.endswith(","):
                        value = value[0:-1]
                elif isinstance(value,bool):
                    if value:
                        value = "True"
                    else:
                        value = "False"
                    value = str(value)
                else:
                    value = str(value) #int;float
            except Exception as e:
                value = ""
                if DEBUG: print("Error in expanding a Standard Column: ", colname, "   ", str(e))

        if not value:
            value = ""
        elif value == "None":
            value = ""
        elif value == str("None"):
            value = ""
        elif "{" in value:
            value = ""

        return value
    #-----------------------------------------------------------------------------------------
    def get_book_metadata(self,book):
        book = int(book)
        mi = self.guidb.new_api.get_metadata(book)
        if DEBUG: print(mi)
        return mi
    #-----------------------------------------------------------------------------------------
    def get_selected_books(self):

        self.selected_books_list[:] = []

        book_ids_list = []

        book_ids_list = map( partial(self.convert_id_to_book), self.maingui.library_view.get_selected_ids() )
        n = len(book_ids_list)
        if n == 0:
            del book_ids_list
            return error_dialog(self.gui, _('AL: '),_('No Books Were Selected; Canceled.'), show=True)

        for item in book_ids_list:
            book = item['calibre_id']
            book = str(book)
            self.selected_books_list.append(book)
        #END FOR

        self.selected_books_list.sort()

        del book_ids_list
    #-----------------------------------------------------------------------------------------
    def convert_id_to_book(self, idval):
        book = {}
        book['calibre_id'] = idval
        return book
    #-----------------------------------------------------------------------------------------
    def build_current_template(self):
        self.current_template_list = []  #never sort
        for r in xrange(0, self.n_total_rows):
            tag = self.ristable.item(r,0).text()
            source = self.ristable.item(r,2).text()
            row = tag,source
            self.current_template_list.append(row)
        #END FOR
    #-----------------------------------------------------------------------------------------
    def write_ris_file(self,ris_export_book_record_list):

        outlist = unicode("")
        outline = unicode("")
        for book_record_list in ris_export_book_record_list:
            for item in book_record_list:
                tag,value = item
                values_list = self.do_final_tag_explosion(tag,value)
                for value in values_list:
                    if (tag[0:1] == "R") and (not tag == "RI"):
                        tag = "RN"
                    if (value > "") or (tag == "ER"):   #ignore empty tags EXCEPT for ER (End of Reference)
                        outline = tag + " - " + value + "\n"
                        outlist = outlist + outline
                        #~ if DEBUG: print("RIS outline: ", str(outline))
                #END FOR

        #END FOR

        export_file = self.get_export_file_path()
        if not export_file:
            return error_dialog(self.gui, _('ZMI RIS Export File Error'),_("Export File Path Selection Error"), show=True)

        try:
            with open(export_file, 'w') as f:
                f.write(outlist)
            #END WITH
            f.close()
            del outlist
            del ris_export_book_record_list
            msg = "Export of RIS file for Zotero " + export_file + " was successful"
            info_dialog(self.gui, 'ZMI RIS Export File',msg).show()
            os.system(export_file)
            myparentprefs = self.save_all_prefs()
            for k,v in myparentprefs.iteritems():
                self.mytabprefs[k] = v
        #END FOR
        except Exception as e:
            if DEBUG: print("export file error: ", str(e))
            msg = e
            return error_dialog(self.gui, _('ZMI RIS Export File Error'),_(msg), show=True)
    #-----------------------------------------------------------------------------------------
    def get_export_file_path(self):

        if 'RIS_EXPORT_FILE_LAST_SELECTED_PATH' in self.mytabprefs:
            self.export_last_file_path = self.mytabprefs['RIS_EXPORT_FILE_LAST_SELECTED_PATH']

        if not self.export_last_file_path:
            self.export_last_file_path = ""

        self.export_last_file_path = self.export_last_file_path.replace(os.sep,'/')
        if isbytestring(self.export_last_file_path):
            self.export_last_file_path = self.export_last_file_path.decode(filesystem_encoding)

        name = "choose_export_ris_file"
        title = "Choose the RIS file name that you wish to create or replace"

        try:
            export_tuple = QFileDialog.getSaveFileName(self,"Export RIS File for Importing into Zotero",self.export_last_file_path,("Text Files (*.ris )") )
        except Exception as e:
            return None

        if not export_tuple:
            return None

        tmp_full_path, dummy = export_tuple

        if not tmp_full_path:
            return None

        if DEBUG: print("get_export_file_path - export file: ", tmp_full_path)

        self.export_last_file_path = tmp_full_path.replace(os.sep,'/')
        if isbytestring(self.export_last_file_path):
            self.export_last_file_path = self.export_last_file_path.decode(filesystem_encoding)

        self.mytabprefs['RIS_EXPORT_FILE_LAST_SELECTED_PATH'] = self.export_last_file_path

        return self.export_last_file_path
    #-----------------------------------------------------------------------------------------
    def do_final_tag_explosion(self,tag,value):
        if not value:
            value = ""
        value_list = []
        if tag in self.tags_to_semicolon_explode_list:
            if ";" in value:
                s_split = value.split(";")
                for value in s_split:
                    value = value.strip()
                    value_list.append(value)
                #END FOR
            else:
                value_list.append(value)
        else:
            value_list.append(value)

        return value_list
    #-----------------------------------------------------------------------------------------
    def get_book_path(self,mi):
        value = ""
        mysql = "SELECT id,path,\
                        (SELECT name FROM data WHERE book = books.id), \
                        (SELECT format FROM data WHERE book = books.id) \
                      FROM books WHERE id = ? "
        self.my_cursor.execute(mysql,([mi.id]))
        tmp_rows = self.my_cursor.fetchall()
        if not tmp_rows:
            pass
        else:
            if len(tmp_rows) == 0:
                pass
            else:
                for row in tmp_rows:
                    id,path,name,format = row
                    value = self.lib_path + "/" + path + "." + str(format).lower()
                    break  #first format only
                #END FOR

        return value
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#END of zmi_dialog.py