# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.54"  #Added RIS Export Tag L1 for .PDF Files (Only)

from calibre.customize import InterfaceActionBase

class ActionBaseZoteroMetadataImporter(InterfaceActionBase):

    name                    = 'Zotero Metadata Importer'
    description           = "Add Zotero documents and files plus their metadata to Calibre using a normal .csv file exported by Zotero.  Compare items in Zotero to books in Calibre. Export an RIS file with Calibre metadata for import into Zotero."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 54)
    minimum_calibre_version = (3, 8, 0)

    actual_plugin           = 'calibre_plugins.zotero_metadata_importer.ui:ActionZoteroMetadataImporter'

    gui_name = 'Zotero Metadata Importer'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return False
    #-------------------------------------------
#END of __init__py