#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import, print_function)

__license__   = 'GPL v3'
__copyright__ = '2017, Becky <becky@fr.pl>'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase

class METAmover(InterfaceActionBase):
    name                    = 'METAmover'
    description             = _('Copy informations from comment to custom columns')
    supported_platforms     = ['linux','windows','osx']
    author                  = 'Becky'
    version                 = (0, 0, 27)
    minimum_calibre_version = (2, 0, 0)
    actual_plugin           = 'calibre_plugins.metamover.ui:InterfacePlugin'
    can_be_disabled         = True

    def is_customizable(self):
        return True

    def config_widget(self):
        if self.actual_plugin_:
            from calibre_plugins.metamover.config import ConfigWidget
            return ConfigWidget(self.actual_plugin_)

    def save_settings(self, config_widget):
        config_widget.save_settings()

# For testing, run from command line with this:
# calibre-debug -e __init__.py
if __name__ == '__main__':
    try:
        from PyQt5.Qt import QApplication
    except ImportError:
        from PyQt4.Qt import QApplication
    from calibre.gui2.preferences import test_widget
    app = QApplication([])
    test_widget('Advanced', 'Plugins')
