#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2017, Becky <becky@fr.pl>'
__docformat__ = 'restructuredtext en'

import copy
try:
    from PyQt5 import QtCore
    from PyQt5 import QtWidgets as QtGui
    from PyQt5.Qt import (Qt, QWidget, QGridLayout, QLabel, QPushButton, QUrl,
                          QGroupBox, QComboBox, QVBoxLayout, QCheckBox,
                          QLineEdit, QTabWidget, QAbstractItemView,
                          QTableWidget, QHBoxLayout)
except ImportError:
    from PyQt4 import QtGui, QtCore
    from PyQt4.Qt import (Qt, QWidget, QGridLayout, QLabel, QPushButton, QUrl,
                          QGroupBox, QComboBox, QVBoxLayout, QCheckBox,
                          QLineEdit, QTabWidget,QAbstractItemView,
                          QTableWidget, QHBoxLayout,)

from calibre.gui2 import open_url, dynamic, info_dialog
from calibre.utils.config import JSONConfig

from calibre_plugins.metamover.common_utils import (get_library_uuid, get_icon, CustomColumnComboBox,
                                     KeyboardConfigDialog, KeyValueComboBox, PrefsViewerDialog,
                                     ReadOnlyTextIconWidgetItem, ReadOnlyTableWidgetItem,
                                     CheckableTableWidgetItem, ReadOnlyCheckableTableWidgetItem,
                                     convert_qvariant)

try:
    load_translations()
except NameError:
    pass # load_translations() added in calibre 1.9

PREFS_NAMESPACE = 'METAmoverPlugin'
PREFS_KEY_SETTINGS = 'settings'

KEY_PAGES_CUSTOM_COLUMN = 'customColumnPages'
DELETE_PAGES = 'deletePages'
OVERWRITE_PAGES = 'overwriteColumnPages'

KEY_ORIGINALTITLE_CUSTOM_COLUMN = 'customColumnOriginalTitle'
DELETE_ORIGINALTITLE = 'deleteOriginalTitle'
OVERWRITE_ORIGINALTITLE = 'overwriteColumnOriginalTitle'

KEY_TRANSLATORS_CUSTOM_COLUMN = 'customColumnTranslators'
DELETE_TRANSLATORS = 'deleteTranslators'
OVERWRITE_TRANSLATORS = 'overwriteTranslators'

KEY_GENRE_CUSTOM_COLUMN = 'customColumnGenre'
DELETE_GENRE = 'deleteGenre'
OVERWRITE_GENRE = 'overwriteGenre'

KEY_SERIA_CUSTOM_COLUMN = 'customColumnSeria'
DELETE_SERIA = 'deleteSeria'
OVERWRITE_SERIA = 'overwriteSeria'

KEY_OTHEREDITIONS_CUSTOM_COLUMN = 'customColumnOtherEditions'
DELETE_OTHEREDITIONS = 'deleteOtherEditions'
OVERWRITE_OTHEREDITIONS = 'overwriteOtherEditions'

KEY_RATING_CUSTOM_COLUMN = 'customColumnRating'
DELETE_RATING = 'deleteRating'
OVERWRITE_RATING = 'overwriteRating'

KEY_FIRSTPUBDATE_CUSTOM_COLUMN = 'customColumnFirstPubDate'
DELETE_FIRSTPUBDATE = 'deleteFirstPubDate'
OVERWRITE_FIRSTPUBDATE = 'overwriteFirstPubDate'

KEY_FIRSTPUBDATEPL_CUSTOM_COLUMN = 'customColumnFirstPubDatePL'
DELETE_FIRSTPUBDATEPL = 'deleteFirstPubDatePL'
OVERWRITE_FIRSTPUBDATEPL = 'overwriteFirstPubDatePL'

COPY_ID = 'copyID'
DELETE_ID = 'deleteID'
OVERWRITE_ID = 'overwriteID'

DELETE_HR = 'deleteHR'

CONFIRM = 'confirmBox'


DEFAULT_LIBRARY_VALUES = {
                          KEY_PAGES_CUSTOM_COLUMN: '',
                          DELETE_PAGES: False,
                          OVERWRITE_PAGES: False,
                          KEY_ORIGINALTITLE_CUSTOM_COLUMN: '',
                          DELETE_ORIGINALTITLE: False,
                          OVERWRITE_ORIGINALTITLE: False,
                          KEY_TRANSLATORS_CUSTOM_COLUMN: '',
                          DELETE_TRANSLATORS: False,
                          OVERWRITE_TRANSLATORS: False,
                          KEY_GENRE_CUSTOM_COLUMN: '',
                          DELETE_GENRE: False,
                          OVERWRITE_GENRE: False,
                          KEY_SERIA_CUSTOM_COLUMN: '',
                          DELETE_SERIA: False,
                          OVERWRITE_SERIA: False,
                          KEY_OTHEREDITIONS_CUSTOM_COLUMN: '',
                          DELETE_OTHEREDITIONS: False,
                          OVERWRITE_OTHEREDITIONS: False,
                          KEY_RATING_CUSTOM_COLUMN: '',
                          DELETE_RATING: False,
                          OVERWRITE_RATING: False,
                          KEY_FIRSTPUBDATE_CUSTOM_COLUMN: '',
                          DELETE_FIRSTPUBDATE: False,
                          OVERWRITE_FIRSTPUBDATE: False,
                          KEY_FIRSTPUBDATEPL_CUSTOM_COLUMN: '',
                          DELETE_FIRSTPUBDATEPL: False,
                          OVERWRITE_FIRSTPUBDATEPL: False,
                          COPY_ID: False,
                          DELETE_ID: False,
                          OVERWRITE_ID: False,
                          DELETE_HR: False,
                          CONFIRM: True
                          }

KEY_SCHEMA_VERSION = 'SchemaVersion'
DEFAULT_SCHEMA_VERSION = 1.61

# This is where all preferences for this plugin will be stored
plugin_prefs = JSONConfig('plugins/METAmover')


def get_library_config(db):
    library_id = get_library_uuid(db)
    library_config = None
    if library_config is None:
        library_config = db.prefs.get_namespaced(PREFS_NAMESPACE, PREFS_KEY_SETTINGS,
                                             copy.deepcopy(DEFAULT_LIBRARY_VALUES))
    return library_config

def set_library_config(db, library_config):
    db.prefs.set_namespaced(PREFS_NAMESPACE, PREFS_KEY_SETTINGS, library_config)

class ConfigWidget(QWidget):

    def __init__(self, plugin_action):
        QWidget.__init__(self)
        self.plugin_action = plugin_action
        layout = QVBoxLayout(self)
        self.setLayout(layout)

        tab_widget = QTabWidget(self)
        layout.addWidget(tab_widget)

        self.options_tab = OptionsTab(self)
        tab_widget.addTab(self.options_tab, _('Options'))

    def save_settings(self):
        new_prefs = {}
        db = self.plugin_action.gui.current_db
        library_config = get_library_config(db)
        library_config[KEY_PAGES_CUSTOM_COLUMN] = self.options_tab.pages_column_combo.get_selected_column()
        library_config[DELETE_PAGES] = self.options_tab.delete_pages_check.isChecked()
        library_config[OVERWRITE_PAGES] = self.options_tab.overwrite_pages_check.isChecked()
        library_config[KEY_ORIGINALTITLE_CUSTOM_COLUMN] = self.options_tab.orgtit_column_combo.get_selected_column()
        library_config[DELETE_ORIGINALTITLE] = self.options_tab.delete_orgtit_check.isChecked()
        library_config[OVERWRITE_ORIGINALTITLE] = self.options_tab.overwrite_orgtit_check.isChecked()
        library_config[KEY_TRANSLATORS_CUSTOM_COLUMN] = self.options_tab.translators_column_combo.get_selected_column()
        library_config[DELETE_TRANSLATORS] = self.options_tab.delete_translators_check.isChecked()
        library_config[OVERWRITE_TRANSLATORS] = self.options_tab.overwrite_translators_check.isChecked()
        library_config[KEY_GENRE_CUSTOM_COLUMN] = self.options_tab.genre_column_combo.get_selected_column()
        library_config[DELETE_GENRE] = self.options_tab.delete_genre_check.isChecked()
        library_config[OVERWRITE_GENRE] = self.options_tab.overwrite_genre_check.isChecked()
        library_config[KEY_SERIA_CUSTOM_COLUMN] = self.options_tab.seria_column_combo.get_selected_column()
        library_config[DELETE_SERIA] = self.options_tab.delete_seria_check.isChecked()
        library_config[OVERWRITE_SERIA] = self.options_tab.overwrite_seria_check.isChecked()
        library_config[KEY_OTHEREDITIONS_CUSTOM_COLUMN] = self.options_tab.othereditions_column_combo.get_selected_column()
        library_config[DELETE_OTHEREDITIONS] = self.options_tab.delete_othereditions_check.isChecked()
        library_config[OVERWRITE_OTHEREDITIONS] = self.options_tab.overwrite_othereditions_check.isChecked()
        library_config[KEY_RATING_CUSTOM_COLUMN] = self.options_tab.rating_column_combo.get_selected_column()
        library_config[DELETE_RATING] = self.options_tab.delete_rating_check.isChecked()
        library_config[OVERWRITE_RATING] = self.options_tab.overwrite_rating_check.isChecked()
        library_config[KEY_FIRSTPUBDATE_CUSTOM_COLUMN] = self.options_tab.firstpubdate_column_combo.get_selected_column()
        library_config[DELETE_FIRSTPUBDATE] = self.options_tab.delete_firstpubdate_check.isChecked()
        library_config[OVERWRITE_FIRSTPUBDATE] = self.options_tab.overwrite_firstpubdate_check.isChecked()
        library_config[KEY_FIRSTPUBDATEPL_CUSTOM_COLUMN] = self.options_tab.firstpubdatepl_column_combo.get_selected_column()
        library_config[DELETE_FIRSTPUBDATEPL] = self.options_tab.delete_firstpubdatepl_check.isChecked()
        library_config[OVERWRITE_FIRSTPUBDATEPL] = self.options_tab.overwrite_firstpubdatepl_check.isChecked()
        library_config[COPY_ID] = self.options_tab.copy_id_check.isChecked()
        library_config[DELETE_ID] = self.options_tab.delete_id_check.isChecked()
        library_config[OVERWRITE_ID] = self.options_tab.overwrite_id_check.isChecked()
        library_config[DELETE_HR] = self.options_tab.delete_hr_check.isChecked()
        library_config[CONFIRM] = self.options_tab.confirm_check.isChecked()
        set_library_config(db, library_config)

    def get_custom_columns(self):
        column_types = ['float','int']
        custom_columns = self.plugin_action.gui.library_view.model().custom_columns
        available_columns = {}
        for key, column in custom_columns.iteritems():
            typ = column['datatype']
            if typ in column_types:
                available_columns[key] = column
        return available_columns

    def get_custom_columns_text(self):
        column_types = ['text']
        custom_columns = self.plugin_action.gui.library_view.model().custom_columns
        available_columns = {}
        for key, column in custom_columns.iteritems():
            typ = column['datatype']
            if typ in column_types:
                available_columns[key] = column
        return available_columns


    def get_custom_columns_text2(self):
        column_types = ['text']
        custom_columns = self.plugin_action.gui.library_view.model().custom_columns
        available_columns = {}
        for key, column in custom_columns.iteritems():
            typ = column['datatype']
            multi = column['is_multiple']
            if typ in column_types and multi:
                available_columns[key] = column
        return available_columns

    def get_custom_columns_series(self):
        column_types = ['series', 'text']
        custom_columns = self.plugin_action.gui.library_view.model().custom_columns
        available_columns = {}
        for key, column in custom_columns.iteritems():
            typ = column['datatype']
            if typ in column_types:
                available_columns[key] = column
        return available_columns


    def get_custom_columns_date(self):
        column_types = ['text', 'datetime']
        custom_columns = self.plugin_action.gui.library_view.model().custom_columns
        available_columns = {}
        for key, column in custom_columns.iteritems():
            typ = column['datatype']
            if typ in column_types:
                available_columns[key] = column
        return available_columns


    def _link_activated(self, url):
        open_url(QUrl(url))


    def edit_shortcuts(self):
        d = KeyboardConfigDialog(self.plugin_action.gui, self.plugin_action.action_spec[0])
        if d.exec_() == d.Accepted:
            self.plugin_action.gui.keyboard.finalize()


    def view_prefs(self):
        d = PrefsViewerDialog(self.plugin_action.gui, PREFS_NAMESPACE)
        d.exec_()


    def get_source_list(self):
        return self.other_tab.get_source_list()


class OptionsTab(QWidget):

    def __init__(self, parent_dialog):
        self.parent_dialog = parent_dialog
        QWidget.__init__(self)
        layout = QVBoxLayout()
        self.setLayout(layout)

        avail_columns = self.parent_dialog.get_custom_columns()
        avail_columns_text = self.parent_dialog.get_custom_columns_text()
        avail_columns_text2 = self.parent_dialog.get_custom_columns_text2()
        avail_columns_series = self.parent_dialog.get_custom_columns_series()
        avail_columns_date = self.parent_dialog.get_custom_columns_date()
        library_config = get_library_config(self.parent_dialog.plugin_action.gui.current_db)
        my_group_box = QGroupBox(_('Select custom columns:'), self)
        layout.addWidget(my_group_box)
        other_group_box = QGroupBox(_('Additional options:'), self)
        layout.addWidget(other_group_box)
        my_group_box_layout = QGridLayout()
        my_group_box.setLayout(my_group_box_layout)
        other_group_box_layout = QGridLayout()
        other_group_box.setLayout(other_group_box_layout)


        pages_column_label = QLabel(_('Number of &pages:'), self)
        pages_column_toolTip = _('Set custom column for number of pages.\n'
                                 'Leave this blank if you do not want copy number of pages.')
        pages_column_label.setToolTip(pages_column_toolTip)
        pages_col = library_config.get(KEY_PAGES_CUSTOM_COLUMN, '')
        self.pages_column_combo = CustomColumnComboBox(self, avail_columns, pages_col)
        self.pages_column_combo.setToolTip(pages_column_toolTip)
        self.delete_pages_check = QCheckBox(_('Delete after copy'), self)
        self.delete_pages_check.setToolTip(_('Delete informations about number of pages from comment\n'
                                             'after copy to the custom column.'))
        self.overwrite_pages_check = QCheckBox(_('Overwrite'), self)
        self.overwrite_pages_check.setToolTip(_('Overwrite value in custom column.'))

        orgtit_column_label = QLabel(_('&Original title:'), self)
        orgtit_column_toolTip = _('Set custom column for original title.\n'
                                 'Leave this blank if you do not want copy original title.')
        orgtit_column_label.setToolTip(orgtit_column_toolTip)
        orgtit_col = library_config.get(KEY_ORIGINALTITLE_CUSTOM_COLUMN, '')
        self.orgtit_column_combo = CustomColumnComboBox(self, avail_columns_text, orgtit_col)
        self.orgtit_column_combo.setToolTip(orgtit_column_toolTip)
        self.delete_orgtit_check = QCheckBox(_('Delete after copy'), self)
        self.delete_orgtit_check.setToolTip(_('Delete informations about original title from comment\n'
                                             'after copy to the custom column.'))
        self.overwrite_orgtit_check = QCheckBox(_('Overwrite'), self)
        self.overwrite_orgtit_check.setToolTip(_('Overwrite text in custom column.'))

        translators_column_label = QLabel(_('&Translators:'), self)
        translators_column_toolTip = _('Set custom column for translators.\n'
                                 'Leave this blank if you do not want copy translators.')
        translators_column_label.setToolTip(translators_column_toolTip)
        translators_col = library_config.get(KEY_TRANSLATORS_CUSTOM_COLUMN, '')
        self.translators_column_combo = CustomColumnComboBox(self, avail_columns_text2, translators_col)
        self.translators_column_combo.setToolTip(translators_column_toolTip)
        self.delete_translators_check = QCheckBox(_('Delete after copy'), self)
        self.delete_translators_check.setToolTip(_('Delete informations about translators from comment\n'
                                             'after copy to the custom column.'))
        self.overwrite_translators_check = QCheckBox(_('Overwrite'), self)
        self.overwrite_translators_check.setToolTip(_('Overwrite text in custom column.'))

        genre_column_label = QLabel(_('&Genre:'), self)
        genre_column_toolTip = _('Set custom column for genre.\n'
                                 'Leave this blank if you do not want copy genre.')
        genre_column_label.setToolTip(genre_column_toolTip)
        genre_col = library_config.get(KEY_GENRE_CUSTOM_COLUMN, '')
        self.genre_column_combo = CustomColumnComboBox(self, avail_columns_text, genre_col)
        self.genre_column_combo.setToolTip(genre_column_toolTip)
        self.delete_genre_check = QCheckBox(_('Delete after copy'), self)
        self.delete_genre_check.setToolTip(_('Delete genre informations from comment\n'
                                             'after copy to the custom column.'))
        self.overwrite_genre_check = QCheckBox(_('Overwrite'), self)
        self.overwrite_genre_check.setToolTip(_('Overwrite text in custom column.'))

        seria_column_label = QLabel(_('Book &series:'), self)
        seria_column_toolTip = _('Set custom column for book series.\n'
                                 'Leave this blank if you do not want copy book series.')
        seria_column_label.setToolTip(seria_column_toolTip)
        seria_col = library_config.get(KEY_SERIA_CUSTOM_COLUMN, '')
        self.seria_column_combo = CustomColumnComboBox(self, avail_columns_series, seria_col)
        self.seria_column_combo.setToolTip(seria_column_toolTip)
        self.delete_seria_check = QCheckBox(_('Delete after copy'), self)
        self.delete_seria_check.setToolTip(_('Delete seria informations from comment\n'
                                             'after copy to the custom column.'))
        self.overwrite_seria_check = QCheckBox(_('Overwrite'), self)
        self.overwrite_seria_check.setToolTip(_('Overwrite text in custom column.'))

        othereditions_column_label = QLabel(_('Other &editions:'), self)
        othereditions_column_toolTip = _('Set custom column for the other editions.\n'
                                 'Leave this blank if you do not want copy other editions.')
        othereditions_column_label.setToolTip(othereditions_column_toolTip)
        othereditions_col = library_config.get(KEY_OTHEREDITIONS_CUSTOM_COLUMN, '')
        self.othereditions_column_combo = CustomColumnComboBox(self, avail_columns_text, othereditions_col)
        self.othereditions_column_combo.setToolTip(othereditions_column_toolTip)
        self.delete_othereditions_check = QCheckBox(_('Delete after copy'), self)
        self.delete_othereditions_check.setToolTip(_('Delete informations about other editions from comment\n'
                                             'after copy to the custom column.'))
        self.overwrite_othereditions_check = QCheckBox(_('Overwrite'), self)
        self.overwrite_othereditions_check.setToolTip(_('Overwrite text in custom column.'))

        rating_column_label = QLabel(_('&Rating:'), self)
        rating_column_toolTip = _('Set custom column for the rating.\n'
                                 'Leave this blank if you do not want copy rating.')
        rating_column_label.setToolTip(rating_column_toolTip)
        rating_col = library_config.get(KEY_RATING_CUSTOM_COLUMN, '')
        self.rating_column_combo = CustomColumnComboBox(self, avail_columns, rating_col)
        self.rating_column_combo.setToolTip(rating_column_toolTip)
        self.delete_rating_check = QCheckBox(_('Delete after copy'), self)
        self.delete_rating_check.setToolTip(_('Delete informations about rating from comment\n'
                                             'after copy to the custom column.'))
        self.overwrite_rating_check = QCheckBox(_('Overwrite'), self)
        self.overwrite_rating_check.setToolTip(_('Overwrite text in custom column.'))

        firstpubdate_column_label = QLabel(_('First edition &date:'), self)
        firstpubdate_column_toolTip = _('Set custom column for the first edition date.\n'
                                 'Leave this blank if you do not want copy first edition date.')
        firstpubdate_column_label.setToolTip(firstpubdate_column_toolTip)
        firstpubdate_col = library_config.get(KEY_FIRSTPUBDATE_CUSTOM_COLUMN, '')
        self.firstpubdate_column_combo = CustomColumnComboBox(self, avail_columns_date, firstpubdate_col)
        self.firstpubdate_column_combo.setToolTip(firstpubdate_column_toolTip)
        self.delete_firstpubdate_check = QCheckBox(_('Delete after copy'), self)
        self.delete_firstpubdate_check.setToolTip(_('Delete informations about first edition date from comment\n'
                                             'after copy to the custom column.'))
        self.overwrite_firstpubdate_check = QCheckBox(_('Overwrite'), self)
        self.overwrite_firstpubdate_check.setToolTip(_('Overwrite text in custom column.'))

        firstpubdatepl_column_label = QLabel(_('First edition date (P&L):'), self)
        firstpubdatepl_column_toolTip = _('Set custom column for the first edition date in Poland.\n'
                                 'Leave this blank if you do not want copy first edition date in Poland.')
        firstpubdatepl_column_label.setToolTip(firstpubdatepl_column_toolTip)
        firstpubdatepl_col = library_config.get(KEY_FIRSTPUBDATEPL_CUSTOM_COLUMN, '')
        self.firstpubdatepl_column_combo = CustomColumnComboBox(self, avail_columns_date, firstpubdatepl_col)
        self.firstpubdatepl_column_combo.setToolTip(firstpubdatepl_column_toolTip)
        self.delete_firstpubdatepl_check = QCheckBox(_('Delete after copy'), self)
        self.delete_firstpubdatepl_check.setToolTip(_('Delete informations about first edition date in Poland from comment\n'
                                             'after copy to the custom column.'))
        self.overwrite_firstpubdatepl_check = QCheckBox(_('Overwrite'), self)
        self.overwrite_firstpubdatepl_check.setToolTip(_('Overwrite text in custom column.'))

        id_label = QLabel(_(' '), self)
        id_toolTip = _('Copy LubimyCzytac ID from comment to the identifiers.')
        self.copy_id_check = QCheckBox(_('Copy LubimyCzytac &ID to identifiers'), self)
        self.copy_id_check.setToolTip(id_toolTip)
        self.delete_id_check = QCheckBox(_('Delete after copy'), self)
        self.delete_id_check.setToolTip(_('Delete LubimyCzytac ID informations from comment\n'
                                             'after copy to the identifiers.'))
        self.overwrite_id_check = QCheckBox(_('Overwrite'), self)
        self.overwrite_id_check.setToolTip(_('Overwrite LubimyCzytac ID in the identifiers.'))


        self.delete_hr_check = QCheckBox(_('Delete &HR before comment'), self)
        self.delete_hr_check.setToolTip(_('Delete horizontal rule before comment.'))

        self.confirm_check = QCheckBox(_('When done, &display the confirmation box'), self)
        self.confirm_check.setToolTip(_('When done (main icon action only), display information window with confirmation.'))


        pages_column_label.setBuddy(self.pages_column_combo)
        my_group_box_layout.addWidget(pages_column_label, 0, 0, 1, 1)
        my_group_box_layout.addWidget(self.pages_column_combo, 0, 1, 1, 1)
        my_group_box_layout.addWidget(self.delete_pages_check, 0, 2, 1, 1)
        self.delete_pages_check.setChecked(library_config.get(DELETE_PAGES, DEFAULT_LIBRARY_VALUES[DELETE_PAGES]))
        my_group_box_layout.addWidget(self.overwrite_pages_check, 0, 3, 1, 1)
        self.overwrite_pages_check.setChecked(library_config.get(OVERWRITE_PAGES, DEFAULT_LIBRARY_VALUES[OVERWRITE_PAGES]))

        orgtit_column_label.setBuddy(self.orgtit_column_combo)
        my_group_box_layout.addWidget(orgtit_column_label, 1, 0, 1, 1)
        my_group_box_layout.addWidget(self.orgtit_column_combo, 1, 1, 1, 1)
        my_group_box_layout.addWidget(self.delete_orgtit_check, 1, 2, 1, 1)
        self.delete_orgtit_check.setChecked(library_config.get(DELETE_ORIGINALTITLE, DEFAULT_LIBRARY_VALUES[DELETE_ORIGINALTITLE]))
        my_group_box_layout.addWidget(self.overwrite_orgtit_check, 1, 3, 1, 1)
        self.overwrite_orgtit_check.setChecked(library_config.get(OVERWRITE_ORIGINALTITLE, DEFAULT_LIBRARY_VALUES[OVERWRITE_ORIGINALTITLE]))

        translators_column_label.setBuddy(self.translators_column_combo)
        my_group_box_layout.addWidget(translators_column_label, 2, 0, 1, 1)
        my_group_box_layout.addWidget(self.translators_column_combo, 2, 1, 1, 1)
        my_group_box_layout.addWidget(self.delete_translators_check, 2, 2, 1, 1)
        self.delete_translators_check.setChecked(library_config.get(DELETE_TRANSLATORS, DEFAULT_LIBRARY_VALUES[DELETE_TRANSLATORS]))
        my_group_box_layout.addWidget(self.overwrite_translators_check, 2, 3, 1, 1)
        self.overwrite_translators_check.setChecked(library_config.get(OVERWRITE_TRANSLATORS, DEFAULT_LIBRARY_VALUES[OVERWRITE_TRANSLATORS]))

        genre_column_label.setBuddy(self.genre_column_combo)
        my_group_box_layout.addWidget(genre_column_label, 3, 0, 1, 1)
        my_group_box_layout.addWidget(self.genre_column_combo, 3, 1, 1, 1)
        my_group_box_layout.addWidget(self.delete_genre_check, 3, 2, 1, 1)
        self.delete_genre_check.setChecked(library_config.get(DELETE_GENRE, DEFAULT_LIBRARY_VALUES[DELETE_GENRE]))
        my_group_box_layout.addWidget(self.overwrite_genre_check, 3, 3, 1, 1)
        self.overwrite_genre_check.setChecked(library_config.get(OVERWRITE_GENRE, DEFAULT_LIBRARY_VALUES[OVERWRITE_GENRE]))

        seria_column_label.setBuddy(self.seria_column_combo)
        my_group_box_layout.addWidget(seria_column_label, 4, 0, 1, 1)
        my_group_box_layout.addWidget(self.seria_column_combo, 4, 1, 1, 1)
        my_group_box_layout.addWidget(self.delete_seria_check, 4, 2, 1, 1)
        self.delete_seria_check.setChecked(library_config.get(DELETE_SERIA, DEFAULT_LIBRARY_VALUES[DELETE_SERIA]))
        my_group_box_layout.addWidget(self.overwrite_seria_check, 4, 3, 1, 1)
        self.overwrite_seria_check.setChecked(library_config.get(OVERWRITE_SERIA, DEFAULT_LIBRARY_VALUES[OVERWRITE_SERIA]))

        othereditions_column_label.setBuddy(self.othereditions_column_combo)
        my_group_box_layout.addWidget(othereditions_column_label, 5, 0, 1, 1)
        my_group_box_layout.addWidget(self.othereditions_column_combo, 5, 1, 1, 1)
        my_group_box_layout.addWidget(self.delete_othereditions_check, 5, 2, 1, 1)
        self.delete_othereditions_check.setChecked(library_config.get(DELETE_OTHEREDITIONS, DEFAULT_LIBRARY_VALUES[DELETE_OTHEREDITIONS]))
        my_group_box_layout.addWidget(self.overwrite_othereditions_check, 5, 3, 1, 1)
        self.overwrite_othereditions_check.setChecked(library_config.get(OVERWRITE_OTHEREDITIONS, DEFAULT_LIBRARY_VALUES[OVERWRITE_OTHEREDITIONS]))

        rating_column_label.setBuddy(self.rating_column_combo)
        my_group_box_layout.addWidget(rating_column_label, 6, 0, 1, 1)
        my_group_box_layout.addWidget(self.rating_column_combo, 6, 1, 1, 1)
        my_group_box_layout.addWidget(self.delete_rating_check, 6, 2, 1, 1)
        self.delete_rating_check.setChecked(library_config.get(DELETE_RATING, DEFAULT_LIBRARY_VALUES[DELETE_RATING]))
        my_group_box_layout.addWidget(self.overwrite_rating_check, 6, 3, 1, 1)
        self.overwrite_rating_check.setChecked(library_config.get(OVERWRITE_RATING, DEFAULT_LIBRARY_VALUES[OVERWRITE_RATING]))

        firstpubdate_column_label.setBuddy(self.firstpubdate_column_combo)
        my_group_box_layout.addWidget(firstpubdate_column_label, 7, 0, 1, 1)
        my_group_box_layout.addWidget(self.firstpubdate_column_combo, 7, 1, 1, 1)
        my_group_box_layout.addWidget(self.delete_firstpubdate_check, 7, 2, 1, 1)
        self.delete_firstpubdate_check.setChecked(library_config.get(DELETE_FIRSTPUBDATE, DEFAULT_LIBRARY_VALUES[DELETE_FIRSTPUBDATE]))
        my_group_box_layout.addWidget(self.overwrite_firstpubdate_check, 7, 3, 1, 1)
        self.overwrite_firstpubdate_check.setChecked(library_config.get(OVERWRITE_FIRSTPUBDATE, DEFAULT_LIBRARY_VALUES[OVERWRITE_FIRSTPUBDATE]))

        firstpubdatepl_column_label.setBuddy(self.firstpubdatepl_column_combo)
        my_group_box_layout.addWidget(firstpubdatepl_column_label, 8, 0, 1, 1)
        my_group_box_layout.addWidget(self.firstpubdatepl_column_combo, 8, 1, 1, 1)
        my_group_box_layout.addWidget(self.delete_firstpubdatepl_check, 8, 2, 1, 1)
        self.delete_firstpubdate_check.setChecked(library_config.get(DELETE_FIRSTPUBDATEPL, DEFAULT_LIBRARY_VALUES[DELETE_FIRSTPUBDATEPL]))
        my_group_box_layout.addWidget(self.overwrite_firstpubdatepl_check, 8, 3, 1, 1)
        self.overwrite_firstpubdatepl_check.setChecked(library_config.get(OVERWRITE_FIRSTPUBDATEPL, DEFAULT_LIBRARY_VALUES[OVERWRITE_FIRSTPUBDATEPL]))

        self.copy_id_check.setChecked(library_config.get(COPY_ID, DEFAULT_LIBRARY_VALUES[COPY_ID]))
        other_group_box_layout.addWidget(self.copy_id_check, 0, 0, 1, 1)
        self.copy_id_check.setMinimumWidth(225)
        other_group_box_layout.addWidget(id_label, 0, 1, 1, 1)
        self.delete_id_check.setChecked(library_config.get(DELETE_ID, DEFAULT_LIBRARY_VALUES[DELETE_ID]))
        other_group_box_layout.addWidget(self.delete_id_check, 0, 2, 1, 1)
        other_group_box_layout.addWidget(self.overwrite_id_check, 0, 3, 1, 1)
        self.overwrite_id_check.setChecked(library_config.get(OVERWRITE_ID, DEFAULT_LIBRARY_VALUES[OVERWRITE_ID]))

        self.delete_hr_check.setChecked(library_config.get(DELETE_HR, DEFAULT_LIBRARY_VALUES[DELETE_HR]))
        other_group_box_layout.addWidget(self.delete_hr_check, 1, 0, 1, 1)

        self.confirm_check.setChecked(library_config.get(CONFIRM, DEFAULT_LIBRARY_VALUES[CONFIRM]))
        other_group_box_layout.addWidget(self.confirm_check, 2, 0, 1, 1)

        #Keyboard and library preferences
        keyboard_shortcuts_button = QPushButton(_('Keyboard shortcuts...'), self)
        keyboard_shortcuts_button.setToolTip(_('Edit the keyboard shortcuts associated with this plugin'))
        keyboard_shortcuts_button.clicked.connect(self.parent_dialog.edit_shortcuts)
        view_prefs_button = QPushButton(_('&View library preferences...'), self)
        view_prefs_button.setToolTip(_('View data stored in the library database for this plugin'))
        view_prefs_button.clicked.connect(self.parent_dialog.view_prefs)
        layout.addWidget(keyboard_shortcuts_button)
        layout.addWidget(view_prefs_button)
