#! /bin/sh

LED=/sys/class/backlight/lm3630a_leda
MAX_VALUE=$(cat "$LED"/max_brightness)
STEP=$((MAX_VALUE / 5))
VALUE=$STEP

[ "$STEP" -gt 0 ] || exit 1

echo 31 > "$LED"/bl_power

while [ "$VALUE" -le "$MAX_VALUE" ] ; do
	echo "$VALUE" > "$LED"/brightness
	sleep 1
	VALUE=$((VALUE + STEP))
done

echo 0 > "$LED"/brightness
echo 0 > "$LED"/bl_power
